/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl;

import com.google.gwt.dev.jjs.ast.Context;
import com.google.gwt.dev.jjs.ast.JBinaryOperation;
import com.google.gwt.dev.jjs.ast.JExpression;
import com.google.gwt.dev.jjs.ast.JLiteral;
import com.google.gwt.dev.jjs.ast.JMethod;
import com.google.gwt.dev.jjs.ast.JMethodCall;
import com.google.gwt.dev.jjs.ast.JNode;
import com.google.gwt.dev.jjs.ast.JParameter;
import com.google.gwt.dev.jjs.ast.JParameterRef;
import com.google.gwt.dev.jjs.ast.JPostfixOperation;
import com.google.gwt.dev.jjs.ast.JPrefixOperation;
import com.google.gwt.dev.jjs.ast.JProgram;
import com.google.gwt.dev.jjs.ast.JValueLiteral;
import com.google.gwt.dev.jjs.ast.JVisitor;
import com.google.gwt.dev.jjs.ast.js.JsniMethodBody;
import com.google.gwt.dev.jjs.ast.js.JsniMethodRef;
import com.google.gwt.dev.jjs.impl.CloneExpressionVisitor;
import com.google.gwt.dev.jjs.impl.JChangeTrackingVisitor;
import com.google.gwt.dev.jjs.impl.JavaAstVerifier;
import com.google.gwt.dev.jjs.impl.OptimizerContext;
import com.google.gwt.dev.jjs.impl.OptimizerStats;
import com.google.gwt.dev.jjs.impl.Simplifier;
import com.google.gwt.dev.util.log.speedtracer.CompilerEventType;
import com.google.gwt.dev.util.log.speedtracer.SpeedTracerLogger;
import com.google.gwt.thirdparty.guava.common.annotations.VisibleForTesting;
import com.google.gwt.thirdparty.guava.common.collect.Maps;
import com.google.gwt.thirdparty.guava.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SameParameterValueOptimizer {
    private static final String NAME = SameParameterValueOptimizer.class.getSimpleName();
    private final Map<JParameter, JValueLiteral> parameterValues = Maps.newIdentityHashMap();
    private final JProgram program;
    private final Set<JMethod> nonOptimizableMethods = Sets.newHashSet();

    @VisibleForTesting
    static OptimizerStats exec(JProgram program) {
        return SameParameterValueOptimizer.exec(program, OptimizerContext.NULL_OPTIMIZATION_CONTEXT);
    }

    public static OptimizerStats exec(JProgram program, OptimizerContext optimizerCtx) {
        SpeedTracerLogger.Event optimizeEvent = SpeedTracerLogger.start(CompilerEventType.OPTIMIZE, "optimizer", NAME);
        OptimizerStats stats = new SameParameterValueOptimizer(program).execImpl(program, optimizerCtx);
        optimizerCtx.incOptimizationStep();
        optimizeEvent.end("didChange", "" + stats.didChange());
        return stats;
    }

    private SameParameterValueOptimizer(JProgram program) {
        this.program = program;
    }

    private OptimizerStats execImpl(JNode node, OptimizerContext optimizerCtx) {
        OptimizerStats stats = new OptimizerStats(NAME);
        new AnalysisVisitor().accept(node);
        SubstituteParameterVisitor substituteParameterVisitor = new SubstituteParameterVisitor(optimizerCtx);
        substituteParameterVisitor.accept(node);
        stats.recordModified(substituteParameterVisitor.getNumMods());
        JavaAstVerifier.assertProgramIsConsistent(this.program);
        return stats;
    }

    private class SubstituteParameterVisitor
    extends JChangeTrackingVisitor {
        private final CloneExpressionVisitor cloner;

        public SubstituteParameterVisitor(OptimizerContext optimizerCtx) {
            super(optimizerCtx);
            this.cloner = new CloneExpressionVisitor();
        }

        @Override
        public boolean enter(JMethod x, Context ctx) {
            if (SameParameterValueOptimizer.this.nonOptimizableMethods.contains(x)) {
                return false;
            }
            for (JParameter parameter : x.getParams()) {
                if (SameParameterValueOptimizer.this.parameterValues.get(parameter) == null) continue;
                return true;
            }
            return false;
        }

        @Override
        public void endVisit(JParameterRef x, Context ctx) {
            JParameter parameter = x.getParameter();
            JLiteral value = (JLiteral)SameParameterValueOptimizer.this.parameterValues.get(parameter);
            if (value != null) {
                ctx.replaceMe(this.cloner.cloneExpression(Simplifier.cast(parameter.getType(), value)));
            }
        }
    }

    private class AnalysisVisitor
    extends JVisitor {
        private AnalysisVisitor() {
        }

        @Override
        public void endVisit(JBinaryOperation x, Context ctx) {
            if (x.isAssignment() && x.getLhs() instanceof JParameterRef) {
                SameParameterValueOptimizer.this.parameterValues.put(((JParameterRef)x.getLhs()).getParameter(), null);
            }
        }

        @Override
        public void endVisit(JMethodCall x, Context ctx) {
            JMethod method = x.getTarget();
            if (this.isNotOptimizable(method)) {
                return;
            }
            List<JExpression> arguments = x.getArgs();
            List<JParameter> parameters = method.getParams();
            for (int i = 0; i < arguments.size() && i < parameters.size(); ++i) {
                JParameter parameter = parameters.get(i);
                JExpression argument = arguments.get(i);
                if (!(argument instanceof JValueLiteral)) {
                    SameParameterValueOptimizer.this.parameterValues.put(parameter, null);
                    continue;
                }
                if (!SameParameterValueOptimizer.this.parameterValues.containsKey(parameter)) {
                    SameParameterValueOptimizer.this.parameterValues.put(parameter, (JValueLiteral)argument);
                    continue;
                }
                JValueLiteral commonParamValue = (JValueLiteral)SameParameterValueOptimizer.this.parameterValues.get(parameter);
                if (commonParamValue == null || this.equalLiterals(commonParamValue, (JValueLiteral)argument)) continue;
                SameParameterValueOptimizer.this.parameterValues.put(parameter, null);
            }
        }

        @Override
        public void endVisit(JPostfixOperation x, Context ctx) {
            if (x.getArg() instanceof JParameterRef) {
                SameParameterValueOptimizer.this.parameterValues.put(((JParameterRef)x.getArg()).getParameter(), null);
            }
        }

        @Override
        public void endVisit(JPrefixOperation x, Context ctx) {
            if (x.getArg() instanceof JParameterRef) {
                SameParameterValueOptimizer.this.parameterValues.put(((JParameterRef)x.getArg()).getParameter(), null);
            }
        }

        @Override
        public void endVisit(JsniMethodBody x, Context ctx) {
            for (JsniMethodRef methodRef : x.getJsniMethodRefs()) {
                SameParameterValueOptimizer.this.nonOptimizableMethods.add(methodRef.getTarget());
            }
        }

        @Override
        public boolean visit(JMethod x, Context ctx) {
            if (this.isNotOptimizable(x)) {
                SameParameterValueOptimizer.this.nonOptimizableMethods.add(x);
            }
            return true;
        }

        private boolean isNotOptimizable(JMethod x) {
            return x.needsDynamicDispatch() || x.canBeReferencedExternally();
        }

        private boolean equalLiterals(JValueLiteral l1, JValueLiteral l2) {
            Object v2;
            Object v1 = l1.getValueObj();
            if (v1 == (v2 = l2.getValueObj())) {
                return true;
            }
            if (v1 == null || v2 == null) {
                return false;
            }
            return v1.equals(v2);
        }
    }
}

