/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl;

import com.google.gwt.dev.jjs.ast.Context;
import com.google.gwt.dev.jjs.ast.JConstructor;
import com.google.gwt.dev.jjs.ast.JDeclaredType;
import com.google.gwt.dev.jjs.ast.JExpression;
import com.google.gwt.dev.jjs.ast.JMethod;
import com.google.gwt.dev.jjs.ast.JMethodCall;
import com.google.gwt.dev.jjs.ast.JModVisitor;
import com.google.gwt.dev.jjs.ast.JNewInstance;
import com.google.gwt.dev.jjs.ast.JProgram;
import com.google.gwt.dev.jjs.ast.JType;
import com.google.gwt.dev.jjs.ast.js.JsniMethodRef;
import com.google.gwt.dev.jjs.impl.OptimizerStats;
import com.google.gwt.dev.util.log.speedtracer.CompilerEventType;
import com.google.gwt.dev.util.log.speedtracer.SpeedTracerLogger;
import com.google.gwt.thirdparty.guava.common.base.Function;
import com.google.gwt.thirdparty.guava.common.base.Joiner;
import com.google.gwt.thirdparty.guava.common.collect.Iterables;
import java.util.HashMap;
import java.util.Map;

public class RewriteConstructorCallsForUnboxedTypes
extends JModVisitor {
    public static final String NATIVE_TYPE_CREATEMETHOD_PREFIX = "$create";
    private JProgram program;
    private Map<JDeclaredType, Map<String, JMethod>> createMethodsByType = new HashMap<JDeclaredType, Map<String, JMethod>>();
    private static final String NAME = RewriteConstructorCallsForUnboxedTypes.class.getSimpleName();

    public RewriteConstructorCallsForUnboxedTypes(JProgram program) {
        this.program = program;
        for (JDeclaredType jDeclaredType : program.getRepresentedAsNativeTypes()) {
            HashMap<String, JMethod> createMethods = new HashMap<String, JMethod>();
            this.createMethodsByType.put(jDeclaredType, createMethods);
            for (JMethod method : jDeclaredType.getMethods()) {
                if (!method.getName().startsWith(NATIVE_TYPE_CREATEMETHOD_PREFIX)) continue;
                createMethods.put(RewriteConstructorCallsForUnboxedTypes.getParametersAsString(method), method);
            }
        }
    }

    @Override
    public void endVisit(JNewInstance x, Context ctx) {
        JConstructor ctor = x.getTarget();
        if (!this.program.isRepresentedAsNativeJsPrimitive(ctor.getEnclosingType())) {
            return;
        }
        JMethod createMethod = this.createMethodsByType.get(ctor.getEnclosingType()).get(RewriteConstructorCallsForUnboxedTypes.getParametersAsString(ctor));
        assert (createMethod != null);
        JMethodCall createCall = new JMethodCall(x.getSourceInfo(), null, createMethod, new JExpression[0]);
        createCall.addArgs(x.getArgs());
        ctx.replaceMe(createCall);
    }

    @Override
    public void endVisit(JsniMethodRef x, Context ctx) {
        if (x.getTarget().isConstructor() && this.program.isRepresentedAsNativeJsPrimitive(x.getTarget().getEnclosingType())) {
            JConstructor ctor = (JConstructor)x.getTarget();
            JMethod createMethod = this.createMethodsByType.get(ctor.getEnclosingType()).get(RewriteConstructorCallsForUnboxedTypes.getParametersAsString(ctor));
            assert (createMethod != null);
            JsniMethodRef newJsniMethodRef = new JsniMethodRef(x.getSourceInfo(), x.getIdent(), createMethod, this.program.getJavaScriptObject());
            ctx.replaceMe(newJsniMethodRef);
        }
    }

    private static String getParametersAsString(JMethod method) {
        return Joiner.on(",").join(Iterables.transform(method.getOriginalParamTypes(), new Function<JType, String>(){

            @Override
            public String apply(JType type) {
                return type.getJsniSignatureName();
            }
        }));
    }

    private OptimizerStats execImpl() {
        OptimizerStats stats = new OptimizerStats(NAME);
        this.accept(this.program);
        return stats;
    }

    public static OptimizerStats exec(JProgram program) {
        SpeedTracerLogger.Event optimizeEvent = SpeedTracerLogger.start(CompilerEventType.OPTIMIZE, "optimizer", NAME);
        OptimizerStats stats = new RewriteConstructorCallsForUnboxedTypes(program).execImpl();
        optimizeEvent.end("didChange", "" + stats.didChange());
        return stats;
    }
}

