/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl;

import com.google.gwt.dev.jjs.ast.Context;
import com.google.gwt.dev.jjs.ast.HasName;
import com.google.gwt.dev.jjs.ast.JCastMap;
import com.google.gwt.dev.jjs.ast.JExpression;
import com.google.gwt.dev.jjs.ast.JIntLiteral;
import com.google.gwt.dev.jjs.ast.JMethod;
import com.google.gwt.dev.jjs.ast.JMethodCall;
import com.google.gwt.dev.jjs.ast.JModVisitor;
import com.google.gwt.dev.jjs.ast.JProgram;
import com.google.gwt.dev.jjs.ast.JReferenceType;
import com.google.gwt.dev.jjs.ast.JRuntimeTypeReference;
import com.google.gwt.dev.jjs.ast.JStringLiteral;
import com.google.gwt.dev.jjs.ast.JType;
import com.google.gwt.dev.jjs.ast.JVisitor;
import com.google.gwt.thirdparty.guava.common.annotations.VisibleForTesting;
import com.google.gwt.thirdparty.guava.common.base.Objects;
import com.google.gwt.thirdparty.guava.common.collect.LinkedHashMultiset;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import com.google.gwt.thirdparty.guava.common.collect.Maps;
import com.google.gwt.thirdparty.guava.common.collect.Multiset;
import com.google.gwt.thirdparty.guava.common.collect.Multisets;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ResolveRuntimeTypeReferences {
    private final JProgram program;
    private TypeMapper<?> typeMapper;
    private TypeOrder typeOrder;

    private ResolveRuntimeTypeReferences(JProgram program, TypeMapper<?> typeMapper, TypeOrder typeOrder) {
        this.program = program;
        this.typeMapper = typeMapper;
        this.typeOrder = typeOrder;
    }

    private void assignTypes(Multiset<JReferenceType> typesWithReferenceCounts) {
        this.typeMapper.getOrCreateTypeId(this.program.getJavaScriptObject());
        this.typeMapper.getOrCreateTypeId(this.program.getTypeJavaLangObject());
        this.typeMapper.getOrCreateTypeId(this.program.getTypeJavaLangString());
        Collection<Object> types = null;
        switch (this.typeOrder) {
            case FREQUENCY: {
                types = Multisets.copyHighestCountFirst(typesWithReferenceCounts).elementSet();
                break;
            }
            case ALPHABETICAL: {
                types = Lists.newArrayList(typesWithReferenceCounts.elementSet());
                Collections.sort((List)types, HasName.BY_NAME_COMPARATOR);
                break;
            }
            case NONE: {
                types = typesWithReferenceCounts.elementSet();
            }
        }
        for (JType type : types) {
            this.typeMapper.getOrCreateTypeId(type);
        }
    }

    private void execImpl() {
        RuntimeTypeCollectorVisitor runtimeTypeCollector = new RuntimeTypeCollectorVisitor();
        runtimeTypeCollector.accept(this.program);
        runtimeTypeCollector.accept(Lists.newArrayList(this.program.getCastMap().values()));
        runtimeTypeCollector.accept(this.program.getIndexedType("ClassLiteralHolder"));
        this.assignTypes(runtimeTypeCollector.typesRequiringRuntimeIds);
        ReplaceRuntimeTypeReferencesVisitor replaceTypeIdsVisitor = new ReplaceRuntimeTypeReferencesVisitor();
        replaceTypeIdsVisitor.accept(this.program);
        replaceTypeIdsVisitor.accept(this.program.getIndexedType("ClassLiteralHolder"));
        for (Map.Entry<JReferenceType, JCastMap> entry : this.program.getCastMap().entrySet()) {
            JCastMap castMap = entry.getValue();
            replaceTypeIdsVisitor.accept(castMap);
        }
    }

    private JExpression getTypeIdExpression(JType type) {
        return this.typeMapper.getOrCreateTypeId(type);
    }

    public static void exec(JProgram program, TypeMapper<?> typeMapper, TypeOrder typeOrder) {
        new ResolveRuntimeTypeReferences(program, typeMapper, typeOrder).execImpl();
    }

    private class ReplaceRuntimeTypeReferencesVisitor
    extends JModVisitor {
        private ReplaceRuntimeTypeReferencesVisitor() {
        }

        @Override
        public void endVisit(JRuntimeTypeReference x, Context ctx) {
            ctx.replaceMe(ResolveRuntimeTypeReferences.this.getTypeIdExpression(x.getReferredType()));
        }
    }

    private class RuntimeTypeCollectorVisitor
    extends JVisitor {
        private final Multiset<JReferenceType> typesRequiringRuntimeIds = LinkedHashMultiset.create();

        private RuntimeTypeCollectorVisitor() {
        }

        @Override
        public void endVisit(JRuntimeTypeReference x, Context ctx) {
            this.typesRequiringRuntimeIds.add(x.getReferredType());
        }

        @Override
        public void endVisit(JMethodCall x, Context ctx) {
            if (!x.isStaticDispatchOnly() || x.getTarget().isStatic()) {
                return;
            }
            this.typesRequiringRuntimeIds.add(x.getTarget().getEnclosingType());
        }

        @Override
        public void endVisit(JReferenceType x, Context ctx) {
            if (((ResolveRuntimeTypeReferences)ResolveRuntimeTypeReferences.this).program.typeOracle.isInstantiatedType(x)) {
                this.typesRequiringRuntimeIds.add(x);
            }
        }
    }

    public static class ClosureUniqueIdTypeMapper
    implements TypeMapper<JMethodCall> {
        private JProgram program;

        public ClosureUniqueIdTypeMapper(JProgram program) {
            this.program = program;
        }

        @Override
        public void copyFrom(TypeMapper<JMethodCall> that) {
            if (!(that instanceof ClosureUniqueIdTypeMapper)) {
                throw new IllegalArgumentException("Can only copy from ClosureUniqueIdTypeMapper");
            }
        }

        @Override
        public JMethodCall getOrCreateTypeId(JType type) {
            return this.get(type);
        }

        @Override
        public JMethodCall get(JType type) {
            JMethod getUniqueId = this.program.getIndexedMethod("Runtime.uniqueId");
            return new JMethodCall(type.getSourceInfo(), null, getUniqueId, this.program.getStringLiteral(type.getSourceInfo(), type.getName()));
        }
    }

    public static class StringTypeMapper
    implements TypeMapper<JStringLiteral> {
        private JProgram program;

        public StringTypeMapper(JProgram program) {
            this.program = program;
        }

        @Override
        public void copyFrom(TypeMapper<JStringLiteral> that) {
            if (!(that instanceof StringTypeMapper)) {
                throw new IllegalArgumentException("Can only copy from StringTypeMapper");
            }
        }

        @Override
        public JStringLiteral getOrCreateTypeId(JType type) {
            return this.get(type);
        }

        @Override
        public JStringLiteral get(JType type) {
            return this.program.getStringLiteral(type.getSourceInfo(), type.getName());
        }
    }

    public static class IntTypeMapper
    implements Serializable,
    TypeMapper<JIntLiteral> {
        private final Map<String, Integer> typeIdByTypeName = Maps.newHashMap();
        private int nextAvailableId = 0;

        @Override
        public void copyFrom(TypeMapper<JIntLiteral> that) {
            if (!(that instanceof IntTypeMapper)) {
                throw new IllegalArgumentException("Can only copy from IntTypeMapper");
            }
            IntTypeMapper from = (IntTypeMapper)that;
            this.nextAvailableId = from.nextAvailableId;
            this.typeIdByTypeName.clear();
            this.typeIdByTypeName.putAll(from.typeIdByTypeName);
        }

        @VisibleForTesting
        public boolean hasSameContent(IntTypeMapper that) {
            return Objects.equal(this.typeIdByTypeName, that.typeIdByTypeName) && Objects.equal(this.nextAvailableId, that.nextAvailableId);
        }

        @Override
        public JIntLiteral get(JType type) {
            Integer typeId = this.typeIdByTypeName.get(type.getName());
            return typeId == null ? null : new JIntLiteral(type.getSourceInfo(), typeId);
        }

        @Override
        public JIntLiteral getOrCreateTypeId(JType type) {
            String typeName = type.getName();
            if (!this.typeIdByTypeName.containsKey(typeName)) {
                int nextId = this.nextAvailableId++;
                this.typeIdByTypeName.put(typeName, nextId);
            }
            return this.get(type);
        }
    }

    public static interface TypeMapper<T extends JExpression> {
        public T getOrCreateTypeId(JType var1);

        public void copyFrom(TypeMapper<T> var1);

        public T get(JType var1);
    }

    public static enum TypeOrder {
        ALPHABETICAL,
        FREQUENCY,
        NONE;

    }
}

