/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl;

import com.google.gwt.dev.PropertyAndBindingInfo;
import com.google.gwt.dev.cfg.BindingProperty;
import com.google.gwt.dev.cfg.PermutationProperties;
import com.google.gwt.dev.jjs.InternalCompilerException;
import com.google.gwt.dev.jjs.SourceInfo;
import com.google.gwt.dev.jjs.SourceOrigin;
import com.google.gwt.dev.jjs.ast.AccessModifier;
import com.google.gwt.dev.jjs.ast.Context;
import com.google.gwt.dev.jjs.ast.JBlock;
import com.google.gwt.dev.jjs.ast.JCaseStatement;
import com.google.gwt.dev.jjs.ast.JClassType;
import com.google.gwt.dev.jjs.ast.JExpression;
import com.google.gwt.dev.jjs.ast.JMethod;
import com.google.gwt.dev.jjs.ast.JMethodBody;
import com.google.gwt.dev.jjs.ast.JMethodCall;
import com.google.gwt.dev.jjs.ast.JModVisitor;
import com.google.gwt.dev.jjs.ast.JPermutationDependentValue;
import com.google.gwt.dev.jjs.ast.JProgram;
import com.google.gwt.dev.jjs.ast.JReferenceType;
import com.google.gwt.dev.jjs.ast.JReturnStatement;
import com.google.gwt.dev.jjs.ast.JStatement;
import com.google.gwt.dev.jjs.ast.JSwitchStatement;
import com.google.gwt.thirdparty.guava.common.base.Function;
import com.google.gwt.thirdparty.guava.common.base.Joiner;
import com.google.gwt.thirdparty.guava.common.collect.FluentIterable;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import com.google.gwt.thirdparty.guava.common.collect.Maps;
import com.google.gwt.thirdparty.guava.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ResolvePermutationDependentValues {
    private final JProgram program;
    private final PermutationProperties props;
    private final Set<String> bindingPropertyNames;
    private final List<PropertyAndBindingInfo> permutationPropertyAndBindingInfo;
    private final PropertyAndBindingInfo commonPropertyAndBindingInfo;
    private final JClassType holderType;
    private final JMethod permutationIdMethod;
    private final Map<String, JMethod> softPermutationMethods = Maps.newHashMap();

    public static boolean exec(JProgram program, PermutationProperties props, List<PropertyAndBindingInfo> propertyAndBindingInfo) {
        return new ResolvePermutationDependentValues(program, props, propertyAndBindingInfo).execImpl();
    }

    private ResolvePermutationDependentValues(JProgram program, PermutationProperties props, List<PropertyAndBindingInfo> gwtCreateAnswers) {
        this.program = program;
        this.permutationPropertyAndBindingInfo = gwtCreateAnswers;
        this.props = props;
        this.bindingPropertyNames = FluentIterable.from(props.getBindingProperties()).transform(new Function<BindingProperty, String>(){

            @Override
            public String apply(BindingProperty bindingProperty) {
                return bindingProperty.getName();
            }
        }).toSet();
        this.commonPropertyAndBindingInfo = PropertyAndBindingInfo.getCommonAnswers(gwtCreateAnswers);
        this.holderType = (JClassType)program.getIndexedType("CollapsedPropertyHolder");
        this.permutationIdMethod = program.getIndexedMethod("CollapsedPropertyHolder.getPermutationId");
    }

    public JExpression computeInstantiationExpression(JPermutationDependentValue x) {
        String reqType = x.getRequestedValue();
        String reboundClassName = this.commonPropertyAndBindingInfo.getReboundType(reqType);
        if (reboundClassName == null) {
            throw new InternalCompilerException("Unexpected failure to rebind '" + reqType + "'");
        }
        assert (this.program.getFromTypeMap(reboundClassName) != null);
        int index = x.getResultValues().indexOf(reboundClassName);
        if (index == -1) {
            throw new InternalCompilerException("No matching rebind result in all rebind results!");
        }
        return x.getResultExpressions().get(index);
    }

    private boolean execImpl() {
        ValueReplacer valueReplacer = new ValueReplacer();
        valueReplacer.accept(this.program);
        return valueReplacer.didChange();
    }

    private boolean isSoftTypeRebind(String requestType) {
        return !this.commonPropertyAndBindingInfo.containsType(requestType);
    }

    private boolean isSoftPermutationProperty(String propertyName) {
        return this.bindingPropertyNames.contains(propertyName) && !this.commonPropertyAndBindingInfo.containsProperty(propertyName);
    }

    private JMethod getOrCreateSoftPropertyMethod(final SourceInfo info, String propertyName) {
        JMethod toReturn = this.softPermutationMethods.get(propertyName);
        if (toReturn != null) {
            return toReturn;
        }
        Multimap<String, Integer> resultsToPermutations = PropertyAndBindingInfo.getPermutationIdsByPropertyName(this.permutationPropertyAndBindingInfo, propertyName);
        ArrayList<String> propertyValues = Lists.newArrayList(resultsToPermutations.keySet());
        return this.createReboundValueSelectorMethod(info, "property_", propertyName, this.program.getTypeJavaLangString(), propertyValues, FluentIterable.from(propertyValues).transform(new Function<String, JExpression>(){

            @Override
            public JExpression apply(String s) {
                return ResolvePermutationDependentValues.this.program.getLiteral(info, s);
            }
        }).toList(), resultsToPermutations);
    }

    private JMethod getOrCreateTypeRebindMethod(SourceInfo info, String requestType, List<String> resultTypes, List<JExpression> instantiationExpressions) {
        assert (resultTypes.size() == instantiationExpressions.size());
        JMethod toReturn = this.softPermutationMethods.get(requestType);
        if (toReturn != null) {
            return toReturn;
        }
        Multimap<String, Integer> resultsToPermutations = PropertyAndBindingInfo.getPermutationIdsByRequestTypes(this.permutationPropertyAndBindingInfo, requestType);
        return this.createReboundValueSelectorMethod(info, "create_", requestType, this.program.getTypeJavaLangObject().strengthenToNonNull(), resultTypes, instantiationExpressions, resultsToPermutations);
    }

    private JMethod createReboundValueSelectorMethod(SourceInfo info, String prefix, String parameterType, JReferenceType returntype, List<String> results, List<JExpression> resultExpressions, Multimap<String, Integer> resultsToPermutations) {
        String mostUsed = this.mostUsedValue(resultsToPermutations);
        assert (mostUsed != null);
        info = info.makeChild(SourceOrigin.UNKNOWN);
        JMethod toReturn = new JMethod(info, prefix + parameterType.replace("_", "_1").replace('.', '_'), this.holderType, returntype, false, true, true, AccessModifier.PUBLIC);
        toReturn.setBody(new JMethodBody(info));
        this.holderType.addMethod(toReturn);
        toReturn.freezeParamTypes();
        info.addCorrelation(info.getCorrelator().by(toReturn));
        this.softPermutationMethods.put(parameterType, toReturn);
        JExpression mostUsedExpression = null;
        JBlock switchBody = new JBlock(info, new JStatement[0]);
        int j = results.size();
        for (int i = 0; i < j; ++i) {
            String resultType = results.get(i);
            JExpression expression = resultExpressions.get(i);
            Collection<Integer> permutations = resultsToPermutations.get(resultType);
            if (permutations.isEmpty()) continue;
            if (resultType.equals(mostUsed)) {
                mostUsedExpression = expression;
                continue;
            }
            for (int permutationId : permutations) {
                switchBody.addStmt(new JCaseStatement(info, this.program.getLiteralInt(permutationId)));
            }
            switchBody.addStmt(expression.makeReturnStatement());
        }
        assert (switchBody.getStatements().size() > 0) : "No case statement emitted for supposedly soft-rebind " + parameterType;
        JSwitchStatement sw = new JSwitchStatement(info, new JMethodCall(info, null, this.permutationIdMethod, new JExpression[0]), switchBody);
        assert (mostUsedExpression != null) : "No most-used expression";
        JReturnStatement fallbackReturn = mostUsedExpression.makeReturnStatement();
        JMethodBody body = (JMethodBody)toReturn.getBody();
        body.getBlock().addStmt(sw);
        body.getBlock().addStmt(fallbackReturn);
        return toReturn;
    }

    private String mostUsedValue(Multimap<String, Integer> resultsToPermutations) {
        String mostUsed = null;
        int max = 0;
        for (String key : resultsToPermutations.keySet()) {
            int size = resultsToPermutations.get(key).size();
            if (size <= max) continue;
            max = size;
            mostUsed = key;
        }
        return mostUsed;
    }

    private class ValueReplacer
    extends JModVisitor {
        private ValueReplacer() {
        }

        @Override
        public void endVisit(JPermutationDependentValue x, Context ctx) {
            if (x.isTypeRebind()) {
                ctx.replaceMe(this.rebindClassExpression(x));
                return;
            }
            assert (x.isProperty());
            ctx.replaceMe(this.propertyValueExpression(x));
        }

        private JExpression propertyValueExpression(JPermutationDependentValue x) {
            String propertyValue;
            List<String> propertyValues = ResolvePermutationDependentValues.this.props.getConfigurationProperties().getStrings(x.getRequestedValue());
            String string = propertyValue = propertyValues.isEmpty() ? null : Joiner.on(",").join(propertyValues);
            if (propertyValue != null) {
                return ResolvePermutationDependentValues.this.program.getLiteral(x.getSourceInfo(), propertyValue);
            }
            if (ResolvePermutationDependentValues.this.isSoftPermutationProperty(x.getRequestedValue())) {
                JMethod method = ResolvePermutationDependentValues.this.getOrCreateSoftPropertyMethod(x.getSourceInfo(), x.getRequestedValue());
                return new JMethodCall(x.getSourceInfo(), null, method, new JExpression[0]);
            }
            propertyValue = ResolvePermutationDependentValues.this.commonPropertyAndBindingInfo.getPropertyValue(x.getRequestedValue());
            if (propertyValue != null) {
                return ResolvePermutationDependentValues.this.program.getLiteral(x.getSourceInfo(), propertyValue);
            }
            return x.getDefaultValueExpression();
        }

        private JExpression rebindClassExpression(JPermutationDependentValue x) {
            if (ResolvePermutationDependentValues.this.isSoftTypeRebind(x.getRequestedValue())) {
                JMethod method = ResolvePermutationDependentValues.this.getOrCreateTypeRebindMethod(x.getSourceInfo(), x.getRequestedValue(), x.getResultValues(), x.getResultExpressions());
                return new JMethodCall(x.getSourceInfo(), null, method, new JExpression[0]);
            }
            return ResolvePermutationDependentValues.this.computeInstantiationExpression(x);
        }
    }
}

