/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl;

import com.google.gwt.dev.jjs.ast.Context;
import com.google.gwt.dev.jjs.ast.JField;
import com.google.gwt.dev.jjs.ast.JFieldRef;
import com.google.gwt.dev.jjs.ast.JMethod;
import com.google.gwt.dev.jjs.ast.JMethodCall;
import com.google.gwt.dev.jjs.ast.JModVisitor;
import com.google.gwt.dev.jjs.ast.JProgram;
import com.google.gwt.dev.jjs.ast.JType;

public class ReplaceGetClassOverrides {
    public static void exec(JProgram program) {
        new GetClassInlinerRemover(program).accept(program);
    }

    private static class GetClassInlinerRemover
    extends JModVisitor {
        private JProgram program;
        private JMethod getClassMethod;
        private JField clazzField;

        public GetClassInlinerRemover(JProgram program) {
            this.program = program;
            this.getClassMethod = program.getIndexedMethod("Object.getClass");
            this.clazzField = program.getIndexedField("Object.___clazz");
        }

        @Override
        public void endVisit(JMethod x, Context ctx) {
            if (!this.isGetClassMethod(x)) {
                return;
            }
            if (x.getEnclosingType() == this.program.getTypeJavaLangObject()) {
                x.getOverridingMethods().clear();
                return;
            }
            ctx.removeMe();
        }

        @Override
        public void endVisit(JMethodCall x, Context ctx) {
            if (this.isGetClassMethod(x.getTarget())) {
                assert (!this.isGetClassDevirtualized(x.getTarget().getEnclosingType()));
                ctx.replaceMe(new JFieldRef(x.getSourceInfo(), x.getInstance(), this.clazzField, this.clazzField.getEnclosingType()));
            }
        }

        private boolean isGetClassMethod(JMethod method) {
            return method == this.getClassMethod || method.getOverriddenMethods().contains(this.getClassMethod);
        }

        private boolean isGetClassDevirtualized(JType type) {
            return type == this.program.getJavaScriptObject() || this.program.getRepresentedAsNativeTypes().contains(type) || type.isJsNative();
        }
    }
}

