/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl;

import com.google.gwt.dev.jjs.ast.Context;
import com.google.gwt.dev.jjs.ast.JMethod;
import com.google.gwt.dev.jjs.ast.JMethodCall;
import com.google.gwt.dev.jjs.ast.JModVisitor;
import com.google.gwt.dev.jjs.ast.JProgram;
import com.google.gwt.thirdparty.guava.common.collect.ImmutableSet;
import com.google.gwt.thirdparty.guava.common.collect.Iterables;
import com.google.gwt.thirdparty.guava.common.collect.Sets;

public class ReplaceCallsToNativeJavaLangObjectOverrides {
    public static void exec(JProgram program) {
        final ImmutableSet<JMethod> overridableJavaLangObjectMethods = ImmutableSet.of(program.getIndexedMethodOrNull("Object.equals"), program.getIndexedMethodOrNull("Object.hashCode"), program.getIndexedMethodOrNull("Object.toString"));
        new JModVisitor(){

            @Override
            public void endVisit(JMethodCall x, Context ctx) {
                JMethod targetMethod = x.getTarget();
                if (!targetMethod.isJsNative()) {
                    return;
                }
                JMethod overridenMethod = Iterables.getOnlyElement(Sets.intersection(targetMethod.getOverriddenMethods(), overridableJavaLangObjectMethods), null);
                if (overridenMethod == null) {
                    return;
                }
                ctx.replaceMe(new JMethodCall(x.getSourceInfo(), x.getInstance(), overridenMethod, x.getArgs()));
            }
        }.accept(program);
    }
}

