/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl;

import com.google.gwt.dev.jjs.ast.Context;
import com.google.gwt.dev.jjs.ast.JConstructor;
import com.google.gwt.dev.jjs.ast.JExpression;
import com.google.gwt.dev.jjs.ast.JExpressionStatement;
import com.google.gwt.dev.jjs.ast.JMethodCall;
import com.google.gwt.dev.jjs.ast.JModVisitor;
import com.google.gwt.dev.jjs.ast.JProgram;
import com.google.gwt.dev.jjs.ast.js.JMultiExpression;
import com.google.gwt.dev.jjs.impl.JjsUtils;

public class RemoveEmptySuperCalls {
    public static boolean exec(JProgram program) {
        EmptySuperCallVisitor v = new EmptySuperCallVisitor();
        v.accept(program);
        return v.didChange();
    }

    public static class EmptySuperCallVisitor
    extends JModVisitor {
        @Override
        public void endVisit(JExpressionStatement x, Context ctx) {
            JMethodCall call = JjsUtils.getThisOrSuperConstructorCall(x);
            if (call == null) {
                return;
            }
            JConstructor ctor = (JConstructor)call.getTarget();
            if (ctor.isEmpty() && !ctor.isJsNative()) {
                if (call.getArgs().isEmpty()) {
                    ctx.removeMe();
                } else if (call.getArgs().size() == 1) {
                    ctx.replaceMe(call.getArgs().get(0).makeStatement());
                } else {
                    JMultiExpression multi = new JMultiExpression(call.getSourceInfo(), new JExpression[0]);
                    multi.addExpressions(call.getArgs());
                    ctx.replaceMe(multi.makeStatement());
                }
            }
        }
    }
}

