/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl;

import com.google.gwt.dev.javac.JdtUtil;
import com.google.gwt.dev.jjs.InternalCompilerException;
import com.google.gwt.dev.jjs.SourceInfo;
import com.google.gwt.dev.jjs.SourceOrigin;
import com.google.gwt.dev.jjs.ast.AccessModifier;
import com.google.gwt.dev.jjs.ast.JArrayType;
import com.google.gwt.dev.jjs.ast.JClassType;
import com.google.gwt.dev.jjs.ast.JConstructor;
import com.google.gwt.dev.jjs.ast.JDeclaredType;
import com.google.gwt.dev.jjs.ast.JEnumType;
import com.google.gwt.dev.jjs.ast.JField;
import com.google.gwt.dev.jjs.ast.JInterfaceType;
import com.google.gwt.dev.jjs.ast.JMethod;
import com.google.gwt.dev.jjs.ast.JParameter;
import com.google.gwt.dev.jjs.ast.JPrimitiveType;
import com.google.gwt.dev.jjs.ast.JReferenceType;
import com.google.gwt.dev.jjs.ast.JType;
import com.google.gwt.dev.jjs.impl.GwtAstBuilder;
import com.google.gwt.dev.util.StringInterner;
import com.google.gwt.thirdparty.guava.common.base.Preconditions;
import com.google.gwt.thirdparty.guava.common.collect.Interner;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticArgumentBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;

public class ReferenceMapper {
    private final List<String> argNames = new ArrayList<String>();
    private final Map<String, JField> fields = new HashMap<String, JField>();
    private final Map<String, JMethod> methods = new HashMap<String, JMethod>();
    private final Map<String, JField> sourceFields = new HashMap<String, JField>();
    private final Map<String, JMethod> sourceMethods = new HashMap<String, JMethod>();
    private final Map<String, JReferenceType> sourceTypes = new HashMap<String, JReferenceType>();
    private final Interner<String> stringInterner = StringInterner.get();
    private final Map<String, JType> types = new HashMap<String, JType>();

    public ReferenceMapper() {
        this.put(JPrimitiveType.BOOLEAN, JPrimitiveType.BYTE, JPrimitiveType.CHAR, JPrimitiveType.DOUBLE, JPrimitiveType.FLOAT, JPrimitiveType.INT, JPrimitiveType.LONG, JPrimitiveType.SHORT, JPrimitiveType.VOID, JReferenceType.NULL_TYPE);
    }

    public void clearSource() {
        this.sourceFields.clear();
        this.sourceMethods.clear();
        this.sourceTypes.clear();
    }

    public JField get(FieldBinding binding) {
        String key = JdtUtil.signature(binding = binding.original());
        JField sourceField = this.sourceFields.get(key);
        if (sourceField != null) {
            assert (!sourceField.isExternal());
            return sourceField;
        }
        JField field = this.fields.get(key);
        if (field == null) {
            field = this.createField(binding);
            assert (field.isExternal());
            this.fields.put(key, field);
        }
        return field;
    }

    public JMethod get(MethodBinding binding) {
        String key = JdtUtil.signature(binding = binding.original());
        JMethod sourceMethod = this.sourceMethods.get(key);
        if (sourceMethod != null) {
            assert (!sourceMethod.isExternal());
            return sourceMethod;
        }
        JMethod method = this.methods.get(key);
        if (method == null) {
            method = binding.isConstructor() ? this.createConstructor(SourceOrigin.UNKNOWN, binding) : this.createMethod(SourceOrigin.UNKNOWN, binding, null);
            assert (binding instanceof SyntheticMethodBinding || method.isExternal());
            this.methods.put(key, method);
        }
        return method;
    }

    public JType get(TypeBinding binding) {
        String key = JdtUtil.signature(binding = binding.erasure());
        JReferenceType sourceType = this.sourceTypes.get(key);
        if (sourceType != null) {
            assert (!sourceType.isExternal());
            return sourceType;
        }
        JType type = this.types.get(key);
        if (type != null) {
            assert (type.isPrimitiveType() || type.isNullType() || type.isExternal());
            return type;
        }
        assert (!(binding instanceof BaseTypeBinding));
        if (binding instanceof ArrayBinding) {
            ArrayBinding arrayBinding = (ArrayBinding)binding;
            JArrayType arrayType = new JArrayType(this.get(arrayBinding.elementsType()));
            if (arrayType.isExternal()) {
                this.types.put(key, arrayType);
            } else {
                this.sourceTypes.put(key, arrayType);
            }
            return arrayType;
        }
        assert (binding.isClass() || binding.isInterface() || binding.isEnum()) : "Expecting a declared type binding but got " + binding;
        ReferenceBinding refBinding = (ReferenceBinding)binding;
        JDeclaredType declType = this.createType(refBinding);
        try {
            ReferenceBinding[] superInterfaces;
            ReferenceBinding superclass;
            if (declType instanceof JClassType && (superclass = refBinding.superclass()) != null && superclass.isValidBinding()) {
                ((JClassType)declType).setSuperClass((JClassType)this.get(superclass));
            }
            if ((superInterfaces = refBinding.superInterfaces()) != null) {
                for (ReferenceBinding intf : superInterfaces) {
                    if (!intf.isValidBinding()) continue;
                    declType.addImplements((JInterfaceType)this.get(intf));
                }
            }
        }
        catch (AbortCompilation superInterfaces) {
            // empty catch block
        }
        JMethod clinit = new JMethod(SourceOrigin.UNKNOWN, "$clinit", declType, JPrimitiveType.VOID, false, true, true, AccessModifier.PRIVATE);
        clinit.freezeParamTypes();
        clinit.setSynthetic();
        declType.addMethod(clinit);
        declType.setExternal(true);
        this.types.put(key, declType);
        return declType;
    }

    public void setField(FieldBinding binding, JField field) {
        Preconditions.checkArgument(this.get(binding.declaringClass.erasure()) == field.getEnclosingType());
        String key = JdtUtil.signature(binding);
        JField oldField = this.sourceFields.put(key, field);
        Preconditions.checkState(oldField == null);
    }

    public void setMethod(MethodBinding binding, JMethod method) {
        Preconditions.checkArgument(this.get(binding.declaringClass.erasure()) == method.getEnclosingType());
        String key = JdtUtil.signature(binding);
        JMethod oldMethod = this.sourceMethods.put(key, method);
        Preconditions.checkState(oldMethod == null);
    }

    public void setSourceType(SourceTypeBinding binding, JDeclaredType type) {
        String key = JdtUtil.signature(binding);
        this.sourceTypes.put(key, type);
    }

    JMethod createConstructor(SourceInfo info, MethodBinding b) {
        JDeclaredType enclosingType = (JDeclaredType)this.get(b.declaringClass);
        JConstructor method = new JConstructor(info, (JClassType)enclosingType, AccessModifier.fromMethodBinding(b));
        enclosingType.addMethod(method);
        int argPosition = 0;
        ReferenceBinding declaringClass = b.declaringClass;
        if (declaringClass.isNestedType() && !declaringClass.isStatic() && declaringClass.syntheticEnclosingInstanceTypes() != null) {
            for (ReferenceBinding referenceBinding : declaringClass.syntheticEnclosingInstanceTypes()) {
                this.createParameter(info, referenceBinding, method, argPosition++);
            }
        }
        argPosition = this.mapParameters(info, (JMethod)method, b, argPosition);
        if (declaringClass.isNestedType() && !declaringClass.isStatic() && declaringClass.syntheticOuterLocalVariables() != null) {
            for (Binding binding : declaringClass.syntheticOuterLocalVariables()) {
                this.createParameter(info, ((SyntheticArgumentBinding)binding).type, method, argPosition++);
            }
        }
        this.mapExceptions(method, b);
        if (b.isSynthetic()) {
            method.setSynthetic();
        }
        return method;
    }

    JMethod createMethod(SourceInfo info, MethodBinding b, String[] paramNames) {
        JDeclaredType enclosingType = (JDeclaredType)this.get(b.declaringClass);
        JMethod method = new JMethod(info, this.intern(b.selector), enclosingType, this.get(b.returnType), b.isAbstract(), b.isStatic(), b.isFinal(), AccessModifier.fromMethodBinding(b));
        enclosingType.addMethod(method);
        if (paramNames == null) {
            this.mapParameters(info, method, b, 0);
        } else {
            this.mapParameters(info, method, b, paramNames);
        }
        this.mapExceptions(method, b);
        if (b.isSynthetic()) {
            method.setSynthetic();
        }
        return method;
    }

    private JField createField(FieldBinding binding) {
        JDeclaredType enclosingType = (JDeclaredType)this.get(binding.declaringClass);
        JField field = new JField(SourceOrigin.UNKNOWN, this.intern(binding.name), enclosingType, this.get(binding.type), binding.isStatic(), GwtAstBuilder.getFieldDisposition(binding), AccessModifier.fromFieldBinding(binding));
        enclosingType.addField(field);
        return field;
    }

    private JParameter createParameter(SourceInfo info, TypeBinding paramType, JMethod enclosingMethod, int argPosition) {
        this.ensureArgNames(argPosition);
        return enclosingMethod.createFinalParameter(info, this.argNames.get(argPosition), this.get(paramType));
    }

    private JDeclaredType createType(ReferenceBinding binding) {
        String name = JdtUtil.getQualifiedSourceName(binding);
        SourceOrigin info = SourceOrigin.UNKNOWN;
        if (binding.isClass()) {
            return new JClassType(info, name, binding.isAbstract(), binding.isFinal());
        }
        if (binding.isInterface() || binding.isAnnotationType()) {
            return new JInterfaceType(info, name);
        }
        if (binding.isEnum()) {
            if (binding.isAnonymousType()) {
                return new JClassType(info, name, false, true);
            }
            return new JEnumType(info, name, binding.isAbstract());
        }
        throw new InternalCompilerException("ReferenceBinding is not a class, interface, or enum.");
    }

    private void ensureArgNames(int required) {
        for (int i = this.argNames.size(); i <= required; ++i) {
            this.argNames.add(this.intern("arg" + i));
        }
    }

    private String intern(char[] cs) {
        return this.intern(String.valueOf(cs));
    }

    private String intern(String s) {
        return this.stringInterner.intern(s);
    }

    private void mapExceptions(JMethod method, MethodBinding binding) {
        for (ReferenceBinding thrownBinding : binding.thrownExceptions) {
            JClassType type = (JClassType)this.get(thrownBinding);
            method.addThrownException(type);
        }
    }

    private int mapParameters(SourceInfo info, JMethod method, MethodBinding binding, int argPosition) {
        if (binding.parameters != null) {
            this.ensureArgNames(argPosition + binding.parameters.length);
            for (TypeBinding argType : binding.parameters) {
                method.createFinalParameter(info, this.argNames.get(argPosition++), this.get(argType));
            }
        }
        method.freezeParamTypes();
        return argPosition;
    }

    private void mapParameters(SourceInfo info, JMethod method, MethodBinding binding, String[] paramNames) {
        if (binding.parameters != null) {
            int i = 0;
            for (TypeBinding argType : binding.parameters) {
                method.createFinalParameter(info, paramNames[i++], this.get(argType));
            }
        }
        method.freezeParamTypes();
    }

    private void put(JType ... baseTypes) {
        for (JType type : baseTypes) {
            this.types.put(type.getName(), type);
        }
    }
}

