/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl;

import com.google.gwt.dev.jjs.ast.Context;
import com.google.gwt.dev.jjs.ast.JPermutationDependentValue;
import com.google.gwt.dev.jjs.ast.JProgram;
import com.google.gwt.dev.jjs.ast.JVisitor;
import com.google.gwt.dev.util.log.speedtracer.CompilerEventType;
import com.google.gwt.dev.util.log.speedtracer.SpeedTracerLogger;
import com.google.gwt.thirdparty.guava.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;

public class RecordRebinds {
    private final Set<String> liveRebindRequests;
    private final JProgram program;

    public static Set<String> exec(JProgram program) {
        SpeedTracerLogger.Event recordRebindsEvent = SpeedTracerLogger.start(CompilerEventType.RECORD_REBINDS, new String[0]);
        HashSet<String> liveRebindRequests = Sets.newHashSet();
        new RecordRebinds(program, liveRebindRequests).execImpl();
        recordRebindsEvent.end(new String[0]);
        return liveRebindRequests;
    }

    private RecordRebinds(JProgram program, Set<String> liveRebindRequests) {
        this.program = program;
        this.liveRebindRequests = liveRebindRequests;
    }

    private void execImpl() {
        RebindVisitor rebinder = new RebindVisitor();
        rebinder.accept(this.program);
    }

    private class RebindVisitor
    extends JVisitor {
        private RebindVisitor() {
        }

        @Override
        public void endVisit(JPermutationDependentValue x, Context ctx) {
            if (x.isTypeRebind()) {
                RecordRebinds.this.liveRebindRequests.add(x.getRequestedValue());
            }
        }
    }
}

