/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl;

import cern.colt.list.IntArrayList;
import cern.colt.map.OpenIntIntHashMap;
import com.google.gwt.dev.util.collect.IntMultimap;
import com.google.gwt.dev.util.collect.IntStack;
import java.util.BitSet;

public class RapidTypeAnalyzer {
    private AnalyzableTypeEnvironment analyzableTypeEnvironment;
    private BitSet instantiatedTypeIds = new BitSet();
    private IntMultimap knownOverridingMethodIdsByOverriddenMethodId = new IntMultimap();
    private BitSet overidingMethodIdsOfReachableMethods = new BitSet();
    private BitSet reachableMethodIds = new BitSet();
    private OpenIntIntHashMap reachableTypeIds = new OpenIntIntHashMap();
    private IntStack unprocessedReachableMethodIds = new IntStack();

    public RapidTypeAnalyzer(AnalyzableTypeEnvironment analyzableTypeEnvironment) {
        this.analyzableTypeEnvironment = analyzableTypeEnvironment;
    }

    public IntArrayList computeReachableTypeIds() {
        while (!this.unprocessedReachableMethodIds.isEmpty()) {
            int reachableMethodId = this.unprocessedReachableMethodIds.pop();
            this.addReachableTypeIds(this.analyzableTypeEnvironment.getStaticallyReferencedTypeIdsIn(reachableMethodId));
            this.markTypeIdsInstantiated(this.analyzableTypeEnvironment.getTypeIdsInstantiatedIn(reachableMethodId));
            this.markMethodIdsReachable(this.analyzableTypeEnvironment.getMethodIdsCalledBy(reachableMethodId), true);
        }
        return this.reachableTypeIds.keys();
    }

    public void markMemberMethodIdsReachable(int typeId) {
        IntArrayList memberMethodIds = this.analyzableTypeEnvironment.getMemberMethodIdsIn(typeId);
        if (memberMethodIds == null) {
            return;
        }
        this.markMethodIdsReachable(memberMethodIds, true);
    }

    public void markMethodIdReachable(int methodId, boolean cascade) {
        IntArrayList values;
        if (this.reachableMethodIds.get(methodId)) {
            return;
        }
        this.overidingMethodIdsOfReachableMethods.set(methodId);
        this.unprocessedReachableMethodIds.push(methodId);
        this.reachableMethodIds.set(methodId);
        this.recordOverridingMethodIdsOfReachableMethod(methodId);
        if (cascade && (values = this.knownOverridingMethodIdsByOverriddenMethodId.get(methodId)) != null) {
            for (int i = 0; i < values.size(); ++i) {
                int overridingMethodId = values.get(i);
                this.markMethodIdReachable(overridingMethodId, false);
            }
        }
    }

    public void markTypeIdReachable(int typeId) {
        this.reachableTypeIds.put(typeId, typeId);
    }

    private void addReachableTypeIds(IntArrayList typeIds) {
        if (typeIds == null) {
            return;
        }
        for (int i = 0; i < typeIds.size(); ++i) {
            int typeId = typeIds.get(i);
            this.markTypeIdReachable(typeId);
        }
    }

    private void markMethodIdsReachable(IntArrayList methodIds, boolean cascade) {
        if (methodIds == null) {
            return;
        }
        for (int i = 0; i < methodIds.size(); ++i) {
            this.markMethodIdReachable(methodIds.get(i), cascade);
        }
    }

    private void markTypeIdInstantiated(int typeId) {
        int memberMethodId;
        int i;
        if (this.instantiatedTypeIds.get(typeId)) {
            return;
        }
        this.instantiatedTypeIds.set(typeId);
        this.markTypeIdReachable(typeId);
        IntArrayList memberMethodIds = this.analyzableTypeEnvironment.getMemberMethodIdsIn(typeId);
        if (memberMethodIds == null) {
            return;
        }
        for (i = 0; i < memberMethodIds.size(); ++i) {
            memberMethodId = memberMethodIds.get(i);
            IntArrayList overriddenMethodIds = this.analyzableTypeEnvironment.getOverriddenMethodIds(memberMethodId);
            if (overriddenMethodIds == null) continue;
            for (int j = 0; j < overriddenMethodIds.size(); ++j) {
                int overriddenMethodId = overriddenMethodIds.get(j);
                this.knownOverridingMethodIdsByOverriddenMethodId.put(overriddenMethodId, memberMethodId);
            }
        }
        for (i = 0; i < memberMethodIds.size(); ++i) {
            memberMethodId = memberMethodIds.get(i);
            if (!this.overidingMethodIdsOfReachableMethods.get(memberMethodId)) continue;
            this.markMethodIdReachable(memberMethodId, true);
        }
    }

    private void markTypeIdsInstantiated(IntArrayList typeIds) {
        if (typeIds == null) {
            return;
        }
        for (int i = 0; i < typeIds.size(); ++i) {
            int typeId = typeIds.get(i);
            this.markTypeIdInstantiated(typeId);
        }
    }

    private void recordOverridingMethodIdsOfReachableMethod(int methodId) {
        IntArrayList overridingMethodIds = this.analyzableTypeEnvironment.getOverridingMethodIds(methodId);
        if (overridingMethodIds != null) {
            for (int i = 0; i < overridingMethodIds.size(); ++i) {
                int overridingMethodId = overridingMethodIds.get(i);
                this.overidingMethodIdsOfReachableMethods.set(overridingMethodId);
            }
        }
    }

    public static interface AnalyzableTypeEnvironment {
        public IntArrayList getMemberMethodIdsIn(int var1);

        public IntArrayList getMethodIdsCalledBy(int var1);

        public IntArrayList getOverriddenMethodIds(int var1);

        public IntArrayList getOverridingMethodIds(int var1);

        public IntArrayList getStaticallyReferencedTypeIdsIn(int var1);

        public IntArrayList getTypeIdsInstantiatedIn(int var1);
    }
}

