/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl;

import com.google.gwt.dev.jjs.InternalCompilerException;
import com.google.gwt.dev.jjs.SourceInfo;
import com.google.gwt.dev.jjs.ast.CanBeStatic;
import com.google.gwt.dev.jjs.ast.Context;
import com.google.gwt.dev.jjs.ast.HasEnclosingType;
import com.google.gwt.dev.jjs.ast.HasName;
import com.google.gwt.dev.jjs.ast.JArrayType;
import com.google.gwt.dev.jjs.ast.JBinaryOperation;
import com.google.gwt.dev.jjs.ast.JBinaryOperator;
import com.google.gwt.dev.jjs.ast.JClassType;
import com.google.gwt.dev.jjs.ast.JConstructor;
import com.google.gwt.dev.jjs.ast.JDeclarationStatement;
import com.google.gwt.dev.jjs.ast.JDeclaredType;
import com.google.gwt.dev.jjs.ast.JExpression;
import com.google.gwt.dev.jjs.ast.JField;
import com.google.gwt.dev.jjs.ast.JFieldRef;
import com.google.gwt.dev.jjs.ast.JLocal;
import com.google.gwt.dev.jjs.ast.JMethod;
import com.google.gwt.dev.jjs.ast.JMethodBody;
import com.google.gwt.dev.jjs.ast.JMethodCall;
import com.google.gwt.dev.jjs.ast.JNameOf;
import com.google.gwt.dev.jjs.ast.JNewInstance;
import com.google.gwt.dev.jjs.ast.JNode;
import com.google.gwt.dev.jjs.ast.JParameter;
import com.google.gwt.dev.jjs.ast.JProgram;
import com.google.gwt.dev.jjs.ast.JReferenceType;
import com.google.gwt.dev.jjs.ast.JRuntimeTypeReference;
import com.google.gwt.dev.jjs.ast.JType;
import com.google.gwt.dev.jjs.ast.JVariable;
import com.google.gwt.dev.jjs.ast.JVariableRef;
import com.google.gwt.dev.jjs.ast.js.JMultiExpression;
import com.google.gwt.dev.jjs.ast.js.JsniFieldRef;
import com.google.gwt.dev.jjs.ast.js.JsniMethodRef;
import com.google.gwt.dev.jjs.impl.ControlFlowAnalyzer;
import com.google.gwt.dev.jjs.impl.JChangeTrackingVisitor;
import com.google.gwt.dev.jjs.impl.JModVisitorWithTemporaryVariableCreation;
import com.google.gwt.dev.jjs.impl.JavaAstVerifier;
import com.google.gwt.dev.jjs.impl.OptimizerContext;
import com.google.gwt.dev.jjs.impl.OptimizerStats;
import com.google.gwt.dev.util.collect.Stack;
import com.google.gwt.dev.util.log.speedtracer.CompilerEventType;
import com.google.gwt.dev.util.log.speedtracer.SpeedTracerLogger;
import com.google.gwt.thirdparty.guava.common.base.Predicate;
import com.google.gwt.thirdparty.guava.common.base.Predicates;
import com.google.gwt.thirdparty.guava.common.collect.ArrayListMultimap;
import com.google.gwt.thirdparty.guava.common.collect.ImmutableList;
import com.google.gwt.thirdparty.guava.common.collect.Iterables;
import com.google.gwt.thirdparty.guava.common.collect.ListMultimap;
import com.google.gwt.thirdparty.guava.common.collect.Sets;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class Pruner {
    private static final String NAME = Pruner.class.getSimpleName();
    private final JProgram program;
    private final boolean saveCodeGenTypes;
    private final Set<JMethod> prunedMethods = Sets.newLinkedHashSet();

    public static OptimizerStats exec(JProgram program, boolean noSpecialTypes, OptimizerContext optimizerCtx) {
        SpeedTracerLogger.Event optimizeEvent = SpeedTracerLogger.start(CompilerEventType.OPTIMIZE, "optimizer", NAME);
        OptimizerStats stats = new Pruner(program, noSpecialTypes).execImpl(optimizerCtx);
        optimizeEvent.end("didChange", "" + stats.didChange());
        return stats;
    }

    public static OptimizerStats exec(JProgram program, boolean noSpecialTypes) {
        return Pruner.exec(program, noSpecialTypes, OptimizerContext.NULL_OPTIMIZATION_CONTEXT);
    }

    public static JFieldRef transformToNullFieldRef(JFieldRef x, JProgram program) {
        JExpression instance = x.getInstance();
        if (x.getField().isStatic() && instance == null) {
            instance = program.getLiteralNull();
        }
        assert (instance != null);
        if (!instance.hasSideEffects()) {
            instance = program.getLiteralNull();
        }
        JFieldRef fieldRef = new JFieldRef(x.getSourceInfo(), instance, program.getNullField(), x.getEnclosingType(), Pruner.primitiveTypeOrNullTypeOrArray(program, x.getType()));
        return fieldRef;
    }

    public static JMethodCall transformToNullMethodCall(JMethodCall x, JProgram program) {
        JExpression instance = x.getInstance();
        List<JExpression> args = x.getArgs();
        if (program.isStaticImpl(x.getTarget())) {
            instance = args.get(0);
            args = args.subList(1, args.size());
        } else if (x.getTarget().isStatic() && instance == null) {
            instance = program.getLiteralNull();
        }
        assert (instance != null);
        if (!instance.hasSideEffects()) {
            instance = program.getLiteralNull();
        }
        JMethodCall newCall = new JMethodCall(x.getSourceInfo(), instance, program.getNullMethod(), new JExpression[0]);
        newCall.overrideReturnType(Pruner.primitiveTypeOrNullTypeOrArray(program, x.getType()));
        for (JExpression arg : args) {
            if (!arg.hasSideEffects()) continue;
            newCall.addArg(arg);
        }
        return newCall;
    }

    static JType primitiveTypeOrNullTypeOrArray(JProgram program, JType type) {
        if (type instanceof JArrayType) {
            JType leafType = Pruner.primitiveTypeOrNullTypeOrArray(program, ((JArrayType)type).getLeafType());
            return program.getOrCreateArrayType(leafType, ((JArrayType)type).getDims());
        }
        if (type.isPrimitiveType()) {
            return type;
        }
        return JReferenceType.NULL_TYPE;
    }

    private Pruner(JProgram program, boolean saveCodeGenTypes) {
        this.program = program;
        this.saveCodeGenTypes = saveCodeGenTypes;
    }

    private OptimizerStats execImpl(OptimizerContext optimizerCtx) {
        OptimizerStats stats = new OptimizerStats(NAME);
        ControlFlowAnalyzer livenessAnalyzer = new ControlFlowAnalyzer(this.program);
        livenessAnalyzer.setForPruning();
        this.traverseTypes(livenessAnalyzer, this.program.immortalCodeGenTypes);
        if (this.saveCodeGenTypes) {
            this.traverseTypes(livenessAnalyzer, this.program.codeGenTypes);
        }
        livenessAnalyzer.traverseEverything();
        this.program.typeOracle.setInstantiatedTypes(livenessAnalyzer.getInstantiatedTypes());
        PruneVisitor pruner = new PruneVisitor(livenessAnalyzer.getReferencedTypes(), livenessAnalyzer.getLiveFieldsAndMethods(), optimizerCtx);
        pruner.accept(this.program);
        stats.recordModified(pruner.getNumMods());
        if (!pruner.didChange()) {
            return stats;
        }
        CleanupRefsVisitor cleaner = new CleanupRefsVisitor(livenessAnalyzer.getLiveFieldsAndMethods(), pruner.getPriorParametersByMethod(), optimizerCtx);
        cleaner.accept(this.program.getDeclaredTypes());
        optimizerCtx.incOptimizationStep();
        optimizerCtx.syncDeletedSubCallGraphsSince(optimizerCtx.getLastStepFor(NAME) + 1, this.prunedMethods);
        JavaAstVerifier.assertProgramIsConsistent(this.program);
        return stats;
    }

    private void traverseTypes(ControlFlowAnalyzer livenessAnalyzer, List<JClassType> types) {
        for (JClassType type : types) {
            livenessAnalyzer.traverseFromReferenceTo(type);
            for (JMethod method : type.getMethods()) {
                if (method instanceof JConstructor) {
                    livenessAnalyzer.traverseFromInstantiationOf(type);
                }
                livenessAnalyzer.traverseFrom(method);
            }
        }
    }

    private class PruneVisitor
    extends JChangeTrackingVisitor {
        private final ListMultimap<JMethod, JParameter> priorParametersByMethod;
        private final Set<? extends JNode> referencedNonTypes;
        private final Set<? extends JReferenceType> referencedTypes;

        public PruneVisitor(Set<? extends JReferenceType> referencedTypes, Set<? extends JNode> referencedNodes, OptimizerContext optimizerCtx) {
            super(optimizerCtx);
            this.priorParametersByMethod = ArrayListMultimap.create();
            this.referencedTypes = referencedTypes;
            this.referencedNonTypes = referencedNodes;
        }

        public ListMultimap<JMethod, JParameter> getPriorParametersByMethod() {
            return this.priorParametersByMethod;
        }

        @Override
        public boolean visit(JDeclaredType type, Context ctx) {
            assert (this.referencedTypes.contains(type));
            Predicate<JNode> notReferenced = Predicates.not(Predicates.in(this.referencedNonTypes));
            this.removeFields(notReferenced, type);
            this.removeMethods(notReferenced, type);
            for (JMethod method : type.getMethods()) {
                this.accept(method);
            }
            return false;
        }

        @Override
        public boolean enter(JMethod x, Context ctx) {
            if (!x.canBePolymorphic()) {
                if (!this.referencedNonTypes.contains(x)) {
                    return true;
                }
                JMethod instanceMethod = Pruner.this.program.instanceMethodForStaticImpl(x);
                if (Pruner.this.saveCodeGenTypes && instanceMethod != null && this.referencedNonTypes.contains(instanceMethod)) {
                    return true;
                }
                ImmutableList<JParameter> originalParameters = ImmutableList.copyOf(x.getParams());
                for (int i = 0; i < x.getParams().size(); ++i) {
                    JParameter param = x.getParams().get(i);
                    if (this.referencedNonTypes.contains(param)) continue;
                    x.removeParam(i);
                    this.madeChanges();
                    --i;
                }
                if (x.getParams().size() != originalParameters.size()) {
                    this.priorParametersByMethod.putAll(x, originalParameters);
                }
            }
            return true;
        }

        @Override
        public boolean visit(JMethodBody x, Context ctx) {
            for (int i = 0; i < x.getLocals().size(); ++i) {
                if (this.referencedNonTypes.contains(x.getLocals().get(i))) continue;
                x.removeLocal(i--);
                this.madeChanges();
            }
            return false;
        }

        @Override
        public boolean visit(JProgram program, Context ctx) {
            Iterator<JDeclaredType> it = program.getDeclaredTypes().iterator();
            while (it.hasNext()) {
                JDeclaredType type = it.next();
                if (this.referencedTypes.contains(type)) {
                    this.accept(type);
                    continue;
                }
                Pruner.this.prunedMethods.addAll(type.getMethods());
                this.methodsWereRemoved(type.getMethods());
                this.fieldsWereRemoved(type.getFields());
                it.remove();
                this.madeChanges();
            }
            return false;
        }

        private void removeFields(Predicate<JNode> shouldRemove, JDeclaredType type) {
            for (int i = 0; i < type.getFields().size(); ++i) {
                JField field = type.getFields().get(i);
                if (!shouldRemove.apply(field)) continue;
                this.wasRemoved(field);
                type.removeField(i);
                this.madeChanges();
                --i;
            }
        }

        private void removeMethods(Predicate<JNode> shouldRemove, JDeclaredType type) {
            assert (type.getMethods().get(0) == type.getClinitMethod());
            for (int i = 1; i < type.getMethods().size(); ++i) {
                JMethod method = type.getMethods().get(i);
                if (!shouldRemove.apply(method)) continue;
                Pruner.this.prunedMethods.add(method);
                this.wasRemoved(method);
                type.removeMethod(i);
                Pruner.this.program.removeStaticImplMapping(method);
                this.madeChanges();
                --i;
            }
        }
    }

    private class CleanupRefsVisitor
    extends JModVisitorWithTemporaryVariableCreation {
        private final Stack<JExpression> lValues;
        private final ListMultimap<JMethod, JParameter> priorParametersByMethod;
        private final Set<? extends JNode> referencedNonTypes;

        public CleanupRefsVisitor(Set<? extends JNode> referencedNodes, ListMultimap<JMethod, JParameter> priorParametersByMethod, OptimizerContext optimizerCtx) {
            super(optimizerCtx);
            this.lValues = new Stack();
            this.lValues.push(null);
            this.referencedNonTypes = referencedNodes;
            this.priorParametersByMethod = priorParametersByMethod;
        }

        @Override
        public void endVisit(JBinaryOperation x, Context ctx) {
            if (x.getOp() != JBinaryOperator.ASG) {
                return;
            }
            this.lValues.pop();
            JExpression lhs = x.getLhs();
            if (!(lhs instanceof JVariableRef)) {
                return;
            }
            JVariableRef variableRef = (JVariableRef)lhs;
            if (this.isVariablePruned(variableRef.getTarget())) {
                JExpression replacement = this.makeReplacementForAssignment(x.getSourceInfo(), variableRef, x.getRhs());
                ctx.replaceMe(replacement);
            }
        }

        @Override
        public void endVisit(JDeclarationStatement x, Context ctx) {
            super.endVisit(x, ctx);
            this.lValues.pop();
            if (this.isVariablePruned(x.getVariableRef().getTarget())) {
                JExpression replacement = this.makeReplacementForAssignment(x.getSourceInfo(), x.getVariableRef(), x.getInitializer());
                ctx.replaceMe(replacement.makeStatement());
            }
        }

        @Override
        public void endVisit(JFieldRef x, Context ctx) {
            if (this.lValues.peek() == x) {
                return;
            }
            if (this.isPruned(x.getField())) {
                JFieldRef fieldRef = Pruner.transformToNullFieldRef(x, Pruner.this.program);
                ctx.replaceMe(fieldRef);
            }
        }

        @Override
        public void exit(JMethod x, Context ctx) {
            JType type = x.getType();
            if (type instanceof JReferenceType && !((Pruner)Pruner.this).program.typeOracle.isInstantiatedType((JReferenceType)type)) {
                x.setType(JReferenceType.NULL_TYPE);
            }
            Predicate<JMethod> isPruned = new Predicate<JMethod>(){

                @Override
                public boolean apply(JMethod method) {
                    return CleanupRefsVisitor.this.isPruned(method);
                }
            };
            Iterables.removeIf(x.getOverriddenMethods(), isPruned);
            Iterables.removeIf(x.getOverridingMethods(), isPruned);
        }

        @Override
        public void endVisit(JMethodCall x, Context ctx) {
            JMethod method = x.getTarget();
            if (this.isPruned(method)) {
                ctx.replaceMe(Pruner.transformToNullMethodCall(x, Pruner.this.program));
                return;
            }
            this.maybeReplaceForPrunedParameters(x, ctx);
        }

        @Override
        public void endVisit(JNameOf x, Context ctx) {
            boolean pruned;
            HasName node = x.getNode();
            if (node instanceof JField) {
                pruned = this.isPruned((JField)node);
            } else if (node instanceof JMethod) {
                pruned = this.isPruned((JMethod)node);
            } else if (node instanceof JReferenceType) {
                pruned = !((Pruner)Pruner.this).program.typeOracle.isInstantiatedType((JReferenceType)node);
            } else {
                throw new InternalCompilerException("Unhandled JNameOf node: " + node);
            }
            if (pruned) {
                ctx.replaceMe(Pruner.this.program.getLiteralNull());
            }
        }

        @Override
        public void endVisit(JNewInstance x, Context ctx) {
            this.maybeReplaceForPrunedParameters(x, ctx);
        }

        @Override
        public void endVisit(JRuntimeTypeReference x, Context ctx) {
            if (!((Pruner)Pruner.this).program.typeOracle.isInstantiatedType(x.getReferredType())) {
                ctx.replaceMe(Pruner.this.program.getLiteralNull());
            }
        }

        @Override
        public void endVisit(JsniFieldRef x, Context ctx) {
            if (this.isPruned(x.getField())) {
                String ident = x.getIdent();
                JField nullField = Pruner.this.program.getNullField();
                JsniFieldRef nullFieldRef = new JsniFieldRef(x.getSourceInfo(), ident, nullField, x.getEnclosingType(), x.isLvalue());
                ctx.replaceMe(nullFieldRef);
            }
        }

        @Override
        public void endVisit(JsniMethodRef x, Context ctx) {
            if (this.isPruned(x.getTarget())) {
                String ident = x.getIdent();
                JMethod nullMethod = Pruner.this.program.getNullMethod();
                JsniMethodRef nullMethodRef = new JsniMethodRef(x.getSourceInfo(), ident, nullMethod, Pruner.this.program.getJavaScriptObject());
                ctx.replaceMe(nullMethodRef);
            }
        }

        @Override
        public void exit(JVariable x, Context ctx) {
            JType type = x.getType();
            if (type instanceof JReferenceType && !((Pruner)Pruner.this).program.typeOracle.isInstantiatedType((JReferenceType)type)) {
                x.setType(JReferenceType.NULL_TYPE);
                this.madeChanges();
            }
        }

        @Override
        public boolean visit(JBinaryOperation x, Context ctx) {
            if (x.getOp() == JBinaryOperator.ASG) {
                this.lValues.push(x.getLhs());
            }
            return true;
        }

        @Override
        public boolean visit(JDeclarationStatement x, Context ctx) {
            super.visit(x, ctx);
            this.lValues.push(x.getVariableRef());
            return true;
        }

        private <T extends HasEnclosingType & CanBeStatic> boolean isPruned(T node) {
            if (!this.referencedNonTypes.contains(node)) {
                return true;
            }
            JDeclaredType enclosingType = node.getEnclosingType();
            return !((CanBeStatic)node).isStatic() && enclosingType != null && !((Pruner)Pruner.this).program.typeOracle.isInstantiatedType((JReferenceType)enclosingType);
        }

        private boolean isVariablePruned(JVariable variable) {
            if (variable instanceof JField) {
                return this.isPruned((JField)variable);
            }
            return !this.referencedNonTypes.contains(variable);
        }

        private JExpression makeReplacementForAssignment(SourceInfo info, JVariableRef variableRef, JExpression rhs) {
            JFieldRef fieldRef;
            JExpression instance;
            JMultiExpression multi = new JMultiExpression(info, new JExpression[0]);
            if (variableRef instanceof JFieldRef && (instance = (fieldRef = (JFieldRef)variableRef).getInstance()) != null) {
                multi.addExpressions(instance);
            }
            if (rhs != null) {
                multi.addExpressions(rhs);
            }
            if (multi.getNumberOfExpressions() == 1) {
                return multi.getExpression(0);
            }
            return multi;
        }

        private void maybeReplaceForPrunedParameters(JMethodCall x, Context ctx) {
            if (!this.priorParametersByMethod.containsKey(x.getTarget())) {
                return;
            }
            JMethodCall replacementCall = x.cloneWithoutParameters();
            assert (!x.getTarget().canBePolymorphic());
            Collection originalParams = this.priorParametersByMethod.get((Object)x.getTarget());
            assert (originalParams.size() == x.getArgs().size());
            SourceInfo sourceInfo = x.getSourceInfo();
            JMultiExpression unevaluatedArgumentsForPrunedParameters = new JMultiExpression(sourceInfo, new JExpression[0]);
            List<JExpression> args = x.getArgs();
            for (int currentArgumentIndex = 0; currentArgumentIndex < args.size(); ++currentArgumentIndex) {
                JExpression arg = args.get(currentArgumentIndex);
                if (this.referencedNonTypes.contains(originalParams.get(currentArgumentIndex))) {
                    unevaluatedArgumentsForPrunedParameters.addExpressions(arg);
                    replacementCall.addArg(unevaluatedArgumentsForPrunedParameters);
                    unevaluatedArgumentsForPrunedParameters = new JMultiExpression(sourceInfo, new JExpression[0]);
                    continue;
                }
                if (!arg.hasSideEffects()) continue;
                unevaluatedArgumentsForPrunedParameters.addExpressions(arg);
            }
            if (unevaluatedArgumentsForPrunedParameters.isEmpty()) {
                ctx.replaceMe(replacementCall);
                return;
            }
            if (replacementCall.getArgs().isEmpty()) {
                unevaluatedArgumentsForPrunedParameters.addExpressions(replacementCall);
                ctx.replaceMe(unevaluatedArgumentsForPrunedParameters);
                return;
            }
            JExpression lastArg = Iterables.getLast(replacementCall.getArgs());
            JLocal tempVar = this.createTempLocal(sourceInfo, ((JParameter)Iterables.getLast(Iterables.filter(originalParams, Predicates.in(this.referencedNonTypes)))).getType(), "lastArg");
            unevaluatedArgumentsForPrunedParameters.addExpressions(0, JProgram.createAssignment(lastArg.getSourceInfo(), tempVar.makeRef(sourceInfo), lastArg));
            unevaluatedArgumentsForPrunedParameters.addExpressions(tempVar.makeRef(sourceInfo));
            replacementCall.setArg(replacementCall.getArgs().size() - 1, unevaluatedArgumentsForPrunedParameters);
            ctx.replaceMe(replacementCall);
        }
    }
}

