/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl;

import com.google.gwt.dev.jjs.ast.JBinaryOperation;
import com.google.gwt.dev.jjs.ast.JBinaryOperator;
import com.google.gwt.dev.jjs.ast.JCastOperation;
import com.google.gwt.dev.jjs.ast.JExpression;
import com.google.gwt.dev.jjs.ast.JPostfixOperation;
import com.google.gwt.dev.jjs.ast.JPrefixOperation;
import com.google.gwt.dev.jjs.ast.JPrimitiveType;
import com.google.gwt.dev.jjs.ast.JProgram;
import com.google.gwt.dev.jjs.ast.JType;
import com.google.gwt.dev.jjs.impl.CompoundAssignmentNormalizer;

public class PostOptimizationCompoundAssignmentNormalizer
extends CompoundAssignmentNormalizer {
    public static void exec(JProgram program) {
        new PostOptimizationCompoundAssignmentNormalizer().accept(program);
    }

    protected PostOptimizationCompoundAssignmentNormalizer() {
    }

    @Override
    protected JExpression modifyResultOperation(JBinaryOperation op) {
        JType rhsType;
        JType lhsType = op.getLhs().getType();
        if (lhsType != (rhsType = op.getRhs().getType())) {
            return new JCastOperation(op.getSourceInfo(), lhsType, new JBinaryOperation(op.getSourceInfo(), this.widenType(lhsType, rhsType), op.getOp(), op.getLhs(), op.getRhs()));
        }
        return op;
    }

    @Override
    protected boolean shouldBreakUp(JBinaryOperation x) {
        if (x.getType() == JPrimitiveType.LONG) {
            return true;
        }
        if (x.getOp() == JBinaryOperator.ASG_DIV && x.getType() != JPrimitiveType.FLOAT && x.getType() != JPrimitiveType.DOUBLE) {
            return true;
        }
        JType lhsType = x.getLhs().getType();
        JType rhsType = x.getRhs().getType();
        if (lhsType == JPrimitiveType.FLOAT && rhsType == JPrimitiveType.DOUBLE) {
            return false;
        }
        return lhsType.isPrimitiveType() && rhsType.isPrimitiveType() && this.widenType(lhsType, rhsType) != lhsType;
    }

    @Override
    protected boolean shouldBreakUp(JPostfixOperation x) {
        return x.getType() == JPrimitiveType.LONG;
    }

    @Override
    protected boolean shouldBreakUp(JPrefixOperation x) {
        return x.getType() == JPrimitiveType.LONG;
    }

    private JType widenType(JType lhsType, JType rhsType) {
        if (lhsType == JPrimitiveType.DOUBLE || rhsType == JPrimitiveType.DOUBLE) {
            return JPrimitiveType.DOUBLE;
        }
        if (lhsType == JPrimitiveType.FLOAT || rhsType == JPrimitiveType.FLOAT) {
            return JPrimitiveType.FLOAT;
        }
        if (lhsType == JPrimitiveType.LONG || rhsType == JPrimitiveType.LONG) {
            return JPrimitiveType.LONG;
        }
        return JPrimitiveType.INT;
    }
}

