/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl;

import com.google.gwt.thirdparty.guava.common.base.Joiner;
import java.util.ArrayList;
import java.util.List;

public class OptimizerStats {
    private final List<OptimizerStats> children = new ArrayList<OptimizerStats>();
    private final String name;
    private int numMods = 0;
    private int numVisits = 0;

    public OptimizerStats(String name) {
        this.name = name;
    }

    public void add(OptimizerStats childStats) {
        this.children.add(childStats);
    }

    public boolean didChange() {
        if (this.numMods > 0) {
            return true;
        }
        for (OptimizerStats child : this.children) {
            if (!child.didChange()) continue;
            return true;
        }
        return false;
    }

    public List<OptimizerStats> getChildren() {
        return this.children;
    }

    public String getName() {
        return this.name;
    }

    public int getNumMods() {
        int childMods = 0;
        for (OptimizerStats child : this.children) {
            childMods += child.getNumMods();
        }
        return this.numMods + childMods;
    }

    public int getNumVisits() {
        int childVisits = 0;
        for (OptimizerStats child : this.children) {
            childVisits += child.getNumVisits();
        }
        return this.numVisits + childVisits;
    }

    public String prettyPrint() {
        StringBuilder builder = new StringBuilder();
        this.prettyPrint(builder, 0);
        return builder.toString();
    }

    public OptimizerStats recordModified() {
        ++this.numMods;
        return this;
    }

    public OptimizerStats recordModified(int numMods) {
        this.numMods += numMods;
        return this;
    }

    public OptimizerStats recordVisit() {
        ++this.numVisits;
        return this;
    }

    public OptimizerStats recordVisits(int numVisits) {
        this.numVisits += numVisits;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%s (%d/%d)", this.name, this.getNumMods(), this.getNumVisits()));
        if (this.children.isEmpty()) {
            return sb.toString();
        }
        sb.append(" [");
        sb.append(Joiner.on(",").join(this.children));
        sb.append("]");
        return sb.toString();
    }

    private void prettyPrint(StringBuilder builder, int level) {
        int visits = this.getNumVisits();
        int mods = this.getNumMods();
        String ratioString = " ----";
        if (visits > 0) {
            ratioString = String.format("%5.2f", (double)mods / (double)visits * 100.0);
        }
        String entry = String.format("%-6s%% (%6d/%6d)", ratioString, mods, visits);
        builder.append(String.format("%12s: %-22s  ", this.name, entry));
        if (this.children.size() > 0) {
            builder.append("\n      ");
            for (int i = 0; i <= level; ++i) {
                builder.append("  ");
            }
            for (OptimizerStats child : this.children) {
                child.prettyPrint(builder, ++level);
            }
        }
    }
}

