/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl;

import com.google.gwt.dev.jjs.ast.Context;
import com.google.gwt.dev.jjs.ast.JBlock;
import com.google.gwt.dev.jjs.ast.JFieldRef;
import com.google.gwt.dev.jjs.ast.JLocal;
import com.google.gwt.dev.jjs.ast.JMethod;
import com.google.gwt.dev.jjs.ast.JMethodBody;
import com.google.gwt.dev.jjs.ast.JModVisitor;
import com.google.gwt.dev.jjs.ast.JParameter;
import com.google.gwt.dev.jjs.ast.JProgram;
import com.google.gwt.dev.jjs.ast.JVariable;
import com.google.gwt.dev.jjs.ast.JVariableRef;
import com.google.gwt.dev.jjs.ast.JVisitor;
import com.google.gwt.thirdparty.guava.common.collect.ImmutableSet;
import com.google.gwt.thirdparty.guava.common.collect.LinkedHashMultimap;
import com.google.gwt.thirdparty.guava.common.collect.Maps;
import com.google.gwt.thirdparty.guava.common.collect.Multimap;
import com.google.gwt.thirdparty.guava.common.collect.Sets;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class NameClashesFixer {
    private static Set<String> unshadowableNames = ImmutableSet.of("arguments");

    public static void exec(JProgram program) {
        new JModVisitor(){

            @Override
            public boolean visit(JMethod method, Context ctx) {
                return !method.isJsniMethod() && method.isJsMethodVarargs();
            }

            @Override
            public void endVisit(JLocal variable, Context ctx) {
                NameClashesFixer.maybeRename(variable);
            }

            @Override
            public void endVisit(JParameter parameter, Context ctx) {
                NameClashesFixer.maybeRename(parameter);
            }
        }.accept(program);
        new FixNameClashesVisitor().accept(program);
    }

    private static void maybeRename(JVariable variable) {
        if (unshadowableNames.contains(variable.getName())) {
            variable.setName("_" + variable.getName());
        }
    }

    private NameClashesFixer() {
    }

    private static class FixNameClashesVisitor
    extends JVisitor {
        private Scope currentScope;
        private Map<JVariable, Scope> scopesByLocal;
        private Multimap<String, JVariable> localsByName;

        private FixNameClashesVisitor() {
        }

        @Override
        public boolean visit(JMethodBody x, Context ctx) {
            this.currentScope = new Scope();
            this.scopesByLocal = Maps.newHashMap();
            this.localsByName = LinkedHashMultimap.create();
            return true;
        }

        @Override
        public boolean visit(JBlock x, Context ctx) {
            this.currentScope = new Scope(this.currentScope);
            return true;
        }

        @Override
        public void endVisit(JBlock x, Context ctx) {
            this.currentScope = this.currentScope.parent;
        }

        @Override
        public void endVisit(JVariableRef x, Context ctx) {
            if (x instanceof JFieldRef) {
                return;
            }
            JVariable local = x.getTarget();
            Scope oldVariableScope = this.scopesByLocal.get(local);
            Scope newVariableScope = Scope.getInnermostEnclosingScope(oldVariableScope, this.currentScope);
            newVariableScope.addUsedName(local.getName());
            if (newVariableScope != oldVariableScope) {
                this.scopesByLocal.put(local, newVariableScope);
            }
            this.localsByName.put(local.getName(), local);
        }

        @Override
        public void endVisit(JMethodBody x, Context ctx) {
            for (String name : this.localsByName.keySet()) {
                Collection<JVariable> localSet = this.localsByName.get(name);
                if (localSet.size() == 1) continue;
                JVariable[] locals = localSet.toArray(new JVariable[localSet.size()]);
                block1: for (int i = 0; i < locals.length; ++i) {
                    for (int j = i + 1; j < locals.length; ++j) {
                        String newName;
                        Scope jLocalScope;
                        Scope iLocalScope = this.scopesByLocal.get(locals[i]);
                        Scope commonAncestor = Scope.getInnermostEnclosingScope(iLocalScope, jLocalScope = this.scopesByLocal.get(locals[j]));
                        if (commonAncestor != iLocalScope && commonAncestor != jLocalScope) continue;
                        int n = 0;
                        String baseName = locals[i].getName();
                        while (iLocalScope.isConflictingName(newName = baseName + n++)) {
                        }
                        locals[i].setName(newName);
                        iLocalScope.addUsedName(newName);
                        continue block1;
                    }
                }
            }
            this.currentScope = null;
            this.scopesByLocal = null;
            this.localsByName = null;
        }

        private static class Scope {
            private Scope parent;
            private Set<String> usedInChildScope = Sets.newHashSet();
            private Set<String> namesInThisScope = Sets.newHashSet();
            private int level;

            private Scope() {
                this.parent = null;
                this.level = 0;
            }

            private Scope(Scope parent) {
                this.parent = parent;
                this.level = parent.level + 1;
            }

            private static Scope getInnermostEnclosingScope(Scope thisScope, Scope thatScope) {
                if (thisScope == null) {
                    return thatScope;
                }
                if (thatScope == null) {
                    return thisScope;
                }
                if (thisScope == thatScope) {
                    return thisScope;
                }
                if (thisScope.level > thatScope.level) {
                    return Scope.getInnermostEnclosingScope(thatScope, thisScope);
                }
                if (thisScope.level == thatScope.level) {
                    return Scope.getInnermostEnclosingScope(thisScope.parent, thatScope.parent);
                }
                return Scope.getInnermostEnclosingScope(thisScope, thatScope.parent);
            }

            private void addChildUsage(String name) {
                this.usedInChildScope.add(name);
                if (this.parent != null) {
                    this.parent.addChildUsage(name);
                }
            }

            protected void addUsedName(String name) {
                this.namesInThisScope.add(name);
                if (this.parent != null) {
                    this.parent.addChildUsage(name);
                }
            }

            private boolean isUsedInParent(String name) {
                return this.namesInThisScope.contains(name) || this.parent != null && this.parent.isUsedInParent(name);
            }

            protected boolean isConflictingName(String name) {
                return this.usedInChildScope.contains(name) || this.isUsedInParent(name);
            }
        }
    }
}

