/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl;

import com.google.gwt.dev.jjs.InternalCompilerException;
import com.google.gwt.dev.jjs.ast.Context;
import com.google.gwt.dev.jjs.ast.JBinaryOperation;
import com.google.gwt.dev.jjs.ast.JBinaryOperator;
import com.google.gwt.dev.jjs.ast.JCastOperation;
import com.google.gwt.dev.jjs.ast.JDeclarationStatement;
import com.google.gwt.dev.jjs.ast.JDeclaredType;
import com.google.gwt.dev.jjs.ast.JExpression;
import com.google.gwt.dev.jjs.ast.JExpressionStatement;
import com.google.gwt.dev.jjs.ast.JLocal;
import com.google.gwt.dev.jjs.ast.JLocalRef;
import com.google.gwt.dev.jjs.ast.JMethod;
import com.google.gwt.dev.jjs.ast.JMethodBody;
import com.google.gwt.dev.jjs.ast.JMethodCall;
import com.google.gwt.dev.jjs.ast.JModVisitor;
import com.google.gwt.dev.jjs.ast.JNewInstance;
import com.google.gwt.dev.jjs.ast.JParameter;
import com.google.gwt.dev.jjs.ast.JParameterRef;
import com.google.gwt.dev.jjs.ast.JProgram;
import com.google.gwt.dev.jjs.ast.JReferenceType;
import com.google.gwt.dev.jjs.ast.JReturnStatement;
import com.google.gwt.dev.jjs.ast.JStatement;
import com.google.gwt.dev.jjs.ast.JSwitchExpression;
import com.google.gwt.dev.jjs.ast.JThisRef;
import com.google.gwt.dev.jjs.ast.JType;
import com.google.gwt.dev.jjs.ast.JVisitor;
import com.google.gwt.dev.jjs.ast.js.JMultiExpression;
import com.google.gwt.dev.jjs.impl.CloneExpressionVisitor;
import com.google.gwt.dev.jjs.impl.DeadCodeElimination;
import com.google.gwt.dev.jjs.impl.ExpressionAnalyzer;
import com.google.gwt.dev.jjs.impl.FullOptimizerContext;
import com.google.gwt.dev.jjs.impl.JChangeTrackingVisitor;
import com.google.gwt.dev.jjs.impl.JavaAstVerifier;
import com.google.gwt.dev.jjs.impl.JjsUtils;
import com.google.gwt.dev.jjs.impl.OptimizerContext;
import com.google.gwt.dev.jjs.impl.OptimizerStats;
import com.google.gwt.dev.util.collect.Stack;
import com.google.gwt.dev.util.log.speedtracer.CompilerEventType;
import com.google.gwt.dev.util.log.speedtracer.SpeedTracerLogger;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import com.google.gwt.thirdparty.guava.common.collect.Maps;
import com.google.gwt.thirdparty.guava.common.collect.Sets;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MethodInliner {
    public static String NAME = MethodInliner.class.getSimpleName();
    private final JProgram program;

    private static void markCallsAsSideEffectFree(List<JExpression> expressions) {
        new JModVisitor(){

            @Override
            public void endVisit(JMethodCall x, Context ctx) {
                x.markSideEffectFree();
            }
        }.accept(expressions);
    }

    private static boolean isTooComplexToInline(List<JExpression> bodyAsExpressionList, boolean ignoringReturn) {
        if (bodyAsExpressionList.size() > 3) {
            return true;
        }
        return bodyAsExpressionList.size() == 3 && (!ignoringReturn || bodyAsExpressionList.get(2).hasSideEffects());
    }

    public static OptimizerStats exec(JProgram program, OptimizerContext optimizerCtx) {
        SpeedTracerLogger.Event optimizeEvent = SpeedTracerLogger.start(CompilerEventType.OPTIMIZE, "optimizer", NAME);
        OptimizerStats stats = new MethodInliner(program).execImpl(optimizerCtx);
        optimizeEvent.end("didChange", "" + stats.didChange());
        return stats;
    }

    public static OptimizerStats exec(JProgram program) {
        return MethodInliner.exec(program, new FullOptimizerContext(program));
    }

    private MethodInliner(JProgram program) {
        this.program = program;
    }

    private OptimizerStats execImpl(OptimizerContext optimizerCtx) {
        OptimizerStats stats = new OptimizerStats(NAME);
        while (true) {
            InliningVisitor inliner = new InliningVisitor(optimizerCtx);
            Set<JMethod> modifiedMethods = optimizerCtx.getModifiedMethodsSince(optimizerCtx.getLastStepFor(NAME));
            Set<JMethod> affectedMethods = this.affectedMethods(modifiedMethods, optimizerCtx);
            optimizerCtx.traverse(inliner, affectedMethods);
            stats.recordModified(inliner.getNumMods());
            optimizerCtx.setLastStepFor(NAME, optimizerCtx.getOptimizationStep());
            optimizerCtx.incOptimizationStep();
            if (!inliner.didChange()) break;
            OptimizerStats dceStats = DeadCodeElimination.exec(this.program, optimizerCtx);
            stats.recordModified(dceStats.getNumMods());
        }
        JavaAstVerifier.assertProgramIsConsistent(this.program);
        return stats;
    }

    private Set<JMethod> affectedMethods(Set<JMethod> modifiedMethods, OptimizerContext optimizerCtx) {
        assert (modifiedMethods != null);
        LinkedHashSet<JMethod> affectedMethods = Sets.newLinkedHashSet();
        affectedMethods.addAll(modifiedMethods);
        affectedMethods.addAll(optimizerCtx.getCallers(modifiedMethods));
        return affectedMethods;
    }

    private JExpression maybeCast(JExpression exp, JType targetType) {
        if (targetType instanceof JReferenceType) {
            assert (exp.getType() instanceof JReferenceType);
            targetType = this.merge((JReferenceType)exp.getType(), (JReferenceType)targetType);
        }
        if (!this.program.typeOracle.castSucceedsTrivially(exp.getType(), targetType)) {
            exp = new JCastOperation(exp.getSourceInfo(), targetType, exp);
        }
        return exp;
    }

    private JReferenceType merge(JReferenceType source, JReferenceType target) {
        JReferenceType result = this.program.typeOracle.castSucceedsTrivially(source.getUnderlyingType(), target.getUnderlyingType()) ? source : target;
        return result;
    }

    private static enum InlineResult {
        BLACKLIST,
        DO_NOT_BLACKLIST;

    }

    private static enum SideEffectCheck {
        CORRECT_ORDER,
        FAILS,
        NO_REFERENCES;

    }

    private static class RecursionCheckVisitor
    extends JVisitor {
        private boolean isRecursive = false;
        private final JMethod method;

        public RecursionCheckVisitor(JMethod method) {
            this.method = method;
        }

        @Override
        public void endVisit(JMethodCall x, Context ctx) {
            if (x.getTarget() == this.method) {
                this.isRecursive = true;
            }
        }

        public boolean isRecursive() {
            return this.isRecursive;
        }
    }

    private class LocalVariableExtruder
    extends JModVisitor {
        private final Map<JLocal, JLocal> newLocalsByOriginalLocal = Maps.newLinkedHashMap();
        private final JMethodBody methodBody;

        public LocalVariableExtruder(JMethod method) {
            this.methodBody = (JMethodBody)method.getBody();
        }

        @Override
        public void endVisit(JLocalRef x, Context ctx) {
            JLocal originalLocal = x.getLocal();
            JLocal newLocal = this.newLocalsByOriginalLocal.get(originalLocal);
            if (newLocal == null) {
                newLocal = JProgram.createLocal(originalLocal.getSourceInfo(), originalLocal.getName(), originalLocal.getType(), originalLocal.isFinal(), this.methodBody);
                this.newLocalsByOriginalLocal.put(originalLocal, newLocal);
            }
            ctx.replaceMe(newLocal.makeRef(x.getSourceInfo()));
        }
    }

    private class ParameterReplacer
    extends JModVisitor {
        private final JMethodCall methodCall;

        public ParameterReplacer(JMethodCall methodCall) {
            this.methodCall = methodCall;
        }

        @Override
        public void endVisit(JParameterRef x, Context ctx) {
            int paramIndex = this.methodCall.getTarget().getParams().indexOf(x.getParameter());
            assert (paramIndex != -1);
            CloneExpressionVisitor cloner = new CloneExpressionVisitor();
            JExpression arg = this.methodCall.getArgs().get(paramIndex);
            JExpression clone = cloner.cloneExpression(arg);
            clone = MethodInliner.this.maybeCast(clone, x.getType());
            ctx.replaceMe(clone);
        }
    }

    private static class OrderVisitor
    extends ExpressionAnalyzer {
        private int currentIndex = 0;
        private final List<JParameter> parameters;
        private boolean succeeded = true;

        public OrderVisitor(List<JParameter> parameters) {
            this.parameters = parameters;
        }

        public SideEffectCheck checkResults() {
            if (this.succeeded && this.currentIndex == this.parameters.size()) {
                return SideEffectCheck.CORRECT_ORDER;
            }
            if (this.succeeded && this.currentIndex == 0) {
                return SideEffectCheck.NO_REFERENCES;
            }
            return SideEffectCheck.FAILS;
        }

        @Override
        public void endVisit(JParameterRef x, Context ctx) {
            JParameter param = x.getParameter();
            if (this.hasAssignment() || this.accessesField() || this.canThrowException()) {
                this.succeeded = false;
            }
            if (this.isInConditional()) {
                this.succeeded = false;
            }
            if (this.parameters.indexOf(param) == this.currentIndex) {
                ++this.currentIndex;
            } else {
                this.succeeded = false;
            }
            super.endVisit(x, ctx);
        }
    }

    private class InliningVisitor
    extends JChangeTrackingVisitor {
        private final Set<JMethod> cannotInline;
        private final Stack<JExpression> expressionsWhoseValuesAreIgnored;

        public InliningVisitor(OptimizerContext optimizerCtx) {
            super(optimizerCtx);
            this.cannotInline = Sets.newHashSet();
            this.expressionsWhoseValuesAreIgnored = Stack.create();
        }

        @Override
        public void endVisit(JExpressionStatement x, Context ctx) {
            this.expressionsWhoseValuesAreIgnored.pop();
        }

        @Override
        public void endVisit(JMethodCall x, Context ctx) {
            JMethod method = x.getTarget();
            if (this.getCurrentMethod() == method) {
                return;
            }
            if (this.cannotInline.contains(method)) {
                return;
            }
            if (this.tryInlineMethodCall(x, ctx) == InlineResult.BLACKLIST) {
                this.cannotInline.add(method);
            }
        }

        @Override
        public void endVisit(JMultiExpression x, Context ctx) {
            for (int i = 0; i < x.getExpressions().size() - 1; ++i) {
                this.expressionsWhoseValuesAreIgnored.pop();
            }
        }

        private InlineResult tryInlineMethodCall(JMethodCall x, Context ctx) {
            JMethod method = x.getTarget();
            if (!method.isStatic() || method.isJsniMethod() || method.canBeImplementedExternally()) {
                return InlineResult.BLACKLIST;
            }
            if (!method.isInliningAllowed()) {
                return InlineResult.BLACKLIST;
            }
            JMethodBody body = (JMethodBody)method.getBody();
            List<JStatement> stmts = body.getStatements();
            if (method.getEnclosingType() != null && method.getEnclosingType().getClinitMethod() == method && !stmts.isEmpty()) {
                return InlineResult.BLACKLIST;
            }
            List<JExpression> expressions = this.extractExpressionsFromBody(body);
            if (expressions == null) {
                return InlineResult.BLACKLIST;
            }
            return this.tryInlineBody(x, ctx, expressions, this.expressionsWhoseValuesAreIgnored.contains(x));
        }

        @Override
        public void endVisit(JNewInstance x, Context ctx) {
        }

        @Override
        public boolean visit(JExpressionStatement x, Context ctx) {
            this.expressionsWhoseValuesAreIgnored.push(x.getExpr());
            return true;
        }

        @Override
        public boolean enter(JMethod x, Context ctx) {
            return MethodInliner.this.program.getStaticImpl(x) == null;
        }

        @Override
        public boolean visit(JMultiExpression x, Context ctx) {
            for (int i = 0; i < x.getExpressions().size() - 1; ++i) {
                this.expressionsWhoseValuesAreIgnored.push(x.getExpression(i));
            }
            return true;
        }

        private JMethodCall createClinitCall(JMethodCall x) {
            JDeclaredType targetType = x.getTarget().getEnclosingType().getClinitTarget();
            if (!this.getCurrentMethod().getEnclosingType().checkClinitTo(targetType)) {
                return null;
            }
            if (MethodInliner.this.program.isStaticImpl(x.getTarget()) && !x.getTarget().getEnclosingType().isJsoType()) {
                return null;
            }
            if (JProgram.isClinit(x.getTarget())) {
                return null;
            }
            JMethod clinit = targetType.getClinitMethod();
            if (!clinit.isJsniMethod() && ((JMethodBody)clinit.getBody()).getStatements().size() == 0) {
                return null;
            }
            return new JMethodCall(x.getSourceInfo(), null, clinit, new JExpression[0]);
        }

        private List<JExpression> extractExpressionsFromBody(JMethodBody body) {
            ArrayList<JExpression> expressions = Lists.newArrayList();
            CloneCalleeExpressionVisitor cloner = new CloneCalleeExpressionVisitor();
            for (JStatement stmt : body.getStatements()) {
                JExpression clone;
                JExpression expr;
                if (stmt instanceof JDeclarationStatement) {
                    JDeclarationStatement declStatement = (JDeclarationStatement)stmt;
                    if (!(declStatement.getVariableRef() instanceof JLocalRef)) {
                        return null;
                    }
                    JExpression initializer = declStatement.getInitializer();
                    if (initializer == null) continue;
                    if (!CannotBeInlinedVisitor.check(initializer)) {
                        return null;
                    }
                    JLocal local = (JLocal)declStatement.getVariableRef().getTarget();
                    JBinaryOperation clone2 = new JBinaryOperation(stmt.getSourceInfo(), local.getType(), JBinaryOperator.ASG, local.makeRef(declStatement.getVariableRef().getSourceInfo()), cloner.cloneExpression(initializer));
                    expressions.add(clone2);
                    continue;
                }
                if (stmt instanceof JExpressionStatement) {
                    JExpressionStatement exprStmt = (JExpressionStatement)stmt;
                    expr = exprStmt.getExpr();
                    if (!CannotBeInlinedVisitor.check(expr)) {
                        return null;
                    }
                    clone = cloner.cloneExpression(expr);
                    expressions.add(clone);
                    continue;
                }
                if (stmt instanceof JReturnStatement) {
                    JReturnStatement returnStatement = (JReturnStatement)stmt;
                    expr = returnStatement.getExpr();
                    if (expr == null) break;
                    if (!CannotBeInlinedVisitor.check(expr)) {
                        return null;
                    }
                    clone = cloner.cloneExpression(expr);
                    clone = MethodInliner.this.maybeCast(clone, body.getMethod().getType());
                    expressions.add(clone);
                    break;
                }
                return null;
            }
            return expressions;
        }

        private List<JExpression> expressionsIncludingArgs(JMethodCall x) {
            ArrayList<JExpression> expressions = Lists.newArrayListWithCapacity(x.getArgs().size() + 2);
            expressions.add(x.getInstance());
            expressions.add(this.createClinitCall(x));
            int c = x.getArgs().size();
            for (int i = 0; i < c; ++i) {
                JExpression arg = x.getArgs().get(i);
                ExpressionAnalyzer analyzer = new ExpressionAnalyzer();
                analyzer.accept(arg);
                if (!analyzer.hasAssignment() && !analyzer.canThrowException()) continue;
                expressions.add(arg);
            }
            return expressions;
        }

        private InlineResult tryInlineBody(JMethodCall x, Context ctx, List<JExpression> bodyAsExpressionList, boolean ignoringReturn) {
            if (MethodInliner.isTooComplexToInline(bodyAsExpressionList, ignoringReturn)) {
                return InlineResult.BLACKLIST;
            }
            ExpressionAnalyzer targetAnalyzer = new ExpressionAnalyzer();
            targetAnalyzer.accept(bodyAsExpressionList);
            if (targetAnalyzer.hasAssignmentToParameter()) {
                return InlineResult.BLACKLIST;
            }
            RecursionCheckVisitor recursionCheckVisitor = new RecursionCheckVisitor(x.getTarget());
            recursionCheckVisitor.accept(bodyAsExpressionList);
            if (recursionCheckVisitor.isRecursive()) {
                return InlineResult.BLACKLIST;
            }
            if (x.getTarget().getParams().size() != x.getArgs().size()) {
                return InlineResult.DO_NOT_BLACKLIST;
            }
            OrderVisitor orderVisitor = new OrderVisitor(x.getTarget().getParams());
            orderVisitor.accept(bodyAsExpressionList);
            switch (orderVisitor.checkResults()) {
                case NO_REFERENCES: {
                    if (!x.hasSideEffects()) {
                        MethodInliner.markCallsAsSideEffectFree(bodyAsExpressionList);
                    }
                    new LocalVariableExtruder(this.getCurrentMethod()).accept(bodyAsExpressionList);
                    List<JExpression> expressions = this.expressionsIncludingArgs(x);
                    expressions.addAll(bodyAsExpressionList);
                    ctx.replaceMe(JjsUtils.createOptimizedMultiExpression(ignoringReturn, expressions));
                    return InlineResult.DO_NOT_BLACKLIST;
                }
                case FAILS: {
                    for (JExpression arg : x.getArgs()) {
                        ExpressionAnalyzer argAnalyzer = new ExpressionAnalyzer();
                        argAnalyzer.accept(arg);
                        if (!argAnalyzer.hasAssignment() && !argAnalyzer.accessesField() && !argAnalyzer.createsObject() && !argAnalyzer.canThrowException()) continue;
                        return InlineResult.DO_NOT_BLACKLIST;
                    }
                    break;
                }
            }
            if (!x.hasSideEffects()) {
                MethodInliner.markCallsAsSideEffectFree(bodyAsExpressionList);
            }
            new LocalVariableExtruder(this.getCurrentMethod()).accept(bodyAsExpressionList);
            ParameterReplacer replacer = new ParameterReplacer(x);
            replacer.accept(bodyAsExpressionList);
            bodyAsExpressionList.add(0, x.getInstance());
            bodyAsExpressionList.add(1, this.createClinitCall(x));
            ctx.replaceMe(JjsUtils.createOptimizedMultiExpression(ignoringReturn, bodyAsExpressionList));
            return InlineResult.DO_NOT_BLACKLIST;
        }
    }

    private static class CannotBeInlinedVisitor
    extends JVisitor {
        private boolean succeed = true;

        private CannotBeInlinedVisitor() {
        }

        public static boolean check(JExpression expr) {
            CannotBeInlinedVisitor v = new CannotBeInlinedVisitor();
            v.accept(expr);
            return v.succeed;
        }

        @Override
        public boolean visit(JStatement x, Context ctx) {
            throw new IllegalStateException("Should never visit statements");
        }

        @Override
        public boolean visit(JSwitchExpression x, Context ctx) {
            this.succeed = false;
            return false;
        }
    }

    private static class CloneCalleeExpressionVisitor
    extends CloneExpressionVisitor {
        private CloneCalleeExpressionVisitor() {
        }

        @Override
        public boolean visit(JThisRef x, Context ctx) {
            throw new InternalCompilerException("Should not encounter a JThisRef within a static method");
        }
    }
}

