/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl;

import com.google.gwt.dev.jjs.ast.Context;
import com.google.gwt.dev.jjs.ast.JClassType;
import com.google.gwt.dev.jjs.ast.JDeclaredType;
import com.google.gwt.dev.jjs.ast.JMethod;
import com.google.gwt.dev.jjs.ast.JMethodCall;
import com.google.gwt.dev.jjs.ast.JNewInstance;
import com.google.gwt.dev.jjs.ast.JProgram;
import com.google.gwt.dev.jjs.ast.JReferenceType;
import com.google.gwt.dev.jjs.ast.JRunAsync;
import com.google.gwt.dev.jjs.ast.JType;
import com.google.gwt.dev.jjs.impl.JChangeTrackingVisitor;
import com.google.gwt.dev.jjs.impl.JavaAstVerifier;
import com.google.gwt.dev.jjs.impl.OptimizerContext;
import com.google.gwt.dev.jjs.impl.OptimizerStats;
import com.google.gwt.dev.util.log.speedtracer.CompilerEventType;
import com.google.gwt.dev.util.log.speedtracer.SpeedTracerLogger;
import com.google.gwt.thirdparty.guava.common.annotations.VisibleForTesting;

public class MethodCallTightener {
    public static final String NAME = MethodCallTightener.class.getSimpleName();
    private final JProgram program;

    @VisibleForTesting
    static OptimizerStats exec(JProgram program) {
        return MethodCallTightener.exec(program, OptimizerContext.NULL_OPTIMIZATION_CONTEXT);
    }

    public static OptimizerStats exec(JProgram program, OptimizerContext optimizerCtx) {
        SpeedTracerLogger.Event optimizeEvent = SpeedTracerLogger.start(CompilerEventType.OPTIMIZE, "optimizer", NAME);
        OptimizerStats stats = new MethodCallTightener(program).execImpl(optimizerCtx);
        optimizerCtx.incOptimizationStep();
        optimizeEvent.end("didChange", "" + stats.didChange());
        JavaAstVerifier.assertProgramIsConsistent(program);
        return stats;
    }

    private MethodCallTightener(JProgram program) {
        this.program = program;
    }

    private OptimizerStats execImpl(OptimizerContext optimizerCtx) {
        MethodCallTighteningVisitor tightener = new MethodCallTighteningVisitor(optimizerCtx);
        tightener.accept(this.program);
        return new OptimizerStats(NAME).recordModified(tightener.getNumMods());
    }

    public class MethodCallTighteningVisitor
    extends JChangeTrackingVisitor {
        public MethodCallTighteningVisitor(OptimizerContext optimizerCtx) {
            super(optimizerCtx);
        }

        @Override
        public void endVisit(JMethodCall x, Context ctx) {
            if (x.isVolatile() || !x.canBePolymorphic()) {
                return;
            }
            JType instanceType = x.getInstance().getType().getUnderlyingType();
            if (!(instanceType instanceof JClassType)) {
                return;
            }
            JMethod mostSpecificTarget = this.getMostSpecificOverride(x);
            if (mostSpecificTarget.getEnclosingType().isJsNative()) {
                assert (x.getTarget().getEnclosingType().isJavaLangObject() || x.getTarget().getEnclosingType().isJsNative());
                return;
            }
            JMethodCall newCall = this.maybeReplaceTargetMethod(x, mostSpecificTarget);
            this.maybeUpgradeToNonPolymorphicCall(newCall);
            if (newCall != x) {
                ctx.replaceMe(newCall);
            }
        }

        private JMethod getMostSpecificOverride(JMethodCall methodCall) {
            JMethod original = methodCall.getTarget();
            JClassType underlyingType = (JClassType)methodCall.getInstance().getType().getUnderlyingType();
            return ((MethodCallTightener)MethodCallTightener.this).program.typeOracle.findMostSpecificOverride(underlyingType, original);
        }

        private JMethodCall maybeReplaceTargetMethod(JMethodCall methodCall, JMethod newTargetMethod) {
            if (methodCall.getTarget() == newTargetMethod) {
                return methodCall;
            }
            return new JMethodCall(methodCall.getSourceInfo(), methodCall.getInstance(), newTargetMethod, methodCall.getArgs());
        }

        private void maybeUpgradeToNonPolymorphicCall(JMethodCall x) {
            JReferenceType instanceType = (JReferenceType)x.getInstance().getType();
            if (!instanceType.canBeSubclass() || !this.hasPotentialOverride(instanceType, x.getTarget())) {
                assert (this.getMostSpecificOverride(x) == x.getTarget());
                x.setCannotBePolymorphic();
                this.madeChanges();
            }
        }

        private boolean hasPotentialOverride(JReferenceType instanceType, JMethod target) {
            if (target.isAbstract()) {
                return true;
            }
            for (JMethod override : target.getOverridingMethods()) {
                JDeclaredType overrideType = override.getEnclosingType();
                if (((MethodCallTightener)MethodCallTightener.this).program.typeOracle.castFailsTrivially(instanceType, overrideType)) continue;
                return true;
            }
            return false;
        }

        @Override
        public void endVisit(JNewInstance x, Context ctx) {
        }

        @Override
        public boolean visit(JRunAsync x, Context ctx) {
            x.traverseOnSuccess(this);
            return super.visit(x, ctx);
        }
    }
}

