/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl;

import com.google.gwt.dev.jjs.ast.Context;
import com.google.gwt.dev.jjs.ast.JExpression;
import com.google.gwt.dev.jjs.ast.JMethod;
import com.google.gwt.dev.jjs.ast.JMethodCall;
import com.google.gwt.dev.jjs.ast.JProgram;
import com.google.gwt.dev.jjs.ast.JType;
import com.google.gwt.dev.jjs.impl.JChangeTrackingVisitor;
import com.google.gwt.dev.jjs.impl.JavaAstVerifier;
import com.google.gwt.dev.jjs.impl.OptimizerContext;
import com.google.gwt.dev.jjs.impl.OptimizerStats;
import com.google.gwt.dev.util.log.speedtracer.CompilerEventType;
import com.google.gwt.dev.util.log.speedtracer.SpeedTracerLogger;
import com.google.gwt.thirdparty.guava.common.annotations.VisibleForTesting;
import java.util.List;

public class MethodCallSpecializer {
    public static final String NAME = MethodCallSpecializer.class.getSimpleName();
    private final JProgram program;

    @VisibleForTesting
    static OptimizerStats exec(JProgram program) {
        return MethodCallSpecializer.exec(program, OptimizerContext.NULL_OPTIMIZATION_CONTEXT);
    }

    public static OptimizerStats exec(JProgram program, OptimizerContext optimizerCtx) {
        SpeedTracerLogger.Event optimizeEvent = SpeedTracerLogger.start(CompilerEventType.OPTIMIZE, "optimizer", NAME);
        OptimizerStats stats = new MethodCallSpecializer(program).execImpl(optimizerCtx);
        optimizerCtx.incOptimizationStep();
        optimizeEvent.end("didChange", "" + stats.didChange());
        return stats;
    }

    private MethodCallSpecializer(JProgram program) {
        this.program = program;
    }

    private OptimizerStats execImpl(OptimizerContext optimizerCtx) {
        MethodCallSpecializingVisitor specializer = new MethodCallSpecializingVisitor(optimizerCtx);
        specializer.accept(this.program);
        JavaAstVerifier.assertProgramIsConsistent(this.program);
        return new OptimizerStats(NAME).recordModified(specializer.getNumMods());
    }

    private class MethodCallSpecializingVisitor
    extends JChangeTrackingVisitor {
        public MethodCallSpecializingVisitor(OptimizerContext optimizerCtx) {
            super(optimizerCtx);
        }

        @Override
        public void endVisit(JMethodCall x, Context ctx) {
            if (!x.getTarget().isStatic()) {
                return;
            }
            JMethod method = x.getTarget();
            JMethod.Specialization specialization = method.getSpecialization();
            if (specialization == null) {
                return;
            }
            List<JType> params = specialization.getParams();
            if (params.size() == x.getArgs().size()) {
                for (int i = 0; i < params.size(); ++i) {
                    JType argType = x.getArgs().get(i).getType().getUnderlyingType();
                    if (argType.isNullType()) {
                        return;
                    }
                    JType qType = params.get(i).getUnderlyingType();
                    if (((MethodCallSpecializer)MethodCallSpecializer.this).program.typeOracle.castSucceedsTrivially(argType, qType)) continue;
                    return;
                }
                JMethod targetMethod = specialization.getTargetMethod();
                if (targetMethod != null) {
                    JMethodCall call = new JMethodCall(x.getSourceInfo(), x.getInstance(), targetMethod, new JExpression[0]);
                    call.addArgs(x.getArgs());
                    ctx.replaceMe(call);
                }
            }
        }
    }
}

