/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl;

import com.google.gwt.dev.jjs.InternalCompilerException;
import com.google.gwt.dev.jjs.SourceInfo;
import com.google.gwt.dev.jjs.ast.Context;
import com.google.gwt.dev.jjs.ast.JAbstractMethodBody;
import com.google.gwt.dev.jjs.ast.JConstructor;
import com.google.gwt.dev.jjs.ast.JDeclaredType;
import com.google.gwt.dev.jjs.ast.JExpression;
import com.google.gwt.dev.jjs.ast.JMethod;
import com.google.gwt.dev.jjs.ast.JMethodBody;
import com.google.gwt.dev.jjs.ast.JMethodCall;
import com.google.gwt.dev.jjs.ast.JParameter;
import com.google.gwt.dev.jjs.ast.JParameterRef;
import com.google.gwt.dev.jjs.ast.JProgram;
import com.google.gwt.dev.jjs.ast.JThisRef;
import com.google.gwt.dev.jjs.ast.JType;
import com.google.gwt.dev.jjs.ast.JVisitor;
import com.google.gwt.dev.jjs.ast.js.JMultiExpression;
import com.google.gwt.dev.jjs.ast.js.JsniMethodBody;
import com.google.gwt.dev.jjs.impl.ControlFlowAnalyzer;
import com.google.gwt.dev.jjs.impl.FullOptimizerContext;
import com.google.gwt.dev.jjs.impl.JChangeTrackingVisitor;
import com.google.gwt.dev.jjs.impl.JavaAstVerifier;
import com.google.gwt.dev.jjs.impl.JjsUtils;
import com.google.gwt.dev.jjs.impl.OptimizerContext;
import com.google.gwt.dev.jjs.impl.OptimizerStats;
import com.google.gwt.dev.jjs.impl.codesplitter.CodeSplitter;
import com.google.gwt.dev.js.ast.JsContext;
import com.google.gwt.dev.js.ast.JsFunction;
import com.google.gwt.dev.js.ast.JsModVisitor;
import com.google.gwt.dev.js.ast.JsName;
import com.google.gwt.dev.js.ast.JsParameter;
import com.google.gwt.dev.js.ast.JsThisRef;
import com.google.gwt.dev.util.log.speedtracer.CompilerEventType;
import com.google.gwt.dev.util.log.speedtracer.SpeedTracerLogger;
import com.google.gwt.thirdparty.guava.common.annotations.VisibleForTesting;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import com.google.gwt.thirdparty.guava.common.collect.Maps;
import com.google.gwt.thirdparty.guava.common.collect.Sets;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class MakeCallsStatic {
    private static final String NAME = MakeCallsStatic.class.getSimpleName();
    protected Set<JMethod> toBeMadeStatic = Sets.newLinkedHashSet();
    private final JProgram program;
    private final StaticCallConverter converter;

    private static String getStaticMethodName(JMethod x) {
        return "$" + x.getName();
    }

    public static OptimizerStats exec(JProgram program, boolean addRuntimeChecks, OptimizerContext optimizerCtx) {
        SpeedTracerLogger.Event optimizeEvent = SpeedTracerLogger.start(CompilerEventType.OPTIMIZE, "optimizer", NAME);
        OptimizerStats stats = new MakeCallsStatic(program, addRuntimeChecks).execImpl(optimizerCtx);
        optimizerCtx.setLastStepFor(NAME, optimizerCtx.getOptimizationStep());
        optimizerCtx.incOptimizationStep();
        optimizeEvent.end("didChange", "" + stats.didChange());
        return stats;
    }

    @VisibleForTesting
    static OptimizerStats exec(JProgram program, boolean addRuntimeChecks) {
        return MakeCallsStatic.exec(program, addRuntimeChecks, new FullOptimizerContext(program));
    }

    private MakeCallsStatic(JProgram program, boolean addRuntimeChecks) {
        this.program = program;
        this.converter = new StaticCallConverter(program, addRuntimeChecks);
    }

    private OptimizerStats execImpl(OptimizerContext optimizerCtx) {
        OptimizerStats stats = new OptimizerStats(NAME);
        FindStaticDispatchSitesVisitor finder = new FindStaticDispatchSitesVisitor();
        Set<JMethod> modifiedMethods = optimizerCtx.getModifiedMethodsSince(optimizerCtx.getLastStepFor(NAME));
        Set<JMethod> affectedMethods = this.affectedMethods(modifiedMethods, optimizerCtx);
        optimizerCtx.traverse(finder, affectedMethods);
        CreateStaticImplsVisitor creator = new CreateStaticImplsVisitor(this.program, optimizerCtx);
        for (JMethod method : this.toBeMadeStatic) {
            creator.accept(method);
        }
        for (JMethod method : this.toBeMadeStatic) {
            JMethod.Specialization specialization = method.getSpecialization();
            if (specialization == null) continue;
            JMethod staticMethod = this.program.getStaticImpl(method);
            ArrayList<JType> params = Lists.newArrayList(specialization.getParams());
            params.add(0, staticMethod.getParams().get(0).getType());
            staticMethod.setSpecialization(params, specialization.getReturns(), staticMethod.getName());
            staticMethod.getSpecialization().resolve(params, specialization.getReturns(), this.program.getStaticImpl(specialization.getTargetMethod()));
        }
        RewriteCallSites rewriter = new RewriteCallSites(optimizerCtx);
        rewriter.accept(this.program);
        stats.recordModified(rewriter.getNumMods());
        assert (rewriter.didChange() || this.toBeMadeStatic.isEmpty());
        JavaAstVerifier.assertProgramIsConsistent(this.program);
        return stats;
    }

    private Set<JMethod> affectedMethods(Set<JMethod> modifiedMethods, OptimizerContext optimizerCtx) {
        assert (modifiedMethods != null);
        LinkedHashSet<JMethod> affectedMethods = Sets.newLinkedHashSet();
        affectedMethods.addAll(modifiedMethods);
        affectedMethods.addAll(optimizerCtx.getCallers(modifiedMethods));
        return affectedMethods;
    }

    static class StaticCallConverter {
        private final JMethod checkNotNull;

        StaticCallConverter(JProgram program, boolean addNullChecksForThis) {
            this.checkNotNull = addNullChecksForThis ? program.getIndexedMethod("Exceptions.checkNotNull") : null;
        }

        JExpression convertCall(JMethodCall original, JMethod newMethod) {
            JMethodCall newCall = new JMethodCall(original.getSourceInfo(), null, newMethod, new JExpression[0]);
            if (original.getInstance() instanceof JMultiExpression) {
                JMultiExpression multi = (JMultiExpression)original.getInstance();
                int lastIndex = multi.getNumberOfExpressions() - 1;
                newCall.addArg(this.makeNullCheck(multi.getExpression(lastIndex), original));
                newCall.addArgs(original.getArgs());
                multi.setExpression(lastIndex, newCall);
                return multi;
            }
            newCall.addArg(this.makeNullCheck(original.getInstance(), original));
            newCall.addArgs(original.getArgs());
            return newCall;
        }

        private JExpression makeNullCheck(JExpression x, JMethodCall call) {
            if (this.checkNotNull == null) {
                return x;
            }
            if (this.isJso(call)) {
                return x;
            }
            JMethodCall check = new JMethodCall(x.getSourceInfo(), null, this.checkNotNull, new JExpression[0]);
            check.addArg(x);
            return check;
        }

        private boolean isJso(JMethodCall call) {
            JDeclaredType type = call.getTarget().getEnclosingType();
            return type != null && type.isJsoType();
        }
    }

    private class RewriteCallSites
    extends JChangeTrackingVisitor {
        private boolean currentMethodIsInitiallyLive;
        private ControlFlowAnalyzer initiallyLive;

        public RewriteCallSites(OptimizerContext optimizerCtx) {
            super(optimizerCtx);
        }

        @Override
        public void endVisit(JMethodCall x, Context ctx) {
            JMethod oldMethod = x.getTarget();
            JMethod newMethod = MakeCallsStatic.this.program.getStaticImpl(oldMethod);
            if (newMethod == null || x.canBePolymorphic()) {
                return;
            }
            if (this.currentMethodIsInitiallyLive && !this.initiallyLive.getLiveFieldsAndMethods().contains(x.getTarget())) {
                return;
            }
            ctx.replaceMe(MakeCallsStatic.this.converter.convertCall(x, newMethod));
        }

        @Override
        public boolean enter(JMethod x, Context ctx) {
            this.currentMethodIsInitiallyLive = this.initiallyLive.getLiveFieldsAndMethods().contains(x);
            return true;
        }

        @Override
        public boolean visit(JProgram x, Context ctx) {
            this.initiallyLive = CodeSplitter.computeInitiallyLive(x);
            return true;
        }
    }

    private class FindStaticDispatchSitesVisitor
    extends JVisitor {
        private FindStaticDispatchSitesVisitor() {
        }

        @Override
        public void endVisit(JMethodCall x, Context ctx) {
            JMethod method = x.getTarget();
            if (this.shouldBeMadeStatic(x, method)) {
                MakeCallsStatic.this.toBeMadeStatic.add(method);
                if (method.getSpecialization() != null && this.shouldBeMadeStatic(x, method.getSpecialization().getTargetMethod())) {
                    MakeCallsStatic.this.toBeMadeStatic.add(method.getSpecialization().getTargetMethod());
                }
            }
        }

        private boolean shouldBeMadeStatic(JMethodCall x, JMethod method) {
            if (method.isExternal()) {
                return false;
            }
            if (!method.isDevirtualizationAllowed()) {
                return false;
            }
            if (MakeCallsStatic.this.program.getStaticImpl(method) != null || MakeCallsStatic.this.toBeMadeStatic.contains(method)) {
                return false;
            }
            if (x.canBePolymorphic()) {
                return false;
            }
            if (!method.needsDynamicDispatch()) {
                return false;
            }
            if (method.isAbstract()) {
                return false;
            }
            if (method.isJsNative()) {
                return false;
            }
            if (method == MakeCallsStatic.this.program.getNullMethod()) {
                return false;
            }
            return method.getEnclosingType().getMethods().contains(method);
        }
    }

    static class CreateStaticImplsVisitor
    extends JVisitor {
        private final JProgram program;
        private final OptimizerContext optimizerCtx;

        private CreateStaticImplsVisitor(JProgram program, OptimizerContext optimizerCtx) {
            this.program = program;
            this.optimizerCtx = optimizerCtx;
        }

        CreateStaticImplsVisitor(JProgram program) {
            this.program = program;
            this.optimizerCtx = null;
        }

        @Override
        public boolean visit(JConstructor x, Context ctx) {
            throw new InternalCompilerException("Should not try to staticify constructors");
        }

        @Override
        public boolean visit(JMethod x, Context ctx) {
            assert (!x.isJsNative()) : "Native methods can not be devirtualized";
            JDeclaredType enclosingType = x.getEnclosingType();
            JType returnType = x.getType();
            SourceInfo sourceInfo = x.getSourceInfo().makeChild();
            int myIndexInClass = enclosingType.getMethods().indexOf(x);
            assert (myIndexInClass > 0);
            String newName = MakeCallsStatic.getStaticMethodName(x);
            JMethod newMethod = new JMethod(sourceInfo, newName, enclosingType, returnType, false, true, true, x.getAccess());
            newMethod.setInliningMode(x.getInliningMode());
            newMethod.setHasSideEffects(x.hasSideEffects());
            newMethod.setSynthetic();
            newMethod.addThrownExceptions(x.getThrownExceptions());
            if (x.isJsOverlay()) {
                newMethod.setJsOverlay();
            }
            JDeclaredType thisParameterType = enclosingType;
            JParameter thisParam = newMethod.createThisParameter(sourceInfo, thisParameterType);
            IdentityHashMap<JParameter, JParameter> varMap = Maps.newIdentityHashMap();
            for (JParameter oldVar : x.getParams()) {
                JParameter newVar = newMethod.cloneParameter(oldVar);
                varMap.put(oldVar, newVar);
            }
            ArrayList<JType> originalParamTypes = Lists.newArrayList();
            originalParamTypes.add(thisParameterType);
            originalParamTypes.addAll(x.getOriginalParamTypes());
            newMethod.setOriginalTypes(x.getOriginalReturnType(), originalParamTypes);
            JAbstractMethodBody movedBody = x.getBody();
            newMethod.setBody(movedBody);
            JMethodBody newBody = new JMethodBody(sourceInfo);
            x.setBody(newBody);
            JMethodCall newCall = new JMethodCall(sourceInfo, null, newMethod, new JExpression[0]);
            newCall.addArg(new JThisRef(sourceInfo, enclosingType));
            for (int i = 0; i < x.getParams().size(); ++i) {
                JParameter param = x.getParams().get(i);
                newCall.addArg(param.makeRef(sourceInfo));
            }
            newBody.getBlock().addStmt(JjsUtils.makeMethodEndStatement(returnType, newCall));
            if (newMethod.isJsniMethod()) {
                JsFunction jsFunc = ((JsniMethodBody)movedBody).getFunc();
                JsName paramName = jsFunc.getScope().declareName("this$static");
                jsFunc.getParameters().add(0, new JsParameter(sourceInfo, paramName));
                RewriteJsniMethodBody rewriter = new RewriteJsniMethodBody(paramName);
                rewriter.accept(jsFunc.getBody());
            } else {
                RewriteMethodBody rewriter = new RewriteMethodBody(thisParam, varMap, this.optimizerCtx);
                rewriter.accept(movedBody);
            }
            this.program.putStaticImpl(x, newMethod);
            enclosingType.getMethods().add(myIndexInClass + 1, newMethod);
            if (this.optimizerCtx != null) {
                this.optimizerCtx.markModified(x);
                this.optimizerCtx.markModified(newMethod);
            }
            return false;
        }

        public JMethod getOrCreateStaticImpl(JProgram program, JMethod method) {
            assert (!method.isStatic());
            JMethod staticImpl = program.getStaticImpl(method);
            if (staticImpl == null) {
                this.accept(method);
                staticImpl = program.getStaticImpl(method);
            }
            return staticImpl;
        }

        private class RewriteMethodBody
        extends JChangeTrackingVisitor {
            private final JParameter thisParam;
            private final Map<JParameter, JParameter> varMap;

            public RewriteMethodBody(JParameter thisParam, Map<JParameter, JParameter> varMap, OptimizerContext optimizerCtx) {
                super(optimizerCtx);
                this.thisParam = thisParam;
                this.varMap = varMap;
            }

            @Override
            public void endVisit(JParameterRef x, Context ctx) {
                JParameter param = this.varMap.get(x.getTarget());
                ctx.replaceMe(param.makeRef(x.getSourceInfo()));
            }

            @Override
            public void endVisit(JThisRef x, Context ctx) {
                ctx.replaceMe(this.thisParam.makeRef(x.getSourceInfo()));
            }
        }

        private static class RewriteJsniMethodBody
        extends JsModVisitor {
            private final JsName thisParam;

            public RewriteJsniMethodBody(JsName thisParam) {
                this.thisParam = thisParam;
            }

            @Override
            public void endVisit(JsThisRef x, JsContext ctx) {
                ctx.replaceMe(this.thisParam.makeRef(x.getSourceInfo()));
            }

            @Override
            public boolean visit(JsFunction x, JsContext ctx) {
                return false;
            }
        }
    }
}

