/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl;

import com.google.gwt.dev.jjs.InternalCompilerException;
import com.google.gwt.dev.jjs.ast.Context;
import com.google.gwt.dev.jjs.ast.JBinaryOperation;
import com.google.gwt.dev.jjs.ast.JBinaryOperator;
import com.google.gwt.dev.jjs.ast.JMethod;
import com.google.gwt.dev.jjs.ast.JMethodCall;
import com.google.gwt.dev.jjs.ast.JModVisitor;
import com.google.gwt.dev.jjs.ast.JPostfixOperation;
import com.google.gwt.dev.jjs.ast.JPrefixOperation;
import com.google.gwt.dev.jjs.ast.JPrimitiveType;
import com.google.gwt.dev.jjs.ast.JProgram;
import com.google.gwt.dev.jjs.ast.JType;
import com.google.gwt.dev.jjs.ast.JUnaryOperator;

public class LongEmulationNormalizer {
    private final JProgram program;

    public static void exec(JProgram program) {
        new LongEmulationNormalizer(program).execImpl();
    }

    private LongEmulationNormalizer(JProgram program) {
        this.program = program;
    }

    private void execImpl() {
        LongOpVisitor visitor = new LongOpVisitor(this.program.getTypePrimitiveLong());
        visitor.accept(this.program);
    }

    private class LongOpVisitor
    extends JModVisitor {
        private final JPrimitiveType longType;

        public LongOpVisitor(JPrimitiveType longType) {
            this.longType = longType;
        }

        @Override
        public void endVisit(JBinaryOperation x, Context ctx) {
            if (LongEmulationNormalizer.this.program.isJavaLangString(x.getType())) {
                return;
            }
            JType lhsType = x.getLhs().getType();
            JType rhsType = x.getRhs().getType();
            if (lhsType != this.longType) {
                return;
            }
            String methodName = this.getEmulationMethod(x.getOp());
            if (methodName == null) {
                return;
            }
            switch (x.getOp()) {
                case SHL: 
                case SHR: 
                case SHRU: {
                    if (rhsType != this.longType) break;
                    throw new InternalCompilerException("Expected right operand not to be of type long");
                }
                default: {
                    if (rhsType == this.longType) break;
                    throw new InternalCompilerException("Expected right operand to be of type long");
                }
            }
            JMethod method = LongEmulationNormalizer.this.program.getIndexedMethod("LongLib." + methodName);
            JMethodCall call = new JMethodCall(x.getSourceInfo(), null, method, x.getLhs(), x.getRhs());
            call.overrideReturnType(x.getType());
            ctx.replaceMe(call);
        }

        @Override
        public void endVisit(JPostfixOperation x, Context ctx) {
            JType argType = x.getArg().getType();
            if (argType == this.longType) {
                throw new InternalCompilerException("Postfix operations on longs should not reach here");
            }
        }

        @Override
        public void endVisit(JPrefixOperation x, Context ctx) {
            JType argType = x.getArg().getType();
            if (argType != this.longType) {
                return;
            }
            String methodName = this.getEmulationMethod(x.getOp());
            JMethod method = LongEmulationNormalizer.this.program.getIndexedMethod("LongLib." + methodName);
            JMethodCall call = new JMethodCall(x.getSourceInfo(), null, method, x.getArg());
            call.overrideReturnType(x.getType());
            ctx.replaceMe(call);
        }

        private String getEmulationMethod(JBinaryOperator op) {
            switch (op) {
                case MUL: {
                    return "mul";
                }
                case DIV: {
                    return "div";
                }
                case MOD: {
                    return "mod";
                }
                case ADD: {
                    return "add";
                }
                case SUB: {
                    return "sub";
                }
                case SHL: {
                    return "shl";
                }
                case SHR: {
                    return "shr";
                }
                case SHRU: {
                    return "shru";
                }
                case LT: {
                    return "lt";
                }
                case LTE: {
                    return "lte";
                }
                case GT: {
                    return "gt";
                }
                case GTE: {
                    return "gte";
                }
                case EQ: {
                    return "eq";
                }
                case NEQ: {
                    return "neq";
                }
                case BIT_AND: {
                    return "and";
                }
                case BIT_XOR: {
                    return "xor";
                }
                case BIT_OR: {
                    return "or";
                }
                case AND: 
                case OR: {
                    throw new InternalCompilerException("AND and OR should not have long operands");
                }
                case ASG: {
                    return null;
                }
                case ASG_ADD: 
                case ASG_SUB: 
                case ASG_MUL: 
                case ASG_DIV: 
                case ASG_MOD: 
                case ASG_SHL: 
                case ASG_SHR: 
                case ASG_SHRU: 
                case ASG_BIT_AND: 
                case ASG_BIT_OR: 
                case ASG_BIT_XOR: {
                    throw new InternalCompilerException("Modifying long ops should not reach here");
                }
            }
            throw new InternalCompilerException("Should not reach here");
        }

        private String getEmulationMethod(JUnaryOperator op) {
            switch (op) {
                case INC: 
                case DEC: {
                    throw new InternalCompilerException("Modifying long ops should not reach here");
                }
                case NEG: {
                    return "neg";
                }
                case NOT: {
                    throw new InternalCompilerException("NOT should not have a long operand");
                }
                case BIT_NOT: {
                    return "not";
                }
            }
            throw new InternalCompilerException("Should not reach here");
        }
    }
}

