/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl;

import com.google.gwt.dev.jjs.ast.Context;
import com.google.gwt.dev.jjs.ast.JBinaryOperation;
import com.google.gwt.dev.jjs.ast.JBinaryOperator;
import com.google.gwt.dev.jjs.ast.JConditional;
import com.google.gwt.dev.jjs.ast.JDeclarationStatement;
import com.google.gwt.dev.jjs.ast.JExpression;
import com.google.gwt.dev.jjs.ast.JMethod;
import com.google.gwt.dev.jjs.ast.JMethodCall;
import com.google.gwt.dev.jjs.ast.JModVisitor;
import com.google.gwt.dev.jjs.ast.JNewArray;
import com.google.gwt.dev.jjs.ast.JParameter;
import com.google.gwt.dev.jjs.ast.JPrimitiveType;
import com.google.gwt.dev.jjs.ast.JProgram;
import com.google.gwt.dev.jjs.ast.JReturnStatement;
import com.google.gwt.dev.jjs.ast.JType;
import com.google.gwt.dev.jjs.impl.Simplifier;
import java.util.List;

public class LongCastNormalizer {
    private final JProgram program;

    public static void exec(JProgram program) {
        new LongCastNormalizer(program).execImpl();
    }

    private LongCastNormalizer(JProgram program) {
        this.program = program;
    }

    private void execImpl() {
        ImplicitCastVisitor visitor = new ImplicitCastVisitor(this.program.getTypePrimitiveLong());
        visitor.accept(this.program);
    }

    private class ImplicitCastVisitor
    extends JModVisitor {
        private JMethod currentMethod;
        private final JPrimitiveType longType;

        public ImplicitCastVisitor(JPrimitiveType longType) {
            this.longType = longType;
        }

        @Override
        public void endVisit(JBinaryOperation x, Context ctx) {
            JType lhsType = x.getLhs().getType();
            JType rhsType = x.getRhs().getType();
            JType resultType = x.getType();
            JBinaryOperator op = x.getOp();
            if (LongCastNormalizer.this.program.isJavaLangString(resultType)) {
                return;
            }
            if (lhsType == JPrimitiveType.BOOLEAN && (op == JBinaryOperator.AND || op == JBinaryOperator.OR)) {
                return;
            }
            if (op.isShiftOperator()) {
                if (rhsType == this.longType) {
                    rhsType = LongCastNormalizer.this.program.getTypePrimitiveInt();
                }
            } else if (lhsType == this.longType || rhsType == this.longType) {
                JType coerceTo = this.longType;
                JPrimitiveType floatType = LongCastNormalizer.this.program.getTypePrimitiveFloat();
                JPrimitiveType doubleType = LongCastNormalizer.this.program.getTypePrimitiveDouble();
                if (lhsType == floatType || lhsType == doubleType) {
                    coerceTo = lhsType;
                }
                if (op.isAssignment()) {
                    coerceTo = lhsType;
                } else if (rhsType == floatType || rhsType == doubleType) {
                    coerceTo = rhsType;
                }
                lhsType = rhsType = coerceTo;
            }
            JExpression newLhs = this.checkAndReplace(x.getLhs(), lhsType);
            JExpression newRhs = this.checkAndReplace(x.getRhs(), rhsType);
            if (newLhs != x.getLhs() || newRhs != x.getRhs()) {
                JBinaryOperation binOp = new JBinaryOperation(x.getSourceInfo(), resultType, op, newLhs, newRhs);
                ctx.replaceMe(binOp);
            }
        }

        @Override
        public void endVisit(JConditional x, Context ctx) {
            JExpression newThen = this.checkAndReplace(x.getThenExpr(), x.getType());
            JExpression newElse = this.checkAndReplace(x.getElseExpr(), x.getType());
            if (newThen != x.getThenExpr() || newElse != x.getElseExpr()) {
                JConditional newCond = new JConditional(x.getSourceInfo(), x.getType(), x.getIfTest(), newThen, newElse);
                ctx.replaceMe(newCond);
            }
        }

        @Override
        public void endVisit(JDeclarationStatement x, Context ctx) {
            JExpression init = x.getInitializer();
            if (init != null && (init = this.checkAndReplace(init, x.getVariableRef().getType())) != x.getInitializer()) {
                JDeclarationStatement newStmt = new JDeclarationStatement(x.getSourceInfo(), x.getVariableRef(), init);
                ctx.replaceMe(newStmt);
            }
        }

        @Override
        public void endVisit(JMethod x, Context ctx) {
            this.currentMethod = null;
        }

        @Override
        public void endVisit(JMethodCall x, Context ctx) {
            List<JParameter> params = x.getTarget().getParams();
            for (int i = 0; i < params.size(); ++i) {
                JExpression newArg;
                JParameter param = params.get(i);
                JExpression arg = x.getArgs().get(i);
                if (arg == (newArg = this.checkAndReplace(arg, param.getType()))) continue;
                x.setArg(i, newArg);
                this.madeChanges();
            }
        }

        @Override
        public void endVisit(JNewArray x, Context ctx) {
            JType elementType = x.getArrayType().getElementType();
            List<JExpression> initializers = x.getInitializers();
            if (initializers != null) {
                for (int i = 0; i < initializers.size(); ++i) {
                    JExpression newInitializer;
                    JExpression initializer = initializers.get(i);
                    if (initializer == (newInitializer = this.checkAndReplace(initializer, elementType))) continue;
                    initializers.set(i, newInitializer);
                    this.madeChanges();
                }
            }
        }

        @Override
        public void endVisit(JReturnStatement x, Context ctx) {
            JExpression newExpr;
            JExpression expr = x.getExpr();
            if (expr != null && expr != (newExpr = this.checkAndReplace(expr, this.currentMethod.getType()))) {
                ctx.replaceMe(newExpr.makeReturnStatement());
            }
        }

        @Override
        public boolean visit(JMethod x, Context ctx) {
            this.currentMethod = x;
            return true;
        }

        private JExpression checkAndReplace(JExpression arg, JType targetType) {
            if (targetType != this.longType && arg.getType() != this.longType) {
                return arg;
            }
            return Simplifier.cast(targetType, arg);
        }
    }
}

