/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.dev.jjs.ast.Context;
import com.google.gwt.dev.jjs.ast.JDeclaredType;
import com.google.gwt.dev.jjs.ast.JMethod;
import com.google.gwt.dev.jjs.ast.JMethodBody;
import com.google.gwt.dev.jjs.ast.JProgram;
import com.google.gwt.dev.jjs.ast.JVisitor;
import com.google.gwt.dev.jjs.ast.js.JsniMethodBody;
import com.google.gwt.dev.jjs.ast.js.JsniMethodRef;
import com.google.gwt.dev.jjs.impl.AbstractRestrictionChecker;
import com.google.gwt.dev.jjs.impl.JjsUtils;
import com.google.gwt.dev.js.ast.JsContext;
import com.google.gwt.dev.js.ast.JsExpression;
import com.google.gwt.dev.js.ast.JsInvocation;
import com.google.gwt.dev.js.ast.JsModVisitor;
import com.google.gwt.dev.js.ast.JsNameRef;
import com.google.gwt.thirdparty.guava.common.collect.Maps;
import com.google.gwt.thirdparty.guava.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;

public class JsniRestrictionChecker
extends AbstractRestrictionChecker {
    public static void exec(TreeLogger logger, JProgram program) throws UnableToCompleteException {
        new JsniRestrictionChecker().checkProgram(logger, program);
    }

    private void checkProgram(TreeLogger logger, final JProgram program) throws UnableToCompleteException {
        final HashSet<JDeclaredType> typesRequiringTrampolineDispatch = Sets.newHashSet();
        for (JDeclaredType jDeclaredType : program.getRepresentedAsNativeTypes()) {
            JjsUtils.addAllSuperTypes(jDeclaredType, typesRequiringTrampolineDispatch);
        }
        new JVisitor(){

            @Override
            public boolean visit(JMethodBody x, Context ctx) {
                return false;
            }

            @Override
            public boolean visit(JsniMethodBody x, Context ctx) {
                final HashMap<String, JsniMethodRef> methodsByJsniReference = Maps.newHashMap();
                for (JsniMethodRef ref : x.getJsniMethodRefs()) {
                    methodsByJsniReference.put(ref.getIdent(), ref);
                }
                if (methodsByJsniReference.isEmpty()) {
                    return false;
                }
                new JsModVisitor(){

                    @Override
                    public boolean visit(JsInvocation x, JsContext ctx) {
                        if (!(x.getQualifier() instanceof JsNameRef)) {
                            return true;
                        }
                        JsNameRef ref = (JsNameRef)x.getQualifier();
                        if (!ref.isJsniReference()) {
                            return true;
                        }
                        JsExpression methodQualifier = ref.getQualifier();
                        if (methodQualifier != null) {
                            this.accept(methodQualifier);
                        }
                        return false;
                    }

                    @Override
                    public void endVisit(JsNameRef x, JsContext ctx) {
                        JsniMethodRef jsniMethodReference = (JsniMethodRef)methodsByJsniReference.get(x.getIdent());
                        if (jsniMethodReference != null) {
                            this.checkJsniMethodReference(jsniMethodReference);
                        }
                    }
                }.accept(x.getFunc());
                return false;
            }

            private void checkJsniMethodReference(JsniMethodRef jsniMethodReference) {
                JDeclaredType enclosingType;
                JMethod method = jsniMethodReference.getTarget();
                if (JsniRestrictionChecker.isNonStaticJsoClassDispatch(method, enclosingType = method.getEnclosingType()) || this.isJsoInterface(enclosingType)) {
                    JsniRestrictionChecker.this.logError(jsniMethodReference, "Method %s is implemented by a JSO and can only be used in calls within a JSNI method body.", AbstractRestrictionChecker.getDescription(method));
                } else if (program.isRepresentedAsNativeJsPrimitive(enclosingType) && !method.isStatic() && !method.isConstructor()) {
                    JsniRestrictionChecker.this.logError(jsniMethodReference, "Method %s is implemented by devirtualized type %s JSO and can only be used in calls within a JSNI method body.", AbstractRestrictionChecker.getDescription(method), AbstractRestrictionChecker.getDescription(enclosingType));
                } else if (typesRequiringTrampolineDispatch.contains(enclosingType) && !method.isStatic() && !method.isConstructor()) {
                    JsniRestrictionChecker.this.logWarning(jsniMethodReference, "Unsafe reference to method %s. Instance methods from %s should not be called on Boolean, Double, String, Array or JSO instances from  within a JSNI method body.", AbstractRestrictionChecker.getDescription(method), AbstractRestrictionChecker.getDescription(enclosingType));
                }
            }

            private boolean isJsoInterface(JDeclaredType type) {
                return program.typeOracle.isSingleJsoImpl(type) || program.typeOracle.isDualJsoInterface(type);
            }
        }.accept(program);
        boolean hasErrors = this.reportErrorsAndWarnings(logger);
        if (hasErrors) {
            throw new UnableToCompleteException();
        }
    }

    private static boolean isNonStaticJsoClassDispatch(JMethod method, JDeclaredType enclosingType) {
        return !method.isStatic() && enclosingType.isJsoType();
    }

    private JsniRestrictionChecker() {
    }
}

