/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl;

import com.google.gwt.dev.jjs.ast.JArrayType;
import com.google.gwt.dev.jjs.ast.JClassType;
import com.google.gwt.dev.jjs.ast.JConstructor;
import com.google.gwt.dev.jjs.ast.JDeclaredType;
import com.google.gwt.dev.jjs.ast.JField;
import com.google.gwt.dev.jjs.ast.JMethod;
import com.google.gwt.dev.jjs.ast.JNode;
import com.google.gwt.dev.jjs.ast.JParameter;
import com.google.gwt.dev.jjs.ast.JProgram;
import com.google.gwt.dev.jjs.ast.JType;
import com.google.gwt.dev.util.JsniRef;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.TreeSet;

@Deprecated
public class JsniRefLookup {
    public static JNode findJsniRefTarget(JsniRef ref, JProgram program, ErrorReporter errorReporter) {
        String className = ref.className();
        JType type = program.getTypeFromJsniRef(className);
        if (type == null) {
            errorReporter.reportError("Unresolvable native reference to type '" + className + "'");
            return null;
        }
        if (!ref.isMethod()) {
            String fieldName = ref.memberName();
            if (fieldName.equals("class")) {
                return type;
            }
            if (type.isPrimitiveType()) {
                errorReporter.reportError("May not refer to fields on primitive types");
                return null;
            }
            if (type instanceof JArrayType) {
                errorReporter.reportError("May not refer to fields on array types");
                return null;
            }
            for (JField field : ((JDeclaredType)type).getFields()) {
                if (!field.getName().equals(fieldName)) continue;
                return field;
            }
            errorReporter.reportError("Unresolvable native reference to field '" + fieldName + "' in type '" + className + "'");
            return null;
        }
        if (type.isPrimitiveType()) {
            errorReporter.reportError("May not refer to methods on primitive types");
            return null;
        }
        LinkedHashMap<String, LinkedHashMap<String, JMethod>> matchesBySig = new LinkedHashMap<String, LinkedHashMap<String, JMethod>>();
        String methodName = ref.memberName();
        String jsniSig = ref.memberSignature();
        JsniRefLookup.findMostDerivedMembers(matchesBySig, (JDeclaredType)type, methodName, true);
        LinkedHashMap<String, JMethod> matches = matchesBySig.get(jsniSig);
        if (matches != null && matches.size() == 1) {
            return matches.values().iterator().next();
        }
        JsniRefLookup.removeSyntheticMembers(matchesBySig);
        matches = matchesBySig.get(jsniSig);
        if (matches != null && matches.size() == 1) {
            return matches.values().iterator().next();
        }
        if (matchesBySig.isEmpty()) {
            errorReporter.reportError("Unresolvable native reference to method '" + methodName + "' in type '" + className + "'");
            return null;
        }
        StringBuilder suggestList = new StringBuilder();
        String comma = "";
        TreeSet<String> almostMatchSigs = new TreeSet<String>();
        for (String sig : matchesBySig.keySet()) {
            if (matchesBySig.get(sig).size() != 1) continue;
            almostMatchSigs.add(sig);
        }
        for (String almost : almostMatchSigs) {
            suggestList.append(comma + "'" + almost + "'");
            comma = ", ";
        }
        errorReporter.reportError("Unresolvable native reference to method '" + methodName + "' in type '" + className + "' (did you mean " + suggestList.toString() + "?)");
        return null;
    }

    private static void addMember(LinkedHashMap<String, LinkedHashMap<String, JMethod>> matchesBySig, JMethod member, String refSig, String fullSig) {
        LinkedHashMap<String, JMethod> matchesByFullSig = matchesBySig.get(refSig);
        if (matchesByFullSig == null) {
            matchesByFullSig = new LinkedHashMap();
            matchesBySig.put(refSig, matchesByFullSig);
        }
        matchesByFullSig.put(fullSig, member);
    }

    private static void findMostDerivedMembers(LinkedHashMap<String, LinkedHashMap<String, JMethod>> matchesBySig, JDeclaredType targetType, String memberName, boolean addConstructorsAndPrivates) {
        JClassType targetClass;
        if (targetType instanceof JClassType && (targetClass = (JClassType)targetType).getSuperClass() != null) {
            JsniRefLookup.findMostDerivedMembers(matchesBySig, targetClass.getSuperClass(), memberName, false);
        }
        for (JDeclaredType jDeclaredType : targetType.getImplements()) {
            JsniRefLookup.findMostDerivedMembers(matchesBySig, jDeclaredType, memberName, false);
        }
        for (JMethod jMethod : targetType.getMethods()) {
            if (jMethod instanceof JConstructor && "new".equals(memberName)) {
                if (!addConstructorsAndPrivates) continue;
                StringBuilder sb = new StringBuilder();
                sb.append("new");
                sb.append("(");
                for (JParameter param : jMethod.getParams()) {
                    sb.append(param.getType().getJsniSignatureName());
                }
                sb.append(")");
                String fullSig = sb.toString();
                String wildcardSig = "new(*)";
                JsniRefLookup.addMember(matchesBySig, jMethod, fullSig, fullSig);
                JsniRefLookup.addMember(matchesBySig, jMethod, wildcardSig, fullSig);
                continue;
            }
            if (!jMethod.getName().equals(memberName) || !addConstructorsAndPrivates && jMethod.isPrivate()) continue;
            String fullSig = jMethod.getJsniSignature(false, false);
            String wildcardSig = jMethod.getName() + "(" + "*" + ")";
            JsniRefLookup.addMember(matchesBySig, jMethod, fullSig, fullSig);
            JsniRefLookup.addMember(matchesBySig, jMethod, wildcardSig, fullSig);
        }
    }

    private static void removeSyntheticMembers(LinkedHashMap<String, LinkedHashMap<String, JMethod>> matchesBySig) {
        for (LinkedHashMap<String, JMethod> matchesByFullSig : matchesBySig.values()) {
            LinkedHashSet<String> toRemove = new LinkedHashSet<String>();
            for (String fullSig : matchesByFullSig.keySet()) {
                JMethod member = matchesByFullSig.get(fullSig);
                if (!member.isSynthetic()) continue;
                toRemove.add(fullSig);
            }
            for (String fullSig : toRemove) {
                matchesByFullSig.remove(fullSig);
            }
        }
    }

    public static interface ErrorReporter {
        public void reportError(String var1);
    }
}

