/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.linker.StatementRanges;
import com.google.gwt.core.ext.linker.impl.JsSourceMapBuilder;
import com.google.gwt.core.ext.linker.impl.JsSourceMapExtractor;
import com.google.gwt.core.ext.linker.impl.NamedRange;
import com.google.gwt.core.ext.linker.impl.StatementRangesBuilder;
import com.google.gwt.core.ext.linker.impl.StatementRangesExtractor;
import com.google.gwt.dev.MinimalRebuildCache;
import com.google.gwt.dev.jjs.JsSourceMap;
import com.google.gwt.dev.jjs.ast.JTypeOracle;
import com.google.gwt.dev.jjs.impl.JsAbstractTextTransformer;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import com.google.gwt.thirdparty.guava.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class JsTypeLinker
extends JsAbstractTextTransformer {
    private static final String FOOTER_NAME = "-footer-";
    private static final String HEADER_NAME = "-header-";
    private final NamedRange footerRange;
    private final NamedRange headerRange;
    private final StringBuilder jsBuilder;
    private final JsSourceMapBuilder jsSourceMapBuilder = new JsSourceMapBuilder();
    private final JsSourceMapExtractor jsSourceMapExtractor;
    private final Set<String> linkedTypeNames = Sets.newHashSet();
    private TreeLogger logger;
    private final MinimalRebuildCache minimalRebuildCache;
    private final StatementRangesBuilder statementRangesBuilder = new StatementRangesBuilder();
    private final StatementRangesExtractor statementRangesExtractor;
    private final JTypeOracle typeOracle;
    private final List<NamedRange> typeRanges;

    public JsTypeLinker(TreeLogger logger, JsAbstractTextTransformer textTransformer, List<NamedRange> typeRanges, NamedRange programTypeRange, MinimalRebuildCache minimalRebuildCache, JTypeOracle typeOracle) {
        super(textTransformer);
        this.logger = logger;
        this.statementRangesExtractor = new StatementRangesExtractor(this.statementRanges);
        this.jsSourceMapExtractor = this.sourceInfoMap.createExtractor();
        this.typeRanges = typeRanges;
        this.headerRange = new NamedRange(HEADER_NAME, 0, programTypeRange.getStartPosition(), 0, programTypeRange.getStartLineNumber());
        this.footerRange = new NamedRange(FOOTER_NAME, programTypeRange.getEndPosition(), this.js.length(), programTypeRange.getEndLineNumber(), this.sourceInfoMap.getLines());
        this.minimalRebuildCache = minimalRebuildCache;
        this.typeOracle = typeOracle;
        this.jsBuilder = new StringBuilder(minimalRebuildCache.knowsLastLinkedJsBytes() ? (int)((double)minimalRebuildCache.getLastLinkedJsBytes() * 1.05) : this.sourceInfoMap.getBytes());
    }

    @Override
    public void exec() {
        this.logger = this.logger.branch(TreeLogger.INFO, "Linking per-type JS with " + this.typeRanges.size() + " new/changed types.");
        this.linkAll(this.computeReachableTypes());
    }

    @Override
    protected void updateSourceInfoMap() {
    }

    private List<String> computeReachableTypes() {
        ArrayList<String> reachableTypeNames = Lists.newArrayList(this.minimalRebuildCache.computeReachableTypeNames());
        Collections.sort(reachableTypeNames);
        return reachableTypeNames;
    }

    private void extractOne(NamedRange typeRange) {
        String typeName = typeRange.getName();
        this.minimalRebuildCache.setJsForType(this.logger, typeName, this.js.substring(typeRange.getStartPosition(), typeRange.getEndPosition()));
        this.minimalRebuildCache.setStatementRangesForType(typeName, this.statementRangesExtractor.extract(typeRange.getStartPosition(), typeRange.getEndPosition()));
        this.minimalRebuildCache.setSourceMapForType(typeName, this.jsSourceMapExtractor.extract(typeRange.getStartPosition(), typeRange.getEndPosition(), typeRange.getStartLineNumber(), typeRange.getEndLineNumber()));
    }

    private void linkAll(List<String> reachableTypeNames) {
        if (this.minimalRebuildCache.getJs(HEADER_NAME) == null) {
            this.extractOne(this.headerRange);
        }
        for (NamedRange typeRange : this.typeRanges) {
            this.extractOne(typeRange);
        }
        this.extractOne(this.footerRange);
        this.linkOne(HEADER_NAME);
        for (String reachableTypeName : reachableTypeNames) {
            this.linkOne(reachableTypeName);
        }
        this.linkOne(FOOTER_NAME);
        this.logger.log(TreeLogger.TRACE, "prelink JS size = " + this.js.length());
        this.logger.log(TreeLogger.TRACE, "prelink sourcemap = " + this.sourceInfoMap.getBytes() + " bytes and " + this.sourceInfoMap.getLines() + " lines");
        this.js = this.jsBuilder.toString();
        this.statementRanges = this.statementRangesBuilder.build();
        this.sourceInfoMap = this.jsSourceMapBuilder.build();
        this.minimalRebuildCache.setLastLinkedJsBytes(this.js.length());
        this.logger.log(TreeLogger.TRACE, "postlink JS size = " + this.js.length());
        this.logger.log(TreeLogger.TRACE, "postlink sourcemap = " + this.sourceInfoMap.getBytes() + " bytes and " + this.sourceInfoMap.getLines() + " lines");
    }

    private void linkOne(String typeName) {
        if (this.linkedTypeNames.contains(typeName)) {
            return;
        }
        this.linkedTypeNames.add(typeName);
        String typeJs = this.minimalRebuildCache.getJs(typeName);
        if (typeJs == null) {
            return;
        }
        String superTypeName = this.typeOracle.getSuperTypeName(typeName);
        if (superTypeName != null) {
            this.linkOne(superTypeName);
        }
        this.logger.log(TreeLogger.SPAM, "linking type " + typeName + " (" + typeJs.length() + " bytes)");
        StatementRanges typeStatementRanges = this.minimalRebuildCache.getStatementRanges(typeName);
        JsSourceMap typeSourceMap = this.minimalRebuildCache.getSourceMap(typeName);
        this.jsBuilder.append(typeJs);
        this.statementRangesBuilder.append(typeStatementRanges);
        this.jsSourceMapBuilder.append(typeSourceMap);
    }
}

