/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.dev.MinimalRebuildCache;
import com.google.gwt.dev.javac.JsInteropUtil;
import com.google.gwt.dev.jjs.HasSourceInfo;
import com.google.gwt.dev.jjs.ast.CanBeJsNative;
import com.google.gwt.dev.jjs.ast.CanHaveSuppressedWarnings;
import com.google.gwt.dev.jjs.ast.Context;
import com.google.gwt.dev.jjs.ast.HasJsInfo;
import com.google.gwt.dev.jjs.ast.HasJsName;
import com.google.gwt.dev.jjs.ast.HasType;
import com.google.gwt.dev.jjs.ast.JClassType;
import com.google.gwt.dev.jjs.ast.JConstructor;
import com.google.gwt.dev.jjs.ast.JDeclaredType;
import com.google.gwt.dev.jjs.ast.JExpression;
import com.google.gwt.dev.jjs.ast.JExpressionStatement;
import com.google.gwt.dev.jjs.ast.JField;
import com.google.gwt.dev.jjs.ast.JInstanceOf;
import com.google.gwt.dev.jjs.ast.JInterfaceType;
import com.google.gwt.dev.jjs.ast.JMember;
import com.google.gwt.dev.jjs.ast.JMethod;
import com.google.gwt.dev.jjs.ast.JMethodBody;
import com.google.gwt.dev.jjs.ast.JMethodCall;
import com.google.gwt.dev.jjs.ast.JParameter;
import com.google.gwt.dev.jjs.ast.JPrimitiveType;
import com.google.gwt.dev.jjs.ast.JProgram;
import com.google.gwt.dev.jjs.ast.JReferenceType;
import com.google.gwt.dev.jjs.ast.JStatement;
import com.google.gwt.dev.jjs.ast.JType;
import com.google.gwt.dev.jjs.ast.JVisitor;
import com.google.gwt.dev.jjs.ast.js.JsniMethodBody;
import com.google.gwt.dev.jjs.impl.AbstractRestrictionChecker;
import com.google.gwt.dev.jjs.impl.JjsUtils;
import com.google.gwt.dev.js.JsUtils;
import com.google.gwt.dev.js.ast.JsContext;
import com.google.gwt.dev.js.ast.JsFunction;
import com.google.gwt.dev.js.ast.JsNameRef;
import com.google.gwt.dev.js.ast.JsParameter;
import com.google.gwt.dev.js.ast.JsVisitor;
import com.google.gwt.thirdparty.guava.common.base.Preconditions;
import com.google.gwt.thirdparty.guava.common.base.Predicate;
import com.google.gwt.thirdparty.guava.common.collect.FluentIterable;
import com.google.gwt.thirdparty.guava.common.collect.Iterables;
import com.google.gwt.thirdparty.guava.common.collect.LinkedHashMultimap;
import com.google.gwt.thirdparty.guava.common.collect.Multimap;
import com.google.gwt.thirdparty.guava.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.List;

public class JsInteropRestrictionChecker
extends AbstractRestrictionChecker {
    private final JProgram jprogram;
    private final MinimalRebuildCache minimalRebuildCache;
    private boolean wasUnusableByJsWarningReported = false;

    public static void exec(TreeLogger logger, JProgram jprogram, MinimalRebuildCache minimalRebuildCache) throws UnableToCompleteException {
        JsInteropRestrictionChecker jsInteropRestrictionChecker = new JsInteropRestrictionChecker(jprogram, minimalRebuildCache);
        boolean success = jsInteropRestrictionChecker.checkProgram(logger);
        if (!success) {
            throw new UnableToCompleteException();
        }
    }

    private JsInteropRestrictionChecker(JProgram jprogram, MinimalRebuildCache minimalRebuildCache) {
        this.jprogram = jprogram;
        this.minimalRebuildCache = minimalRebuildCache;
    }

    private static boolean isConstructorEmpty(final JConstructor constructor) {
        return Iterables.all(constructor.getBody().getStatements(), new Predicate<JStatement>(){

            @Override
            public boolean apply(JStatement statement) {
                JClassType type = constructor.getEnclosingType();
                if (JsInteropRestrictionChecker.isImplicitSuperCall(statement, type.getSuperClass())) {
                    return true;
                }
                return JsInteropRestrictionChecker.isInitCall(statement, type);
            }
        });
    }

    private static JMethodCall isMethodCall(JStatement statement) {
        if (!(statement instanceof JExpressionStatement)) {
            return null;
        }
        JExpression expression = ((JExpressionStatement)statement).getExpr();
        return expression instanceof JMethodCall ? (JMethodCall)expression : null;
    }

    private static boolean isInitCall(JStatement statement, JDeclaredType type) {
        JMethodCall methodCall = JsInteropRestrictionChecker.isMethodCall(statement);
        return methodCall != null && methodCall.getTarget() == type.getInitMethod();
    }

    private static boolean isImplicitSuperCall(JStatement statement, JDeclaredType superType) {
        JMethodCall methodCall = JsInteropRestrictionChecker.isMethodCall(statement);
        return methodCall != null && methodCall.isStaticDispatchOnly() && methodCall.getTarget().isConstructor() && methodCall.getTarget().getEnclosingType() == superType;
    }

    private static boolean isInitEmpty(JDeclaredType type) {
        return type.getInitMethod() == null || ((JMethodBody)type.getInitMethod().getBody()).getStatements().isEmpty();
    }

    private void checkJsConstructors(JDeclaredType type) {
        List<JConstructor> jsConstructors = this.getJsConstructors(type);
        if (type.isJsNative()) {
            return;
        }
        if (jsConstructors.isEmpty()) {
            return;
        }
        if (jsConstructors.size() > 1) {
            this.logError(type, "More than one JsConstructor exists for %s.", JsInteropRestrictionChecker.getDescription(type));
        }
        JConstructor jsConstructor = jsConstructors.get(0);
        if (JjsUtils.getPrimaryConstructor(type) != jsConstructor) {
            this.logError(jsConstructor, "Constructor %s can be a JsConstructor only if all constructors in the class are delegating to it.", JsInteropRestrictionChecker.getMemberDescription(jsConstructor));
        }
    }

    private List<JConstructor> getJsConstructors(JDeclaredType type) {
        return FluentIterable.from(type.getConstructors()).filter(new Predicate<JConstructor>(){

            @Override
            public boolean apply(JConstructor m) {
                return m.isJsConstructor();
            }
        }).toList();
    }

    private void checkJsConstructorSubtype(JDeclaredType type) {
        if (!this.isJsConstructorSubtype(type)) {
            return;
        }
        if (Iterables.isEmpty(type.getConstructors())) {
            return;
        }
        if (type.isJsNative()) {
            return;
        }
        JClassType superClass = type.getSuperClass();
        JConstructor superPrimaryConsructor = JjsUtils.getPrimaryConstructor(superClass);
        if (!superClass.isJsNative() && superPrimaryConsructor == null) {
            return;
        }
        JConstructor primaryConstructor = JjsUtils.getPrimaryConstructor(type);
        if (primaryConstructor == null) {
            this.logError(type, "Class %s should have only one constructor delegating to the superclass since it is subclass of a a type with JsConstructor.", JsInteropRestrictionChecker.getDescription(type));
            return;
        }
        JConstructor delegatedConstructor = JjsUtils.getDelegatedThisOrSuperConstructor(primaryConstructor);
        if (delegatedConstructor.isJsConstructor() || delegatedConstructor == superPrimaryConsructor) {
            return;
        }
        this.logError(primaryConstructor, "Constructor %s can only delegate to super constructor %s since it is a subclass of a type with JsConstructor.", JsInteropRestrictionChecker.getDescription(primaryConstructor), JsInteropRestrictionChecker.getDescription(superPrimaryConsructor));
    }

    private void checkMember(JMember member, Multimap<String, JMember> instanceMembersByJsName) {
        if (member.getEnclosingType().isJsNative()) {
            this.checkMemberOfNativeJsType(member);
        }
        if (member.needsDynamicDispatch()) {
            this.checkIllegalOverrides(member);
        }
        if (member instanceof JMethod) {
            this.checkMethodParameters((JMethod)member);
        }
        if (member.isJsOverlay()) {
            this.checkJsOverlay(member);
            return;
        }
        if (member.canBeReferencedExternally()) {
            this.checkUnusableByJs(member);
        }
        if (member.getJsMemberType() == HasJsInfo.JsMemberType.NONE) {
            return;
        }
        if (!this.checkJsPropertyAccessor(member)) {
            return;
        }
        this.checkMemberQualifiedJsName(member);
        if (this.isInstanceJsMember(member)) {
            this.checkInstanceNameConsistency(instanceMembersByJsName, member);
        }
        if (this.isStaticJsMember(member)) {
            this.checkStaticNameCollisions(member);
        }
    }

    private void checkIllegalOverrides(JMember member) {
        if (member instanceof JField) {
            return;
        }
        JMethod method = (JMethod)member;
        if (method.isSynthetic()) {
            return;
        }
        for (JMethod overriddenMethod : method.getOverriddenMethods()) {
            if (overriddenMethod.isSynthetic() || !overriddenMethod.isJsOverlay()) continue;
            this.logError(member, "Method '%s' cannot override a JsOverlay method '%s'.", JjsUtils.getReadableDescription(method), JjsUtils.getReadableDescription(overriddenMethod));
            return;
        }
    }

    private void checkJsOverlay(JMember member) {
        if (member.getEnclosingType().isJsoType() || member.isSynthetic()) {
            return;
        }
        String memberDescription = JjsUtils.getReadableDescription(member);
        if (!member.getEnclosingType().isJsNative() && !member.getEnclosingType().isJsFunction()) {
            this.logError(member, "JsOverlay '%s' can only be declared in a native type or a JsFunction interface.", memberDescription);
        }
        if (member instanceof JConstructor) {
            this.logError(member, "JsOverlay method '%s' cannot be a constructor.", memberDescription);
            return;
        }
        if (member.getJsMemberType() != HasJsInfo.JsMemberType.NONE) {
            this.logError(member, "JsOverlay method '%s' cannot be nor override a JsProperty or a JsMethod.", memberDescription);
            return;
        }
        if (member instanceof JField) {
            JField field = (JField)member;
            if (field.needsDynamicDispatch()) {
                this.logError(member, "JsOverlay field '%s' can only be static.", memberDescription);
            }
            return;
        }
        JMethod method = (JMethod)member;
        assert (method.getOverriddenMethods().isEmpty());
        if (!(method.getBody() != null && (method.isFinal() || method.getEnclosingType().isFinal() || method.isPrivate() || method.isStatic() || method.isDefaultMethod()))) {
            this.logError(member, "JsOverlay method '%s' cannot be non-final nor native.", memberDescription);
        }
    }

    private void checkSuperDispachToNativeJavaLangObjectMethodOverride() {
        new JVisitor(){
            JClassType superClass;

            @Override
            public boolean visit(JDeclaredType x, Context ctx) {
                this.superClass = JjsUtils.getNativeSuperClassOrNull(x);
                return x instanceof JClassType && this.superClass != null;
            }

            @Override
            public boolean visit(JMethod x, Context ctx) {
                return !x.isSynthetic();
            }

            @Override
            public void endVisit(JMethodCall x, Context ctx) {
                JMethod target = x.getTarget();
                if (!x.isStaticDispatchOnly()) {
                    return;
                }
                assert (!target.isStatic());
                if (JsInteropRestrictionChecker.this.overridesObjectMethod(target) && target.getEnclosingType().isJsNative() || target.getEnclosingType() == JsInteropRestrictionChecker.this.jprogram.getTypeJavaLangObject()) {
                    JsInteropRestrictionChecker.this.logError(x, "Cannot use super to call '%s.%s'. 'java.lang.Object' methods in native JsTypes cannot be called using super.", JjsUtils.getReadableDescription(this.superClass), target.getName());
                    return;
                }
            }
        }.accept(this.jprogram);
    }

    private void checkMemberOfNativeJsType(JMember member) {
        if (member instanceof JMethod && ((JMethod)member).isJsniMethod()) {
            this.logError(member, "JSNI method %s is not allowed in a native JsType.", JsInteropRestrictionChecker.getMemberDescription(member));
            return;
        }
        if (member.isSynthetic() || member.isJsOverlay()) {
            return;
        }
        if (this.overridesObjectMethod(member) && (member.getJsMemberType() != HasJsInfo.JsMemberType.METHOD || !member.getName().equals(member.getJsName()))) {
            this.logError(member, "Method %s cannot override a method from 'java.lang.Object' and change its name.", JsInteropRestrictionChecker.getMemberDescription(member));
            return;
        }
        HasJsInfo.JsMemberType jsMemberType = member.getJsMemberType();
        switch (jsMemberType) {
            case CONSTRUCTOR: {
                if (JsInteropRestrictionChecker.isConstructorEmpty((JConstructor)member)) break;
                this.logError(member, "Native JsType constructor %s cannot have non-empty method body.", JsInteropRestrictionChecker.getMemberDescription(member));
                break;
            }
            case METHOD: 
            case GETTER: 
            case SETTER: 
            case UNDEFINED_ACCESSOR: {
                JMethod method = (JMethod)member;
                if (method.isAbstract() || method.getBody() == null) break;
                this.logError(member, "Native JsType method %s should be native or abstract.", JsInteropRestrictionChecker.getMemberDescription(member));
                break;
            }
            case PROPERTY: {
                JField field = (JField)member;
                if (field.isFinal()) {
                    this.logError(member, "Native JsType field %s cannot be final.", JsInteropRestrictionChecker.getMemberDescription(member));
                    break;
                }
                if (!field.hasInitializer()) break;
                this.logError(member, "Native JsType field %s cannot have initializer.", JsInteropRestrictionChecker.getMemberDescription(member));
                break;
            }
            case NONE: {
                this.logError(member, "Native JsType member %s cannot have @JsIgnore.", JsInteropRestrictionChecker.getMemberDescription(member));
            }
        }
    }

    private boolean overridesObjectMethod(JMember member) {
        if (!(member instanceof JMethod)) {
            return false;
        }
        JMethod method = (JMethod)member;
        for (JMethod overriddenMethod : method.getOverriddenMethods()) {
            if (overriddenMethod.getEnclosingType() != this.jprogram.getTypeJavaLangObject()) continue;
            return true;
        }
        return false;
    }

    private void checkMethodParameters(JMethod method) {
        if (method.isSynthetic()) {
            return;
        }
        boolean hasOptionalParameters = false;
        for (JParameter parameter : method.getParams()) {
            if (parameter.isOptional()) {
                if (parameter.getType().isPrimitiveType()) {
                    this.logError(method, "JsOptional parameter '%s' in method %s cannot be of primitive type.", parameter.getName(), JsInteropRestrictionChecker.getMemberDescription(method));
                }
                hasOptionalParameters = true;
                continue;
            }
            if (!hasOptionalParameters || parameter.isVarargs()) continue;
            this.logError(method, "JsOptional parameter '%s' in method %s cannot precede parameters that are not optional.", parameter.getName(), JsInteropRestrictionChecker.getMemberDescription(method));
            break;
        }
        if (hasOptionalParameters && method.getJsMemberType() != HasJsInfo.JsMemberType.CONSTRUCTOR && method.getJsMemberType() != HasJsInfo.JsMemberType.METHOD && !method.isOrOverridesJsFunctionMethod()) {
            this.logError(method, "Method %s has JsOptional parameters and is not a JsMethod, a JsConstructor or a JsFunction method.", JsInteropRestrictionChecker.getMemberDescription(method));
        }
        if (method.isJsMethodVarargs()) {
            this.checkJsVarargs(method);
        }
        block1: for (JMethod overriddenMethod : method.getOverriddenMethods()) {
            for (int i = 0; i < overriddenMethod.getParams().size(); ++i) {
                if (!overriddenMethod.getParams().get(i).isOptional()) continue;
                if (method.getParams().get(i).isOptional()) continue block1;
                this.logError(method, "Method %s should declare parameter '%s' as JsOptional", JsInteropRestrictionChecker.getMemberDescription(method), method.getParams().get(i).getName());
                return;
            }
        }
    }

    private void checkJsVarargs(final JMethod method) {
        if (!method.isJsniMethod()) {
            return;
        }
        JsFunction function = ((JsniMethodBody)method.getBody()).getFunc();
        final JsParameter varargParameter = Iterables.getLast(function.getParameters());
        new JsVisitor(){

            @Override
            public void endVisit(JsNameRef x, JsContext ctx) {
                if (x.getName() == varargParameter.getName()) {
                    JsInteropRestrictionChecker.this.logError(x, "Cannot access vararg parameter '%s' from JSNI in JsMethod %s. Use 'arguments' instead.", x.getIdent(), AbstractRestrictionChecker.getMemberDescription(method));
                }
            }
        }.accept(function);
    }

    private boolean checkJsPropertyAccessor(JMember member) {
        HasJsInfo.JsMemberType memberType = member.getJsMemberType();
        if (member.getJsName().equals("<invalid>")) {
            assert (memberType.isPropertyAccessor());
            this.logError(member, "JsProperty %s should either follow Java Bean naming conventions or provide a name.", JsInteropRestrictionChecker.getMemberDescription(member));
            return false;
        }
        switch (memberType) {
            case UNDEFINED_ACCESSOR: {
                this.logError(member, "JsProperty %s should have a correct setter or getter signature.", JsInteropRestrictionChecker.getMemberDescription(member));
                break;
            }
            case GETTER: {
                if (member.getType() == JPrimitiveType.BOOLEAN || !member.getName().startsWith("is")) break;
                this.logError(member, "JsProperty %s cannot have a non-boolean return.", JsInteropRestrictionChecker.getMemberDescription(member));
                break;
            }
            case SETTER: {
                if (!((JMethod)member).getParams().get(0).isVarargs()) break;
                this.logError(member, "JsProperty %s cannot have a vararg parameter.", JsInteropRestrictionChecker.getMemberDescription(member));
            }
        }
        if (memberType.isPropertyAccessor() && member.isStatic() && !member.isJsNative()) {
            this.logError(member, "Static property accessor '%s' can only be native.", JjsUtils.getReadableDescription(member));
        }
        return true;
    }

    private void checkMemberQualifiedJsName(JMember member) {
        if (member instanceof JConstructor) {
            return;
        }
        this.checkJsName(member);
        if (member.getJsNamespace().equals(member.getEnclosingType().getQualifiedJsName())) {
            return;
        }
        if (member.needsDynamicDispatch()) {
            this.logError(member, "Instance member %s cannot declare a namespace.", JsInteropRestrictionChecker.getMemberDescription(member));
            return;
        }
        this.checkJsNamespace(member);
    }

    private <T extends HasJsName & HasSourceInfo> void checkJsName(T item) {
        if (item.getJsName().isEmpty()) {
            this.logError(item, "%s cannot have an empty name.", JsInteropRestrictionChecker.getDescription(item));
        } else if (((CanBeJsNative)item).isJsNative() && !JsUtils.isValidJsQualifiedName(item.getJsName()) || !((CanBeJsNative)item).isJsNative() && !JsUtils.isValidJsIdentifier(item.getJsName())) {
            this.logError(item, "%s has invalid name '%s'.", JsInteropRestrictionChecker.getDescription(item), item.getJsName());
        }
    }

    private <T extends HasJsName & HasSourceInfo> void checkJsNamespace(T item) {
        if (JsInteropUtil.isGlobal(item.getJsNamespace())) {
            return;
        }
        if (JsInteropUtil.isWindow(item.getJsNamespace())) {
            if (((CanBeJsNative)item).isJsNative()) {
                return;
            }
            this.logError(item, "'%s' can only be used as a namespace of native types and members.", item.getJsNamespace());
        } else if (item.getJsNamespace().isEmpty()) {
            this.logError(item, "%s cannot have an empty namespace.", JsInteropRestrictionChecker.getDescription(item));
        } else if (!JsUtils.isValidJsQualifiedName(item.getJsNamespace())) {
            this.logError(item, "%s has invalid namespace '%s'.", JsInteropRestrictionChecker.getDescription(item), item.getJsNamespace());
        }
    }

    private void checkInstanceNameConsistency(Multimap<String, JMember> instanceMembersByJsName, JMember member) {
        this.checkOverrideConsistency(member);
        if (member.isJsNative()) {
            return;
        }
        String name = member.getJsName();
        LinkedHashSet<JMember> potentiallyCollidingMembers = Sets.newLinkedHashSet(instanceMembersByJsName.get(name));
        boolean removed = potentiallyCollidingMembers.remove(member);
        Preconditions.checkState(removed);
        Iterables.removeIf(potentiallyCollidingMembers, new Predicate<JMember>(){

            @Override
            public boolean apply(JMember member) {
                return member.isJsNative();
            }
        });
        if (potentiallyCollidingMembers.isEmpty()) {
            return;
        }
        JMember potentiallyCollidingMember = (JMember)potentiallyCollidingMembers.iterator().next();
        if (potentiallyCollidingMembers.size() == 1 && this.isJsPropertyAccessorPair(member, potentiallyCollidingMember)) {
            if (!this.checkPropertyConsistency(member, potentiallyCollidingMember)) {
                instanceMembersByJsName.get(name).remove(member);
            }
            return;
        }
        this.logError(member, "%s and %s cannot both use the same JavaScript name '%s'.", JsInteropRestrictionChecker.getMemberDescription(member), JsInteropRestrictionChecker.getMemberDescription(potentiallyCollidingMember), member.getJsName());
        instanceMembersByJsName.get(name).remove(member);
    }

    private boolean isJsPropertyAccessorPair(JMember thisMember, JMember thatMember) {
        return thisMember.getJsMemberType() == HasJsInfo.JsMemberType.GETTER && thatMember.getJsMemberType() == HasJsInfo.JsMemberType.SETTER || thatMember.getJsMemberType() == HasJsInfo.JsMemberType.GETTER && thisMember.getJsMemberType() == HasJsInfo.JsMemberType.SETTER;
    }

    private void checkStaticNameCollisions(JMember member) {
        if (member.isJsNative()) {
            return;
        }
        String currentGlobalNameDescription = this.minimalRebuildCache.addExportedGlobalName(member.getQualifiedJsName(), JjsUtils.getReadableDescription(member), member.getEnclosingType().getName());
        if (currentGlobalNameDescription == null) {
            return;
        }
        this.logError(member, "%s cannot be exported because the global name '%s' is already taken by '%s'.", JsInteropRestrictionChecker.getMemberDescription(member), member.getQualifiedJsName(), currentGlobalNameDescription);
    }

    private boolean checkPropertyConsistency(JMember member, JMember otherMember) {
        JMember getter;
        JMember setter = member.getJsMemberType() == HasJsInfo.JsMemberType.SETTER ? member : otherMember;
        JMember jMember = getter = member.getJsMemberType() == HasJsInfo.JsMemberType.GETTER ? member : otherMember;
        if (setter != null && getter != null) {
            List<JParameter> setterParams = ((JMethod)setter).getParams();
            if (this.isSameType(getter.getType(), setterParams.get(0).getType())) {
                this.logError(member, "JsProperty setter %s and getter %s cannot have inconsistent types.", JsInteropRestrictionChecker.getMemberDescription(setter), JsInteropRestrictionChecker.getMemberDescription(getter));
                return false;
            }
        }
        return true;
    }

    private boolean isSameType(JType thisType, JType thatType) {
        return !thisType.getJavahSignatureName().equals(thatType.getJavahSignatureName());
    }

    private void checkOverrideConsistency(JMember member) {
        if (member instanceof JMethod) {
            String jsName = member.getJsName();
            for (JMethod overridenMethod : ((JMethod)member).getOverriddenMethods()) {
                String parentName = overridenMethod.getJsName();
                if (parentName == null) continue;
                if (!parentName.equals(jsName)) {
                    this.logError(member, "%s cannot be assigned a different JavaScript name than the method it overrides.", JsInteropRestrictionChecker.getMemberDescription(member));
                    break;
                }
                if (overridenMethod.getJsMemberType() == member.getJsMemberType()) continue;
                this.logError(member, "%s %s cannot override %s %s.", member.getJsMemberType() == HasJsInfo.JsMemberType.METHOD ? "JsMethod" : "JsProperty", JsInteropRestrictionChecker.getMemberDescription(member), overridenMethod.getJsMemberType() == HasJsInfo.JsMemberType.METHOD ? "JsMethod" : "JsProperty", JsInteropRestrictionChecker.getMemberDescription(overridenMethod));
            }
        }
    }

    private void checkStaticJsPropertyCalls() {
        new JVisitor(){

            @Override
            public boolean visit(JMethod x, Context ctx) {
                return !JjsUtils.isJsMemberUnnecessaryAccidentalOverride(x);
            }

            @Override
            public void endVisit(JMethodCall x, Context ctx) {
                JMethod target = x.getTarget();
                if (x.isStaticDispatchOnly() && target.getJsMemberType().isPropertyAccessor()) {
                    JsInteropRestrictionChecker.this.logError(x, "Cannot call property accessor %s via super.", AbstractRestrictionChecker.getMemberDescription(target));
                }
            }
        }.accept(this.jprogram);
    }

    private void checkInstanceOfNativeJsTypesOrJsFunctionImplementations() {
        new JVisitor(){

            @Override
            public boolean visit(JInstanceOf x, Context ctx) {
                JReferenceType type = x.getTestType();
                if (type.isJsNative() && type instanceof JInterfaceType) {
                    JsInteropRestrictionChecker.this.logError(x, "Cannot do instanceof against native JsType interface '%s'.", JjsUtils.getReadableDescription(type));
                } else if (type.isJsFunctionImplementation()) {
                    JsInteropRestrictionChecker.this.logError(x, "Cannot do instanceof against JsFunction implementation '%s'.", JjsUtils.getReadableDescription(type));
                }
                return true;
            }
        }.accept(this.jprogram);
    }

    private boolean checkJsType(JDeclaredType type) {
        assert (type.getClassDisposition() != JDeclaredType.NestedClassDisposition.ANONYMOUS && type.getClassDisposition() != JDeclaredType.NestedClassDisposition.LAMBDA);
        if (type.getClassDisposition() == JDeclaredType.NestedClassDisposition.LOCAL) {
            this.logError("Local class '%s' cannot be a JsType.", type);
            return false;
        }
        return true;
    }

    private boolean checkNativeJsType(JDeclaredType type) {
        if (type.isEnumOrSubclass() != null) {
            this.logError("Enum '%s' cannot be a native JsType.", type);
            return false;
        }
        if (type.getClassDisposition() == JDeclaredType.NestedClassDisposition.INNER) {
            this.logError("Non static inner class '%s' cannot be a native JsType.", type);
            return false;
        }
        JClassType superClass = type.getSuperClass();
        if (superClass != null && superClass != this.jprogram.getTypeJavaLangObject() && !superClass.isJsNative()) {
            this.logError("Native JsType '%s' can only extend native JsType classes.", type);
        }
        for (JInterfaceType interfaceType : type.getImplements()) {
            if (interfaceType.isJsNative()) continue;
            this.logError(type, "Native JsType '%s' can only %s native JsType interfaces.", JsInteropRestrictionChecker.getDescription(type), type instanceof JInterfaceType ? "extend" : "implement");
        }
        if (!JsInteropRestrictionChecker.isInitEmpty(type)) {
            this.logError("Native JsType '%s' cannot have initializer.", type);
        }
        return true;
    }

    private void checkMemberOfJsFunction(JMember member) {
        if (member.getJsMemberType() != HasJsInfo.JsMemberType.NONE) {
            this.logError(member, "JsFunction interface member '%s' cannot be JsMethod nor JsProperty.", JjsUtils.getReadableDescription(member));
        }
        if (member.isJsOverlay() || member.isSynthetic()) {
            return;
        }
        if (member instanceof JMethod && ((JMethod)member).isOrOverridesJsFunctionMethod()) {
            return;
        }
        this.logError(member, "JsFunction interface '%s' cannot declare non-JsOverlay member '%s'.", JjsUtils.getReadableDescription(member.getEnclosingType()), JjsUtils.getReadableDescription(member));
    }

    private void checkJsFunction(JDeclaredType type) {
        if (type.getImplements().size() > 0) {
            this.logError("JsFunction '%s' cannot extend other interfaces.", type);
        }
        if (type.isJsType()) {
            this.logError("'%s' cannot be both a JsFunction and a JsType at the same time.", type);
            return;
        }
        for (JMember member : type.getMembers()) {
            this.checkMemberOfJsFunction(member);
        }
    }

    private void checkMemberOfJsFunctionImplementation(JMember member) {
        if (member.getJsMemberType() != HasJsInfo.JsMemberType.NONE) {
            this.logError(member, "JsFunction implementation member '%s' cannot be JsMethod nor JsProperty.", JjsUtils.getReadableDescription(member));
        }
        if (!(member instanceof JMethod)) {
            return;
        }
        JMethod method = (JMethod)member;
        if (method.isOrOverridesJsFunctionMethod() || method.isSynthetic() || method.getOverriddenMethods().isEmpty()) {
            return;
        }
        this.logError(method, "JsFunction implementation '%s' cannot implement method '%s'.", JjsUtils.getReadableDescription(member.getEnclosingType()), JjsUtils.getReadableDescription(method));
    }

    private void checkJsFunctionImplementation(JDeclaredType type) {
        if (!type.isFinal()) {
            this.logError("JsFunction implementation '%s' must be final.", type);
        }
        if (type.getImplements().size() != 1) {
            this.logError("JsFunction implementation '%s' cannot implement more than one interface.", type);
        }
        if (type.getSuperClass() != this.jprogram.getTypeJavaLangObject()) {
            this.logError("JsFunction implementation '%s' cannot extend a class.", type);
        }
        if (type.isJsType()) {
            this.logError("'%s' cannot be both a JsFunction implementation and a JsType at the same time.", type);
            return;
        }
        for (JMember member : type.getMembers()) {
            this.checkMemberOfJsFunctionImplementation(member);
        }
    }

    private void checkJsFunctionSubtype(JDeclaredType type) {
        for (JInterfaceType superInterface : type.getImplements()) {
            if (!superInterface.isJsFunction()) continue;
            this.logError(type, "'%s' cannot extend JsFunction '%s'.", JjsUtils.getReadableDescription(type), JjsUtils.getReadableDescription(superInterface));
        }
    }

    private boolean checkProgram(TreeLogger logger) {
        boolean hasErrors;
        for (JDeclaredType type : this.jprogram.getModuleDeclaredTypes()) {
            this.checkType(type);
        }
        this.checkStaticJsPropertyCalls();
        this.checkInstanceOfNativeJsTypesOrJsFunctionImplementations();
        this.checkSuperDispachToNativeJavaLangObjectMethodOverride();
        if (this.wasUnusableByJsWarningReported) {
            this.logSuggestion("Suppress \"[unusable-by-js]\" warnings by adding a `@SuppressWarnings(\"unusable-by-js\")` annotation to the corresponding member.", new Object[0]);
        }
        return !(hasErrors = this.reportErrorsAndWarnings(logger));
    }

    private boolean isJsConstructorSubtype(JDeclaredType type) {
        JClassType superClass = type.getSuperClass();
        if (superClass == null) {
            return false;
        }
        if (JjsUtils.getJsConstructor(superClass) != null) {
            return true;
        }
        return this.isJsConstructorSubtype(superClass);
    }

    private static boolean isSubclassOfNativeClass(JDeclaredType type) {
        return JjsUtils.getNativeSuperClassOrNull(type) != null;
    }

    private void checkJsNameOnType(JDeclaredType type) {
        if (!type.getJsName().equals("*") && !type.getJsName().equals("?")) {
            this.checkJsName(type);
            return;
        }
        if (!(type.isJsNative() && type instanceof JInterfaceType && JsInteropUtil.isGlobal(type.getJsNamespace()))) {
            this.logError(type, "'%s' can only be used as a name for native interfaces in the global namespace.", type.getJsName());
        }
    }

    private void checkType(JDeclaredType type) {
        this.minimalRebuildCache.removeExportedNames(type.getName());
        if (type.isJsType()) {
            if (!this.checkJsType(type)) {
                return;
            }
            this.checkJsNameOnType(type);
            this.checkJsNamespace(type);
        }
        if (type.isJsNative()) {
            if (!this.checkNativeJsType(type)) {
                return;
            }
        } else if (JsInteropRestrictionChecker.isSubclassOfNativeClass(type)) {
            this.checkSubclassOfNativeClass(type);
        }
        if (type.isJsFunction()) {
            this.checkJsFunction(type);
        } else if (type.isJsFunctionImplementation()) {
            this.checkJsFunctionImplementation(type);
        } else {
            this.checkJsFunctionSubtype(type);
            this.checkJsConstructors(type);
            this.checkJsConstructorSubtype(type);
        }
        Multimap<String, JMember> instanceJsNames = this.collectInstanceMembersByJsNames(type);
        for (JMember member : type.getMembers()) {
            this.checkMember(member, instanceJsNames);
        }
    }

    private void checkSubclassOfNativeClass(JDeclaredType type) {
        assert (type instanceof JClassType);
        for (JMethod method : type.getMethods()) {
            if (!this.overridesObjectMethod(method) || !method.isSynthetic()) continue;
            for (JMethod overridenMethod : method.getOverriddenMethods()) {
                if (!(overridenMethod.getEnclosingType() instanceof JInterfaceType) || overridenMethod.getJsMemberType() == HasJsInfo.JsMemberType.METHOD) continue;
                this.logError(type, "Native JsType subclass %s can not implement interface %s that declares method '%s' inherited from java.lang.Object.", JsInteropRestrictionChecker.getDescription(type), JsInteropRestrictionChecker.getDescription(overridenMethod.getEnclosingType()), overridenMethod.getName());
            }
        }
    }

    private void checkUnusableByJs(JMember member) {
        if (member instanceof JMethod) {
            JMethod method = (JMethod)member;
            if (method.isSynthetic() && !method.isSyntheticAccidentalOverride()) {
                return;
            }
            this.logIfUnusableByJs(member, "Return type of", member);
            for (JParameter parameter : method.getParams()) {
                String prefix = String.format("Type of parameter '%s' in", parameter.getName());
                this.logIfUnusableByJs(parameter, prefix, member);
            }
        } else {
            this.logIfUnusableByJs(member, "Type of", member);
        }
    }

    private <T extends HasType & CanHaveSuppressedWarnings> void logIfUnusableByJs(T hasType, String prefix, JMember x) {
        if (hasType.getType().canBeReferencedExternally()) {
            return;
        }
        if (this.isUnusableByJsSuppressed(x.getEnclosingType()) || this.isUnusableByJsSuppressed(x) || this.isUnusableByJsSuppressed(hasType)) {
            return;
        }
        this.logWarning(x, "[unusable-by-js] %s %s is not usable by but exposed to JavaScript.", prefix, JsInteropRestrictionChecker.getMemberDescription(x));
        this.wasUnusableByJsWarningReported = true;
    }

    private Multimap<String, JMember> collectInstanceMembersByJsNames(JDeclaredType type) {
        if (type == null) {
            return LinkedHashMultimap.create();
        }
        Multimap<String, JMember> instanceMembersByJsName = this.collectInstanceMembersByJsNames(type.getSuperClass());
        for (JMember member : type.getMembers()) {
            if (!this.isInstanceJsMember(member)) continue;
            JsInteropRestrictionChecker.addMember(instanceMembersByJsName, member);
        }
        return instanceMembersByJsName;
    }

    private static void addMember(Multimap<String, JMember> instanceMembersByJsName, final JMember member) {
        String name = member.getJsName();
        Iterables.removeIf(instanceMembersByJsName.get(name), new Predicate<JMember>(){

            @Override
            public boolean apply(JMember m) {
                return JsInteropRestrictionChecker.overrides(member, m);
            }
        });
        instanceMembersByJsName.put(name, member);
    }

    private boolean isInstanceJsMember(JMember method) {
        return method.needsDynamicDispatch() && method.getJsMemberType() != HasJsInfo.JsMemberType.NONE && !this.isSyntheticBridgeMethod(method);
    }

    private boolean isSyntheticBridgeMethod(JMember member) {
        if (!(member instanceof JMethod)) {
            return false;
        }
        return member.isSynthetic() && !((JMethod)member).isForwarding();
    }

    private boolean isStaticJsMember(JMember member) {
        return !member.needsDynamicDispatch() && member.getJsMemberType() != HasJsInfo.JsMemberType.NONE;
    }

    private static boolean overrides(JMember member, JMember potentiallyOverriddenMember) {
        if (member instanceof JField || potentiallyOverriddenMember instanceof JField) {
            return false;
        }
        JMethod method = (JMethod)member;
        if (method.getOverriddenMethods().contains(potentiallyOverriddenMember)) {
            return true;
        }
        JMethod potentiallyOverriddenMethod = (JMethod)potentiallyOverriddenMember;
        boolean visibilitiesMatchesForOverride = !method.isPackagePrivate() && !method.isPrivate() && !potentiallyOverriddenMethod.isPackagePrivate() && !potentiallyOverriddenMethod.isPrivate();
        return visibilitiesMatchesForOverride && method.getJsniSignature(false, false).equals(potentiallyOverriddenMethod.getJsniSignature(false, false));
    }

    private boolean isUnusableByJsSuppressed(CanHaveSuppressedWarnings x) {
        return x.getSuppressedWarnings() != null && x.getSuppressedWarnings().contains("unusable-by-js");
    }
}

