/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl;

import com.google.gwt.core.ext.soyc.Range;
import com.google.gwt.dev.jjs.JsSourceMap;
import com.google.gwt.dev.jjs.impl.JsAbstractTextTransformer;
import com.google.gwt.dev.util.editdistance.GeneralEditDistance;
import com.google.gwt.dev.util.editdistance.GeneralEditDistances;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.regex.Pattern;

public class JsFunctionClusterer
extends JsAbstractTextTransformer {
    private static final Pattern functionDeclarationPattern = Pattern.compile("function |[a-zA-Z][.$_a-zA-Z0-9]*=function");
    private static final int MAX_DISTANCE_LIMIT = 100;
    private static final int SEARCH_LIMIT = 10;
    private int numFunctions;
    private int[] reorderedIndices;

    private static boolean isFunctionDeclaration(String code) {
        return functionDeclarationPattern.matcher(code).lookingAt();
    }

    public JsFunctionClusterer(JsAbstractTextTransformer xformer) {
        super(xformer);
    }

    @Override
    public void exec() {
        LinkedList<Integer> functionIndices = new LinkedList<Integer>();
        for (int i = 0; i < this.statementRanges.numStatements(); ++i) {
            String code = this.getJsForRange(i);
            if (!JsFunctionClusterer.isFunctionDeclaration(code)) continue;
            functionIndices.add(i);
        }
        this.numFunctions = functionIndices.size();
        if (functionIndices.size() < 2) {
            return;
        }
        Collections.sort(functionIndices, new Comparator<Integer>(){

            @Override
            public int compare(Integer index1, Integer index2) {
                return JsFunctionClusterer.this.stmtSize(index1) - JsFunctionClusterer.this.stmtSize(index2);
            }
        });
        int[] clusteredIndices = new int[functionIndices.size()];
        int currentFunction = 0;
        clusteredIndices[currentFunction] = (Integer)functionIndices.get(0);
        functionIndices.remove(0);
        while (!functionIndices.isEmpty()) {
            String currentCode = this.getJsForRange(clusteredIndices[currentFunction]);
            GeneralEditDistance editDistance = GeneralEditDistances.getLevenshteinDistance(currentCode);
            int bestIndex = 0;
            int bestFunction = (Integer)functionIndices.getFirst();
            int bestDistance = 100;
            int count = 0;
            Iterator iterator = functionIndices.iterator();
            while (iterator.hasNext()) {
                int functionIndex = (Integer)iterator.next();
                if (count >= 10) break;
                String testCode = this.getJsForRange(functionIndex);
                int dist = editDistance.getDistance(testCode, bestDistance);
                if (dist < bestDistance) {
                    bestDistance = dist;
                    bestIndex = count;
                    bestFunction = functionIndex;
                }
                ++count;
            }
            clusteredIndices[++currentFunction] = bestFunction;
            functionIndices.remove(bestIndex);
        }
        this.reorderedIndices = Arrays.copyOf(clusteredIndices, this.statementRanges.numStatements());
        this.recomputeJsAndStatementRanges(clusteredIndices);
    }

    @Override
    protected void endStatements(StringBuilder newJs, ArrayList<Integer> starts, ArrayList<Integer> ends) {
        int j = this.numFunctions;
        for (int i = 0; i < this.statementRanges.numStatements(); ++i) {
            String code = this.getJsForRange(i);
            if (JsFunctionClusterer.isFunctionDeclaration(code)) continue;
            this.addStatement(j, code, newJs, starts, ends);
            this.reorderedIndices[j] = i;
            ++j;
        }
        super.endStatements(newJs, starts, ends);
    }

    @Override
    protected void updateSourceInfoMap() {
        if (this.sourceInfoMap != null) {
            HashMap<Range, Range> statementShifts = new HashMap<Range, Range>();
            for (int j = 0; j < this.statementRanges.numStatements(); ++j) {
                int permutedStart = this.statementRanges.start(j);
                int permutedEnd = this.statementRanges.end(j);
                int originalStart = this.originalStatementRanges.start(this.reorderedIndices[j]);
                int originalEnd = this.originalStatementRanges.end(this.reorderedIndices[j]);
                statementShifts.put(new Range(originalStart, originalEnd), new Range(permutedStart, permutedEnd));
            }
            Range[] oldStatementRanges = statementShifts.keySet().toArray(new Range[0]);
            Arrays.sort(oldStatementRanges, Range.SOURCE_ORDER_COMPARATOR);
            ArrayList<Range> oldExpressionRanges = Lists.newArrayList(this.sourceInfoMap.getRanges());
            Collections.sort(oldExpressionRanges, Range.SOURCE_ORDER_COMPARATOR);
            ArrayList<Range> updatedRanges = Lists.newArrayList();
            Range entireProgram = new Range(0, oldStatementRanges[oldStatementRanges.length - 1].getEnd());
            int i = 0;
            for (int j = 0; j < oldExpressionRanges.size(); ++j) {
                Range oldExpression = (Range)oldExpressionRanges.get(j);
                if (oldExpression.equals(entireProgram)) {
                    updatedRanges.add(oldExpression);
                    continue;
                }
                Range oldStatement = oldStatementRanges[i];
                Range newStatement = (Range)statementShifts.get(oldStatement);
                int shift = newStatement.getStart() - oldStatement.getStart();
                Range oldExpressionRange = (Range)oldExpressionRanges.get(j);
                Range newExpressionRange = new Range(oldExpressionRange.getStart() + shift, oldExpressionRange.getEnd() + shift, oldExpressionRange.getSourceInfo());
                updatedRanges.add(newExpressionRange);
            }
            this.sourceInfoMap = new JsSourceMap(updatedRanges, this.sourceInfoMap.getBytes(), this.sourceInfoMap.getLines());
        }
    }

    private int stmtSize(int index1) {
        return this.statementRanges.end(index1) - this.statementRanges.start(index1);
    }
}

