/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl;

import com.google.gwt.core.ext.linker.StatementRanges;
import com.google.gwt.core.ext.linker.impl.StandardStatementRanges;
import com.google.gwt.dev.jjs.JsSourceMap;
import java.util.ArrayList;

public abstract class JsAbstractTextTransformer {
    protected String js;
    protected StatementRanges originalStatementRanges;
    protected StatementRanges statementRanges;
    protected JsSourceMap sourceInfoMap;

    public JsAbstractTextTransformer(JsAbstractTextTransformer xformer) {
        this(xformer.getJs(), xformer.getStatementRanges(), xformer.getSourceInfoMap());
    }

    public JsAbstractTextTransformer(String js, StatementRanges statementRanges, JsSourceMap sourceInfoMap) {
        this.js = js;
        this.statementRanges = statementRanges;
        this.originalStatementRanges = statementRanges;
        this.sourceInfoMap = sourceInfoMap;
    }

    public abstract void exec();

    public String getJs() {
        return this.js;
    }

    public JsSourceMap getSourceInfoMap() {
        return this.sourceInfoMap;
    }

    public StatementRanges getStatementRanges() {
        return this.statementRanges;
    }

    protected void addStatement(int index, String code, StringBuilder newJs, ArrayList<Integer> starts, ArrayList<Integer> ends) {
        this.beginStatement(index, newJs, starts);
        newJs.append(code);
        this.endStatement(index, newJs, ends);
    }

    protected void beginStatement(int index, StringBuilder newJs, ArrayList<Integer> starts) {
        starts.add(newJs.length());
    }

    protected void beginStatements(StringBuilder newJs, ArrayList<Integer> starts, ArrayList<Integer> ends) {
    }

    protected void endStatement(int index, StringBuilder newJs, ArrayList<Integer> ends) {
        ends.add(newJs.length());
    }

    protected void endStatements(StringBuilder newJs, ArrayList<Integer> starts, ArrayList<Integer> ends) {
    }

    protected String getJsForRange(int stmtIndex) {
        return this.js.substring(this.statementRanges.start(stmtIndex), this.statementRanges.end(stmtIndex));
    }

    protected void recomputeJsAndStatementRanges(int[] stmtIndices) {
        StringBuilder newJs = new StringBuilder();
        ArrayList<Integer> starts = new ArrayList<Integer>();
        ArrayList<Integer> ends = new ArrayList<Integer>();
        this.beginStatements(newJs, starts, ends);
        for (int stmtIndex : stmtIndices) {
            String code = this.getJsForRange(stmtIndex);
            this.addStatement(stmtIndex, code, newJs, starts, ends);
        }
        this.endStatements(newJs, starts, ends);
        assert (starts.size() == ends.size()) : "Size mismatch between start and end statement ranges.";
        assert (starts.get(0) == 0 && ends.get(ends.size() - 1).intValue() == newJs.length()) : "statement ranges don't cover entire JS output string.";
        this.js = newJs.toString();
        this.statementRanges = new StandardStatementRanges(starts, ends);
        this.updateSourceInfoMap();
    }

    protected abstract void updateSourceInfoMap();
}

