/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl;

import com.google.gwt.dev.PrecompileTaskOptions;
import com.google.gwt.dev.jjs.SourceInfo;
import com.google.gwt.dev.jjs.SourceOrigin;
import com.google.gwt.dev.jjs.ast.HasJsInfo;
import com.google.gwt.dev.jjs.ast.HasName;
import com.google.gwt.dev.jjs.ast.HasType;
import com.google.gwt.dev.jjs.ast.JArrayType;
import com.google.gwt.dev.jjs.ast.JBinaryOperation;
import com.google.gwt.dev.jjs.ast.JBinaryOperator;
import com.google.gwt.dev.jjs.ast.JBlock;
import com.google.gwt.dev.jjs.ast.JBooleanLiteral;
import com.google.gwt.dev.jjs.ast.JCharLiteral;
import com.google.gwt.dev.jjs.ast.JClassType;
import com.google.gwt.dev.jjs.ast.JConstructor;
import com.google.gwt.dev.jjs.ast.JDeclaredType;
import com.google.gwt.dev.jjs.ast.JDoubleLiteral;
import com.google.gwt.dev.jjs.ast.JExpression;
import com.google.gwt.dev.jjs.ast.JExpressionStatement;
import com.google.gwt.dev.jjs.ast.JField;
import com.google.gwt.dev.jjs.ast.JFloatLiteral;
import com.google.gwt.dev.jjs.ast.JIntLiteral;
import com.google.gwt.dev.jjs.ast.JInterfaceType;
import com.google.gwt.dev.jjs.ast.JLiteral;
import com.google.gwt.dev.jjs.ast.JLongLiteral;
import com.google.gwt.dev.jjs.ast.JMember;
import com.google.gwt.dev.jjs.ast.JMethod;
import com.google.gwt.dev.jjs.ast.JMethodBody;
import com.google.gwt.dev.jjs.ast.JMethodCall;
import com.google.gwt.dev.jjs.ast.JNewInstance;
import com.google.gwt.dev.jjs.ast.JNullLiteral;
import com.google.gwt.dev.jjs.ast.JParameter;
import com.google.gwt.dev.jjs.ast.JPrimitiveType;
import com.google.gwt.dev.jjs.ast.JProgram;
import com.google.gwt.dev.jjs.ast.JReferenceType;
import com.google.gwt.dev.jjs.ast.JStatement;
import com.google.gwt.dev.jjs.ast.JStringLiteral;
import com.google.gwt.dev.jjs.ast.JThisRef;
import com.google.gwt.dev.jjs.ast.JType;
import com.google.gwt.dev.jjs.ast.js.JMultiExpression;
import com.google.gwt.dev.jjs.impl.JjsPredicates;
import com.google.gwt.dev.js.ast.JsBooleanLiteral;
import com.google.gwt.dev.js.ast.JsExpression;
import com.google.gwt.dev.js.ast.JsLiteral;
import com.google.gwt.dev.js.ast.JsNameRef;
import com.google.gwt.dev.js.ast.JsNullLiteral;
import com.google.gwt.dev.js.ast.JsNumberLiteral;
import com.google.gwt.dev.js.ast.JsObjectLiteral;
import com.google.gwt.dev.js.ast.JsStringLiteral;
import com.google.gwt.lang.LongLib;
import com.google.gwt.thirdparty.guava.common.base.Function;
import com.google.gwt.thirdparty.guava.common.base.Joiner;
import com.google.gwt.thirdparty.guava.common.base.Predicate;
import com.google.gwt.thirdparty.guava.common.base.Predicates;
import com.google.gwt.thirdparty.guava.common.base.Strings;
import com.google.gwt.thirdparty.guava.common.collect.Collections2;
import com.google.gwt.thirdparty.guava.common.collect.FluentIterable;
import com.google.gwt.thirdparty.guava.common.collect.ImmutableList;
import com.google.gwt.thirdparty.guava.common.collect.ImmutableMap;
import com.google.gwt.thirdparty.guava.common.collect.Iterables;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import com.google.gwt.thirdparty.guava.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JjsUtils {
    private static Map<Class<? extends JLiteral>, LiteralTranslators> translatorByLiteralClass = new ImmutableMap.Builder<Class<JBooleanLiteral>, LiteralTranslators>().put(JBooleanLiteral.class, LiteralTranslators.BOOLEAN_LITERAL_TRANSLATOR).put(JCharLiteral.class, LiteralTranslators.CHAR_LITERAL_TRANSLATOR).put(JFloatLiteral.class, LiteralTranslators.FLOAT_LITERAL_TRANSLATOR).put(JDoubleLiteral.class, LiteralTranslators.DOUBLE_LITERAL_TRANSLATOR).put(JIntLiteral.class, LiteralTranslators.INT_LITERAL_TRANSLATOR).put(JLongLiteral.class, LiteralTranslators.LONG_LITERAL_TRANSLATOR).put(JNullLiteral.class, LiteralTranslators.NULL_LITERAL_TRANSLATOR).put(JStringLiteral.class, LiteralTranslators.STRING_LITERAL_TRANSLATOR).build();

    public static boolean closureStyleLiteralsNeeded(PrecompileTaskOptions options) {
        return JjsUtils.closureStyleLiteralsNeeded(options.isIncrementalCompileEnabled(), options.isClosureCompilerFormatEnabled());
    }

    public static String classLiteralFieldNameFromJavahTypeSignatureName(String javahSignatureName) {
        return javahSignatureName + "_classLit";
    }

    public static boolean closureStyleLiteralsNeeded(boolean incremental, boolean closureOutputFormat) {
        return !incremental && closureOutputFormat;
    }

    public static String computeSignature(String name, List<JType> params, JType returnType, boolean isCtor) {
        StringBuilder sb = new StringBuilder(name);
        sb.append('(');
        for (JType type : params) {
            sb.append(type.getJsniSignatureName());
        }
        sb.append(')');
        if (!isCtor) {
            sb.append(returnType.getJsniSignatureName());
        } else {
            sb.append(" <init>");
        }
        return sb.toString();
    }

    public static String constructManglingSignature(JMethod x, String partialSignature) {
        StringBuilder sb = new StringBuilder(partialSignature);
        sb.append("__");
        for (int i = 0; i < x.getOriginalParamTypes().size(); ++i) {
            JType type = x.getOriginalParamTypes().get(i);
            sb.append(type.getJavahSignatureName());
        }
        sb.append(x.getOriginalReturnType().getJavahSignatureName());
        return sb.toString();
    }

    public static JExpression createDefaultConstructorInstantiation(SourceInfo info, JClassType type) {
        JConstructor noArgCtor = (JConstructor)FluentIterable.from(type.getMethods()).firstMatch(new Predicate<JMethod>(){

            @Override
            public boolean apply(JMethod method) {
                return method instanceof JConstructor && method.getOriginalParamTypes().size() == 0;
            }
        }).orNull();
        if (noArgCtor == null) {
            return null;
        }
        return new JNewInstance(info, noArgCtor);
    }

    public static JMethod createForwardingMethod(JDeclaredType type, JMethod methodToDelegateTo) {
        JMethod forwardingMethod = JjsUtils.createEmptyMethodFromExample(type, methodToDelegateTo, false);
        forwardingMethod.setForwarding();
        if (type.isJsNative()) {
            if (methodToDelegateTo.isJsNative()) {
                return forwardingMethod;
            }
            forwardingMethod.setJsOverlay();
            forwardingMethod.setBody(new JMethodBody(methodToDelegateTo.getSourceInfo()));
        }
        JMethodBody body = (JMethodBody)forwardingMethod.getBody();
        JMethodCall forwardingCall = new JMethodCall(methodToDelegateTo.getSourceInfo(), (JExpression)new JThisRef(methodToDelegateTo.getSourceInfo(), type), methodToDelegateTo, new JExpression[0]);
        forwardingCall.setStaticDispatchOnly();
        for (JParameter p : forwardingMethod.getParams()) {
            forwardingCall.addArg(p.makeRef(p.getSourceInfo()));
        }
        body.getBlock().addStmt(JjsUtils.makeMethodEndStatement(forwardingMethod.getType(), forwardingCall));
        return forwardingMethod;
    }

    public static JExpression createOptimizedMultiExpression(JExpression ... expressions) {
        return JjsUtils.createOptimizedMultiExpression(false, Arrays.asList(expressions));
    }

    public static JExpression createOptimizedMultiExpression(boolean ignoringResult, List<JExpression> expressions) {
        int numberOfExpressions = expressions.size();
        JExpression result = expressions.get(numberOfExpressions - 1);
        numberOfExpressions = expressions.size();
        if (numberOfExpressions == 0) {
            return new JMultiExpression((SourceInfo)SourceOrigin.UNKNOWN, new JExpression[0]);
        }
        expressions = Lists.newArrayList(Collections2.filter(expressions.subList(0, numberOfExpressions - 1), Predicates.and(Predicates.notNull(), new Predicate<JExpression>(){

            @Override
            public boolean apply(JExpression expression) {
                return expression.hasSideEffects();
            }
        })));
        if (result != null && (!ignoringResult || result.hasSideEffects())) {
            expressions.add(result);
        }
        if (expressions.size() == 1) {
            return expressions.iterator().next();
        }
        SourceOrigin info = expressions.size() > 0 ? expressions.get(0).getSourceInfo() : SourceOrigin.UNKNOWN;
        return new JMultiExpression((SourceInfo)info, expressions);
    }

    public static JExpression createOptimizedNotNullComparison(JProgram program, SourceInfo info, JExpression expression) {
        JReferenceType type = (JReferenceType)expression.getType();
        if (type.isNullType()) {
            return program.getLiteralBoolean(false);
        }
        if (!type.canBeNull()) {
            return JjsUtils.createOptimizedMultiExpression(expression, program.getLiteralBoolean(true));
        }
        return new JBinaryOperation(info, program.getTypePrimitiveBoolean(), JBinaryOperator.NEQ, expression, program.getLiteralNull());
    }

    public static String getIndexedName(JMember member) {
        return member.getEnclosingType().getShortName() + '.' + member.getName();
    }

    public static JMethod createSyntheticAbstractStub(JDeclaredType type, JMethod superTypeMethod) {
        assert (type.isAbstract());
        assert (superTypeMethod.isAbstract());
        return JjsUtils.createEmptyMethodFromExample(type, superTypeMethod, true);
    }

    public static JConstructor getJsNativeConstructorOrNull(JType type) {
        if (!type.isJsNative() || !(type.getUnderlyingType() instanceof JClassType)) {
            return null;
        }
        JMethod jsConstructor = Iterables.getFirst(Iterables.filter(((JClassType)type).getMethods(), JjsPredicates.IS_JS_CONSTRUCTOR), null);
        assert (jsConstructor != null);
        return (JConstructor)jsConstructor;
    }

    public static String getReadableDescription(JType type) {
        if (type instanceof JArrayType) {
            JArrayType arrayType = (JArrayType)type;
            return JjsUtils.getReadableDescription(arrayType.getLeafType()) + Strings.repeat("[]", arrayType.getDims());
        }
        return Joiner.on(".").join(type.getCompoundName());
    }

    public static String getReadableDescription(JMember member) {
        if (member instanceof JField) {
            return String.format("%s %s.%s", JjsUtils.getReadableDescription(member.getType()), JjsUtils.getReadableDescription(member.getEnclosingType()), member.getName());
        }
        JMethod method = (JMethod)member;
        String printableDescription = "";
        if (!method.isConstructor()) {
            printableDescription = printableDescription + JjsUtils.getReadableDescription(method.getType()) + " ";
        }
        printableDescription = printableDescription + String.format("%s.%s(%s)", JjsUtils.getReadableDescription(method.getEnclosingType()), method.getName(), Joiner.on(", ").join(Iterables.transform(method.getOriginalParamTypes(), new Function<JType, String>(){

            @Override
            public String apply(JType type) {
                return JjsUtils.getReadableDescription(type);
            }
        })));
        return printableDescription;
    }

    public static void replaceMethodBody(JMethod method, JExpression returnValue) {
        JMethodBody body = (JMethodBody)method.getBody();
        JBlock block = body.getBlock();
        block.clear();
        block.addStmt(returnValue.makeReturnStatement());
    }

    public static Iterable<JReferenceType> getExpressionTypes(Iterable<? extends HasType> nodes) {
        if (nodes == null) {
            return Collections.emptyList();
        }
        return FluentIterable.from(nodes).transform(new Function<HasType, JReferenceType>(){

            @Override
            public JReferenceType apply(HasType typedNode) {
                return (JReferenceType)typedNode.getType();
            }
        });
    }

    public static boolean isJsMemberUnnecessaryAccidentalOverride(JMethod method) {
        assert (!method.isSyntheticAccidentalOverride() || !method.exposesPackagePrivateMethod());
        if (!method.isSyntheticAccidentalOverride()) {
            return false;
        }
        boolean overridesConcreteJsMethod = Iterables.any(method.getOverriddenMethods(), new Predicate<JMethod>(){

            @Override
            public boolean apply(JMethod method) {
                return !method.isAbstract() && method.getJsMemberType() != HasJsInfo.JsMemberType.NONE;
            }
        });
        return overridesConcreteJsMethod && !method.exposesNonJsMember();
    }

    public static String javahSignatureFromName(String name) {
        return "L" + JjsUtils.mangledNameString(name) + "_2";
    }

    public static String mangleMemberName(String enclosingTypeName, String fieldName) {
        return JjsUtils.mangledNameString(enclosingTypeName) + '_' + JjsUtils.mangledNameString(fieldName);
    }

    public static String mangledNameString(HasName hasName) {
        return JjsUtils.mangledNameString(hasName.getName());
    }

    public static String mangledNameString(String name) {
        return name.replaceAll("_", "_1").replace('.', '_');
    }

    public static JStatement makeMethodEndStatement(JType returnType, JExpression expression) {
        return returnType == JPrimitiveType.VOID ? expression.makeStatement() : expression.makeReturnStatement();
    }

    public static JsLiteral translateLiteral(JLiteral literal) {
        return translatorByLiteralClass.get(literal.getClass()).translate(literal);
    }

    static void synthesizeStaticInitializerChain(JDeclaredType type, Iterable<JInterfaceType> superInterfacesRequiringStaticInitialization) {
        ArrayList<JExpressionStatement> superClinitCalls = Lists.newArrayList();
        SourceInfo sourceInfo = type.getSourceInfo();
        JClassType superClass = type.getSuperClass();
        if (superClass != null) {
            superClinitCalls.add(new JMethodCall(sourceInfo, null, superClass.getClinitMethod(), new JExpression[0]).makeStatement());
        }
        for (JInterfaceType interfaceType : superInterfacesRequiringStaticInitialization) {
            superClinitCalls.add(new JMethodCall(sourceInfo, null, interfaceType.getClinitMethod(), new JExpression[0]).makeStatement());
        }
        JMethodBody body = (JMethodBody)type.getClinitMethod().getBody();
        body.getBlock().getStatements().addAll(0, superClinitCalls);
    }

    public static boolean isEmptyBlock(JStatement stmt) {
        if (stmt == null) {
            return true;
        }
        return stmt instanceof JBlock && ((JBlock)stmt).getStatements().isEmpty();
    }

    private static void addPropertyToObject(SourceInfo sourceInfo, String propertyName, long propertyValue, JsObjectLiteral.Builder objectLiteralBuilder) {
        JsNumberLiteral value = new JsNumberLiteral(sourceInfo, propertyValue);
        objectLiteralBuilder.add(new JsNameRef(sourceInfo, propertyName), (JsExpression)value);
    }

    private static JMethod createEmptyMethodFromExample(JDeclaredType inType, JMethod exampleMethod, boolean isAbstract) {
        JMethod emptyMethod = new JMethod(exampleMethod.getSourceInfo(), exampleMethod.getName(), inType, exampleMethod.getType(), isAbstract, false, false, exampleMethod.getAccess());
        emptyMethod.addThrownExceptions(exampleMethod.getThrownExceptions());
        emptyMethod.setSynthetic();
        for (JParameter param : exampleMethod.getParams()) {
            emptyMethod.cloneParameter(param);
        }
        if (!inType.isJsNative()) {
            JMethodBody body = new JMethodBody(exampleMethod.getSourceInfo());
            emptyMethod.setBody(body);
        }
        emptyMethod.freezeParamTypes();
        inType.addMethod(emptyMethod);
        return emptyMethod;
    }

    public static JMethodCall getThisOrSuperConstructorCall(JStatement statement) {
        if (!(statement instanceof JExpressionStatement)) {
            return null;
        }
        JExpressionStatement expressionStatement = (JExpressionStatement)statement;
        if (!(expressionStatement.getExpr() instanceof JMethodCall) || expressionStatement.getExpr() instanceof JNewInstance) {
            return null;
        }
        JMethodCall call = (JMethodCall)expressionStatement.getExpr();
        if (call.getTarget() instanceof JConstructor && call.isStaticDispatchOnly()) {
            return call;
        }
        return null;
    }

    public static Set<JDeclaredType> getSupertypes(JDeclaredType type) {
        HashSet<JDeclaredType> superTypes = Sets.newHashSet();
        JjsUtils.addAllSuperTypes(type, superTypes);
        return superTypes;
    }

    public static void addAllSuperTypes(JDeclaredType type, Set<JDeclaredType> types) {
        if (type.getSuperClass() != null) {
            types.add(type.getSuperClass());
            JjsUtils.addAllSuperTypes(type.getSuperClass(), types);
        }
        for (JInterfaceType interfaceType : type.getImplements()) {
            types.add(interfaceType);
            JjsUtils.addAllSuperTypes(interfaceType, types);
        }
    }

    public static JConstructor getJsConstructor(JDeclaredType type) {
        return FluentIterable.from(type.getConstructors()).filter(new Predicate<JConstructor>(){

            @Override
            public boolean apply(JConstructor constructor) {
                return constructor.isJsConstructor();
            }
        }).first().orNull();
    }

    public static JConstructor getDelegatedThisOrSuperConstructor(JConstructor constructor) {
        JStatement contructorInvocaton = FluentIterable.from(constructor.getBody().getStatements()).filter(new Predicate<JStatement>(){

            @Override
            public boolean apply(JStatement statement) {
                return JjsUtils.getThisOrSuperConstructorCall(statement) != null;
            }
        }).first().orNull();
        return contructorInvocaton != null ? (JConstructor)JjsUtils.getThisOrSuperConstructorCall(contructorInvocaton).getTarget() : null;
    }

    public static JConstructor getPrimaryConstructor(final JDeclaredType type) {
        ImmutableList<JConstructor> delegatedSuperConstructors = FluentIterable.from(type.getConstructors()).filter(new Predicate<JConstructor>(){

            @Override
            public boolean apply(JConstructor constructor) {
                return JjsUtils.getDelegatedThisOrSuperConstructor(constructor).getEnclosingType() != type;
            }
        }).limit(2).toList();
        if (delegatedSuperConstructors.size() == 1) {
            return (JConstructor)delegatedSuperConstructors.get(0);
        }
        return null;
    }

    public static JClassType getNativeSuperClassOrNull(JDeclaredType type) {
        JClassType superClass = type.getSuperClass();
        if (superClass == null || superClass.isJsNative()) {
            return superClass;
        }
        return JjsUtils.getNativeSuperClassOrNull(superClass);
    }

    public static boolean requiresJsName(JMember member) {
        return member.getJsMemberType() != HasJsInfo.JsMemberType.NONE && (member.canBeImplementedExternally() || member.canBeReferencedExternally());
    }

    private JjsUtils() {
    }

    private static enum LiteralTranslators {
        BOOLEAN_LITERAL_TRANSLATOR{

            @Override
            JsLiteral translate(JExpression literal) {
                return JsBooleanLiteral.get(((JBooleanLiteral)literal).getValue());
            }
        }
        ,
        CHAR_LITERAL_TRANSLATOR{

            @Override
            JsLiteral translate(JExpression literal) {
                return new JsNumberLiteral(literal.getSourceInfo(), ((JCharLiteral)literal).getValue());
            }
        }
        ,
        FLOAT_LITERAL_TRANSLATOR{

            @Override
            JsLiteral translate(JExpression literal) {
                return new JsNumberLiteral(literal.getSourceInfo(), ((JFloatLiteral)literal).getValue());
            }
        }
        ,
        DOUBLE_LITERAL_TRANSLATOR{

            @Override
            JsLiteral translate(JExpression literal) {
                return new JsNumberLiteral(literal.getSourceInfo(), ((JDoubleLiteral)literal).getValue());
            }
        }
        ,
        INT_LITERAL_TRANSLATOR{

            @Override
            JsLiteral translate(JExpression literal) {
                return new JsNumberLiteral(literal.getSourceInfo(), ((JIntLiteral)literal).getValue());
            }
        }
        ,
        LONG_LITERAL_TRANSLATOR{

            @Override
            JsLiteral translate(JExpression literal) {
                SourceInfo sourceInfo = literal.getSourceInfo();
                long[] values = LongLib.getAsLongArray(((JLongLiteral)literal).getValue());
                if (values.length == 1) {
                    return new JsNumberLiteral(literal.getSourceInfo(), ((JLongLiteral)literal).getValue());
                }
                JsObjectLiteral.Builder objectLiteralBuilder = JsObjectLiteral.builder(sourceInfo).setInternable();
                assert (values.length == longComponentNames.length);
                for (int i = 0; i < longComponentNames.length; ++i) {
                    JjsUtils.addPropertyToObject(sourceInfo, longComponentNames[i], values[i], objectLiteralBuilder);
                }
                return objectLiteralBuilder.build();
            }
        }
        ,
        STRING_LITERAL_TRANSLATOR{

            @Override
            JsLiteral translate(JExpression literal) {
                return new JsStringLiteral(literal.getSourceInfo(), ((JStringLiteral)literal).getValue());
            }
        }
        ,
        NULL_LITERAL_TRANSLATOR{

            @Override
            JsLiteral translate(JExpression literal) {
                return JsNullLiteral.INSTANCE;
            }
        };

        private static String[] longComponentNames;

        abstract JsLiteral translate(JExpression var1);

        static {
            longComponentNames = new String[]{"l", "m", "h"};
        }
    }
}

