/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl;

import com.google.gwt.dev.jjs.ast.HasName;
import com.google.gwt.dev.jjs.ast.JClassType;
import com.google.gwt.dev.jjs.ast.JDeclaredType;
import com.google.gwt.dev.jjs.ast.JField;
import com.google.gwt.dev.jjs.ast.JMethod;
import com.google.gwt.dev.jjs.impl.JavaToJavaScriptMap;
import com.google.gwt.dev.js.ast.JsExprStmt;
import com.google.gwt.dev.js.ast.JsFunction;
import com.google.gwt.dev.js.ast.JsName;
import com.google.gwt.dev.js.ast.JsStatement;
import com.google.gwt.thirdparty.guava.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JavaToJavaScriptMapImpl
implements JavaToJavaScriptMap {
    private final Map<HasName, JsName> names;
    private final Map<JsName, JField> fieldForName;
    private final Map<JsName, JMethod> methodForName;
    private final Map<JsName, JClassType> typeForConstructorName;
    private final Map<JsStatement, JDeclaredType> typeForStatement;
    private final Map<JsStatement, JMethod> methodForStatement;

    public JavaToJavaScriptMapImpl(List<JDeclaredType> types, Map<HasName, JsName> names, Map<JsStatement, JDeclaredType> typeForStatement, Map<JsStatement, JMethod> methodForStatement) {
        HashMap<JsName, JMethod> methodsByJsName = Maps.newHashMap();
        HashMap<JsName, JField> staticFieldsByJsName = Maps.newHashMap();
        HashMap<JsName, JClassType> typesByContructorJsName = Maps.newHashMap();
        for (JDeclaredType type : types) {
            JsName typeName = names.get(type);
            if (type instanceof JClassType && typeName != null) {
                typesByContructorJsName.put(typeName, (JClassType)type);
            }
            for (JField field : type.getFields()) {
                JsName fieldName;
                if (!field.isStatic() || (fieldName = names.get(field)) == null) continue;
                staticFieldsByJsName.put(fieldName, field);
            }
            for (JMethod method : type.getMethods()) {
                JsName methodName = names.get(method);
                if (methodName == null) continue;
                methodsByJsName.put(methodName, method);
            }
        }
        this.names = names;
        this.fieldForName = staticFieldsByJsName;
        this.methodForName = methodsByJsName;
        this.typeForConstructorName = typesByContructorJsName;
        this.typeForStatement = typeForStatement;
        this.methodForStatement = methodForStatement;
    }

    @Override
    public JsName nameForField(JField field) {
        return this.names.get(field);
    }

    @Override
    public JsName nameForMethod(JMethod method) {
        return this.names.get(method);
    }

    @Override
    public JsName nameForType(JDeclaredType type) {
        return this.names.get(type);
    }

    @Override
    public JField nameToField(JsName name) {
        return this.fieldForName.get(name);
    }

    @Override
    public JMethod nameToMethod(JsName name) {
        return this.methodForName.get(name);
    }

    @Override
    public JClassType nameToType(JsName name) {
        return this.typeForConstructorName.get(name);
    }

    @Override
    public JDeclaredType typeForStatement(JsStatement statement) {
        return this.typeForStatement.get(statement);
    }

    @Override
    public JMethod methodForStatement(JsStatement statement) {
        JMethod method = this.methodForStatement.get(statement);
        if (JavaToJavaScriptMapImpl.class.desiredAssertionStatus() && method == null && statement instanceof JsExprStmt && ((JsExprStmt)statement).getExpression() instanceof JsFunction) {
            JsFunction function = (JsFunction)((JsExprStmt)statement).getExpression();
            assert (this.nameToMethod(function.getName()) == null);
        }
        return method;
    }
}

