/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl;

import com.google.gwt.dev.jjs.ast.Context;
import com.google.gwt.dev.jjs.ast.JClassType;
import com.google.gwt.dev.jjs.ast.JDeclaredType;
import com.google.gwt.dev.jjs.ast.JField;
import com.google.gwt.dev.jjs.ast.JFieldRef;
import com.google.gwt.dev.jjs.ast.JInterfaceType;
import com.google.gwt.dev.jjs.ast.JMethod;
import com.google.gwt.dev.jjs.ast.JMethodCall;
import com.google.gwt.dev.jjs.ast.JNode;
import com.google.gwt.dev.jjs.ast.JProgram;
import com.google.gwt.dev.jjs.ast.JThisRef;
import com.google.gwt.dev.jjs.ast.JVisitor;
import com.google.gwt.dev.jjs.ast.js.JsniFieldRef;
import com.google.gwt.dev.jjs.ast.js.JsniMethodRef;
import com.google.gwt.thirdparty.guava.common.collect.HashMultimap;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import com.google.gwt.thirdparty.guava.common.collect.Multimap;
import com.google.gwt.thirdparty.guava.common.collect.Sets;
import java.util.ArrayList;
import java.util.Set;

public class JavaAstVerifier
extends JVisitor {
    private Multimap<JDeclaredType, JNode> membersByType = HashMultimap.create();
    private Set<String> seenTypeNames = Sets.newHashSet();
    private Multimap<JDeclaredType, String> seenMethodsByType = HashMultimap.create();
    private Multimap<JDeclaredType, String> seenFieldsByType = HashMultimap.create();
    private JProgram program;
    JMethod currentMethod;

    JavaAstVerifier(JProgram program) {
        this.program = program;
        for (JDeclaredType type : program.getDeclaredTypes()) {
            this.membersByType.putAll(type, type.getMethods());
            this.membersByType.putAll(type, type.getFields());
        }
    }

    public static void assertProgramIsConsistent(JProgram program) {
        if (JavaAstVerifier.class.desiredAssertionStatus()) {
            new JavaAstVerifier(program).accept(program);
        }
    }

    public static void assertCorrectOverriddenOrder(JProgram program, JMethod method) {
        ArrayList<JMethod> seenMethods = Lists.newArrayList(method);
        JMethod lastMethod = method;
        for (JMethod overriden : method.getOverriddenMethods()) {
            for (JMethod seenMethod : seenMethods) {
                assert (!program.typeOracle.isSubType(seenMethod.getEnclosingType(), overriden.getEnclosingType())) : "Superclass method '" + seenMethod.getQualifiedName() + "' appeared before subclass method '" + overriden.getQualifiedName() + "' in '" + method.getQualifiedName() + "' overridden list";
            }
            assert (overriden.getEnclosingType() instanceof JInterfaceType || lastMethod.getEnclosingType() instanceof JClassType) : "Class method '" + overriden.getQualifiedName() + "' appeared before after interface method '" + lastMethod.getQualifiedName() + "' in '" + method.getQualifiedName() + "' overridden list";
        }
    }

    public static void assertCorrectOverridingOrder(JProgram program, JMethod method) {
        ArrayList<JMethod> seenMethods = Lists.newArrayList(method);
        for (JMethod overriden : method.getOverridingMethods()) {
            for (JMethod seenMethod : seenMethods) {
                assert (!program.typeOracle.isSubType(overriden.getEnclosingType(), seenMethod.getEnclosingType())) : "Subclass method '" + seenMethod.getQualifiedName() + "' appeared before superclass method '" + overriden.getQualifiedName() + "' in '" + method.getQualifiedName() + "' overriding list";
            }
        }
    }

    @Override
    public void endVisit(JClassType x, Context ctx) {
        this.assertNotSeenBefore(x);
        this.assertJsoCorrectness(x);
    }

    @Override
    public void endVisit(JField x, Context ctx) {
        JDeclaredType enclosingType = x.getEnclosingType();
        String fieldName = x.getName();
        assert (!this.seenFieldsByType.containsEntry(enclosingType, fieldName)) : "Field " + x + " is duplicated.";
        this.seenFieldsByType.put(enclosingType, fieldName);
    }

    @Override
    public void endVisit(JFieldRef x, Context ctx) {
        this.assertReferencedFieldIsInAst(x);
    }

    @Override
    public void endVisit(JInterfaceType x, Context ctx) {
        this.assertNotSeenBefore(x);
    }

    @Override
    public boolean visit(JMethod x, Context ctx) {
        assert (this.currentMethod == null);
        this.currentMethod = x;
        return true;
    }

    @Override
    public void endVisit(JMethod x, Context ctx) {
        JDeclaredType enclosingType = x.getEnclosingType();
        String methodSignature = x.getSignature();
        assert (!this.seenMethodsByType.containsEntry(enclosingType, methodSignature)) : "Method " + x + " is duplicated.";
        this.seenMethodsByType.put(enclosingType, methodSignature);
        JavaAstVerifier.assertCorrectOverriddenOrder(this.program, x);
        JavaAstVerifier.assertCorrectOverridingOrder(this.program, x);
        assert (this.currentMethod == x);
        this.currentMethod = null;
    }

    @Override
    public void endVisit(JMethodCall x, Context ctx) {
        this.assertCalledMethodIsInAst(x);
    }

    @Override
    public void endVisit(JThisRef x, Context ctx) {
        assert (!this.currentMethod.isStatic() || this.currentMethod.isConstructor()) : "JThisRef found in static method " + this.currentMethod;
    }

    @Override
    public void endVisit(JsniFieldRef x, Context ctx) {
        this.assertReferencedFieldIsInAst(x);
    }

    @Override
    public void endVisit(JsniMethodRef x, Context ctx) {
        this.assertCalledMethodIsInAst(x);
    }

    private void assertCalledMethodIsInAst(JMethodCall x) {
        if (x.getTarget() == JMethod.NULL_METHOD) {
            return;
        }
        assert (this.membersByType.containsEntry(x.getTarget().getEnclosingType(), x.getTarget())) : "Method " + x.getTarget() + " is called but is not part of the AST";
        JMethod staticImpl = this.program.getStaticImpl(x.getTarget());
        assert (staticImpl == null || this.membersByType.containsEntry(staticImpl.getEnclosingType(), staticImpl)) : "Method " + staticImpl + " is the static implementation of " + x.getTarget() + " but is not part of the AST";
    }

    private void assertReferencedFieldIsInAst(JFieldRef x) {
        if (x.getField() == JField.NULL_FIELD) {
            return;
        }
        assert (this.membersByType.containsEntry(x.getField().getEnclosingType(), x.getField())) : "Field " + x.getTarget() + " is referenced but is not part of the AST";
    }

    private void assertJsoCorrectness(JClassType x) {
        boolean isJSOorSubclassOfJSO = false;
        for (JClassType current = x; current != null; current = current.getSuperClass()) {
            if (!current.getName().equals("com.google.gwt.core.client.JavaScriptObject")) continue;
            isJSOorSubclassOfJSO = true;
            break;
        }
        assert (isJSOorSubclassOfJSO == x.isJsoType()) : x.isJsoType() ? "Type " + x.getName() + " is considered a Jso but is not subclass of " + "com.google.gwt.core.client.JavaScriptObject" : "Type " + x.getName() + " is subclass of " + "com.google.gwt.core.client.JavaScriptObject" + " but is not considered a Jso";
    }

    private void assertNotSeenBefore(JDeclaredType type) {
        assert (!this.seenTypeNames.contains(type.getName())) : "Found two types with same name " + type.getName();
        this.seenTypeNames.add(type.getName());
    }
}

