/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl;

import com.google.gwt.dev.jjs.ast.Context;
import com.google.gwt.dev.jjs.ast.JConstructor;
import com.google.gwt.dev.jjs.ast.JField;
import com.google.gwt.dev.jjs.ast.JMethod;
import com.google.gwt.dev.jjs.ast.JModVisitor;
import com.google.gwt.dev.jjs.ast.JProgram;
import com.google.gwt.dev.jjs.ast.JVariable;
import com.google.gwt.dev.jjs.impl.OptimizerContext;
import java.util.Collection;

public abstract class JChangeTrackingVisitor
extends JModVisitor {
    private JField currentField;
    private JMethod currentMethod;
    private final OptimizerContext optimizerCtx;
    private boolean fieldModified = false;
    private boolean methodModified = false;

    public JChangeTrackingVisitor(OptimizerContext optimizerCtx) {
        this.optimizerCtx = optimizerCtx;
    }

    @Override
    public final void endVisit(JConstructor x, Context ctx) {
        this.exit(x, ctx);
        if (this.methodModified) {
            this.optimizerCtx.markModified(x);
        }
        this.currentMethod = null;
    }

    @Override
    public final void endVisit(JField x, Context ctx) {
        this.exit(x, ctx);
        if (this.fieldModified) {
            this.optimizerCtx.markModified(x);
        }
        this.currentField = null;
    }

    @Override
    public final void endVisit(JMethod x, Context ctx) {
        this.exit(x, ctx);
        this.currentMethod = null;
        if (!this.methodModified) {
            return;
        }
        this.optimizerCtx.markModified(x);
        if (JProgram.isClinit(x) || JProgram.isInit(x)) {
            for (JField potentiallyModifiedField : x.getEnclosingType().getFields()) {
                if ((!potentiallyModifiedField.isStatic() || !JProgram.isClinit(x)) && (potentiallyModifiedField.isStatic() || JProgram.isClinit(x))) continue;
                this.optimizerCtx.markModified(potentiallyModifiedField);
            }
        }
    }

    @Override
    public final void endVisit(JVariable x, Context ctx) {
        this.exit(x, ctx);
    }

    public boolean enter(JConstructor x, Context ctx) {
        return this.enter((JMethod)x, ctx);
    }

    public boolean enter(JField x, Context ctx) {
        return this.enter((JVariable)x, ctx);
    }

    public boolean enter(JMethod x, Context ctx) {
        return true;
    }

    public boolean enter(JVariable x, Context ctx) {
        return true;
    }

    public void exit(JConstructor x, Context ctx) {
        this.exit((JMethod)x, ctx);
    }

    public void exit(JField x, Context ctx) {
        this.exit((JVariable)x, ctx);
    }

    public void exit(JMethod x, Context ctx) {
    }

    public void exit(JVariable x, Context ctx) {
    }

    public JField getCurrentField() {
        return this.currentField;
    }

    public JMethod getCurrentMethod() {
        return this.currentMethod;
    }

    @Override
    public final boolean visit(JConstructor x, Context ctx) {
        this.currentMethod = x;
        this.methodModified = false;
        return this.enter(x, ctx);
    }

    @Override
    public final boolean visit(JField x, Context ctx) {
        this.currentField = x;
        this.fieldModified = false;
        return this.enter(x, ctx);
    }

    @Override
    public final boolean visit(JMethod x, Context ctx) {
        this.currentMethod = x;
        this.methodModified = false;
        return this.enter(x, ctx);
    }

    @Override
    public final boolean visit(JVariable x, Context ctx) {
        return this.enter(x, ctx);
    }

    public final void wasRemoved(JField field) {
        this.optimizerCtx.remove(field);
    }

    public final void wasRemoved(JMethod method) {
        this.optimizerCtx.remove(method);
    }

    public final void methodsWereRemoved(Collection<JMethod> methods) {
        this.optimizerCtx.removeMethods(methods);
    }

    public final void fieldsWereRemoved(Collection<JField> fields) {
        this.optimizerCtx.removeFields(fields);
    }

    @Override
    protected final void madeChanges() {
        super.madeChanges();
        if (this.currentMethod != null) {
            this.methodModified = true;
        }
        if (this.currentField != null) {
            this.fieldModified = true;
        }
    }
}

