/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl;

import com.google.gwt.dev.jjs.SourceInfo;
import com.google.gwt.dev.jjs.ast.Context;
import com.google.gwt.dev.jjs.ast.JBinaryOperation;
import com.google.gwt.dev.jjs.ast.JBinaryOperator;
import com.google.gwt.dev.jjs.ast.JConditional;
import com.google.gwt.dev.jjs.ast.JDeclarationStatement;
import com.google.gwt.dev.jjs.ast.JExpression;
import com.google.gwt.dev.jjs.ast.JField;
import com.google.gwt.dev.jjs.ast.JMethod;
import com.google.gwt.dev.jjs.ast.JMethodCall;
import com.google.gwt.dev.jjs.ast.JNewArray;
import com.google.gwt.dev.jjs.ast.JParameter;
import com.google.gwt.dev.jjs.ast.JPrimitiveType;
import com.google.gwt.dev.jjs.ast.JProgram;
import com.google.gwt.dev.jjs.ast.JReferenceType;
import com.google.gwt.dev.jjs.ast.JReturnStatement;
import com.google.gwt.dev.jjs.ast.JThrowStatement;
import com.google.gwt.dev.jjs.ast.JType;
import com.google.gwt.dev.jjs.ast.JVisitor;
import com.google.gwt.dev.jjs.ast.js.JsniMethodRef;
import java.util.List;

public class ImplicitUpcastAnalyzer
extends JVisitor {
    protected JMethod currentMethod;
    private final JType javaScriptObjectType;
    private final JType throwableType;

    public ImplicitUpcastAnalyzer(JProgram program) {
        this.throwableType = program.getIndexedType("Throwable");
        this.javaScriptObjectType = program.getJavaScriptObject();
    }

    @Override
    public void endVisit(JBinaryOperation x, Context ctx) {
        if (x.isAssignment()) {
            this.processIfTypesNotEqual(x.getRhs().getType(), x.getLhs().getType(), x.getSourceInfo());
        } else if (x.getRhs().getType().isNullType()) {
            this.processIfTypesNotEqual(JReferenceType.NULL_TYPE, x.getLhs().getType(), x.getSourceInfo());
        } else if (x.getLhs().getType().isNullType()) {
            this.processIfTypesNotEqual(JReferenceType.NULL_TYPE, x.getRhs().getType(), x.getSourceInfo());
        } else if (x.getOp() == JBinaryOperator.CONCAT || x.getOp() == JBinaryOperator.EQ || x.getOp() == JBinaryOperator.NEQ) {
            this.processIfTypesNotEqual(x.getLhs().getType(), x.getRhs().getType(), x.getSourceInfo());
            this.processIfTypesNotEqual(x.getRhs().getType(), x.getLhs().getType(), x.getSourceInfo());
        }
    }

    @Override
    public void endVisit(JConditional x, Context ctx) {
        this.processIfTypesNotEqual(x.getThenExpr().getType(), x.getType(), x.getSourceInfo());
        this.processIfTypesNotEqual(x.getElseExpr().getType(), x.getType(), x.getSourceInfo());
    }

    @Override
    public void endVisit(JDeclarationStatement x, Context ctx) {
        if (x.getInitializer() != null) {
            this.processIfTypesNotEqual(x.getInitializer().getType(), x.getVariableRef().getType(), x.getSourceInfo());
        }
    }

    @Override
    public void endVisit(JField x, Context ctx) {
        if (x.getInitializer() == null && !x.isFinal() && !x.getType().isPrimitiveType()) {
            this.processIfTypesNotEqual(JReferenceType.NULL_TYPE, x.getType(), x.getSourceInfo());
        }
    }

    @Override
    public void endVisit(JMethod x, Context ctx) {
        for (JMethod overridden : x.getOverriddenMethods()) {
            this.processIfTypesNotEqual(x.getType(), overridden.getType(), x.getSourceInfo());
        }
        if (x.getBody() != null && x.getBody().isJsniMethodBody()) {
            List<JParameter> params = x.getParams();
            for (int i = 0; i < params.size(); ++i) {
                this.processIfTypesNotEqual(params.get(i).getType(), this.javaScriptObjectType, x.getSourceInfo());
            }
            if (x.getType() != JPrimitiveType.VOID) {
                this.processIfTypesNotEqual(this.javaScriptObjectType, x.getType(), x.getSourceInfo());
            }
        }
    }

    @Override
    public void endVisit(JMethodCall x, Context ctx) {
        List<JExpression> args = x.getArgs();
        List<JParameter> params = x.getTarget().getParams();
        for (int i = 0; i < args.size(); ++i) {
            if (i >= params.size()) continue;
            this.processIfTypesNotEqual(args.get(i).getType(), params.get(i).getType(), x.getSourceInfo());
        }
    }

    @Override
    public void endVisit(JNewArray x, Context ctx) {
        JType elementType = x.getArrayType().getElementType();
        if (x.getInitializers() != null) {
            for (JExpression init : x.getInitializers()) {
                this.processIfTypesNotEqual(init.getType(), elementType, x.getSourceInfo());
            }
        }
    }

    @Override
    public void endVisit(JReturnStatement x, Context ctx) {
        if (x.getExpr() != null) {
            this.processIfTypesNotEqual(x.getExpr().getType(), this.currentMethod.getType(), x.getSourceInfo());
        }
    }

    @Override
    public void endVisit(JsniMethodRef x, Context ctx) {
        if (x.getTarget().getType() != JPrimitiveType.VOID) {
            this.processIfTypesNotEqual(x.getTarget().getType(), this.javaScriptObjectType, x.getSourceInfo());
        }
        List<JParameter> params = x.getTarget().getParams();
        for (int i = 0; i < params.size(); ++i) {
            this.processIfTypesNotEqual(this.javaScriptObjectType, params.get(i).getType(), x.getSourceInfo());
        }
    }

    @Override
    public void endVisit(JThrowStatement x, Context ctx) {
        JType type = x.getExpr().getType().getUnderlyingType();
        this.processIfTypesNotEqual(type, this.throwableType, x.getSourceInfo());
    }

    @Override
    public boolean visit(JMethod x, Context ctx) {
        this.currentMethod = x;
        return true;
    }

    protected void processImplicitUpcast(JType fromType, JType destType, SourceInfo info) {
    }

    private void processIfTypesNotEqual(JType fromType, JType destType, SourceInfo info) {
        if ((fromType = fromType.getUnderlyingType()) != (destType = destType.getUnderlyingType())) {
            this.processImplicitUpcast(fromType, destType, info);
        }
    }
}

