/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl;

import com.google.gwt.dev.jjs.SourceInfo;
import com.google.gwt.dev.jjs.ast.JBinaryOperation;
import com.google.gwt.dev.jjs.ast.JBinaryOperator;
import com.google.gwt.dev.jjs.ast.JBooleanLiteral;
import com.google.gwt.dev.jjs.ast.JClassLiteral;
import com.google.gwt.dev.jjs.ast.JClassType;
import com.google.gwt.dev.jjs.ast.JDeclaredType;
import com.google.gwt.dev.jjs.ast.JExpression;
import com.google.gwt.dev.jjs.ast.JField;
import com.google.gwt.dev.jjs.ast.JFieldRef;
import com.google.gwt.dev.jjs.ast.JIfStatement;
import com.google.gwt.dev.jjs.ast.JIntLiteral;
import com.google.gwt.dev.jjs.ast.JLocal;
import com.google.gwt.dev.jjs.ast.JMethod;
import com.google.gwt.dev.jjs.ast.JMethodBody;
import com.google.gwt.dev.jjs.ast.JMethodCall;
import com.google.gwt.dev.jjs.ast.JNewArray;
import com.google.gwt.dev.jjs.ast.JNullLiteral;
import com.google.gwt.dev.jjs.ast.JParameter;
import com.google.gwt.dev.jjs.ast.JPrimitiveType;
import com.google.gwt.dev.jjs.ast.JProgram;
import com.google.gwt.dev.jjs.ast.JRecordType;
import com.google.gwt.dev.jjs.ast.JStringLiteral;
import com.google.gwt.dev.jjs.ast.JThisRef;
import com.google.gwt.dev.jjs.ast.JUnsafeTypeCoercion;
import com.google.gwt.dev.jjs.impl.AutoboxUtils;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class ImplementRecordComponents {
    private final JProgram program;
    private final AutoboxUtils autoboxUtils;
    private final JMethod getClassMethod;
    private final JMethod getSimpleNameMethod;
    private final JClassType javaLangString;

    public static void exec(JProgram program) {
        new ImplementRecordComponents(program).execImpl();
    }

    private ImplementRecordComponents(JProgram program) {
        this.program = program;
        this.autoboxUtils = new AutoboxUtils(program);
        this.getClassMethod = program.getIndexedMethod("Object.getClass");
        this.getSimpleNameMethod = program.getIndexedMethod("Class.getSimpleName");
        this.javaLangString = program.getTypeJavaLangString();
    }

    private void execImpl() {
        for (JDeclaredType type : this.program.getDeclaredTypes()) {
            if (!(type instanceof JRecordType)) continue;
            this.implementRecordComponents((JRecordType)type);
        }
    }

    private void implementRecordComponents(JRecordType type) {
        SourceInfo info = type.getSourceInfo();
        for (JMethod method : type.getMethods()) {
            if (method.getBody() != null) continue;
            if (method.getName().equals("toString") && method.getParams().isEmpty()) {
                this.implementToString(type, method, info);
                continue;
            }
            if (method.getName().equals("equals") && method.getParams().size() == 1 && method.getParams().get(0).getType().equals(this.program.getTypeJavaLangObject())) {
                this.implementEquals(type, method, info);
                continue;
            }
            if (method.getName().equals("hashCode") && method.getParams().isEmpty()) {
                this.implementHashCode(type, method, info);
                continue;
            }
            if (!method.getParams().isEmpty()) continue;
            Optional<JField> matchingField = type.getFields().stream().filter(f -> f.getName().equals(method.getName())).filter(f -> f.getType().equals(method.getType())).findFirst();
            matchingField.ifPresent(f -> ImplementRecordComponents.implementComponentAccessor(type, method, f));
        }
    }

    private static void implementComponentAccessor(JRecordType type, JMethod method, JField field) {
        SourceInfo info = field.getSourceInfo();
        JFieldRef fieldReference = new JFieldRef(info, new JThisRef(info, type), field, type);
        JMethodBody body = new JMethodBody(info);
        body.getBlock().addStmt(fieldReference.makeReturnStatement());
        method.setBody(body);
    }

    private void implementHashCode(JRecordType type, JMethod method, SourceInfo info) {
        JExpression hashcodeStatement;
        if (type.getFields().isEmpty()) {
            hashcodeStatement = new JIntLiteral(info, 0);
        } else {
            ArrayList<JExpression> exprs = Lists.newArrayListWithCapacity(type.getFields().size());
            for (JField field : type.getFields()) {
                JFieldRef jFieldRef = new JFieldRef(info, new JThisRef(info, type), field, type);
                if (jFieldRef.getType().isPrimitiveType()) {
                    exprs.add(this.autoboxUtils.box(jFieldRef, (JPrimitiveType)jFieldRef.getType()));
                    continue;
                }
                exprs.add(jFieldRef);
            }
            JNewArray varargsWrapper = JNewArray.createArrayWithInitializers(info, this.program.getTypeJavaLangObjectArray(), exprs);
            JMethod hash = this.program.getIndexedMethod("Objects.hash");
            hashcodeStatement = new JMethodCall(info, null, hash, varargsWrapper);
        }
        JMethodBody body = new JMethodBody(info);
        body.getBlock().addStmt(hashcodeStatement.makeReturnStatement());
        method.setBody(body);
    }

    private void implementEquals(JRecordType type, JMethod method, SourceInfo info) {
        JMethodBody body = new JMethodBody(info);
        JParameter otherParam = method.getParams().get(0);
        JBinaryOperation eq = new JBinaryOperation(info, JPrimitiveType.BOOLEAN, JBinaryOperator.EQ, new JThisRef(info, type), otherParam.createRef(info));
        body.getBlock().addStmt(new JIfStatement(info, eq, JBooleanLiteral.TRUE.makeReturnStatement(), null));
        JBinaryOperation nonNullCheck = new JBinaryOperation(info, JPrimitiveType.BOOLEAN, JBinaryOperator.EQ, otherParam.createRef(info), JNullLiteral.INSTANCE);
        JBinaryOperation sameTypeCheck = new JBinaryOperation(info, JPrimitiveType.BOOLEAN, JBinaryOperator.NEQ, new JClassLiteral(info, type), new JMethodCall(info, (JExpression)otherParam.createRef(info), this.getClassMethod, new JExpression[0]));
        JBinaryOperation nullAndTypeCheck = new JBinaryOperation(info, JPrimitiveType.BOOLEAN, JBinaryOperator.OR, nonNullCheck, sameTypeCheck);
        body.getBlock().addStmt(new JIfStatement(info, nullAndTypeCheck, JBooleanLiteral.FALSE.makeReturnStatement(), null));
        JLocal typedOther = JProgram.createLocal(info, "other", type, true, body);
        JUnsafeTypeCoercion uncheckedCast = new JUnsafeTypeCoercion(info, type, otherParam.createRef(info));
        JBinaryOperation uncheckedAssign = new JBinaryOperation(info, type, JBinaryOperator.ASG, typedOther.createRef(info), uncheckedCast);
        body.getBlock().addStmt(uncheckedAssign.makeStatement());
        JExpression componentCheck = JBooleanLiteral.TRUE;
        JMethod objectEquals = this.program.getIndexedMethod("Object.equals");
        for (JField field : type.getFields()) {
            JBinaryOperation equals;
            if (field.isStatic()) continue;
            JFieldRef myField = new JFieldRef(info, new JThisRef(info, type), field, type);
            JFieldRef otherField = new JFieldRef(info, typedOther.createRef(info), field, type);
            if (field.getType().isPrimitiveType()) {
                equals = new JBinaryOperation(info, JPrimitiveType.BOOLEAN, JBinaryOperator.EQ, myField, otherField);
            } else {
                JFieldRef myField2 = new JFieldRef(info, new JThisRef(info, type), field, type);
                equals = new JBinaryOperation(info, JPrimitiveType.BOOLEAN, JBinaryOperator.AND, new JBinaryOperation(info, JPrimitiveType.BOOLEAN, JBinaryOperator.NEQ, myField, JNullLiteral.INSTANCE), new JMethodCall(info, (JExpression)myField2, objectEquals, otherField));
            }
            if (componentCheck != JBooleanLiteral.TRUE) {
                componentCheck = new JBinaryOperation(info, JPrimitiveType.BOOLEAN, JBinaryOperator.AND, componentCheck, equals);
                continue;
            }
            componentCheck = equals;
        }
        body.getBlock().addStmt(componentCheck.makeReturnStatement());
        method.setBody(body);
    }

    private void implementToString(JRecordType type, JMethod method, SourceInfo info) {
        ArrayList<JExpression> args = new ArrayList<JExpression>();
        JMethodCall getClass = new JMethodCall(info, (JExpression)new JThisRef(info, type), this.getClassMethod, new JExpression[0]);
        JExpression toStrExpr = new JMethodCall(info, (JExpression)getClass, this.getSimpleNameMethod, new JExpression[0]);
        args.add(new JStringLiteral(info, "[", this.javaLangString));
        List<JField> fields = type.getFields();
        for (int i = 0; i < fields.size(); ++i) {
            if (i != 0) {
                args.add(new JStringLiteral(info, ", ", this.javaLangString));
            }
            JField field = fields.get(i);
            args.add(new JStringLiteral(info, field.getName() + "=", this.javaLangString));
            args.add(new JFieldRef(info, new JThisRef(info, type), field, type));
        }
        args.add(new JStringLiteral(info, "]", this.javaLangString));
        for (JExpression arg : args) {
            toStrExpr = new JBinaryOperation(info, this.javaLangString, JBinaryOperator.CONCAT, toStrExpr, arg);
        }
        JMethodBody body = new JMethodBody(info);
        body.getBlock().addStmt(toStrExpr.makeReturnStatement());
        method.setBody(body);
    }
}

