/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl;

import com.google.gwt.dev.jjs.SourceInfo;
import com.google.gwt.dev.jjs.ast.Context;
import com.google.gwt.dev.jjs.ast.JArrayLength;
import com.google.gwt.dev.jjs.ast.JArrayRef;
import com.google.gwt.dev.jjs.ast.JArrayType;
import com.google.gwt.dev.jjs.ast.JBinaryOperation;
import com.google.gwt.dev.jjs.ast.JBinaryOperator;
import com.google.gwt.dev.jjs.ast.JBlock;
import com.google.gwt.dev.jjs.ast.JDeclarationStatement;
import com.google.gwt.dev.jjs.ast.JExpression;
import com.google.gwt.dev.jjs.ast.JForStatement;
import com.google.gwt.dev.jjs.ast.JIntLiteral;
import com.google.gwt.dev.jjs.ast.JLocal;
import com.google.gwt.dev.jjs.ast.JMethod;
import com.google.gwt.dev.jjs.ast.JMethodBody;
import com.google.gwt.dev.jjs.ast.JMethodCall;
import com.google.gwt.dev.jjs.ast.JModVisitor;
import com.google.gwt.dev.jjs.ast.JNewArray;
import com.google.gwt.dev.jjs.ast.JParameter;
import com.google.gwt.dev.jjs.ast.JParameterRef;
import com.google.gwt.dev.jjs.ast.JPostfixOperation;
import com.google.gwt.dev.jjs.ast.JPrimitiveType;
import com.google.gwt.dev.jjs.ast.JProgram;
import com.google.gwt.dev.jjs.ast.JStatement;
import com.google.gwt.dev.jjs.ast.JUnaryOperation;
import com.google.gwt.dev.jjs.ast.JUnaryOperator;
import com.google.gwt.dev.jjs.ast.JVariableRef;
import com.google.gwt.dev.jjs.ast.JVisitor;
import com.google.gwt.dev.jjs.impl.ArrayNormalizer;
import com.google.gwt.dev.jjs.impl.CloneExpressionVisitor;
import com.google.gwt.dev.jjs.impl.JjsUtils;
import com.google.gwt.thirdparty.guava.common.collect.Iterables;
import java.util.Collections;

public class ImplementJsVarargs {
    private final JProgram program;

    private VarargsProcessingResult needsVarargsProcessing(JMethod method) {
        NeedsArgumentsCopyAnalyzer analyzer = new NeedsArgumentsCopyAnalyzer(method);
        analyzer.accept(method);
        return analyzer.result;
    }

    public static void exec(JProgram program) {
        new ImplementJsVarargs(program).execImpl();
    }

    private ImplementJsVarargs(JProgram program) {
        this.program = program;
    }

    private void execImpl() {
        new VarargsMethodNormalizer().accept(this.program);
        new VarargsCallsNormalizer().accept(this.program);
    }

    private class VarargsCallsNormalizer
    extends JModVisitor {
        private JMethodBody currentMethodBody;

        private VarargsCallsNormalizer() {
        }

        @Override
        public boolean visit(JMethodBody x, Context ctx) {
            this.currentMethodBody = x;
            return true;
        }

        @Override
        public void endVisit(JMethodBody x, Context ctx) {
            this.currentMethodBody = null;
        }

        @Override
        public void endVisit(JMethodCall x, Context ctx) {
            JNewArray varargArray;
            JMethod method = x.getTarget();
            if (!method.isJsMethodVarargs()) {
                return;
            }
            int varargIndex = method.getParams().size() - 1;
            JExpression varargArgument = x.getArgs().get(varargIndex);
            if (varargArgument instanceof JNewArray && (varargArray = (JNewArray)varargArgument).getInitializers() != null) {
                x.setArg(varargIndex, ArrayNormalizer.getInitializerArray(varargArray));
                this.madeChanges();
                return;
            }
            SourceInfo varargsArgumentsourceInfo = varargArgument.getSourceInfo();
            if (varargArgument.getType().canBeNull()) {
                x.setArg(varargIndex, new JMethodCall(varargsArgumentsourceInfo, null, ImplementJsVarargs.this.program.getIndexedMethod("Array.ensureNotNull"), varargArgument));
            }
            JExpression instance = x.getInstance();
            if (x.getTarget().needsDynamicDispatch() && !x.isStaticDispatchOnly() && instance != null && (!(instance instanceof JVariableRef) || instance.hasSideEffects())) {
                SourceInfo sourceInfo = x.getSourceInfo();
                JLocal tempInstance = JProgram.createLocal(sourceInfo, "$instance", instance.getType(), false, this.currentMethodBody);
                ctx.replaceMe(JjsUtils.createOptimizedMultiExpression(new JBinaryOperation(sourceInfo, instance.getType(), JBinaryOperator.ASG, tempInstance.createRef(sourceInfo), instance), new JMethodCall(x, (JExpression)tempInstance.createRef(sourceInfo), x.getArgs())));
            }
        }
    }

    private class VarargsMethodNormalizer
    extends JModVisitor {
        private JParameter varargsParameter;
        private int varargsIndex;
        private VarargsReplacer replacer;
        private JLocal argumentsCopyVariable;

        private VarargsMethodNormalizer() {
        }

        private boolean needsVarArgsPrologue(JMethod x) {
            return x.isJsNative() || !x.isJsMethodVarargs();
        }

        @Override
        public boolean visit(JMethod x, Context ctx) {
            if (this.needsVarArgsPrologue(x)) {
                return false;
            }
            this.varargsParameter = Iterables.getLast(x.getParams());
            this.varargsIndex = x.getParams().size() - 1;
            this.varargsParameter.setType(this.varargsParameter.getType().strengthenToNonNull());
            this.argumentsCopyVariable = null;
            switch (ImplementJsVarargs.this.needsVarargsProcessing(x)) {
                case GENERAL_ACCESS: {
                    this.argumentsCopyVariable = JProgram.createLocal(this.varargsParameter.getSourceInfo(), this.varargsParameter.getName(), this.varargsParameter.getType(), false, (JMethodBody)x.getBody());
                    this.replacer = new ReplaceVarargsVariable(this.argumentsCopyVariable);
                    return true;
                }
                case OFFSET_ACCESS: {
                    this.replacer = new ReindexAccess(this.varargsIndex);
                    return true;
                }
            }
            return false;
        }

        @Override
        public void endVisit(JParameterRef x, Context ctx) {
            if (x.getTarget() == this.varargsParameter) {
                this.maybeReplace(x, this.replacer.replace(x), ctx);
            }
        }

        @Override
        public void endVisit(JArrayRef x, Context ctx) {
            if (x.getInstance() instanceof JParameterRef && ((JParameterRef)x.getInstance()).getTarget() == this.varargsParameter) {
                this.maybeReplace(x, this.replacer.replace(x), ctx);
            }
        }

        @Override
        public void endVisit(JArrayLength x, Context ctx) {
            if (x.getInstance() instanceof JParameterRef && ((JParameterRef)x.getInstance()).getTarget() == this.varargsParameter) {
                this.maybeReplace(x, this.replacer.replace(x), ctx);
            }
        }

        @Override
        public void endVisit(JMethod x, Context ctx) {
            if (this.needsVarArgsPrologue(x)) {
                return;
            }
            this.varargsParameter.setName("_arguments_");
        }

        private void maybeReplace(JExpression x, JExpression replacement, Context ctx) {
            if (replacement != x) {
                ctx.replaceMe(replacement);
            }
        }

        @Override
        public void endVisit(JMethodBody x, Context ctx) {
            if (this.argumentsCopyVariable == null) {
                return;
            }
            SourceInfo sourceInfo = this.varargsParameter.getSourceInfo();
            JBlock preamble = new JBlock(sourceInfo, new JStatement[0]);
            JArrayType varargsArrayType = (JArrayType)this.varargsParameter.getType().getUnderlyingType();
            JExpression lengthMinusVarargsIndex = this.varargsIndex == 0 ? new JArrayLength(sourceInfo, this.varargsParameter.createRef(sourceInfo)) : new JBinaryOperation(sourceInfo, JPrimitiveType.INT, JBinaryOperator.SUB, new JArrayLength(sourceInfo, this.varargsParameter.createRef(sourceInfo)), new JIntLiteral(sourceInfo, this.varargsIndex));
            JNewArray arrayVariable = JNewArray.createArrayWithDimensionExpressions(sourceInfo, varargsArrayType, Collections.singletonList(lengthMinusVarargsIndex));
            arrayVariable.getLeafTypeClassLiteral().setField(ImplementJsVarargs.this.program.getClassLiteralField(varargsArrayType.getLeafType()));
            preamble.addStmt(new JDeclarationStatement(sourceInfo, this.argumentsCopyVariable.createRef(sourceInfo), arrayVariable));
            JLocal index = JProgram.createLocal(sourceInfo, "$i", JPrimitiveType.INT, false, x);
            JExpression iPlusVarargsIndex = this.varargsIndex == 0 ? index.createRef(sourceInfo) : new JBinaryOperation(sourceInfo, JPrimitiveType.INT, JBinaryOperator.ADD, index.createRef(sourceInfo), new JIntLiteral(sourceInfo, this.varargsIndex));
            JBlock block = new JBlock(sourceInfo, new JStatement[0]);
            block.addStmt(new JBinaryOperation(sourceInfo, varargsArrayType.getElementType(), JBinaryOperator.ASG, new JArrayRef(sourceInfo, this.replacer.replace(this.varargsParameter.createRef(sourceInfo)), index.createRef(sourceInfo)), new JArrayRef(sourceInfo, this.varargsParameter.createRef(sourceInfo), iPlusVarargsIndex)).makeStatement());
            preamble.addStmt(new JForStatement(sourceInfo, Collections.singletonList(new JDeclarationStatement(sourceInfo, index.createRef(sourceInfo), JIntLiteral.ZERO)), new JBinaryOperation(sourceInfo, JPrimitiveType.INT, JBinaryOperator.LT, index.createRef(sourceInfo), new CloneExpressionVisitor().cloneExpression(lengthMinusVarargsIndex)), new JPostfixOperation(sourceInfo, JUnaryOperator.INC, index.createRef(sourceInfo)), block));
            x.getStatements().add(0, preamble);
        }
    }

    private class ReindexAccess
    extends VarargsReplacer {
        private int varargsIndex;

        ReindexAccess(int varargsIndex) {
            this.varargsIndex = varargsIndex;
        }

        @Override
        public JExpression replace(JParameterRef expression) {
            return expression;
        }

        @Override
        JExpression replace(JArrayRef expression) {
            SourceInfo sourceInfo = expression.getSourceInfo();
            return new JArrayRef(expression.getSourceInfo(), expression.getInstance(), new JBinaryOperation(sourceInfo, JPrimitiveType.INT, JBinaryOperator.ADD, expression.getIndexExpr(), new JIntLiteral(sourceInfo, this.varargsIndex)));
        }

        @Override
        JExpression replace(JArrayLength expression) {
            SourceInfo sourceInfo = expression.getSourceInfo();
            return new JBinaryOperation(sourceInfo, JPrimitiveType.INT, JBinaryOperator.SUB, expression, new JIntLiteral(sourceInfo, this.varargsIndex));
        }
    }

    private class ReplaceVarargsVariable
    extends VarargsReplacer {
        private JLocal localVariable;

        ReplaceVarargsVariable(JLocal localVariable) {
            this.localVariable = localVariable;
        }

        @Override
        public JExpression replace(JParameterRef expression) {
            return this.localVariable.createRef(expression.getSourceInfo());
        }
    }

    private abstract class VarargsReplacer {
        private VarargsReplacer() {
        }

        abstract JExpression replace(JParameterRef var1);

        JExpression replace(JArrayRef expression) {
            return new JArrayRef(expression.getSourceInfo(), this.replace((JParameterRef)expression.getInstance()), expression.getIndexExpr());
        }

        JExpression replace(JArrayLength expression) {
            return new JArrayLength(expression.getSourceInfo(), this.replace((JParameterRef)expression.getInstance()));
        }
    }

    private static enum VarargsProcessingResult {
        SIMPLE_ACCESS,
        PASS_WHOLE,
        OFFSET_ACCESS,
        GENERAL_ACCESS;


        private static VarargsProcessingResult join(VarargsProcessingResult thisResult, VarargsProcessingResult thatResult) {
            if (thisResult.ordinal() > thatResult.ordinal()) {
                VarargsProcessingResult swap = thisResult;
                thisResult = thatResult;
                thatResult = swap;
            }
            if (thisResult == PASS_WHOLE && thatResult == OFFSET_ACCESS) {
                return GENERAL_ACCESS;
            }
            return thatResult;
        }
    }

    private class NeedsArgumentsCopyAnalyzer
    extends JVisitor {
        private VarargsProcessingResult result = VarargsProcessingResult.SIMPLE_ACCESS;
        private JParameter varargsParameter;
        private int varargsParameterIndex;

        private NeedsArgumentsCopyAnalyzer(JMethod method) {
            assert (method.isJsMethodVarargs());
            this.varargsParameter = Iterables.getLast(method.getParams());
            this.varargsParameterIndex = method.getParams().size() - 1;
            if (this.varargsParameterIndex != 0) {
                this.upgradeResult(VarargsProcessingResult.OFFSET_ACCESS);
            }
        }

        @Override
        public void endVisit(JParameterRef x, Context ctx) {
            if (this.isVarargsReference(x)) {
                this.upgradeResult(VarargsProcessingResult.GENERAL_ACCESS);
            }
        }

        @Override
        public boolean visit(JArrayLength x, Context ctx) {
            return !this.isVarargsReference(x.getInstance());
        }

        @Override
        public boolean visit(JArrayRef x, Context ctx) {
            if (this.isVarargsReference(x.getInstance())) {
                this.accept(x.getIndexExpr());
                return false;
            }
            return true;
        }

        @Override
        public boolean visit(JBinaryOperation x, Context ctx) {
            if (this.isModifyingVarargs(x)) {
                this.upgradeResult(VarargsProcessingResult.GENERAL_ACCESS);
                return false;
            }
            return true;
        }

        @Override
        public boolean visit(JUnaryOperation x, Context ctx) {
            if (this.isModifyingVarargs(x)) {
                this.upgradeResult(VarargsProcessingResult.GENERAL_ACCESS);
                return false;
            }
            return true;
        }

        @Override
        public boolean visit(JMethodCall x, Context ctx) {
            if (x.getTarget().isJsMethodVarargs() && x.getArgs().size() == 1 && this.isVarargsReference(x.getArgs().get(0))) {
                this.upgradeResult(VarargsProcessingResult.PASS_WHOLE);
                if (x.getInstance() != null) {
                    this.accept(x.getInstance());
                }
                for (JExpression arg : x.getArgs().subList(1, x.getArgs().size())) {
                    this.accept(arg);
                }
                return false;
            }
            return true;
        }

        private boolean isModifyingVarargs(JBinaryOperation x) {
            if (!x.getOp().isAssignment()) {
                return false;
            }
            if (!(x.getLhs() instanceof JArrayRef)) {
                return false;
            }
            JArrayRef arrayRef = (JArrayRef)x.getLhs();
            JExpression instance = arrayRef.getInstance();
            return this.isVarargsReference(instance);
        }

        private boolean isModifyingVarargs(JUnaryOperation x) {
            if (!x.getOp().isModifying()) {
                return false;
            }
            if (!(x.getArg() instanceof JArrayRef)) {
                return false;
            }
            JArrayRef arrayRef = (JArrayRef)x.getArg();
            JExpression instance = arrayRef.getInstance();
            return this.isVarargsReference(instance);
        }

        private boolean isVarargsReference(JExpression instance) {
            if (!(instance instanceof JParameterRef)) {
                return false;
            }
            return ((JParameterRef)instance).getTarget() == this.varargsParameter;
        }

        private void upgradeResult(VarargsProcessingResult upgradeTo) {
            this.result = VarargsProcessingResult.join(this.result, upgradeTo);
        }
    }
}

