/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl;

import com.google.gwt.dev.jjs.Correlation;
import com.google.gwt.dev.jjs.SourceInfo;
import com.google.gwt.dev.jjs.ast.Context;
import com.google.gwt.dev.jjs.ast.JArrayType;
import com.google.gwt.dev.jjs.ast.JClassLiteral;
import com.google.gwt.dev.jjs.ast.JClassType;
import com.google.gwt.dev.jjs.ast.JDeclarationStatement;
import com.google.gwt.dev.jjs.ast.JEnumType;
import com.google.gwt.dev.jjs.ast.JExpression;
import com.google.gwt.dev.jjs.ast.JField;
import com.google.gwt.dev.jjs.ast.JFieldRef;
import com.google.gwt.dev.jjs.ast.JInterfaceType;
import com.google.gwt.dev.jjs.ast.JLiteral;
import com.google.gwt.dev.jjs.ast.JMethod;
import com.google.gwt.dev.jjs.ast.JMethodBody;
import com.google.gwt.dev.jjs.ast.JMethodCall;
import com.google.gwt.dev.jjs.ast.JModVisitor;
import com.google.gwt.dev.jjs.ast.JNullLiteral;
import com.google.gwt.dev.jjs.ast.JParameter;
import com.google.gwt.dev.jjs.ast.JPrimitiveType;
import com.google.gwt.dev.jjs.ast.JProgram;
import com.google.gwt.dev.jjs.ast.JRecordType;
import com.google.gwt.dev.jjs.ast.JReferenceType;
import com.google.gwt.dev.jjs.ast.JRuntimeTypeReference;
import com.google.gwt.dev.jjs.ast.JType;
import com.google.gwt.dev.jjs.ast.js.JsniClassLiteral;
import com.google.gwt.dev.jjs.ast.js.JsniMethodBody;
import com.google.gwt.dev.jjs.ast.js.JsniMethodRef;
import com.google.gwt.dev.jjs.impl.JjsUtils;
import com.google.gwt.dev.js.ast.JsContext;
import com.google.gwt.dev.js.ast.JsExpression;
import com.google.gwt.dev.js.ast.JsInvocation;
import com.google.gwt.dev.js.ast.JsModVisitor;
import com.google.gwt.dev.js.ast.JsNameRef;
import com.google.gwt.dev.js.ast.JsNumberLiteral;
import com.google.gwt.dev.util.log.speedtracer.CompilerEventType;
import com.google.gwt.dev.util.log.speedtracer.SpeedTracerLogger;
import com.google.gwt.thirdparty.guava.common.base.Joiner;
import com.google.gwt.thirdparty.guava.common.collect.ArrayListMultimap;
import com.google.gwt.thirdparty.guava.common.collect.ImmutableMap;
import com.google.gwt.thirdparty.guava.common.collect.Iterables;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import com.google.gwt.thirdparty.guava.common.collect.Maps;
import com.google.gwt.thirdparty.guava.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.Map;

public class ImplementClassLiteralsAsFields {
    private static Map<Class<? extends JType>, ClassLiteralFactoryMethod> literalFactoryMethodByTypeClass = new ImmutableMap.Builder<Class<JEnumType>, ClassLiteralFactoryMethod>().put(JEnumType.class, ClassLiteralFactoryMethod.CREATE_FOR_ENUM).put(JClassType.class, ClassLiteralFactoryMethod.CREATE_FOR_CLASS).put(JRecordType.class, ClassLiteralFactoryMethod.CREATE_FOR_CLASS).put(JInterfaceType.class, ClassLiteralFactoryMethod.CREATE_FOR_INTERFACE).put(JPrimitiveType.class, ClassLiteralFactoryMethod.CREATE_FOR_PRIMITIVE).build();
    private final Map<JType, JField> classLiteralFields = Maps.newIdentityHashMap();
    private final JMethodBody classLiteralHolderClinitBody;
    private final JProgram program;
    private final JClassType typeClassLiteralHolder;
    private final boolean shouldOptimize;

    public static void exec(JProgram program, boolean shouldOptimize) {
        SpeedTracerLogger.Event normalizerEvent = SpeedTracerLogger.start(CompilerEventType.NORMALIZER, new String[0]);
        new ImplementClassLiteralsAsFields(program, shouldOptimize).execImpl();
        normalizerEvent.end(new String[0]);
    }

    private ImplementClassLiteralsAsFields(JProgram program, boolean shouldOptimize) {
        this.program = program;
        this.typeClassLiteralHolder = program.getTypeClassLiteralHolder();
        this.classLiteralHolderClinitBody = (JMethodBody)this.typeClassLiteralHolder.getClinitMethod().getBody();
        this.shouldOptimize = shouldOptimize;
        assert (program.getDeclaredTypes().contains(this.typeClassLiteralHolder));
    }

    private JLiteral getSuperclassClassLiteral(SourceInfo info, JType type) {
        if (!(type instanceof JClassType) || ((JClassType)type).getSuperClass() == null) {
            return JNullLiteral.INSTANCE;
        }
        JClassType superClass = ((JClassType)type).getSuperClass();
        if (superClass.isJsNative()) {
            superClass = this.program.getTypeJavaLangObject();
        }
        return this.createDependentClassLiteral(info, superClass);
    }

    private JClassLiteral createDependentClassLiteral(SourceInfo info, JType type) {
        JClassLiteral classLiteral = new JClassLiteral(info.makeChild(), type);
        classLiteral.setField(this.resolveClassLiteralField(classLiteral.getRefType()));
        return classLiteral;
    }

    private void execImpl() {
        if (!this.shouldOptimize) {
            for (JPrimitiveType jPrimitiveType : JPrimitiveType.types) {
                this.resolveClassLiteralField(jPrimitiveType);
            }
            for (JType jType : this.program.getDeclaredTypes()) {
                this.resolveClassLiteralField(jType);
            }
        }
        NormalizeVisitor visitor = new NormalizeVisitor();
        visitor.accept(this.program);
        this.program.recordClassLiteralFields(this.classLiteralFields);
    }

    private JMethodCall createLiteralCall(SourceInfo info, JProgram program, JType type) {
        type = type.getUnderlyingType();
        Class<Object> typeClass = type.getClass();
        if (type.isEnumOrSubclass() != null) {
            typeClass = JEnumType.class;
        }
        return literalFactoryMethodByTypeClass.get(typeClass).createCall(info, program, type, this.getSuperclassClassLiteral(info, type));
    }

    private void resolveClassLiteral(JClassLiteral x) {
        JField field = this.resolveClassLiteralField(x.getRefType());
        x.setField(field);
    }

    private JField resolveClassLiteralField(JType type) {
        JField field = this.classLiteralFields.get(type = type.isJsNative() || type.isJsFunction() || type.isJsFunctionImplementation() ? this.program.getJavaScriptObject() : this.program.normalizeJsoType(type));
        if (field == null) {
            SourceInfo info = type.getSourceInfo().makeChild();
            assert (!(type instanceof JArrayType));
            JMethodCall classLiteralCreationExpression = this.createLiteralCall(info, this.program, type);
            field = new JField(info, ImplementClassLiteralsAsFields.getClassLiteralFieldName(type), this.typeClassLiteralHolder, this.program.getTypeJavaLangClass(), true, JField.Disposition.FINAL);
            this.typeClassLiteralHolder.addField(field);
            info.addCorrelation(info.getCorrelator().by(Correlation.Literal.CLASS));
            JFieldRef fieldRef = new JFieldRef(info, null, field, this.typeClassLiteralHolder);
            JDeclarationStatement decl = new JDeclarationStatement(info, fieldRef, classLiteralCreationExpression);
            this.classLiteralHolderClinitBody.getBlock().addStmt(decl);
            this.classLiteralFields.put(type, field);
        }
        return field;
    }

    private static String getClassLiteralFieldName(JType type) {
        return JjsUtils.classLiteralFieldNameFromJavahTypeSignatureName(type.getJavahSignatureName());
    }

    private class NormalizeVisitor
    extends JModVisitor {
        private NormalizeVisitor() {
        }

        @Override
        public void endVisit(JClassLiteral x, Context ctx) {
            JType type = x.getRefType();
            if (type instanceof JArrayType) {
                JArrayType arrayType = (JArrayType)type;
                JClassLiteral leafTypeClassLiteral = new JClassLiteral(x.getSourceInfo(), arrayType.getLeafType());
                ImplementClassLiteralsAsFields.this.resolveClassLiteral(leafTypeClassLiteral);
                int dims = type.isJsNative() ? 1 : arrayType.getDims();
                JExpression arrayClassLiteralExpression = ImplementClassLiteralsAsFields.this.program.createArrayClassLiteralExpression(x.getSourceInfo(), leafTypeClassLiteral, dims);
                ctx.replaceMe(arrayClassLiteralExpression);
            } else {
                ImplementClassLiteralsAsFields.this.resolveClassLiteral(x);
            }
        }

        @Override
        public void endVisit(JMethod x, Context ctx) {
            if (x.isJsMethodVarargs()) {
                JParameter varargsParameter = Iterables.getLast(x.getParams());
                assert (varargsParameter.isVarargs());
                ImplementClassLiteralsAsFields.this.resolveClassLiteralField(((JArrayType)varargsParameter.getType()).getLeafType());
            }
        }

        @Override
        public void endVisit(JsniClassLiteral x, Context ctx) {
        }

        @Override
        public void endVisit(JsniMethodBody jsniMethodBody, Context ctx) {
            if (jsniMethodBody.getClassRefs().size() == 0) {
                return;
            }
            final ArrayListMultimap<String, JsniClassLiteral> jsniClassLiteralsByJsniReference = ArrayListMultimap.create();
            JMethod getClassLiteralForArrayMethod = ImplementClassLiteralsAsFields.this.program.getIndexedMethod("Array.getClassLiteralForArray");
            final String getClassLiteralForArrayMethodIdent = "@" + getClassLiteralForArrayMethod.getJsniSignature(true, false);
            boolean areThereArrayClassLiterals = false;
            for (JsniClassLiteral jsniClassLiteral : jsniMethodBody.getClassRefs()) {
                if (jsniClassLiteral.getRefType() instanceof JArrayType) {
                    areThereArrayClassLiterals = true;
                } else {
                    ImplementClassLiteralsAsFields.this.resolveClassLiteral(jsniClassLiteral);
                }
                jsniClassLiteralsByJsniReference.put(jsniClassLiteral.getIdent(), jsniClassLiteral);
            }
            if (!areThereArrayClassLiterals) {
                return;
            }
            final LinkedHashSet newClassRefs = Sets.newLinkedHashSet();
            JsModVisitor replaceJsniClassLiteralVisitor = new JsModVisitor(){

                @Override
                public void endVisit(JsNameRef x, JsContext ctx) {
                    if (!x.isJsniReference()) {
                        return;
                    }
                    if (jsniClassLiteralsByJsniReference.get(x.getIdent()).isEmpty()) {
                        return;
                    }
                    JsniClassLiteral jsniClassLiteral = (JsniClassLiteral)jsniClassLiteralsByJsniReference.get(x.getIdent()).iterator().next();
                    jsniClassLiteralsByJsniReference.remove(x.getIdent(), jsniClassLiteral);
                    if (jsniClassLiteral.getRefType() instanceof JArrayType) {
                        JArrayType arrayType = (JArrayType)jsniClassLiteral.getRefType();
                        JType leafType = arrayType.getLeafType();
                        jsniClassLiteral = new JsniClassLiteral(jsniClassLiteral.getSourceInfo(), leafType);
                        SourceInfo info = x.getSourceInfo();
                        JsNameRef getArrayClassLiteralMethodNameRef = new JsNameRef(info, getClassLiteralForArrayMethodIdent);
                        JsInvocation invocation = new JsInvocation(info, (JsExpression)getArrayClassLiteralMethodNameRef, new JsNameRef(info, jsniClassLiteral.getIdent()), new JsNumberLiteral(info, arrayType.getDims()));
                        ImplementClassLiteralsAsFields.this.resolveClassLiteral(jsniClassLiteral);
                        ctx.replaceMe(invocation);
                    }
                    newClassRefs.add(jsniClassLiteral);
                }
            };
            replaceJsniClassLiteralVisitor.accept(jsniMethodBody.getFunc());
            if (!replaceJsniClassLiteralVisitor.didChange()) {
                return;
            }
            JsniMethodBody newBody = new JsniMethodBody(jsniMethodBody.getSourceInfo(), jsniMethodBody.getFunc(), Lists.newArrayList(newClassRefs), jsniMethodBody.getJsniFieldRefs(), jsniMethodBody.getJsniMethodRefs(), jsniMethodBody.getUsedStrings());
            newBody.addJsniRef(new JsniMethodRef(jsniMethodBody.getSourceInfo(), getClassLiteralForArrayMethodIdent, getClassLiteralForArrayMethod, ImplementClassLiteralsAsFields.this.program.getJavaScriptObject()));
            ctx.replaceMe(newBody);
        }
    }

    public static abstract class ClassLiteralFactoryMethod
    extends Enum<ClassLiteralFactoryMethod> {
        public static final /* enum */ ClassLiteralFactoryMethod CREATE_FOR_ENUM = new ClassLiteralFactoryMethod(){

            @Override
            JMethodCall createCall(SourceInfo info, JProgram program, JType type, JLiteral superclassLiteral) {
                JEnumType enumType = type.isEnumOrSubclass();
                assert (enumType != null);
                JMethodCall call = ClassLiteralFactoryMethod.createBaseCall(info, program, type, "Class.createForEnum");
                call.addArg(new JRuntimeTypeReference(info, program.getTypeJavaLangObject(), (JReferenceType)type));
                call.addArg(superclassLiteral);
                call.addArg(this.getStandardMethodAsArg(info, program, type, "values()"));
                call.addArg(this.getStandardMethodAsArg(info, program, type, "valueOf(Ljava/lang/String;)"));
                return call;
            }

            private JExpression getStandardMethodAsArg(SourceInfo info, JProgram program, JType type, String methodSignature) {
                JEnumType enumType = type.isEnumOrSubclass();
                if (enumType != type) {
                    return JNullLiteral.INSTANCE;
                }
                for (JMethod method : enumType.getMethods()) {
                    if (!method.isStatic() || !method.getSignature().startsWith(methodSignature)) continue;
                    return new JsniMethodRef(info, method.getJsniSignature(true, false), method, program.getJavaScriptObject());
                }
                return JNullLiteral.INSTANCE;
            }
        };
        public static final /* enum */ ClassLiteralFactoryMethod CREATE_FOR_CLASS = new ClassLiteralFactoryMethod(){

            @Override
            JMethodCall createCall(SourceInfo info, JProgram program, JType type, JLiteral superclassLiteral) {
                JMethodCall call = ClassLiteralFactoryMethod.createBaseCall(info, program, type, "Class.createForClass");
                call.addArg(new JRuntimeTypeReference(info, program.getTypeJavaLangObject(), (JReferenceType)type));
                call.addArg(superclassLiteral);
                return call;
            }
        };
        public static final /* enum */ ClassLiteralFactoryMethod CREATE_FOR_PRIMITIVE = new ClassLiteralFactoryMethod(){

            @Override
            JMethodCall createCall(SourceInfo info, JProgram program, JType type, JLiteral superclassLiteral) {
                JMethodCall call = new JMethodCall(info, null, program.getIndexedMethod("Class.createForPrimitive"), new JExpression[0]);
                call.addArg(program.getStringLiteral(info, type.getShortName()));
                call.addArg(program.getStringLiteral(info, type.getJavahSignatureName()));
                return call;
            }
        };
        public static final /* enum */ ClassLiteralFactoryMethod CREATE_FOR_INTERFACE = new ClassLiteralFactoryMethod(){

            @Override
            JMethodCall createCall(SourceInfo info, JProgram program, JType type, JLiteral superclassLiteral) {
                return ClassLiteralFactoryMethod.createBaseCall(info, program, type, "Class.createForInterface");
            }
        };
        private static final /* synthetic */ ClassLiteralFactoryMethod[] $VALUES;

        public static ClassLiteralFactoryMethod[] values() {
            return (ClassLiteralFactoryMethod[])$VALUES.clone();
        }

        public static ClassLiteralFactoryMethod valueOf(String name) {
            return Enum.valueOf(ClassLiteralFactoryMethod.class, name);
        }

        abstract JMethodCall createCall(SourceInfo var1, JProgram var2, JType var3, JLiteral var4);

        private static JMethodCall createBaseCall(SourceInfo info, JProgram program, JType type, String indexedMethodName) {
            String[] compoundName = ClassLiteralFactoryMethod.maybeMangleJSOTypeName(type);
            JMethodCall call = new JMethodCall(info, null, program.getIndexedMethod(indexedMethodName), program.getStringLiteral(info, type.getPackageName()), ClassLiteralFactoryMethod.getCompoundNameLiteral(program, info, compoundName));
            return call;
        }

        private static String[] maybeMangleJSOTypeName(JType type) {
            assert (!(type instanceof JArrayType));
            String[] compoundName = type.getCompoundName();
            if (type.isJsoType()) {
                compoundName[compoundName.length - 1] = compoundName[compoundName.length - 1] + '$';
            }
            return compoundName;
        }

        private static JExpression getCompoundNameLiteral(JProgram program, SourceInfo info, String[] compoundName) {
            return program.getStringLiteral(info, Joiner.on('/').join(compoundName));
        }

        static {
            $VALUES = new ClassLiteralFactoryMethod[]{CREATE_FOR_ENUM, CREATE_FOR_CLASS, CREATE_FOR_PRIMITIVE, CREATE_FOR_INTERFACE};
        }
    }
}

