/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl;

import com.google.gwt.dev.jjs.SourceInfo;
import com.google.gwt.dev.jjs.ast.Context;
import com.google.gwt.dev.jjs.ast.JArrayType;
import com.google.gwt.dev.jjs.ast.JBinaryOperation;
import com.google.gwt.dev.jjs.ast.JBinaryOperator;
import com.google.gwt.dev.jjs.ast.JCastOperation;
import com.google.gwt.dev.jjs.ast.JConstructor;
import com.google.gwt.dev.jjs.ast.JDeclaredType;
import com.google.gwt.dev.jjs.ast.JExpression;
import com.google.gwt.dev.jjs.ast.JInstanceOf;
import com.google.gwt.dev.jjs.ast.JInterfaceType;
import com.google.gwt.dev.jjs.ast.JMethod;
import com.google.gwt.dev.jjs.ast.JMethodCall;
import com.google.gwt.dev.jjs.ast.JModVisitor;
import com.google.gwt.dev.jjs.ast.JPrimitiveType;
import com.google.gwt.dev.jjs.ast.JProgram;
import com.google.gwt.dev.jjs.ast.JReferenceType;
import com.google.gwt.dev.jjs.ast.JRuntimeTypeReference;
import com.google.gwt.dev.jjs.ast.JType;
import com.google.gwt.dev.jjs.ast.js.JsniMethodRef;
import com.google.gwt.dev.jjs.impl.JjsUtils;
import com.google.gwt.dev.jjs.impl.TypeCategory;
import com.google.gwt.thirdparty.guava.common.collect.Maps;
import java.util.Map;

public class ImplementCastsAndTypeChecks {
    private final boolean pruneTrivialCasts;
    private final JProgram program;
    private Map<TypeCategory, JMethod> instanceOfMethodsByTargetTypeCategory = Maps.newEnumMap(TypeCategory.class);
    private Map<TypeCategory, JMethod> dynamicCastMethodsByTargetTypeCategory = Maps.newEnumMap(TypeCategory.class);

    private TypeCategory determineTypeCategoryForType(JReferenceType type) {
        TypeCategory typeCategory = TypeCategory.typeCategoryForType(type, this.program);
        assert (typeCategory.castInstanceOfQualifier() != null);
        return typeCategory;
    }

    private JMethodCall implementCastOrInstanceOfOperation(SourceInfo sourceInfo, JExpression targetExpression, JReferenceType targetType, Map<TypeCategory, JMethod> targetMethodByTypeCategory, boolean overrideReturnType) {
        TypeCategory targetTypeCategory = this.determineTypeCategoryForType(targetType);
        JMethod method = targetMethodByTypeCategory.get((Object)targetTypeCategory);
        assert (method != null);
        JMethodCall call = new JMethodCall(sourceInfo, null, method, new JExpression[0]);
        if (overrideReturnType) {
            call.overrideReturnType(targetType);
        }
        call.addArg(targetExpression);
        if (method.getParams().size() < 2) {
            return call;
        }
        if (targetTypeCategory.requiresTypeId()) {
            call.addArg(new JRuntimeTypeReference(sourceInfo, this.program.getTypeJavaLangObject(), targetType));
            return call;
        }
        if (targetTypeCategory.requiresJsConstructor()) {
            JDeclaredType declaredType = (JDeclaredType)targetType;
            JConstructor jsConstructor = JjsUtils.getJsNativeConstructorOrNull(declaredType);
            assert (jsConstructor != null && declaredType.isJsNative());
            call.addArg(new JsniMethodRef(sourceInfo, declaredType.getQualifiedJsName(), (JMethod)jsConstructor, this.program.getJavaScriptObject()));
            return call;
        }
        throw new AssertionError();
    }

    public static void exec(JProgram program, boolean pruneTrivialCasts) {
        new ImplementCastsAndTypeChecks(program, pruneTrivialCasts).execImpl();
    }

    public static void exec(JProgram program) {
        new ImplementCastsAndTypeChecks(program, true).execImpl();
    }

    private ImplementCastsAndTypeChecks(JProgram program, boolean pruneTrivialCasts) {
        this.program = program;
        this.pruneTrivialCasts = pruneTrivialCasts;
        for (TypeCategory t : TypeCategory.values()) {
            String castInstanceOfQualifier = t.castInstanceOfQualifier();
            if (castInstanceOfQualifier == null) continue;
            String instanceOfMethod = "Cast.instanceOf" + castInstanceOfQualifier;
            this.instanceOfMethodsByTargetTypeCategory.put(t, program.getIndexedMethod(instanceOfMethod));
            String castMethod = "Cast.castTo" + castInstanceOfQualifier;
            this.dynamicCastMethodsByTargetTypeCategory.put(t, program.getIndexedMethod(castMethod));
        }
    }

    private void execImpl() {
        new ReplaceTypeChecksVisitor().accept(this.program);
    }

    private class ReplaceTypeChecksVisitor
    extends JModVisitor {
        private ReplaceTypeChecksVisitor() {
        }

        @Override
        public void endVisit(JCastOperation x, Context ctx) {
            JMethodCall call;
            JMethod castMethod;
            JType toType = x.getCastType();
            JExpression expr = x.getExpr();
            SourceInfo info = x.getSourceInfo();
            if (ImplementCastsAndTypeChecks.this.pruneTrivialCasts && toType.isNullType()) {
                JMethod method = ImplementCastsAndTypeChecks.this.program.getIndexedMethod("Cast.throwClassCastExceptionUnlessNull");
                JMethodCall call2 = new JMethodCall(info, null, method, expr);
                call2.overrideReturnType(toType);
                ctx.replaceMe(call2);
                return;
            }
            if (toType instanceof JReferenceType) {
                JExpression curExpr = expr;
                JReferenceType refType = (JReferenceType)toType.getUnderlyingType();
                JReferenceType argType = (JReferenceType)expr.getType();
                if (refType instanceof JArrayType) {
                    refType = (JReferenceType)ImplementCastsAndTypeChecks.this.program.normalizeJsoType(refType);
                }
                if (ImplementCastsAndTypeChecks.this.pruneTrivialCasts && ((ImplementCastsAndTypeChecks)ImplementCastsAndTypeChecks.this).program.typeOracle.castSucceedsTrivially(argType, refType) || ImplementCastsAndTypeChecks.this.determineTypeCategoryForType(refType) == TypeCategory.TYPE_JAVA_LANG_OBJECT) {
                    ctx.replaceMe(curExpr);
                    return;
                }
                if (((ImplementCastsAndTypeChecks)ImplementCastsAndTypeChecks.this).program.typeOracle.isEffectivelyJavaScriptObject(argType) && ((ImplementCastsAndTypeChecks)ImplementCastsAndTypeChecks.this).program.typeOracle.isEffectivelyJavaScriptObject(refType)) {
                    return;
                }
                ctx.replaceMe(ImplementCastsAndTypeChecks.this.implementCastOrInstanceOfOperation(x.getSourceInfo(), curExpr, refType, ImplementCastsAndTypeChecks.this.dynamicCastMethodsByTargetTypeCategory, true));
                return;
            }
            assert (toType.isPrimitiveType());
            JPrimitiveType tByte = ImplementCastsAndTypeChecks.this.program.getTypePrimitiveByte();
            JPrimitiveType tChar = ImplementCastsAndTypeChecks.this.program.getTypePrimitiveChar();
            JPrimitiveType tShort = ImplementCastsAndTypeChecks.this.program.getTypePrimitiveShort();
            JPrimitiveType tInt = ImplementCastsAndTypeChecks.this.program.getTypePrimitiveInt();
            JPrimitiveType tLong = ImplementCastsAndTypeChecks.this.program.getTypePrimitiveLong();
            JPrimitiveType tFloat = ImplementCastsAndTypeChecks.this.program.getTypePrimitiveFloat();
            JPrimitiveType tDouble = ImplementCastsAndTypeChecks.this.program.getTypePrimitiveDouble();
            JType fromType = expr.getType();
            String methodName = null;
            if (tLong == fromType && tLong != toType) {
                if (tByte == toType || tShort == toType || tChar == toType) {
                    castMethod = ImplementCastsAndTypeChecks.this.program.getIndexedMethod("LongLib.toInt");
                    call = new JMethodCall(info, null, castMethod, new JExpression[0]);
                    call.addArg(expr);
                    expr = call;
                    fromType = tInt;
                } else if (tInt == toType) {
                    methodName = "LongLib.toInt";
                } else if (tFloat == toType || tDouble == toType) {
                    methodName = "LongLib.toDouble";
                }
            }
            if (toType == tLong && fromType != tLong) {
                if (tByte == fromType || tShort == fromType || tChar == fromType || tInt == fromType) {
                    methodName = "LongLib.fromInt";
                } else if (tFloat == fromType || tDouble == fromType) {
                    methodName = "LongLib.fromDouble";
                }
            } else if (tByte == fromType) {
                if (tChar == toType) {
                    methodName = "Cast.narrow_" + toType.getName();
                }
            } else if (tShort == fromType) {
                if (tByte == toType || tChar == toType) {
                    methodName = "Cast.narrow_" + toType.getName();
                }
            } else if (tChar == fromType) {
                if (tByte == toType || tShort == toType) {
                    methodName = "Cast.narrow_" + toType.getName();
                }
            } else if (tInt == fromType) {
                if (tByte == toType || tShort == toType || tChar == toType) {
                    methodName = "Cast.narrow_" + toType.getName();
                }
            } else if (!(tFloat != fromType && tDouble != fromType || tByte != toType && tShort != toType && tChar != toType && tInt != toType)) {
                methodName = "Cast.round_" + toType.getName();
            }
            if (methodName != null) {
                castMethod = ImplementCastsAndTypeChecks.this.program.getIndexedMethod(methodName);
                call = new JMethodCall(info, null, castMethod, expr);
                call.overrideReturnType(toType);
                ctx.replaceMe(call);
            } else {
                ctx.replaceMe(expr);
            }
        }

        @Override
        public void endVisit(JInstanceOf x, Context ctx) {
            boolean isTrivialCast;
            JReferenceType argType = (JReferenceType)x.getExpr().getType();
            JReferenceType toType = x.getTestType();
            assert (toType == toType.getUnderlyingType());
            if (toType instanceof JArrayType) {
                toType = (JReferenceType)ImplementCastsAndTypeChecks.this.program.normalizeJsoType(toType);
            }
            assert (!toType.isJsNative() || !(toType instanceof JInterfaceType));
            boolean bl = isTrivialCast = ((ImplementCastsAndTypeChecks)ImplementCastsAndTypeChecks.this).program.typeOracle.castSucceedsTrivially(argType, toType) || ((ImplementCastsAndTypeChecks)ImplementCastsAndTypeChecks.this).program.typeOracle.isEffectivelyJavaScriptObject(argType) && ((ImplementCastsAndTypeChecks)ImplementCastsAndTypeChecks.this).program.typeOracle.isEffectivelyJavaScriptObject(toType);
            if (ImplementCastsAndTypeChecks.this.pruneTrivialCasts && isTrivialCast || ImplementCastsAndTypeChecks.this.determineTypeCategoryForType(toType) == TypeCategory.TYPE_JAVA_LANG_OBJECT) {
                JBinaryOperation eq = new JBinaryOperation(x.getSourceInfo(), ImplementCastsAndTypeChecks.this.program.getTypePrimitiveBoolean(), JBinaryOperator.NEQ, x.getExpr(), ImplementCastsAndTypeChecks.this.program.getLiteralNull());
                ctx.replaceMe(eq);
            } else {
                ctx.replaceMe(ImplementCastsAndTypeChecks.this.implementCastOrInstanceOfOperation(x.getSourceInfo(), x.getExpr(), toType, ImplementCastsAndTypeChecks.this.instanceOfMethodsByTargetTypeCategory, false));
            }
        }
    }
}

