/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl;

import com.google.gwt.dev.cfg.PermutationProperties;
import com.google.gwt.dev.jjs.SourceInfo;
import com.google.gwt.dev.js.ast.JsBinaryOperation;
import com.google.gwt.dev.js.ast.JsBinaryOperator;
import com.google.gwt.dev.js.ast.JsContext;
import com.google.gwt.dev.js.ast.JsFunction;
import com.google.gwt.dev.js.ast.JsModVisitor;
import com.google.gwt.dev.js.ast.JsName;
import com.google.gwt.dev.js.ast.JsNameRef;
import com.google.gwt.dev.js.ast.JsObjectLiteral;
import com.google.gwt.dev.js.ast.JsProgram;
import com.google.gwt.dev.js.ast.JsVars;
import com.google.gwt.dev.js.ast.JsVisitor;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class HandleCrossFragmentReferences {
    private JsName jslink;
    private final JsProgram jsProgram;
    private final Set<JsName> namesToPredefine = new LinkedHashSet<JsName>();
    private final boolean shouldPredeclareReferences;

    public static void exec(JsProgram jsProgram, PermutationProperties properties) {
        new HandleCrossFragmentReferences(jsProgram, properties).execImpl();
    }

    private static boolean containsOtherThan(Set<Integer> set, int allowed) {
        for (int elem : set) {
            if (elem == allowed) continue;
            return true;
        }
        return false;
    }

    private HandleCrossFragmentReferences(JsProgram jsProgram, PermutationProperties properties) {
        this.jsProgram = jsProgram;
        this.shouldPredeclareReferences = properties.isTrueInAnyPermutation("compiler.predeclare.cross.fragment.references");
    }

    private void chooseNamesToPredefine(Map<JsName, Set<Integer>> map, Map<JsName, Set<Integer>> islandsUsing) {
        for (Map.Entry<JsName, Set<Integer>> entry : map.entrySet()) {
            Set<Integer> useIslands;
            int defIsland;
            JsName name = entry.getKey();
            Set<Integer> defIslands = entry.getValue();
            if (defIslands.size() != 1 || (defIsland = defIslands.iterator().next().intValue()) == 0 || (useIslands = islandsUsing.get(name)) == null || !HandleCrossFragmentReferences.containsOtherThan(islandsUsing.get(name), defIsland)) continue;
            this.namesToPredefine.add(name);
        }
    }

    private void defineJsLink() {
        SourceInfo info = this.jsProgram.createSourceInfoSynthetic(HandleCrossFragmentReferences.class);
        this.jslink = this.jsProgram.getScope().declareName("jslink");
        JsVars vars = new JsVars(info, new JsVars.JsVar[0]);
        JsVars.JsVar var = new JsVars.JsVar(info, this.jslink);
        var.setInitExpr(JsObjectLiteral.EMPTY);
        vars.add(var);
        this.jsProgram.getFragmentBlock(0).getStatements().add(0, vars);
    }

    private void execImpl() {
        if (this.jsProgram.getFragmentCount() == 1) {
            return;
        }
        if (!this.shouldPredeclareReferences) {
            return;
        }
        this.defineJsLink();
        FindNameReferences findNameReferences = new FindNameReferences();
        findNameReferences.accept(this.jsProgram);
        this.chooseNamesToPredefine(findNameReferences.islandsDefining, findNameReferences.islandsUsing);
        new RewriteDeclsAndRefs().accept(this.jsProgram);
    }

    private class RewriteDeclsAndRefs
    extends JsModVisitor {
        private RewriteDeclsAndRefs() {
        }

        @Override
        public void endVisit(JsFunction x, JsContext ctx) {
            if (HandleCrossFragmentReferences.this.namesToPredefine.contains(x.getName())) {
                JsBinaryOperation asg = new JsBinaryOperation(x.getSourceInfo(), JsBinaryOperator.ASG, this.makeRefViaJslink(x.getName(), x.getSourceInfo()), x);
                x.setName(null);
                ctx.replaceMe(asg);
            }
        }

        @Override
        public void endVisit(JsNameRef x, JsContext ctx) {
            if (HandleCrossFragmentReferences.this.namesToPredefine.contains(x.getName())) {
                ctx.replaceMe(this.makeRefViaJslink(x.getName(), x.getSourceInfo()));
            }
        }

        @Override
        public void endVisit(JsVars x, JsContext ctx) {
            if (!ctx.canInsert()) {
                return;
            }
            JsVars currentVar = null;
            for (JsVars.JsVar var : x) {
                if (HandleCrossFragmentReferences.this.namesToPredefine.contains(var.getName())) {
                    if (var.getInitExpr() == null) continue;
                    JsBinaryOperation asg = new JsBinaryOperation(var.getSourceInfo(), JsBinaryOperator.ASG, this.makeRefViaJslink(var.getName(), var.getSourceInfo()), var.getInitExpr());
                    ctx.insertBefore(asg.makeStmt());
                    currentVar = null;
                    continue;
                }
                if (currentVar == null) {
                    currentVar = new JsVars(x.getSourceInfo(), new JsVars.JsVar[0]);
                    ctx.insertBefore(currentVar);
                }
                currentVar.add(var);
            }
            ctx.removeMe();
        }

        private JsNameRef makeRefViaJslink(JsName name, SourceInfo sourceInfo) {
            JsNameRef ref = name.makeRef(sourceInfo);
            ref.setQualifier(HandleCrossFragmentReferences.this.jslink.makeRef(sourceInfo));
            return ref;
        }
    }

    private class FindNameReferences
    extends JsVisitor {
        Map<JsName, Set<Integer>> islandsDefining = new LinkedHashMap<JsName, Set<Integer>>();
        Map<JsName, Set<Integer>> islandsUsing = new LinkedHashMap<JsName, Set<Integer>>();
        private int currentIsland;

        private FindNameReferences() {
        }

        @Override
        public void endVisit(JsFunction x, JsContext ctx) {
            JsName name = x.getName();
            if (name != null) {
                this.definitionSeen(name);
            }
        }

        @Override
        public void endVisit(JsNameRef x, JsContext ctx) {
            JsName name;
            if (x.getQualifier() == null && (name = x.getName()) != null) {
                this.referenceSeen(name);
            }
        }

        @Override
        public void endVisit(JsVars x, JsContext ctx) {
            for (JsVars.JsVar var : x) {
                JsName name = var.getName();
                if (name == null) continue;
                this.definitionSeen(name);
            }
        }

        @Override
        public boolean visit(JsProgram x, JsContext ctx) {
            for (int i = 0; i < x.getFragmentCount(); ++i) {
                this.currentIsland = i;
                this.accept(x.getFragmentBlock(i));
            }
            return false;
        }

        private void definitionSeen(JsName name) {
            Set<Integer> defs = this.islandsDefining.get(name);
            if (defs == null) {
                defs = new LinkedHashSet<Integer>();
                this.islandsDefining.put(name, defs);
            }
            defs.add(this.currentIsland);
        }

        private void referenceSeen(JsName name) {
            Set<Integer> refs = this.islandsUsing.get(name);
            if (refs == null) {
                refs = new HashSet<Integer>();
                this.islandsUsing.put(name, refs);
            }
            refs.add(this.currentIsland);
        }
    }
}

