/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.linker.impl.StandardSymbolData;
import com.google.gwt.dev.CompilerContext;
import com.google.gwt.dev.MinimalRebuildCache;
import com.google.gwt.dev.PrecompileTaskOptions;
import com.google.gwt.dev.cfg.PermutationProperties;
import com.google.gwt.dev.common.InliningMode;
import com.google.gwt.dev.javac.JsInteropUtil;
import com.google.gwt.dev.jjs.HasSourceInfo;
import com.google.gwt.dev.jjs.InternalCompilerException;
import com.google.gwt.dev.jjs.SourceInfo;
import com.google.gwt.dev.jjs.SourceOrigin;
import com.google.gwt.dev.jjs.ast.CanHaveSuppressedWarnings;
import com.google.gwt.dev.jjs.ast.Context;
import com.google.gwt.dev.jjs.ast.HasEnclosingType;
import com.google.gwt.dev.jjs.ast.HasJsInfo;
import com.google.gwt.dev.jjs.ast.HasName;
import com.google.gwt.dev.jjs.ast.JAbstractMethodBody;
import com.google.gwt.dev.jjs.ast.JArrayLength;
import com.google.gwt.dev.jjs.ast.JArrayRef;
import com.google.gwt.dev.jjs.ast.JArrayType;
import com.google.gwt.dev.jjs.ast.JBinaryOperation;
import com.google.gwt.dev.jjs.ast.JBinaryOperator;
import com.google.gwt.dev.jjs.ast.JBlock;
import com.google.gwt.dev.jjs.ast.JBreakStatement;
import com.google.gwt.dev.jjs.ast.JCaseStatement;
import com.google.gwt.dev.jjs.ast.JCastMap;
import com.google.gwt.dev.jjs.ast.JCastOperation;
import com.google.gwt.dev.jjs.ast.JClassLiteral;
import com.google.gwt.dev.jjs.ast.JClassType;
import com.google.gwt.dev.jjs.ast.JConditional;
import com.google.gwt.dev.jjs.ast.JConstructor;
import com.google.gwt.dev.jjs.ast.JContinueStatement;
import com.google.gwt.dev.jjs.ast.JDeclarationStatement;
import com.google.gwt.dev.jjs.ast.JDeclaredType;
import com.google.gwt.dev.jjs.ast.JDoStatement;
import com.google.gwt.dev.jjs.ast.JExpression;
import com.google.gwt.dev.jjs.ast.JExpressionStatement;
import com.google.gwt.dev.jjs.ast.JField;
import com.google.gwt.dev.jjs.ast.JFieldRef;
import com.google.gwt.dev.jjs.ast.JForStatement;
import com.google.gwt.dev.jjs.ast.JIfStatement;
import com.google.gwt.dev.jjs.ast.JInterfaceType;
import com.google.gwt.dev.jjs.ast.JLabel;
import com.google.gwt.dev.jjs.ast.JLabeledStatement;
import com.google.gwt.dev.jjs.ast.JLiteral;
import com.google.gwt.dev.jjs.ast.JLocal;
import com.google.gwt.dev.jjs.ast.JLocalRef;
import com.google.gwt.dev.jjs.ast.JMember;
import com.google.gwt.dev.jjs.ast.JMethod;
import com.google.gwt.dev.jjs.ast.JMethodBody;
import com.google.gwt.dev.jjs.ast.JMethodCall;
import com.google.gwt.dev.jjs.ast.JNameOf;
import com.google.gwt.dev.jjs.ast.JNewInstance;
import com.google.gwt.dev.jjs.ast.JNode;
import com.google.gwt.dev.jjs.ast.JNullLiteral;
import com.google.gwt.dev.jjs.ast.JNumericEntry;
import com.google.gwt.dev.jjs.ast.JParameter;
import com.google.gwt.dev.jjs.ast.JParameterRef;
import com.google.gwt.dev.jjs.ast.JPermutationDependentValue;
import com.google.gwt.dev.jjs.ast.JPostfixOperation;
import com.google.gwt.dev.jjs.ast.JPrefixOperation;
import com.google.gwt.dev.jjs.ast.JPrimitiveType;
import com.google.gwt.dev.jjs.ast.JProgram;
import com.google.gwt.dev.jjs.ast.JReferenceType;
import com.google.gwt.dev.jjs.ast.JReturnStatement;
import com.google.gwt.dev.jjs.ast.JRunAsync;
import com.google.gwt.dev.jjs.ast.JStatement;
import com.google.gwt.dev.jjs.ast.JSwitchExpression;
import com.google.gwt.dev.jjs.ast.JSwitchStatement;
import com.google.gwt.dev.jjs.ast.JThisRef;
import com.google.gwt.dev.jjs.ast.JThrowStatement;
import com.google.gwt.dev.jjs.ast.JTransformer;
import com.google.gwt.dev.jjs.ast.JTryStatement;
import com.google.gwt.dev.jjs.ast.JType;
import com.google.gwt.dev.jjs.ast.JUnaryOperator;
import com.google.gwt.dev.jjs.ast.JUnsafeTypeCoercion;
import com.google.gwt.dev.jjs.ast.JVariable;
import com.google.gwt.dev.jjs.ast.JVisitor;
import com.google.gwt.dev.jjs.ast.JWhileStatement;
import com.google.gwt.dev.jjs.ast.JYieldStatement;
import com.google.gwt.dev.jjs.ast.js.JDebuggerStatement;
import com.google.gwt.dev.jjs.ast.js.JMultiExpression;
import com.google.gwt.dev.jjs.ast.js.JsniClassLiteral;
import com.google.gwt.dev.jjs.ast.js.JsniFieldRef;
import com.google.gwt.dev.jjs.ast.js.JsniMethodBody;
import com.google.gwt.dev.jjs.ast.js.JsniMethodRef;
import com.google.gwt.dev.jjs.ast.js.JsonArray;
import com.google.gwt.dev.jjs.impl.ClosureJsInteropExportsGenerator;
import com.google.gwt.dev.jjs.impl.ComputePotentiallyObservableUninitializedValues;
import com.google.gwt.dev.jjs.impl.ControlFlowAnalyzer;
import com.google.gwt.dev.jjs.impl.DefaultJsInteropExportsGenerator;
import com.google.gwt.dev.jjs.impl.JavaToJavaScriptMap;
import com.google.gwt.dev.jjs.impl.JavaToJavaScriptMapImpl;
import com.google.gwt.dev.jjs.impl.JjsPredicates;
import com.google.gwt.dev.jjs.impl.JjsUtils;
import com.google.gwt.dev.jjs.impl.JsInteropExportsGenerator;
import com.google.gwt.dev.jjs.impl.NameClashesFixer;
import com.google.gwt.dev.jjs.impl.ResolveRuntimeTypeReferences;
import com.google.gwt.dev.js.JsStackEmulator;
import com.google.gwt.dev.js.JsUtils;
import com.google.gwt.dev.js.ast.JsArrayAccess;
import com.google.gwt.dev.js.ast.JsArrayLiteral;
import com.google.gwt.dev.js.ast.JsBinaryOperation;
import com.google.gwt.dev.js.ast.JsBinaryOperator;
import com.google.gwt.dev.js.ast.JsBlock;
import com.google.gwt.dev.js.ast.JsBreak;
import com.google.gwt.dev.js.ast.JsCase;
import com.google.gwt.dev.js.ast.JsCatch;
import com.google.gwt.dev.js.ast.JsConditional;
import com.google.gwt.dev.js.ast.JsContext;
import com.google.gwt.dev.js.ast.JsContinue;
import com.google.gwt.dev.js.ast.JsDebugger;
import com.google.gwt.dev.js.ast.JsDefault;
import com.google.gwt.dev.js.ast.JsDoWhile;
import com.google.gwt.dev.js.ast.JsEmpty;
import com.google.gwt.dev.js.ast.JsExprStmt;
import com.google.gwt.dev.js.ast.JsExpression;
import com.google.gwt.dev.js.ast.JsFor;
import com.google.gwt.dev.js.ast.JsFunction;
import com.google.gwt.dev.js.ast.JsIf;
import com.google.gwt.dev.js.ast.JsInvocation;
import com.google.gwt.dev.js.ast.JsLabel;
import com.google.gwt.dev.js.ast.JsLiteral;
import com.google.gwt.dev.js.ast.JsModVisitor;
import com.google.gwt.dev.js.ast.JsName;
import com.google.gwt.dev.js.ast.JsNameOf;
import com.google.gwt.dev.js.ast.JsNameRef;
import com.google.gwt.dev.js.ast.JsNew;
import com.google.gwt.dev.js.ast.JsNode;
import com.google.gwt.dev.js.ast.JsNormalScope;
import com.google.gwt.dev.js.ast.JsNullLiteral;
import com.google.gwt.dev.js.ast.JsNumberLiteral;
import com.google.gwt.dev.js.ast.JsNumericEntry;
import com.google.gwt.dev.js.ast.JsObjectLiteral;
import com.google.gwt.dev.js.ast.JsParameter;
import com.google.gwt.dev.js.ast.JsPositionMarker;
import com.google.gwt.dev.js.ast.JsPostfixOperation;
import com.google.gwt.dev.js.ast.JsPrefixOperation;
import com.google.gwt.dev.js.ast.JsProgram;
import com.google.gwt.dev.js.ast.JsReturn;
import com.google.gwt.dev.js.ast.JsRootScope;
import com.google.gwt.dev.js.ast.JsScope;
import com.google.gwt.dev.js.ast.JsStatement;
import com.google.gwt.dev.js.ast.JsStringLiteral;
import com.google.gwt.dev.js.ast.JsSwitch;
import com.google.gwt.dev.js.ast.JsSwitchMember;
import com.google.gwt.dev.js.ast.JsThisRef;
import com.google.gwt.dev.js.ast.JsThrow;
import com.google.gwt.dev.js.ast.JsTry;
import com.google.gwt.dev.js.ast.JsUnaryOperator;
import com.google.gwt.dev.js.ast.JsVars;
import com.google.gwt.dev.js.ast.JsWhile;
import com.google.gwt.dev.util.Pair;
import com.google.gwt.dev.util.StringInterner;
import com.google.gwt.dev.util.arg.OptionMethodNameDisplayMode;
import com.google.gwt.dev.util.collect.Stack;
import com.google.gwt.dev.util.log.speedtracer.CompilerEventType;
import com.google.gwt.dev.util.log.speedtracer.SpeedTracerLogger;
import com.google.gwt.thirdparty.guava.common.base.Function;
import com.google.gwt.thirdparty.guava.common.base.Joiner;
import com.google.gwt.thirdparty.guava.common.base.Predicate;
import com.google.gwt.thirdparty.guava.common.base.Predicates;
import com.google.gwt.thirdparty.guava.common.collect.FluentIterable;
import com.google.gwt.thirdparty.guava.common.collect.ImmutableList;
import com.google.gwt.thirdparty.guava.common.collect.ImmutableSet;
import com.google.gwt.thirdparty.guava.common.collect.ImmutableSortedSet;
import com.google.gwt.thirdparty.guava.common.collect.Iterables;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import com.google.gwt.thirdparty.guava.common.collect.Maps;
import com.google.gwt.thirdparty.guava.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;

public class GenerateJavaScriptAST {
    private static final ImmutableList<String> METHODS_PROVIDED_BY_PREAMBLE = ImmutableList.of("Class.createForClass", "Class.createForPrimitive", "Class.createForInterface", "Class.createForEnum");
    private final Map<JBlock, JsCatch> catchMap = Maps.newIdentityHashMap();
    private final Set<JsName> catchParamIdentifiers = Sets.newHashSet();
    private final Map<JClassType, JsScope> classScopes = Maps.newIdentityHashMap();
    private Set<JMethod> crossClassTargets = null;
    private final JsScope interfaceScope;
    private final JsProgram jsProgram;
    private Set<JConstructor> liveCtors = null;
    private Predicate<JField> uninitializedValuePotentiallyObservable;
    private final Map<JAbstractMethodBody, JsFunction> jsFunctionsByJavaMethodBody = Maps.newIdentityHashMap();
    private final Map<HasName, JsName> names = Maps.newIdentityHashMap();
    private final JsScope objectScope;
    private final Map<JMethod, JsName> polymorphicNames = Maps.newIdentityHashMap();
    private final JProgram program;
    private Set<HasName> nameOfTargets = Sets.newHashSet();
    private final TreeLogger logger;
    private final Map<StandardSymbolData, JsName> symbolTable;
    private final JsScope topScope;
    private final Map<JsStatement, JDeclaredType> javaTypeByGlobalStatement = Maps.newHashMap();
    private final Map<JsStatement, JMethod> methodByGlobalStatement = Maps.newHashMap();
    private final ResolveRuntimeTypeReferences.TypeMapper<?> typeMapper;
    private final MinimalRebuildCache minimalRebuildCache;
    private final PermutationProperties properties;
    private JsFunction objectConstructorFunction;
    private OptionMethodNameDisplayMode.Mode methodNameMappingMode;
    private final boolean closureCompilerFormatEnabled;
    private final boolean optimize;
    private final boolean incremental;
    private final boolean stripStack;
    private final Map<JType, JDeclarationStatement> classLiteralDeclarationsByType = Maps.newLinkedHashMap();

    private void addVarsIfNotEmpty(JsVars vars) {
        if (!vars.isEmpty()) {
            this.getGlobalStatements().add(vars);
        }
    }

    private List<JsStatement> getGlobalStatements() {
        return this.jsProgram.getGlobalBlock().getStatements();
    }

    private static boolean doesNotHaveConcreteImplementation(JMethod method) {
        return method.isAbstract() || method.isJsNative() || JjsUtils.isJsMemberUnnecessaryAccidentalOverride(method) || JProgram.isClinit(method) && method.getEnclosingType().getClinitTarget() != method.getEnclosingType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Pair<JavaToJavaScriptMap, Set<JsNode>> exec(TreeLogger logger, JProgram program, JsProgram jsProgram, CompilerContext compilerContext, ResolveRuntimeTypeReferences.TypeMapper<?> typeMapper, Map<StandardSymbolData, JsName> symbolTable, PermutationProperties props) {
        SpeedTracerLogger.Event event = SpeedTracerLogger.start(CompilerEventType.GENERATE_JS_AST, new String[0]);
        try {
            GenerateJavaScriptAST generateJavaScriptAST = new GenerateJavaScriptAST(logger, program, jsProgram, compilerContext, typeMapper, symbolTable, props);
            Pair<JavaToJavaScriptMap, Set<JsNode>> pair = generateJavaScriptAST.execImpl();
            return pair;
        }
        finally {
            event.end(new String[0]);
        }
    }

    private GenerateJavaScriptAST(TreeLogger logger, JProgram program, JsProgram jsProgram, CompilerContext compilerContext, ResolveRuntimeTypeReferences.TypeMapper<?> typeMapper, Map<StandardSymbolData, JsName> symbolTable, PermutationProperties properties) {
        this.logger = logger;
        this.program = program;
        this.jsProgram = jsProgram;
        this.topScope = jsProgram.getScope();
        this.objectScope = jsProgram.getObjectScope();
        this.interfaceScope = new JsNormalScope(this.objectScope, "Interfaces");
        this.minimalRebuildCache = compilerContext.getMinimalRebuildCache();
        this.symbolTable = symbolTable;
        this.typeMapper = typeMapper;
        this.properties = properties;
        PrecompileTaskOptions options = compilerContext.getOptions();
        this.optimize = options.getOptimizationLevel() > 0;
        this.methodNameMappingMode = options.getMethodNameDisplayMode();
        assert (this.methodNameMappingMode != null);
        this.incremental = options.isIncrementalCompileEnabled();
        this.stripStack = JsStackEmulator.getStackMode(properties) == JsStackEmulator.StackMode.STRIP;
        this.closureCompilerFormatEnabled = options.isClosureCompilerFormatEnabled();
        this.objectConstructorFunction = new JsFunction(SourceOrigin.UNKNOWN, this.topScope, this.topScope.findExistingName("Object"));
    }

    JExpression getRuntimeTypeReference(JReferenceType type) {
        return this.typeMapper.get(type);
    }

    private String mangleName(JField x) {
        return JjsUtils.mangleMemberName(x.getEnclosingType().getName(), x.getName());
    }

    private String mangleNameForGlobal(JMethod method) {
        String s = JjsUtils.mangleMemberName(method.getEnclosingType().getName(), method.getName()) + "__";
        for (JType type : method.getOriginalParamTypes()) {
            s = s + type.getJavahSignatureName();
        }
        s = s + method.getOriginalReturnType().getJavahSignatureName();
        return StringInterner.get().intern(s);
    }

    private String mangleNameForPackagePrivatePoly(JMethod method) {
        assert (method.isPackagePrivate() && !method.isStatic());
        String mangledName = Joiner.on("$").join("package_private", JjsUtils.mangledNameString(method.getEnclosingType().getPackageName()), JjsUtils.mangledNameString(method));
        return StringInterner.get().intern(JjsUtils.constructManglingSignature(method, mangledName));
    }

    private String mangleNameForPoly(JMethod method) {
        if (method.isPrivate()) {
            return this.mangleNameForPrivatePoly(method);
        }
        if (method.isPackagePrivate()) {
            return this.mangleNameForPackagePrivatePoly(method);
        }
        return this.mangleNameForPublicPoly(method);
    }

    private String mangleNameForPublicPoly(JMethod method) {
        return StringInterner.get().intern(JjsUtils.constructManglingSignature(method, JjsUtils.mangledNameString(method)));
    }

    private String mangleNameForPrivatePoly(JMethod method) {
        assert (method.isPrivate() && !method.isStatic());
        String mangledName = Joiner.on("$").join("private", JjsUtils.mangledNameString(method.getEnclosingType()), JjsUtils.mangledNameString(method));
        return StringInterner.get().intern(JjsUtils.constructManglingSignature(method, mangledName));
    }

    private void contructTypeToClassLiteralDeclarationMap() {
        JMethodBody clinitBody = (JMethodBody)this.program.getTypeClassLiteralHolder().getClinitMethod().getBody();
        for (JStatement stmt : clinitBody.getStatements()) {
            if (!(stmt instanceof JDeclarationStatement)) continue;
            JDeclarationStatement classLiteralDeclaration = (JDeclarationStatement)stmt;
            JType type = this.program.getTypeByClassLiteralField((JField)((JDeclarationStatement)stmt).getVariableRef().getTarget());
            assert (!this.classLiteralDeclarationsByType.containsKey(type));
            this.classLiteralDeclarationsByType.put(type, classLiteralDeclaration);
        }
    }

    private Pair<JavaToJavaScriptMap, Set<JsNode>> execImpl() {
        NameClashesFixer.exec(this.program);
        this.uninitializedValuePotentiallyObservable = this.optimize ? ComputePotentiallyObservableUninitializedValues.analyze(this.program) : Predicates.alwaysTrue();
        new FindNameOfTargets().accept(this.program);
        new SortVisitor().accept(this.program);
        if (!this.incremental) {
            new RecordCrossClassCallsAndConstructorLiveness().accept(this.program);
        }
        this.contructTypeToClassLiteralDeclarationMap();
        new CreateNamesAndScopesVisitor().accept(this.program);
        new GenerateJavaScriptTransformer().transform(this.program);
        JavaToJavaScriptMapImpl jjsMap = new JavaToJavaScriptMapImpl(this.program.getDeclaredTypes(), this.names, this.javaTypeByGlobalStatement, this.methodByGlobalStatement);
        Set functionsForJsInlining = this.incremental ? Collections.emptySet() : new CollectJsFunctionsForInlining().getFunctionsForJsInlining();
        return Pair.create(jjsMap, functionsForJsInlining);
    }

    private JsFunction getJsFunctionFor(JMethod jMethod) {
        return this.jsFunctionsByJavaMethodBody.get(jMethod.getBody());
    }

    private JsName getIndexedMethodJsName(String indexedName) {
        return this.names.get(this.program.getIndexedMethod(indexedName));
    }

    private JsName getIndexedFieldJsName(String indexedName) {
        return this.names.get(this.program.getIndexedField(indexedName));
    }

    private JsNameRef createGlobalQualifier(String qualifier, SourceInfo sourceInfo) {
        ArrayList<String> parts = Lists.newArrayList(JsInteropUtil.normalizeQualifier(qualifier).split("\\."));
        String topScopeName = (String)parts.remove(0);
        JsNameRef ref = this.jsProgram.getScope().declareUnobfuscatableName(topScopeName).makeRef(sourceInfo);
        for (String part : parts) {
            ref = new JsNameRef(sourceInfo, part, ref);
        }
        return ref;
    }

    private static class SortVisitor
    extends JVisitor {
        private SortVisitor() {
        }

        @Override
        public void endVisit(JClassType x, Context ctx) {
            x.sortFields(HasName.BY_NAME_COMPARATOR);
            x.sortMethods(JMethod.BY_SIGNATURE_COMPARATOR);
        }

        @Override
        public void endVisit(JInterfaceType x, Context ctx) {
            x.sortFields(HasName.BY_NAME_COMPARATOR);
            x.sortMethods(JMethod.BY_SIGNATURE_COMPARATOR);
        }

        @Override
        public void endVisit(JMethodBody x, Context ctx) {
            x.sortLocals(HasName.BY_NAME_COMPARATOR);
        }

        @Override
        public void endVisit(JProgram x, Context ctx) {
            Collections.sort(x.getEntryMethods(), JMethod.BY_SIGNATURE_COMPARATOR);
            Collections.sort(x.getDeclaredTypes(), HasName.BY_NAME_COMPARATOR);
        }

        @Override
        public boolean visit(JMethodBody x, Context ctx) {
            return false;
        }
    }

    private class RecordCrossClassCallsAndConstructorLiveness
    extends JVisitor {
        private JMethod currentMethod;

        private RecordCrossClassCallsAndConstructorLiveness() {
            GenerateJavaScriptAST.this.crossClassTargets = Sets.newHashSet();
            GenerateJavaScriptAST.this.liveCtors = Sets.newIdentityHashSet();
        }

        @Override
        public void endVisit(JMethod x, Context ctx) {
            if (x.isJsInteropEntryPoint() || x.isStatic() && GenerateJavaScriptAST.this.program.getIndexedMethods().contains(x)) {
                if (x instanceof JConstructor) {
                    GenerateJavaScriptAST.this.liveCtors.add((JConstructor)x);
                }
                GenerateJavaScriptAST.this.crossClassTargets.add(x);
            }
            this.currentMethod = null;
        }

        @Override
        public void endVisit(JMethodCall x, Context ctx) {
            JDeclaredType targetType;
            JDeclaredType sourceType = this.currentMethod.getEnclosingType();
            if (sourceType.checkClinitTo(targetType = x.getTarget().getEnclosingType())) {
                GenerateJavaScriptAST.this.crossClassTargets.add(x.getTarget());
            }
        }

        @Override
        public void endVisit(JNewInstance x, Context ctx) {
            super.endVisit(x, ctx);
            GenerateJavaScriptAST.this.liveCtors.add(x.getTarget());
        }

        @Override
        public void endVisit(JProgram x, Context ctx) {
            GenerateJavaScriptAST.this.crossClassTargets.addAll(x.getEntryMethods());
        }

        @Override
        public void endVisit(JsniMethodRef x, Context ctx) {
            if (x.getTarget() instanceof JConstructor) {
                GenerateJavaScriptAST.this.liveCtors.add((JConstructor)x.getTarget());
            }
            this.endVisit((JMethodCall)x, ctx);
        }

        @Override
        public boolean visit(JMethod x, Context ctx) {
            this.currentMethod = x;
            return true;
        }
    }

    private class CollectJsFunctionsForInlining
    extends JVisitor {
        private Set<JsNode> functionsForJsInlining = Sets.newLinkedHashSet();
        private JMethod currentMethod;

        private CollectJsFunctionsForInlining() {
        }

        @Override
        public void endVisit(JMethod x, Context ctx) {
            if (x.isJsniMethod()) {
                JsFunction function = (JsFunction)GenerateJavaScriptAST.this.jsFunctionsByJavaMethodBody.get(x.getBody());
                if (function != null && function.getBody() != null) {
                    this.functionsForJsInlining.add(function);
                }
                assert (function != null);
                new JsModVisitor(){

                    @Override
                    public void endVisit(JsFunction x, JsContext ctx) {
                        CollectJsFunctionsForInlining.this.functionsForJsInlining.add(x);
                    }
                }.accept(function);
            }
            this.currentMethod = null;
        }

        @Override
        public void endVisit(JMethodCall x, Context ctx) {
            JsFunction function;
            JMethod target = x.getTarget();
            if (target.isInliningAllowed() && (target.isJsniMethod() || GenerateJavaScriptAST.this.program.getIndexedTypes().contains(target.getEnclosingType()) || target.getInliningMode() == InliningMode.FORCE_INLINE) && (function = (JsFunction)GenerateJavaScriptAST.this.jsFunctionsByJavaMethodBody.get(this.currentMethod.getBody())) != null && function.getBody() != null) {
                this.functionsForJsInlining.add(function);
            }
        }

        @Override
        public boolean visit(JMethod x, Context ctx) {
            this.currentMethod = x;
            return true;
        }

        public Set<JsNode> getFunctionsForJsInlining() {
            this.accept(GenerateJavaScriptAST.this.program);
            return this.functionsForJsInlining;
        }
    }

    private static class JavaToJsOperatorMap {
        private static final Map<JBinaryOperator, JsBinaryOperator> bOpMap = Maps.newEnumMap(JBinaryOperator.class);
        private static final Map<JUnaryOperator, JsUnaryOperator> uOpMap = Maps.newEnumMap(JUnaryOperator.class);

        private JavaToJsOperatorMap() {
        }

        public static JsBinaryOperator get(JBinaryOperator op) {
            return bOpMap.get((Object)op);
        }

        public static JsUnaryOperator get(JUnaryOperator op) {
            return uOpMap.get((Object)op);
        }

        static {
            bOpMap.put(JBinaryOperator.MUL, JsBinaryOperator.MUL);
            bOpMap.put(JBinaryOperator.DIV, JsBinaryOperator.DIV);
            bOpMap.put(JBinaryOperator.MOD, JsBinaryOperator.MOD);
            bOpMap.put(JBinaryOperator.ADD, JsBinaryOperator.ADD);
            bOpMap.put(JBinaryOperator.CONCAT, JsBinaryOperator.ADD);
            bOpMap.put(JBinaryOperator.SUB, JsBinaryOperator.SUB);
            bOpMap.put(JBinaryOperator.SHL, JsBinaryOperator.SHL);
            bOpMap.put(JBinaryOperator.SHR, JsBinaryOperator.SHR);
            bOpMap.put(JBinaryOperator.SHRU, JsBinaryOperator.SHRU);
            bOpMap.put(JBinaryOperator.LT, JsBinaryOperator.LT);
            bOpMap.put(JBinaryOperator.LTE, JsBinaryOperator.LTE);
            bOpMap.put(JBinaryOperator.GT, JsBinaryOperator.GT);
            bOpMap.put(JBinaryOperator.GTE, JsBinaryOperator.GTE);
            bOpMap.put(JBinaryOperator.EQ, JsBinaryOperator.EQ);
            bOpMap.put(JBinaryOperator.NEQ, JsBinaryOperator.NEQ);
            bOpMap.put(JBinaryOperator.BIT_AND, JsBinaryOperator.BIT_AND);
            bOpMap.put(JBinaryOperator.BIT_XOR, JsBinaryOperator.BIT_XOR);
            bOpMap.put(JBinaryOperator.BIT_OR, JsBinaryOperator.BIT_OR);
            bOpMap.put(JBinaryOperator.AND, JsBinaryOperator.AND);
            bOpMap.put(JBinaryOperator.OR, JsBinaryOperator.OR);
            bOpMap.put(JBinaryOperator.ASG, JsBinaryOperator.ASG);
            bOpMap.put(JBinaryOperator.ASG_ADD, JsBinaryOperator.ASG_ADD);
            bOpMap.put(JBinaryOperator.ASG_CONCAT, JsBinaryOperator.ASG_ADD);
            bOpMap.put(JBinaryOperator.ASG_SUB, JsBinaryOperator.ASG_SUB);
            bOpMap.put(JBinaryOperator.ASG_MUL, JsBinaryOperator.ASG_MUL);
            bOpMap.put(JBinaryOperator.ASG_DIV, JsBinaryOperator.ASG_DIV);
            bOpMap.put(JBinaryOperator.ASG_MOD, JsBinaryOperator.ASG_MOD);
            bOpMap.put(JBinaryOperator.ASG_SHL, JsBinaryOperator.ASG_SHL);
            bOpMap.put(JBinaryOperator.ASG_SHR, JsBinaryOperator.ASG_SHR);
            bOpMap.put(JBinaryOperator.ASG_SHRU, JsBinaryOperator.ASG_SHRU);
            bOpMap.put(JBinaryOperator.ASG_BIT_AND, JsBinaryOperator.ASG_BIT_AND);
            bOpMap.put(JBinaryOperator.ASG_BIT_OR, JsBinaryOperator.ASG_BIT_OR);
            bOpMap.put(JBinaryOperator.ASG_BIT_XOR, JsBinaryOperator.ASG_BIT_XOR);
            uOpMap.put(JUnaryOperator.INC, JsUnaryOperator.INC);
            uOpMap.put(JUnaryOperator.DEC, JsUnaryOperator.DEC);
            uOpMap.put(JUnaryOperator.NEG, JsUnaryOperator.NEG);
            uOpMap.put(JUnaryOperator.NOT, JsUnaryOperator.NOT);
            uOpMap.put(JUnaryOperator.BIT_NOT, JsUnaryOperator.BIT_NOT);
        }
    }

    private class GenerateJavaScriptTransformer
    extends JTransformer<JsNode> {
        public static final String GOOG_ABSTRACT_METHOD = "goog.abstractMethod";
        public static final String GOOG_INHERITS = "goog.inherits";
        public static final String GOOG_OBJECT_CREATE_SET = "goog.object.createSet";
        private final Set<JDeclaredType> alreadyRan = Sets.newLinkedHashSet();
        private final Map<JDeclaredType, JsFunction> clinitFunctionForType = Maps.newHashMap();
        private JMethod currentMethod = null;
        private final JsName arrayLength = GenerateJavaScriptAST.access$500(GenerateJavaScriptAST.this).declareUnobfuscatableName("length");
        private final JsName globalTemp = GenerateJavaScriptAST.access$100(GenerateJavaScriptAST.this).declareUnobfuscatableName("_");
        private final JsName prototype = GenerateJavaScriptAST.access$500(GenerateJavaScriptAST.this).declareUnobfuscatableName("prototype");
        private final JsName wnd = GenerateJavaScriptAST.access$100(GenerateJavaScriptAST.this).declareUnobfuscatableName("$wnd");
        private final JsName goog = GenerateJavaScriptAST.access$100(GenerateJavaScriptAST.this).declareUnobfuscatableName("goog");
        private final JsName global = GenerateJavaScriptAST.access$100(GenerateJavaScriptAST.this).declareUnobfuscatableName("global");

        private GenerateJavaScriptTransformer() {
        }

        @Override
        public JsExpression transformArrayLength(JArrayLength expression) {
            assert (expression.getInstance() != null) : "Can't access the length of a null array";
            return this.arrayLength.makeQualifiedRef(expression.getSourceInfo(), (JsExpression)this.transform(expression.getInstance()));
        }

        @Override
        public JsExpression transformArrayRef(JArrayRef arrayRef) {
            JsArrayAccess jsArrayAccess = new JsArrayAccess(arrayRef.getSourceInfo());
            jsArrayAccess.setIndexExpr((JsExpression)this.transform(arrayRef.getIndexExpr()));
            jsArrayAccess.setArrayExpr((JsExpression)this.transform(arrayRef.getInstance()));
            return jsArrayAccess;
        }

        @Override
        public JsExpression transformBinaryOperation(JBinaryOperation binaryOperation) {
            Object lhs = this.transform(binaryOperation.getLhs());
            Object rhs = this.transform(binaryOperation.getRhs());
            JsBinaryOperator op = JavaToJsOperatorMap.get(binaryOperation.getOp());
            if (binaryOperation.getLhs().getType() instanceof JReferenceType && binaryOperation.getRhs().getType() instanceof JReferenceType) {
                switch (op) {
                    case EQ: {
                        op = JsBinaryOperator.REF_EQ;
                        break;
                    }
                    case NEQ: {
                        op = JsBinaryOperator.REF_NEQ;
                    }
                }
            }
            return new JsBinaryOperation(binaryOperation.getSourceInfo(), op, (JsExpression)lhs, (JsExpression)rhs);
        }

        @Override
        public JsStatement transformBlock(JBlock block) {
            JsBlock jsBlock = new JsBlock(block.getSourceInfo());
            List<JsStatement> stmts = jsBlock.getStatements();
            this.transformIntoExcludingNulls(block.getStatements(), stmts);
            Iterables.removeIf(stmts, Predicates.instanceOf(JsEmpty.class));
            return jsBlock;
        }

        @Override
        public JsNode transformBreakStatement(JBreakStatement breakStatement) {
            SourceInfo info = breakStatement.getSourceInfo();
            return new JsBreak(info, this.transformIntoLabelReference(info, breakStatement.getLabel()));
        }

        @Override
        public JsNode transformCaseStatement(JCaseStatement caseStatement) {
            if (caseStatement.isDefault()) {
                return new JsDefault(caseStatement.getSourceInfo());
            }
            assert (caseStatement.getExprs().size() == 1) : "case must be normalized " + caseStatement;
            JsCase jsCase = new JsCase(caseStatement.getSourceInfo());
            jsCase.setCaseExpr((JsExpression)this.transform(caseStatement.getExprs().get(0)));
            return jsCase;
        }

        @Override
        public JsNode transformCastOperation(JCastOperation castOperation) {
            return this.transform(castOperation.getExpr());
        }

        @Override
        public JsNode transformClassLiteral(JClassLiteral classLiteral) {
            JsName classLit = (JsName)GenerateJavaScriptAST.this.names.get(classLiteral.getField());
            return classLit.makeRef(classLiteral.getSourceInfo());
        }

        @Override
        public JsNode transformDeclaredType(JDeclaredType type) {
            if (GenerateJavaScriptAST.this.program.isReferenceOnly(type)) {
                return null;
            }
            if (this.alreadyRan.contains(type)) {
                return null;
            }
            this.alreadyRan.add(type);
            if (type.isJsNative()) {
                this.emitStaticMethods(type);
                this.emitFields(type);
                return null;
            }
            this.checkForDuplicateMethods(type);
            assert (GenerateJavaScriptAST.this.program.getTypeClassLiteralHolder() != type);
            assert (!((GenerateJavaScriptAST)GenerateJavaScriptAST.this).program.immortalCodeGenTypes.contains(type));
            assert (type.getSuperClass() == null || GenerateJavaScriptAST.this.program.isReferenceOnly(type.getSuperClass()) || this.alreadyRan.contains(type.getSuperClass()));
            this.emitStaticMethods(type);
            this.generateTypeSetup(type);
            this.emitFields(type);
            return null;
        }

        @Override
        public JsNode transformConditional(JConditional conditional) {
            Object ifTest = this.transform(conditional.getIfTest());
            Object thenExpr = this.transform(conditional.getThenExpr());
            Object elseExpr = this.transform(conditional.getElseExpr());
            return new JsConditional(conditional.getSourceInfo(), (JsExpression)ifTest, (JsExpression)thenExpr, (JsExpression)elseExpr);
        }

        @Override
        public JsNode transformContinueStatement(JContinueStatement continueStatement) {
            SourceInfo info = continueStatement.getSourceInfo();
            return new JsContinue(info, this.transformIntoLabelReference(info, continueStatement.getLabel()));
        }

        @Override
        public JsNode transformDebuggerStatement(JDebuggerStatement debuggerStatement) {
            return new JsDebugger(debuggerStatement.getSourceInfo());
        }

        @Override
        public JsNode transformDeclarationStatement(JDeclarationStatement declarationStatement) {
            if (declarationStatement.getInitializer() == null) {
                return null;
            }
            JVariable target = declarationStatement.getVariableRef().getTarget();
            if (target instanceof JField && this.initializeAtTopScope((JField)target)) {
                return null;
            }
            Object initializer = this.transform(declarationStatement.getInitializer());
            JsNameRef localRef = (JsNameRef)this.transform(declarationStatement.getVariableRef());
            SourceInfo info = declarationStatement.getSourceInfo();
            return JsUtils.createAssignment(info, localRef, initializer).makeStmt();
        }

        @Override
        public JsNode transformDoStatement(JDoStatement doStatement) {
            JsDoWhile stmt = new JsDoWhile(doStatement.getSourceInfo());
            stmt.setCondition((JsExpression)this.transform(doStatement.getTestExpr()));
            stmt.setBody(this.jsEmptyIfNull(doStatement.getSourceInfo(), (JsStatement)this.transform(doStatement.getBody())));
            return stmt;
        }

        @Override
        public JsNode transformExpressionStatement(JExpressionStatement statement) {
            if (statement.getExpr() instanceof JSwitchExpression) {
                if (statement.getExpr().getType() == JPrimitiveType.VOID) {
                    return this.transformSwitchStatement(new JSwitchStatement((JSwitchExpression)statement.getExpr()));
                }
                throw new IllegalStateException("top-level switch expr");
            }
            return ((JsExpression)this.transform(statement.getExpr())).makeStmt();
        }

        @Override
        public JsNode transformFieldRef(JFieldRef fieldRef) {
            Object qualifier = this.transform(fieldRef.getInstance());
            boolean isStatic = fieldRef.getField().isStatic();
            return isStatic ? this.dispatchToStaticField(fieldRef, (JsExpression)qualifier) : this.dispatchToInstanceField(fieldRef, (JsExpression)qualifier);
        }

        private JsExpression dispatchToStaticField(JFieldRef fieldRef, JsExpression unnecessaryQualifier) {
            JsNameRef result = this.createStaticReference(fieldRef.getField(), fieldRef.getSourceInfo());
            return JsUtils.createCommaExpression(unnecessaryQualifier, this.maybeCreateClinitCall(fieldRef.getField()), result);
        }

        private JsExpression dispatchToInstanceField(JFieldRef x, JsExpression instance) {
            return ((JsName)GenerateJavaScriptAST.this.names.get(x.getField())).makeQualifiedRef(x.getSourceInfo(), instance);
        }

        @Override
        public JsNode transformForStatement(JForStatement forStatement) {
            JsFor result = new JsFor(forStatement.getSourceInfo());
            JsExpression initExpr = null;
            List initStmts = this.transform(forStatement.getInitializers());
            for (int i = 0; i < initStmts.size(); ++i) {
                JsExprStmt initStmt = (JsExprStmt)initStmts.get(i);
                if (initStmt == null) continue;
                initExpr = JsUtils.createCommaExpression(initExpr, initStmt.getExpression());
            }
            result.setInitExpr(initExpr);
            result.setCondition((JsExpression)this.transform(forStatement.getCondition()));
            result.setIncrExpr((JsExpression)this.transform(forStatement.getIncrements()));
            result.setBody(this.jsEmptyIfNull(forStatement.getSourceInfo(), (JsStatement)this.transform(forStatement.getBody())));
            return result;
        }

        @Override
        public JsNode transformIfStatement(JIfStatement ifStatement) {
            JsIf result = new JsIf(ifStatement.getSourceInfo());
            result.setIfExpr((JsExpression)this.transform(ifStatement.getIfExpr()));
            result.setThenStmt(this.jsEmptyIfNull(ifStatement.getSourceInfo(), (JsStatement)this.transform(ifStatement.getThenStmt())));
            result.setElseStmt((JsStatement)this.transform(ifStatement.getElseStmt()));
            return result;
        }

        @Override
        public JsLabel transformLabel(JLabel label) {
            return new JsLabel(label.getSourceInfo(), (JsName)GenerateJavaScriptAST.this.names.get(label));
        }

        @Override
        public JsStatement transformLabeledStatement(JLabeledStatement labeledStatement) {
            JsLabel label = (JsLabel)this.transform(labeledStatement.getLabel());
            label.setStmt((JsStatement)this.transform(labeledStatement.getBody()));
            return label;
        }

        @Override
        public JsLiteral transformLiteral(JLiteral literal) {
            return JjsUtils.translateLiteral(literal);
        }

        @Override
        public JsNode transformLocalRef(JLocalRef localRef) {
            return ((JsName)GenerateJavaScriptAST.this.names.get(localRef.getTarget())).makeRef(localRef.getSourceInfo());
        }

        @Override
        public JsNode transformMethod(JMethod method) {
            JsInvocation jsInvocation;
            if (method.isAbstract()) {
                return this.generateAbstractMethodDefinition(method);
            }
            if (GenerateJavaScriptAST.doesNotHaveConcreteImplementation(method)) {
                return null;
            }
            this.currentMethod = method;
            JsFunction function = (JsFunction)this.transform(method.getBody());
            function.setInliningMode(method.getInliningMode());
            if (!method.isJsniMethod()) {
                List<JParameter> parameterList = method.getParams();
                if (method.isJsMethodVarargs()) {
                    parameterList = parameterList.subList(0, parameterList.size() - 1);
                }
                this.transformInto(parameterList, function.getParameters());
            }
            if ((jsInvocation = this.maybeCreateClinitCall(method)) != null) {
                function.getBody().getStatements().add(0, jsInvocation.makeStmt());
            }
            if (JProgram.isClinit(method)) {
                function.markAsClinit();
            }
            this.currentMethod = null;
            return function;
        }

        @Override
        public JsNode transformMethodBody(JMethodBody methodBody) {
            JsBlock body = this.transform(methodBody.getBlock());
            JsFunction function = (JsFunction)GenerateJavaScriptAST.this.jsFunctionsByJavaMethodBody.get(methodBody);
            function.setBody(body);
            JsVars vars = new JsVars(methodBody.getSourceInfo(), new JsVars.JsVar[0]);
            HashSet<String> alreadySeen = Sets.newHashSet();
            for (JLocal local : methodBody.getLocals()) {
                JsName name = (JsName)GenerateJavaScriptAST.this.names.get(local);
                String ident = name.getIdent();
                if (alreadySeen.contains(ident) || GenerateJavaScriptAST.this.catchParamIdentifiers.contains(name)) continue;
                alreadySeen.add(ident);
                vars.add(new JsVars.JsVar(methodBody.getSourceInfo(), name));
            }
            if (!vars.isEmpty()) {
                function.getBody().getStatements().add(0, vars);
            }
            return function;
        }

        @Override
        public JsNode transformMethodCall(JMethodCall methodCall) {
            JMethod method = methodCall.getTarget();
            if (JProgram.isClinit(method)) {
                JDeclaredType type = method.getEnclosingType();
                JDeclaredType clinitTarget = type.getClinitTarget();
                if (clinitTarget == null) {
                    return JsNullLiteral.INSTANCE;
                }
                method = clinitTarget.getClinitMethod();
            }
            Object qualifier = this.transform(methodCall.getInstance());
            List<JsExpression> args = this.transform(methodCall.getArgs());
            SourceInfo sourceInfo = methodCall.getSourceInfo();
            if (method.isStatic()) {
                return this.dispatchToStatic((JsExpression)qualifier, method, args, sourceInfo);
            }
            if (methodCall.isStaticDispatchOnly()) {
                return this.dispatchToSuper((JsExpression)qualifier, method, args, sourceInfo);
            }
            if (method.isOrOverridesJsFunctionMethod()) {
                return this.dispatchToJsFunction((JsExpression)qualifier, method, args, sourceInfo);
            }
            return this.dispatchToInstanceMethod((JsExpression)qualifier, method, args, sourceInfo);
        }

        private JsExpression dispatchToStatic(JsExpression unnecessaryQualifier, JMethod method, List<JsExpression> args, SourceInfo sourceInfo) {
            JsNameRef methodName = this.createStaticReference(method, sourceInfo);
            return JsUtils.createCommaExpression(unnecessaryQualifier, JsUtils.createInvocationOrPropertyAccess(JsUtils.InvocationStyle.NORMAL, sourceInfo, method, null, methodName, args));
        }

        private JsExpression dispatchToSuper(JsExpression instance, JMethod method, List<JsExpression> args, SourceInfo sourceInfo) {
            JsNameRef methodNameRef;
            if (method.isJsNative()) {
                methodNameRef = GenerateJavaScriptAST.this.createGlobalQualifier(method.getQualifiedJsName(), sourceInfo);
            } else if (method.isConstructor()) {
                methodNameRef = ((JsName)GenerateJavaScriptAST.this.names.get(method)).makeRef(sourceInfo);
            } else {
                JDeclaredType superClass = method.getEnclosingType();
                JsExpression protoRef = this.getPrototypeQualifierViaLookup(superClass, sourceInfo);
                methodNameRef = ((JsName)GenerateJavaScriptAST.this.polymorphicNames.get(method)).makeQualifiedRef(sourceInfo, protoRef);
            }
            return JsUtils.createInvocationOrPropertyAccess(JsUtils.InvocationStyle.SUPER, sourceInfo, method, instance, methodNameRef, args);
        }

        private JsExpression getPrototypeQualifierViaLookup(JDeclaredType type, SourceInfo sourceInfo) {
            if (GenerateJavaScriptAST.this.closureCompilerFormatEnabled) {
                return this.getPrototypeQualifierOf(type, type.getSourceInfo());
            }
            return this.constructInvocation(sourceInfo, "Runtime.getClassPrototype", new JsExpression[]{this.transform(GenerateJavaScriptAST.this.getRuntimeTypeReference(type))});
        }

        private JsExpression dispatchToJsFunction(JsExpression instance, JMethod method, List<JsExpression> args, SourceInfo sourceInfo) {
            return JsUtils.createInvocationOrPropertyAccess(JsUtils.InvocationStyle.FUNCTION, sourceInfo, method, instance, null, args);
        }

        private JsExpression dispatchToInstanceMethod(JsExpression instance, JMethod method, List<JsExpression> args, SourceInfo sourceInfo) {
            JsNameRef reference = ((JsName)GenerateJavaScriptAST.this.polymorphicNames.get(method)).makeQualifiedRef(sourceInfo, instance);
            return JsUtils.createInvocationOrPropertyAccess(JsUtils.InvocationStyle.NORMAL, sourceInfo, method, instance, reference, args);
        }

        @Override
        public JsNode transformMultiExpression(JMultiExpression multiExpression) {
            if (multiExpression.isEmpty()) {
                return JsRootScope.INSTANCE.getUndefined().makeRef(multiExpression.getSourceInfo());
            }
            List exprs = this.transform(multiExpression.getExpressions());
            JsExpression cur = null;
            for (int i = 0; i < exprs.size(); ++i) {
                JsExpression next = (JsExpression)exprs.get(i);
                cur = JsUtils.createCommaExpression(cur, next);
            }
            return cur;
        }

        @Override
        public JsNode transformNameOf(JNameOf nameof) {
            JsName name = (JsName)GenerateJavaScriptAST.this.names.get(nameof.getNode());
            if (name == null) {
                return JsRootScope.INSTANCE.getUndefined().makeRef(nameof.getSourceInfo());
            }
            return new JsNameOf(nameof.getSourceInfo(), name);
        }

        @Override
        public JsNode transformNewInstance(JNewInstance newInstance) {
            SourceInfo sourceInfo = newInstance.getSourceInfo();
            JConstructor ctor = newInstance.getTarget();
            JsName ctorName = (JsName)GenerateJavaScriptAST.this.names.get(ctor);
            JsNameRef reference = ctor.isJsNative() ? GenerateJavaScriptAST.this.createGlobalQualifier(ctor.getQualifiedJsName(), sourceInfo) : ctorName.makeRef(sourceInfo);
            List<JsExpression> arguments = this.transform(newInstance.getArgs());
            if (newInstance.getClassType().isJsFunctionImplementation()) {
                return this.constructJsFunctionObject(sourceInfo, newInstance.getClassType(), ctorName, reference, new JsArrayLiteral(sourceInfo, arguments));
            }
            return JsUtils.createInvocationOrPropertyAccess(JsUtils.InvocationStyle.NEWINSTANCE, sourceInfo, ctor, null, reference, arguments);
        }

        private JsExpression constructJsFunctionObject(SourceInfo sourceInfo, JClassType type, JsName ctorName, JsNameRef ctorReference, JsExpression ctorArguments) {
            JMethod jsFunctionMethod = this.getJsFunctionMethod(type);
            JsNameRef funcNameRef = JsUtils.createQualifiedNameRef(sourceInfo, ctorName, this.prototype, (JsName)GenerateJavaScriptAST.this.polymorphicNames.get(jsFunctionMethod));
            return this.constructInvocation(sourceInfo, "Runtime.makeLambdaFunction", funcNameRef, ctorReference, ctorArguments);
        }

        private JMethod getJsFunctionMethod(JClassType type) {
            for (JMethod method : type.getMethods()) {
                if (!method.isOrOverridesJsFunctionMethod()) continue;
                return method;
            }
            throw new AssertionError((Object)"Should never reach here.");
        }

        @Override
        public JsNode transformNumericEntry(JNumericEntry entry) {
            return new JsNumericEntry(entry.getSourceInfo(), entry.getKey(), entry.getValue());
        }

        @Override
        public JsNode transformParameter(JParameter parameter) {
            assert (!this.currentMethod.isJsMethodVarargs() || !parameter.isVarargs());
            return new JsParameter(parameter.getSourceInfo(), (JsName)GenerateJavaScriptAST.this.names.get(parameter));
        }

        @Override
        public JsNode transformParameterRef(JParameterRef parameterRef) {
            return ((JsName)GenerateJavaScriptAST.this.names.get(parameterRef.getTarget())).makeRef(parameterRef.getSourceInfo());
        }

        @Override
        public JsNode transformPermutationDependentValue(JPermutationDependentValue dependentValue) {
            throw new AssertionError((Object)("AST should not contain permutation dependent values at this point but contains " + dependentValue));
        }

        @Override
        public JsNode transformPostfixOperation(JPostfixOperation expression) {
            return new JsPostfixOperation(expression.getSourceInfo(), JavaToJsOperatorMap.get(expression.getOp()), (JsExpression)this.transform(expression.getArg()));
        }

        @Override
        public JsNode transformPrefixOperation(JPrefixOperation expression) {
            return new JsPrefixOperation(expression.getSourceInfo(), JavaToJsOperatorMap.get(expression.getOp()), (JsExpression)this.transform(expression.getArg()));
        }

        private void embedBindingProperties() {
            SourceOrigin sourceInfo = SourceOrigin.UNKNOWN;
            JsArrayLiteral permutationProperties = new JsArrayLiteral((SourceInfo)sourceInfo, new JsExpression[0]);
            for (Map map : GenerateJavaScriptAST.this.properties.findEmbeddedProperties(TreeLogger.NULL)) {
                JsArrayLiteral entryList = new JsArrayLiteral((SourceInfo)sourceInfo, new JsExpression[0]);
                for (Map.Entry entry : map.entrySet()) {
                    JsArrayLiteral pair = new JsArrayLiteral((SourceInfo)sourceInfo, new JsStringLiteral(sourceInfo, (String)entry.getKey()), new JsStringLiteral(sourceInfo, (String)entry.getValue()));
                    entryList.getExpressions().add(pair);
                }
                permutationProperties.getExpressions().add(entryList);
            }
            GenerateJavaScriptAST.this.getGlobalStatements().add(this.constructInvocation((SourceInfo)sourceInfo, "ModuleUtils.setGwtProperty", new JsStringLiteral(sourceInfo, "permProps"), permutationProperties).makeStmt());
        }

        @Override
        public JsNode transformReturnStatement(JReturnStatement returnStatement) {
            return new JsReturn(returnStatement.getSourceInfo(), (JsExpression)this.transform(returnStatement.getExpr()));
        }

        @Override
        public JsNode transformRunAsync(JRunAsync runAsync) {
            return this.transform(runAsync.getRunAsyncCall());
        }

        @Override
        public JsNode transformCastMap(JCastMap castMap) {
            SourceInfo sourceInfo = castMap.getSourceInfo();
            List<JsExpression> jsCastToTypes = this.transform(castMap.getCanCastToTypes());
            return this.buildJsCastMapLiteral(jsCastToTypes, sourceInfo);
        }

        @Override
        public JsNameRef transformJsniMethodRef(JsniMethodRef jsniMethodRef) {
            JMethod method = jsniMethodRef.getTarget();
            if (method.isJsNative()) {
                return GenerateJavaScriptAST.this.createGlobalQualifier(method.getQualifiedJsName(), jsniMethodRef.getSourceInfo());
            }
            return ((JsName)GenerateJavaScriptAST.this.names.get(method)).makeRef(jsniMethodRef.getSourceInfo());
        }

        @Override
        public JsArrayLiteral transformJsonArray(JsonArray jsonArray) {
            JsArrayLiteral jsArrayLiteral = new JsArrayLiteral(jsonArray.getSourceInfo(), new JsExpression[0]);
            this.transformInto(jsonArray.getExpressions(), jsArrayLiteral.getExpressions());
            return jsArrayLiteral;
        }

        @Override
        public JsNode transformThisRef(JThisRef thisRef) {
            return new JsThisRef(thisRef.getSourceInfo());
        }

        @Override
        public JsNode transformThrowStatement(JThrowStatement throwStatement) {
            return new JsThrow(throwStatement.getSourceInfo(), (JsExpression)this.transform(throwStatement.getExpr()));
        }

        @Override
        public JsNode transformTryStatement(JTryStatement tryStatement) {
            JsBlock finallyBlock;
            JsTry jsTry = new JsTry(tryStatement.getSourceInfo());
            jsTry.setTryBlock(this.transform(tryStatement.getTryBlock()));
            int size = tryStatement.getCatchClauses().size();
            assert (size < 2);
            if (size == 1) {
                JBlock block = tryStatement.getCatchClauses().get(0).getBlock();
                JsCatch jsCatch = (JsCatch)GenerateJavaScriptAST.this.catchMap.get(block);
                jsCatch.setBody(this.transform(block));
                jsTry.getCatches().add(jsCatch);
            }
            if ((finallyBlock = this.transform(tryStatement.getFinallyBlock())) != null && finallyBlock.getStatements().size() > 0) {
                jsTry.setFinallyBlock(finallyBlock);
            }
            return jsTry;
        }

        @Override
        public JsNode transformUnsafeTypeCoercion(JUnsafeTypeCoercion unsafeTypeCoercion) {
            return this.transform(unsafeTypeCoercion.getExpression());
        }

        @Override
        public JsNode transformWhileStatement(JWhileStatement whileStatement) {
            SourceInfo info = whileStatement.getSourceInfo();
            JsWhile stmt = new JsWhile(info);
            stmt.setCondition((JsExpression)this.transform(whileStatement.getTestExpr()));
            stmt.setBody(this.jsEmptyIfNull(info, (JsStatement)this.transform(whileStatement.getBody())));
            return stmt;
        }

        public JsStatement jsEmptyIfNull(SourceInfo info, JsStatement statement) {
            return statement != null ? statement : new JsEmpty(info);
        }

        private void insertInTopologicalOrder(JDeclaredType type, Set<JDeclaredType> topologicallySortedSet) {
            if (type == null || topologicallySortedSet.contains(type) || GenerateJavaScriptAST.this.program.isReferenceOnly(type)) {
                return;
            }
            this.insertInTopologicalOrder(type.getSuperClass(), topologicallySortedSet);
            for (JInterfaceType intf : type.getImplements()) {
                if (!((GenerateJavaScriptAST)GenerateJavaScriptAST.this).program.typeOracle.isInstantiatedType(type)) continue;
                this.insertInTopologicalOrder(intf, topologicallySortedSet);
            }
            topologicallySortedSet.add(type);
        }

        @Override
        public JsNode transformProgram(JProgram program) {
            Set<JDeclaredType> preambleTypes = this.generatePreamble(program);
            if (GenerateJavaScriptAST.this.incremental && !GenerateJavaScriptAST.this.minimalRebuildCache.hasPreambleTypeNames()) {
                HashSet<String> preambleTypeNames = Sets.newHashSet();
                for (JDeclaredType preambleType : preambleTypes) {
                    preambleTypeNames.add(preambleType.getName());
                }
                GenerateJavaScriptAST.this.minimalRebuildCache.setPreambleTypeNames(GenerateJavaScriptAST.this.logger, preambleTypeNames);
            }
            LinkedHashSet<JDeclaredType> topologicallySortedBodyTypes = Sets.newLinkedHashSet();
            for (JDeclaredType type : program.getModuleDeclaredTypes()) {
                this.insertInTopologicalOrder(type, topologicallySortedBodyTypes);
            }
            topologicallySortedBodyTypes.removeAll(preambleTypes);
            this.markPosition("Program", JsPositionMarker.Type.PROGRAM_START);
            for (JDeclaredType type : topologicallySortedBodyTypes) {
                this.markPosition(type.getName(), JsPositionMarker.Type.CLASS_START);
                this.transform(type);
                this.maybeGenerateClassLiteral(type);
                this.installClassLiterals(Arrays.asList(type));
                this.markPosition(type.getName(), JsPositionMarker.Type.CLASS_END);
            }
            this.markPosition("Program", JsPositionMarker.Type.PROGRAM_END);
            this.generateEpilogue();
            return null;
        }

        private Set<JDeclaredType> generatePreamble(JProgram program) {
            SourceInfo programSourceInfo = GenerateJavaScriptAST.this.jsProgram.getSourceInfo();
            JsVars vars = new JsVars(programSourceInfo, new JsVars.JsVar(programSourceInfo, this.globalTemp));
            GenerateJavaScriptAST.this.addVarsIfNotEmpty(vars);
            this.generateImmortalTypes(vars);
            this.generateGoogGlobalInitialization(programSourceInfo);
            this.addTypeDefinitionStatement(program.getIndexedType("Runtime"), this.constructInvocation(program.getSourceInfo(), "Runtime.bootstrap", new JsExpression[0]).makeStmt());
            LinkedHashSet<JDeclaredType> alreadyProcessed = Sets.newLinkedHashSet(program.immortalCodeGenTypes);
            alreadyProcessed.add(program.getTypeClassLiteralHolder());
            this.alreadyRan.addAll(alreadyProcessed);
            List<JDeclaredType> classLiteralSupportClasses = this.computeClassLiteralsSupportClasses(program, alreadyProcessed);
            classLiteralSupportClasses.removeAll(alreadyProcessed);
            for (JDeclaredType type : classLiteralSupportClasses) {
                this.transform(type);
            }
            this.generateClassLiterals(classLiteralSupportClasses);
            this.installClassLiterals(classLiteralSupportClasses);
            LinkedHashSet<JDeclaredType> preambleTypes = Sets.newLinkedHashSet(alreadyProcessed);
            preambleTypes.addAll(classLiteralSupportClasses);
            return preambleTypes;
        }

        private void generateGoogGlobalInitialization(SourceInfo programSourceInfo) {
            JsNameRef wndGoog = this.goog.makeQualifiedRef(programSourceInfo, this.wnd.makeRef(programSourceInfo));
            this.generatePropertyInitialization(programSourceInfo, wndGoog, JsObjectLiteral.builder(programSourceInfo).build());
            JsNameRef wndGoogGlobal = this.global.makeQualifiedRef(programSourceInfo, wndGoog);
            this.generatePropertyInitialization(programSourceInfo, wndGoogGlobal, this.wnd.makeRef(programSourceInfo));
        }

        private void generatePropertyInitialization(SourceInfo sourceInfo, JsNameRef qualifiedNameRef, JsExpression initializer) {
            GenerateJavaScriptAST.this.getGlobalStatements().add(new JsBinaryOperation(sourceInfo, JsBinaryOperator.ASG, qualifiedNameRef, new JsBinaryOperation(sourceInfo, JsBinaryOperator.OR, qualifiedNameRef, initializer)).makeStmt());
        }

        private JsNameRef transformIntoLabelReference(SourceInfo info, JLabel label) {
            if (label == null) {
                return null;
            }
            return ((JsLabel)this.transform(label)).getName().makeRef(info);
        }

        private void installClassLiterals(List<JDeclaredType> classLiteralTypesToInstall) {
            if (!GenerateJavaScriptAST.this.closureCompilerFormatEnabled) {
                return;
            }
            for (JDeclaredType type : classLiteralTypesToInstall) {
                JsNameRef classLiteralRef;
                if (this.shouldNotEmitTypeDefinition(type) || (classLiteralRef = this.createClassLiteralReference(type)) == null) continue;
                SourceInfo sourceInfo = type.getSourceInfo();
                JsNameRef protoRef = this.getPrototypeQualifierOf(type, sourceInfo);
                JsNameRef clazzField = GenerateJavaScriptAST.this.getIndexedFieldJsName("Object.___clazz").makeRef(sourceInfo);
                clazzField.setQualifier(protoRef);
                JsExprStmt stmt = JsUtils.createAssignment(clazzField, classLiteralRef).makeStmt();
                this.addTypeDefinitionStatement(type, stmt);
            }
        }

        private boolean shouldNotEmitTypeDefinition(JDeclaredType type) {
            return type instanceof JInterfaceType && !GenerateJavaScriptAST.this.closureCompilerFormatEnabled || GenerateJavaScriptAST.this.program.isRepresentedAsNativeJsPrimitive(type) || !((GenerateJavaScriptAST)GenerateJavaScriptAST.this).program.typeOracle.isInstantiatedType(type) || type.isJsoType() || type.isJsNative() || type.isJsFunction();
        }

        private List<JDeclaredType> computeClassLiteralsSupportClasses(JProgram program, Set<JDeclaredType> alreadyProcessedTypes) {
            if (program.isReferenceOnly(program.getIndexedType("Class"))) {
                return Collections.emptyList();
            }
            SortedSet<JDeclaredType> reachableClasses = this.computeReachableTypes(METHODS_PROVIDED_BY_PREAMBLE);
            assert (!GenerateJavaScriptAST.this.incremental || this.checkCoreModulePreambleComplete(program, program.getTypeClassLiteralHolder().getClinitMethod()));
            LinkedHashSet<JDeclaredType> orderedPreambleClasses = Sets.newLinkedHashSet();
            for (JDeclaredType type : reachableClasses) {
                if (alreadyProcessedTypes.contains(type)) continue;
                this.insertInTopologicalOrder(type, orderedPreambleClasses);
            }
            return Lists.newArrayList(orderedPreambleClasses);
        }

        private boolean checkCoreModulePreambleComplete(JProgram program, JMethod classLiteralInitMethod) {
            final HashSet calledMethods = Sets.newHashSet();
            new JVisitor(){

                @Override
                public void endVisit(JMethodCall x, Context ctx) {
                    calledMethods.add(x.getTarget());
                }
            }.accept(classLiteralInitMethod);
            for (String createForMethodName : METHODS_PROVIDED_BY_PREAMBLE) {
                if (calledMethods.contains(program.getIndexedMethod(createForMethodName))) continue;
                return false;
            }
            return true;
        }

        private SortedSet<JDeclaredType> computeReachableTypes(Iterable<String> methodNames) {
            ControlFlowAnalyzer cfa = new ControlFlowAnalyzer(GenerateJavaScriptAST.this.program);
            for (String methodName : methodNames) {
                JMethod method = GenerateJavaScriptAST.this.program.getIndexedMethodOrNull(methodName);
                if (method == null) continue;
                cfa.traverseFrom(method);
            }
            ImmutableSortedSet<JDeclaredType> reachableTypes = ImmutableSortedSet.copyOf(HasName.BY_NAME_COMPARATOR, Iterables.filter(Iterables.transform(cfa.getLiveFieldsAndMethods(), new Function<JNode, JDeclaredType>(){

                @Override
                public JDeclaredType apply(JNode member) {
                    if (member instanceof JMethod) {
                        return ((JMethod)member).getEnclosingType();
                    }
                    if (member instanceof JField) {
                        return ((JField)member).getEnclosingType();
                    }
                    assert (member instanceof JParameter || member instanceof JLocal);
                    return null;
                }
            }), Predicates.notNull()));
            return reachableTypes;
        }

        private JsExpression generateAbstractMethodDefinition(JMethod method) {
            return GenerateJavaScriptAST.this.closureCompilerFormatEnabled ? JsUtils.createQualifiedNameRef(GOOG_ABSTRACT_METHOD, method.getSourceInfo()) : null;
        }

        private void generateEpilogue() {
            this.generateRemainingClassLiterals();
            this.generateExports();
            this.setupGwtOnLoad();
            this.embedBindingProperties();
        }

        private void generateRemainingClassLiterals() {
            if (!GenerateJavaScriptAST.this.incremental) {
                this.generateClassLiterals(Iterables.filter(GenerateJavaScriptAST.this.classLiteralDeclarationsByType.keySet(), Predicates.not(Predicates.in(this.alreadyRan))));
                return;
            }
            assert (FluentIterable.from(GenerateJavaScriptAST.this.classLiteralDeclarationsByType.keySet()).filter(Predicates.instanceOf(JDeclaredType.class)).filter(Predicates.not(Predicates.in(this.alreadyRan))).filter((Predicate<JDeclaredType>)new Predicate<JType>(){

                @Override
                public boolean apply(JType type) {
                    return !GenerateJavaScriptAST.this.program.isReferenceOnly((JDeclaredType)type);
                }
            }).isEmpty());
            this.generateClassLiterals(JPrimitiveType.types);
        }

        private void generateClassLiterals(Iterable<? extends JType> orderedTypes) {
            for (JType jType : orderedTypes) {
                this.maybeGenerateClassLiteral(jType);
            }
        }

        private void generateExports() {
            TreeMap<String, CanHaveSuppressedWarnings> exportedMembersByExportName = new TreeMap<String, CanHaveSuppressedWarnings>();
            HashSet<JDeclaredType> hoistedClinits = Sets.newHashSet();
            JsInteropExportsGenerator exportGenerator = GenerateJavaScriptAST.this.closureCompilerFormatEnabled ? new ClosureJsInteropExportsGenerator(GenerateJavaScriptAST.this.getGlobalStatements(), GenerateJavaScriptAST.this.names) : new DefaultJsInteropExportsGenerator(GenerateJavaScriptAST.this.getGlobalStatements(), this.globalTemp, GenerateJavaScriptAST.this.getIndexedMethodJsName("Runtime.provide"));
            for (JDeclaredType type : GenerateJavaScriptAST.this.program.getDeclaredTypes()) {
                if (type.isJsNative()) continue;
                if (type.isJsType()) {
                    exportedMembersByExportName.put(type.getQualifiedJsName(), type);
                }
                for (JMember member : type.getMembers()) {
                    if (!member.isJsInteropEntryPoint()) continue;
                    if (member.getJsMemberType() == HasJsInfo.JsMemberType.PROPERTY && !member.isFinal()) {
                        GenerateJavaScriptAST.this.logger.log(TreeLogger.Type.WARN, "Exporting effectively non-final field " + member.getQualifiedName() + ". Due to the way exporting works, the value of the exported field will not be reflected across Java/JavaScript border.");
                    }
                    exportedMembersByExportName.put(member.getQualifiedJsName(), member);
                }
            }
            for (JDeclaredType exportedEntity : exportedMembersByExportName.values()) {
                if (exportedEntity instanceof JDeclaredType) {
                    exportGenerator.exportType(exportedEntity);
                    continue;
                }
                JMember member = (JMember)((Object)exportedEntity);
                this.maybeHoistClinit(hoistedClinits, member);
                exportGenerator.exportMember(member, ((JsName)GenerateJavaScriptAST.this.names.get(member)).makeRef(member.getSourceInfo()));
            }
        }

        private void maybeHoistClinit(Set<JDeclaredType> hoistedClinits, JMember member) {
            JsInvocation clinitCall;
            JDeclaredType enclosingType = member.getEnclosingType();
            if (hoistedClinits.contains(enclosingType)) {
                return;
            }
            JsInvocation jsInvocation = clinitCall = member instanceof JMethod ? this.maybeCreateClinitCall((JMethod)member) : this.maybeCreateClinitCall((JField)member);
            if (clinitCall != null) {
                hoistedClinits.add(enclosingType);
                GenerateJavaScriptAST.this.getGlobalStatements().add(clinitCall.makeStmt());
            }
        }

        @Override
        public JsFunction transformJsniMethodBody(JsniMethodBody jsniMethodBody) {
            final HashMap<String, JNode> nodeByJsniReference = Maps.newHashMap();
            for (JsniClassLiteral jsniClassLiteral : jsniMethodBody.getClassRefs()) {
                nodeByJsniReference.put(jsniClassLiteral.getIdent(), jsniClassLiteral.getField());
            }
            for (JsniFieldRef jsniFieldRef : jsniMethodBody.getJsniFieldRefs()) {
                nodeByJsniReference.put(jsniFieldRef.getIdent(), jsniFieldRef.getField());
            }
            for (JsniMethodRef jsniMethodRef : jsniMethodBody.getJsniMethodRefs()) {
                nodeByJsniReference.put(jsniMethodRef.getIdent(), jsniMethodRef.getTarget());
            }
            final JsFunction function = jsniMethodBody.getFunc();
            new JsModVisitor(){
                private JsNameRef dontReplaceCtor;

                @Override
                public void endVisit(JsInvocation x, JsContext ctx) {
                    if (!(x.getQualifier() instanceof JsNameRef)) {
                        return;
                    }
                    JsNameRef ref = (JsNameRef)x.getQualifier();
                    if (!ref.isJsniReference()) {
                        return;
                    }
                    String ident = ref.getIdent();
                    assert (ref.getQualifier() == null);
                    JConstructor constructor = (JConstructor)nodeByJsniReference.get(ident);
                    JsNameRef constructorJsName = GenerateJavaScriptTransformer.this.createStaticReference(constructor, x.getSourceInfo());
                    ctx.replaceMe(new JsNew(x.getSourceInfo(), (JsExpression)constructorJsName, x.getArguments()));
                }

                @Override
                public void endVisit(JsNameRef x, JsContext ctx) {
                    if (!x.isJsniReference()) {
                        return;
                    }
                    String ident = x.getIdent();
                    JNode node = (JNode)nodeByJsniReference.get(ident);
                    assert (node != null);
                    if (node instanceof JField) {
                        JField field = (JField)node;
                        if (field.isStatic() && field.isJsNative()) {
                            ctx.replaceMe(JsUtils.createQualifiedNameRef(field.getQualifiedJsName(), x.getSourceInfo()));
                            return;
                        }
                        JsName jsName = (JsName)GenerateJavaScriptAST.this.names.get(field);
                        assert (jsName != null);
                        x.resolve(jsName);
                        JsInvocation clinitCall = GenerateJavaScriptTransformer.this.maybeCreateClinitCall(field);
                        if (clinitCall != null) {
                            JsExpression commaExpr = JsUtils.createCommaExpression(clinitCall, x);
                            ctx.replaceMe(commaExpr);
                        }
                    } else if (node instanceof JConstructor) {
                        if (x != this.dontReplaceCtor) {
                            JConstructor constructor = (JConstructor)node;
                            SourceInfo info = x.getSourceInfo();
                            JsNameRef constructorJsNameRef = GenerateJavaScriptTransformer.this.createStaticReference(constructor, info);
                            JsFunction anonymousFunction = new JsFunction(info, function.getScope());
                            for (JParameter p : constructor.getParams()) {
                                JsName name = anonymousFunction.getScope().declareName(p.getName());
                                anonymousFunction.getParameters().add(new JsParameter(info, name));
                            }
                            JsNew jsNew = new JsNew(info, (JsExpression)constructorJsNameRef, new JsExpression[0]);
                            for (JsParameter p : anonymousFunction.getParameters()) {
                                jsNew.getArguments().add(p.getName().makeRef(info));
                            }
                            anonymousFunction.setBody(new JsBlock(info));
                            anonymousFunction.getBody().getStatements().add(new JsReturn(info, jsNew));
                            ctx.replaceMe(anonymousFunction);
                        }
                    } else {
                        JMethod method = (JMethod)node;
                        if (!method.needsDynamicDispatch() && method.isJsNative()) {
                            ctx.replaceMe(GenerateJavaScriptAST.this.createGlobalQualifier(method.getQualifiedJsName(), x.getSourceInfo()));
                            return;
                        }
                        if (x.getQualifier() == null) {
                            JsName jsName = (JsName)GenerateJavaScriptAST.this.names.get(method);
                            assert (jsName != null);
                            x.resolve(jsName);
                        } else {
                            JsName jsName = (JsName)GenerateJavaScriptAST.this.polymorphicNames.get(method);
                            if (jsName == null) {
                                jsName = GenerateJavaScriptAST.this.getIndexedMethodJsName("Runtime.emptyMethod");
                            }
                            x.resolve(jsName);
                        }
                    }
                }

                @Override
                public boolean visit(JsInvocation x, JsContext ctx) {
                    if (x.getQualifier() instanceof JsNameRef) {
                        this.dontReplaceCtor = (JsNameRef)x.getQualifier();
                    }
                    return true;
                }
            }.accept(function);
            return function;
        }

        @Override
        public JsNode transformSwitchExpression(JSwitchExpression x) {
            SourceInfo info = x.getSourceInfo();
            JsScope scope = GenerateJavaScriptAST.this.getJsFunctionFor(this.currentMethod).getScope();
            JsFunction fnWrapper = new JsFunction(info, scope);
            JsStatement switchStatement = this.transformSwitchStatement(new JSwitchStatement(x));
            fnWrapper.setBody(new JsBlock(info));
            fnWrapper.getBody().getStatements().add(switchStatement);
            JsNameRef call = new JsNameRef(info, "call", fnWrapper);
            return new JsInvocation(info, (JsExpression)call, new JsThisRef(info));
        }

        @Override
        public JsStatement transformSwitchStatement(JSwitchStatement switchStatement) {
            JsSwitch jsSwitch = new JsSwitch(switchStatement.getSourceInfo());
            jsSwitch.setExpr((JsExpression)this.transform(switchStatement.getExpr()));
            List<JStatement> bodyStmts = switchStatement.getBody().getStatements();
            List<JsStatement> curStatements = null;
            for (JStatement stmt : bodyStmts) {
                if (stmt instanceof JCaseStatement) {
                    JsSwitchMember switchMember = (JsSwitchMember)this.transform((JNode)stmt);
                    jsSwitch.getCases().add(switchMember);
                    curStatements = switchMember.getStmts();
                    continue;
                }
                assert (curStatements != null);
                Object newStmt = this.transform(stmt);
                if (newStmt == null) continue;
                curStatements.add((JsStatement)newStmt);
            }
            return jsSwitch;
        }

        private JsExpression buildJsCastMapLiteral(List<JsExpression> runtimeTypeIdLiterals, SourceInfo sourceInfo) {
            if (JjsUtils.closureStyleLiteralsNeeded(GenerateJavaScriptAST.this.incremental, GenerateJavaScriptAST.this.closureCompilerFormatEnabled)) {
                return this.buildClosureStyleCastMapFromArrayLiteral(runtimeTypeIdLiterals, sourceInfo);
            }
            JsNumberLiteral one = new JsNumberLiteral(sourceInfo, 1.0);
            JsObjectLiteral.Builder objectLiteralBuilder = JsObjectLiteral.builder(sourceInfo).setInternable();
            for (JsExpression runtimeTypeIdLiteral : runtimeTypeIdLiterals) {
                objectLiteralBuilder.add(runtimeTypeIdLiteral, (JsExpression)one);
            }
            return objectLiteralBuilder.build();
        }

        private JsExpression buildClosureStyleCastMapFromArrayLiteral(List<JsExpression> runtimeTypeIdLiterals, SourceInfo sourceInfo) {
            JsNameRef createSet = new JsNameRef(sourceInfo, GOOG_OBJECT_CREATE_SET);
            JsInvocation jsInvocation = new JsInvocation(sourceInfo, (JsExpression)createSet, new JsExpression[0]);
            for (JsExpression expr : runtimeTypeIdLiterals) {
                jsInvocation.getArguments().add(expr);
            }
            return jsInvocation;
        }

        private void checkForDuplicateMethods(JDeclaredType type) {
            List<JMethod> methods = type.getMethods();
            HashSet<String> methodSignatures = Sets.newHashSet();
            for (JMethod method : methods) {
                String sig = method.getSignature();
                if (methodSignatures.contains(sig)) {
                    throw new InternalCompilerException("Signature collision in Type " + type.getName() + " for method " + sig);
                }
                methodSignatures.add(sig);
            }
        }

        private JsNameRef createStaticReference(JMember member, SourceInfo sourceInfo) {
            assert (!member.needsDynamicDispatch());
            return member.isJsNative() ? GenerateJavaScriptAST.this.createGlobalQualifier(member.getQualifiedJsName(), sourceInfo) : ((JsName)GenerateJavaScriptAST.this.names.get(member)).makeRef(sourceInfo);
        }

        private void emitFields(JDeclaredType type) {
            JsVars vars = new JsVars(type.getSourceInfo(), new JsVars.JsVar[0]);
            for (JField field : type.getFields()) {
                if (field.isJsNative()) continue;
                JsExpression initializer = null;
                if (this.initializeAtTopScope(field)) {
                    initializer = (JsExpression)this.transform(field.getLiteralInitializer());
                } else if (field.getType().getDefaultValue() != JNullLiteral.INSTANCE) {
                    initializer = (JsExpression)this.transform(field.getType().getDefaultValue());
                }
                JsName name = (JsName)GenerateJavaScriptAST.this.names.get(field);
                if (field.isStatic()) {
                    JsVars.JsVar var = new JsVars.JsVar(type.getSourceInfo(), name);
                    var.setInitExpr(initializer);
                    vars.add(var);
                    continue;
                }
                if (initializer == null) continue;
                JsNameRef fieldRef = name.makeQualifiedRef(field.getSourceInfo(), this.getPrototypeQualifierOf(field));
                this.addTypeDefinitionStatement(type, JsUtils.createAssignment(fieldRef, initializer).makeStmt());
            }
            GenerateJavaScriptAST.this.addVarsIfNotEmpty(vars);
        }

        private void emitStaticMethods(JDeclaredType type) {
            for (JMethod method : type.getMethods()) {
                JsFunction function;
                if (method.needsDynamicDispatch() || (function = (JsFunction)this.transform(method)) == null) continue;
                if (JProgram.isClinit(method)) {
                    this.handleClinit(type, function);
                }
                this.emitMethodImplementation(method, function.getName().makeRef(function.getSourceInfo()), function.makeStmt());
            }
        }

        private JsExpression generateCastableTypeMap(JDeclaredType type) {
            JCastMap castMap = GenerateJavaScriptAST.this.program.getCastMap(type);
            JsName castableTypeMapName = GenerateJavaScriptAST.this.getIndexedFieldJsName("Object.castableTypeMap");
            if (castMap != null && castableTypeMapName != null) {
                return this.transform(castMap);
            }
            return JsObjectLiteral.EMPTY;
        }

        private JField getClassLiteralField(JType type) {
            JDeclarationStatement decl = (JDeclarationStatement)GenerateJavaScriptAST.this.classLiteralDeclarationsByType.get(type);
            if (decl == null) {
                return null;
            }
            return (JField)decl.getVariableRef().getTarget();
        }

        private void maybeGenerateClassLiteral(JType type) {
            JField field = this.getClassLiteralField(type);
            if (field == null) {
                return;
            }
            if (type != null && type instanceof JDeclaredType && GenerateJavaScriptAST.this.program.isReferenceOnly((JDeclaredType)type)) {
                return;
            }
            JsVars vars = new JsVars(GenerateJavaScriptAST.this.jsProgram.getSourceInfo(), new JsVars.JsVar[0]);
            JsName jsName = (JsName)GenerateJavaScriptAST.this.names.get(field);
            Object classLiteralObject = this.transform(field.getInitializer());
            JsVars.JsVar var = new JsVars.JsVar(field.getSourceInfo(), jsName);
            var.setInitExpr((JsExpression)classLiteralObject);
            vars.add(var);
            GenerateJavaScriptAST.this.addVarsIfNotEmpty(vars);
        }

        private JsNameRef createClassLiteralReference(JType type) {
            JField field = this.getClassLiteralField(type);
            if (field == null) {
                return null;
            }
            JsName jsName = (JsName)GenerateJavaScriptAST.this.names.get(field);
            return jsName.makeRef(type.getSourceInfo());
        }

        private void generateTypeSetup(JDeclaredType type) {
            if (GenerateJavaScriptAST.this.program.isRepresentedAsNativeJsPrimitive(type) && ((GenerateJavaScriptAST)GenerateJavaScriptAST.this).program.typeOracle.isInstantiatedType(type)) {
                this.setupCastMapForUnboxedType(type, GenerateJavaScriptAST.this.program.getRepresentedAsNativeTypesDispatchMap().get(type).getCastMapField());
                return;
            }
            if (this.shouldNotEmitTypeDefinition(type)) {
                return;
            }
            this.generateClassDefinition(type);
            this.generatePrototypeDefinitions(type);
            this.maybeGenerateObjectMethodsAliases(type);
        }

        private void markPosition(String name, JsPositionMarker.Type type) {
            GenerateJavaScriptAST.this.getGlobalStatements().add(new JsPositionMarker(SourceOrigin.UNKNOWN, name, type));
        }

        private void setupGwtOnLoad() {
            SourceOrigin sourceInfo = SourceOrigin.UNKNOWN;
            JsStatement entryVars = this.constructFunctionCallStatement(GenerateJavaScriptAST.this.topScope.declareName("$entry"), "ModuleUtils.registerEntry", new JsExpression[0]);
            GenerateJavaScriptAST.this.getGlobalStatements().add(entryVars);
            JsName gwtOnLoad = GenerateJavaScriptAST.this.topScope.findExistingUnobfuscatableName("gwtOnLoad");
            JsVars.JsVar varGwtOnLoad = new JsVars.JsVar(sourceInfo, gwtOnLoad);
            varGwtOnLoad.setInitExpr(JsUtils.createAssignment(gwtOnLoad.makeRef(sourceInfo), GenerateJavaScriptAST.this.getIndexedMethodJsName("ModuleUtils.gwtOnLoad").makeRef(sourceInfo)));
            GenerateJavaScriptAST.this.getGlobalStatements().add(new JsVars(sourceInfo, varGwtOnLoad));
            ArrayList<JsExpression> arguments = Lists.newArrayList();
            for (JMethod entryPointMethod : GenerateJavaScriptAST.this.program.getEntryMethods()) {
                JsFunction entryFunction = GenerateJavaScriptAST.this.getJsFunctionFor(entryPointMethod);
                arguments.add(entryFunction.getName().makeRef(sourceInfo));
            }
            JsExprStmt createGwtOnLoadFunctionCall = this.constructInvocation("ModuleUtils.addInitFunctions", arguments).makeStmt();
            GenerateJavaScriptAST.this.getGlobalStatements().add(createGwtOnLoadFunctionCall);
        }

        private JsStatement constructFunctionCallStatement(JsName assignToVariableName, String indexedFunctionName, JsExpression ... args) {
            return this.constructFunctionCallStatement(assignToVariableName, indexedFunctionName, Arrays.asList(args));
        }

        private JsStatement constructFunctionCallStatement(JsName assignToVariableName, String indexedFunctionName, List<JsExpression> args) {
            SourceOrigin sourceInfo = SourceOrigin.UNKNOWN;
            JsInvocation invocation = this.constructInvocation(indexedFunctionName, args);
            JsVars.JsVar var = new JsVars.JsVar(sourceInfo, assignToVariableName);
            var.setInitExpr(invocation);
            JsVars entryVars = new JsVars(sourceInfo, new JsVars.JsVar[0]);
            entryVars.add(var);
            return entryVars;
        }

        private JsInvocation constructInvocation(SourceInfo sourceInfo, String indexedFunctionName, JsExpression ... args) {
            return this.constructInvocation(sourceInfo, indexedFunctionName, Arrays.asList(args));
        }

        private JsInvocation constructInvocation(String indexedFunctionName, List<JsExpression> args) {
            SourceOrigin sourceInfo = SourceOrigin.UNKNOWN;
            return this.constructInvocation((SourceInfo)sourceInfo, indexedFunctionName, args);
        }

        private JsInvocation constructInvocation(SourceInfo sourceInfo, String indexedFunctionName, List<JsExpression> args) {
            JsName functionToInvoke = GenerateJavaScriptAST.this.getIndexedMethodJsName(indexedFunctionName);
            return new JsInvocation(sourceInfo, (JsExpression)functionToInvoke.makeRef(sourceInfo), args);
        }

        private void generateImmortalTypes(JsVars globals) {
            List<JClassType> immortalTypesReversed = Lists.reverse(((GenerateJavaScriptAST)GenerateJavaScriptAST.this).program.immortalCodeGenTypes);
            for (JClassType x : immortalTypesReversed) {
                if (GenerateJavaScriptAST.this.program.isReferenceOnly(x)) continue;
                assert (x.getMethods().size() > 0);
                for (JMethod method : x.getMethods()) {
                    if (method.needsDynamicDispatch() || method instanceof JConstructor || GenerateJavaScriptAST.doesNotHaveConcreteImplementation(method)) continue;
                    JsFunction function = (JsFunction)this.transform(method);
                    assert (function.getName() != null);
                    this.addMethodDefinitionStatement(1, method, function.makeStmt());
                }
                for (JField field : x.getFields()) {
                    assert (field.isStatic()) : "'" + field.getName() + "' is not static. Only static fields are allowed on immortal types";
                    assert (field.getInitializer() == field.getLiteralInitializer()) : "'" + field.getName() + "' is not initilialized to a literal. Only literal initializers are allowed on immortal types";
                    JsVars.JsVar var = new JsVars.JsVar(x.getSourceInfo(), (JsName)GenerateJavaScriptAST.this.names.get(field));
                    var.setInitExpr((JsExpression)this.transform(field.getLiteralInitializer()));
                    globals.add(var);
                }
            }
        }

        private void generateCallToDefineClass(JClassType type, List<JsNameRef> constructorArgs) {
            JClassType superClass = type.getSuperClass();
            JNullLiteral superTypeId = superClass == null ? JNullLiteral.INSTANCE : GenerateJavaScriptAST.this.getRuntimeTypeReference(superClass);
            String jsPrototype = this.getSuperPrototype(type);
            ArrayList<JsExpression> defineClassArguments = Lists.newArrayList();
            defineClassArguments.add((JsExpression)this.transform(GenerateJavaScriptAST.this.getRuntimeTypeReference(type)));
            defineClassArguments.add((JsExpression)(jsPrototype == null ? this.transform(superTypeId) : GenerateJavaScriptAST.this.createGlobalQualifier(jsPrototype, type.getSourceInfo())));
            defineClassArguments.add(this.generateCastableTypeMap(type));
            defineClassArguments.addAll(constructorArgs);
            JsExprStmt defineClassStatement = this.constructInvocation(type.getSourceInfo(), "Runtime.defineClass", defineClassArguments).makeStmt();
            this.addTypeDefinitionStatement(type, defineClassStatement);
            this.maybeCopyJavaLangObjectProperties(type, this.getPrototypeQualifierViaLookup(GenerateJavaScriptAST.this.program.getTypeJavaLangObject(), type.getSourceInfo()), this.globalTemp.makeRef(type.getSourceInfo()));
        }

        private void maybeCopyJavaLangObjectProperties(JDeclaredType type, JsExpression javaLangObjectPrototype, JsExpression toPrototype) {
            if (this.getSuperPrototype(type) != null && !type.isJsFunctionImplementation()) {
                JsExprStmt statement = this.constructInvocation(type.getSourceInfo(), "Runtime.copyObjectProperties", javaLangObjectPrototype, toPrototype).makeStmt();
                this.addTypeDefinitionStatement(type, statement);
            }
        }

        private String getSuperPrototype(JDeclaredType type) {
            if (type.isJsFunctionImplementation()) {
                return "Function";
            }
            JClassType superClass = type.getSuperClass();
            if (superClass != null && superClass.isJsNative()) {
                return superClass.getQualifiedJsName();
            }
            return null;
        }

        private void generateClassDefinition(JDeclaredType type) {
            assert (!GenerateJavaScriptAST.this.program.isRepresentedAsNativeJsPrimitive(type));
            if (GenerateJavaScriptAST.this.closureCompilerFormatEnabled) {
                this.generateClosureTypeDefinition(type);
            } else {
                this.generateJsClassDefinition((JClassType)type);
            }
        }

        private void generateJsClassDefinition(JClassType classType) {
            ArrayList<JsNameRef> constructorArgs = Lists.newArrayList();
            for (JMethod method : this.getPotentiallyAliveConstructors(classType)) {
                constructorArgs.add(((JsName)GenerateJavaScriptAST.this.names.get(method)).makeRef(classType.getSourceInfo()));
            }
            this.generateCallToDefineClass(classType, constructorArgs);
        }

        private void generateClosureTypeDefinition(JDeclaredType type) {
            JsName classVar = this.declareSynthesizedClosureConstructor(type);
            this.generateInlinedDefineClass(type, classVar);
            for (JMethod method : this.getPotentiallyAliveConstructors(type)) {
                SourceInfo typeSourceInfo = type.getSourceInfo();
                JsNameRef googInherits = JsUtils.createQualifiedNameRef(GOOG_INHERITS, typeSourceInfo);
                SourceInfo methodSourceInfo = method.getSourceInfo();
                JsExprStmt callGoogInherits = new JsInvocation(typeSourceInfo, (JsExpression)googInherits, ((JsName)GenerateJavaScriptAST.this.names.get(method)).makeRef(methodSourceInfo), ((JsName)GenerateJavaScriptAST.this.names.get(method.getEnclosingType())).makeRef(methodSourceInfo)).makeStmt();
                this.addMethodDefinitionStatement(method, callGoogInherits);
            }
        }

        private void generateInlinedDefineClass(JDeclaredType type, JsName classVar) {
            JsNameRef parentCtor;
            if (type instanceof JInterfaceType) {
                return;
            }
            JClassType superClass = type.getSuperClass();
            String jsPrototype = this.getSuperPrototype(type);
            SourceInfo info = type.getSourceInfo();
            JsNameRef jsNameRef = jsPrototype != null ? GenerateJavaScriptAST.this.createGlobalQualifier(jsPrototype, info) : (parentCtor = superClass != null ? ((JsName)GenerateJavaScriptAST.this.names.get(superClass)).makeRef(info) : null);
            if (parentCtor != null) {
                JsNameRef googInherits = JsUtils.createQualifiedNameRef(GOOG_INHERITS, info);
                JsExprStmt callGoogInherits = new JsInvocation(info, (JsExpression)googInherits, classVar.makeRef(info), parentCtor).makeStmt();
                this.addTypeDefinitionStatement(type, callGoogInherits);
            }
            if (type == GenerateJavaScriptAST.this.program.getTypeJavaLangObject()) {
                this.setupTypeMarkerOnJavaLangObjectPrototype(type);
            }
            this.setupCastMapOnPrototype(type);
            this.maybeCopyJavaLangObjectProperties(type, this.getPrototypeQualifierOf(GenerateJavaScriptAST.this.program.getTypeJavaLangObject(), info), this.getPrototypeQualifierOf(type, info));
        }

        private void setupCastMapOnPrototype(JDeclaredType type) {
            JsExpression castMap = this.generateCastableTypeMap(type);
            this.generatePrototypeAssignmentForJavaField(type, "Object.castableTypeMap", castMap);
        }

        private void setupTypeMarkerOnJavaLangObjectPrototype(JDeclaredType type) {
            JsName typeMarkerMethod = GenerateJavaScriptAST.this.getIndexedMethodJsName("Runtime.typeMarkerFn");
            this.generatePrototypeAssignmentForJavaField(type, "Object.typeMarker", typeMarkerMethod.makeRef(type.getSourceInfo()));
        }

        private void generatePrototypeAssignmentForJavaField(JDeclaredType type, String javaField, JsExpression rhs) {
            SourceInfo sourceInfo = type.getSourceInfo();
            JsNameRef protoRef = this.getPrototypeQualifierOf(type, sourceInfo);
            JsNameRef fieldRef = GenerateJavaScriptAST.this.getIndexedFieldJsName(javaField).makeQualifiedRef(sourceInfo, protoRef);
            this.addTypeDefinitionStatement(type, JsUtils.createAssignment(fieldRef, rhs).makeStmt());
        }

        private void addMethodDefinitionStatement(JMethod method, JsExprStmt methodDefinitionStatement) {
            GenerateJavaScriptAST.this.getGlobalStatements().add(methodDefinitionStatement);
            GenerateJavaScriptAST.this.methodByGlobalStatement.put(methodDefinitionStatement, method);
        }

        private void addMethodDefinitionStatement(int position, JMethod method, JsExprStmt methodDefinitionStatement) {
            GenerateJavaScriptAST.this.getGlobalStatements().add(position, methodDefinitionStatement);
            GenerateJavaScriptAST.this.methodByGlobalStatement.put(methodDefinitionStatement, method);
        }

        private void addTypeDefinitionStatement(JDeclaredType x, JsStatement statement) {
            GenerateJavaScriptAST.this.getGlobalStatements().add(statement);
            GenerateJavaScriptAST.this.javaTypeByGlobalStatement.put(statement, x);
        }

        private JsName declareSynthesizedClosureConstructor(JDeclaredType x) {
            SourceInfo sourceInfo = x.getSourceInfo();
            JsName classVar = GenerateJavaScriptAST.this.topScope.declareName(JjsUtils.mangledNameString(x));
            JsFunction closureCtor = JsUtils.createEmptyFunctionLiteral(sourceInfo, GenerateJavaScriptAST.this.topScope, classVar);
            JsExprStmt statement = closureCtor.makeStmt();
            GenerateJavaScriptAST.this.getGlobalStatements().add(statement);
            GenerateJavaScriptAST.this.names.put(x, classVar);
            return classVar;
        }

        private void setupCastMapForUnboxedType(JDeclaredType type, String castMapField) {
            JsName castableTypeMapName = GenerateJavaScriptAST.this.getIndexedFieldJsName(castMapField);
            JsNameRef castMapVarRef = castableTypeMapName.makeRef(type.getSourceInfo());
            JsExpression castMapLiteral = this.generateCastableTypeMap(type);
            this.addTypeDefinitionStatement(type, JsUtils.createAssignment(castMapVarRef, castMapLiteral).makeStmt());
        }

        private void maybeGenerateObjectMethodsAliases(JDeclaredType type) {
            if (type == GenerateJavaScriptAST.this.program.getTypeJavaLangObject()) {
                ImmutableSet<JMethod> overridableJavaLangObjectMethods = ImmutableSet.of(GenerateJavaScriptAST.this.program.getIndexedMethodOrNull("Object.equals"), GenerateJavaScriptAST.this.program.getIndexedMethodOrNull("Object.hashCode"), GenerateJavaScriptAST.this.program.getIndexedMethodOrNull("Object.toString"));
                for (JMethod method : type.getMethods()) {
                    if (!overridableJavaLangObjectMethods.contains(method)) continue;
                    JsName methodJsName = GenerateJavaScriptAST.this.objectScope.declareUnobfuscatableName(method.getName());
                    this.generatePrototypeDefinitionAlias(method, methodJsName);
                }
            }
        }

        private void generatePrototypeAssignment(JMethod method, JsName name, JsExpression rhs) {
            this.generatePrototypeAssignment(method, name, rhs, method.getJsMemberType());
        }

        private void generatePrototypeAssignment(JMethod method, JsName name, JsExpression rhs, HasJsInfo.JsMemberType memberType) {
            SourceInfo sourceInfo = method.getSourceInfo();
            JsNameRef prototypeQualifierOf = this.getPrototypeQualifierOf(method);
            JsNameRef lhs = name.makeQualifiedRef(sourceInfo, prototypeQualifierOf);
            switch (memberType) {
                case GETTER: 
                case SETTER: {
                    this.emitPropertyImplementation(method, prototypeQualifierOf, name.makeRef(sourceInfo), rhs);
                    break;
                }
                default: {
                    this.emitMethodImplementation(method, lhs, JsUtils.createAssignment(lhs, rhs).makeStmt());
                }
            }
        }

        private void emitPropertyImplementation(JMethod method, JsNameRef prototype, JsNameRef name, JsExpression methodDefinitionStatement) {
            SourceInfo sourceInfo = method.getSourceInfo();
            JsNameRef definePropertyMethod = GenerateJavaScriptAST.this.getIndexedMethodJsName("Runtime.defineProperties").makeRef(sourceInfo);
            JsObjectLiteral definePropertyLiteral = JsObjectLiteral.builder(sourceInfo).add(name, (JsExpression)JsObjectLiteral.builder(sourceInfo).add(method.getJsMemberType().getPropertyAccessorKey(), methodDefinitionStatement).build()).build();
            this.addMethodDefinitionStatement(method, new JsInvocation(sourceInfo, (JsExpression)definePropertyMethod, prototype, definePropertyLiteral).makeStmt());
        }

        private void emitMethodImplementation(JMethod method, JsNameRef functionNameRef, JsExprStmt methodDefinitionStatement) {
            this.addMethodDefinitionStatement(method, methodDefinitionStatement);
            if (this.shouldEmitDisplayNames()) {
                this.addMethodDefinitionStatement(method, this.outputDisplayName(functionNameRef, method));
                this.addMethodDefinitionStatement(method, this.outputFunctionNameProperty(functionNameRef, method));
            }
        }

        private void generatePrototypeDefinitionAlias(JMethod method, JsName alias) {
            JsName polyName = (JsName)GenerateJavaScriptAST.this.polymorphicNames.get(method);
            JsFunction bridge = JsUtils.createBridge(method, polyName, GenerateJavaScriptAST.this.topScope);
            this.generatePrototypeAssignment(method, alias, bridge, HasJsInfo.JsMemberType.NONE);
        }

        private JsExprStmt outputDisplayName(JsNameRef function, JMethod method) {
            JsNameRef displayName = new JsNameRef(function.getSourceInfo(), "displayName", function);
            String displayStringName = this.getDisplayName(method);
            JsStringLiteral displayMethodName = new JsStringLiteral(function.getSourceInfo(), displayStringName);
            return JsUtils.createAssignment(displayName, displayMethodName).makeStmt();
        }

        private JsExprStmt outputFunctionNameProperty(JsNameRef function, JMethod method) {
            String displayStringName = this.getDisplayName(method);
            SourceInfo sourceInfo = function.getSourceInfo();
            JsStringLiteral displayMethodName = new JsStringLiteral(sourceInfo, displayStringName);
            JsObjectLiteral props = JsObjectLiteral.builder(sourceInfo).add(new JsStringLiteral(sourceInfo, "name"), (JsExpression)JsObjectLiteral.builder(sourceInfo).add("value", (JsExpression)displayMethodName).build()).build();
            JsExpression[] args = new JsExpression[]{function, props};
            return this.constructInvocation(sourceInfo, "Runtime.defineProperties", args).makeStmt();
        }

        private boolean shouldEmitDisplayNames() {
            return GenerateJavaScriptAST.this.methodNameMappingMode != OptionMethodNameDisplayMode.Mode.NONE;
        }

        private String getDisplayName(JMethod method) {
            switch (GenerateJavaScriptAST.this.methodNameMappingMode) {
                case ONLY_METHOD_NAME: {
                    return method.getName();
                }
                case ABBREVIATED: {
                    return method.getEnclosingType().getShortName() + "." + method.getName();
                }
                case FULL: {
                    return method.getEnclosingType().getName() + "." + method.getName();
                }
            }
            assert (false) : "Invalid display mode option " + (Object)((Object)GenerateJavaScriptAST.access$3500(GenerateJavaScriptAST.this));
            return null;
        }

        private void generatePrototypeDefinitions(JDeclaredType type) {
            assert (!GenerateJavaScriptAST.this.program.isRepresentedAsNativeJsPrimitive(type));
            Iterable<JMember> orderedInstanceMethods = Iterables.concat(Iterables.filter(type.getMethods(), Predicates.and(JjsPredicates.IS_SYNTHETIC, JjsPredicates.NEEDS_DYNAMIC_DISPATCH)), Iterables.filter(type.getMethods(), Predicates.and(Predicates.not(JjsPredicates.IS_SYNTHETIC), JjsPredicates.NEEDS_DYNAMIC_DISPATCH)));
            for (JMethod jMethod : orderedInstanceMethods) {
                this.generatePrototypeDefinition(jMethod, (JsExpression)this.transformMethod(jMethod));
            }
        }

        private void generatePrototypeDefinition(JMethod method, JsExpression functionDefinition) {
            if (functionDefinition != null) {
                this.generatePrototypeAssignment(method, (JsName)GenerateJavaScriptAST.this.polymorphicNames.get(method), functionDefinition);
            }
            if (method.exposesNonJsMember()) {
                JsName internalMangledName = GenerateJavaScriptAST.this.interfaceScope.declareName(GenerateJavaScriptAST.this.mangleNameForPoly(method), method.getName());
                this.generatePrototypeDefinitionAlias(method, internalMangledName);
            }
            if (method.exposesPackagePrivateMethod()) {
                this.generatePrototypeDefinitionAlias(method, this.getPackagePrivateName(method));
            }
        }

        private JsNameRef getPrototypeQualifierOf(JMember member) {
            return this.getPrototypeQualifierOf(member.getEnclosingType(), member.getSourceInfo());
        }

        private JsNameRef getPrototypeQualifierOf(JDeclaredType type, SourceInfo info) {
            return GenerateJavaScriptAST.this.closureCompilerFormatEnabled ? this.prototype.makeQualifiedRef(info, ((JsName)GenerateJavaScriptAST.this.names.get(type)).makeRef(info)) : this.globalTemp.makeRef(info);
        }

        private JsName getPackagePrivateName(JMethod method) {
            for (JMethod overridenMethod : method.getOverriddenMethods()) {
                if (!overridenMethod.isPackagePrivate()) continue;
                JsName name = (JsName)GenerateJavaScriptAST.this.polymorphicNames.get(overridenMethod);
                assert (name != null);
                return name;
            }
            throw new AssertionError((Object)(method.toString() + " overrides a package private method but was not found."));
        }

        private void handleClinit(JDeclaredType type, JsFunction clinitFunction) {
            this.clinitFunctionForType.put(type, clinitFunction);
            JClassType superClass = type.getSuperClass();
            JsFunction superClinitFunction = superClass == null ? null : this.clinitFunctionForType.get(superClass.getClinitTarget());
            clinitFunction.setSuperClinit(superClinitFunction);
            List<JsStatement> statements = clinitFunction.getBody().getStatements();
            SourceInfo sourceInfo = clinitFunction.getSourceInfo();
            JsName emptyFunctionFnName = GenerateJavaScriptAST.this.incremental ? GenerateJavaScriptAST.this.objectConstructorFunction.getName() : GenerateJavaScriptAST.this.getIndexedMethodJsName("Runtime.emptyMethod");
            JsExpression assignment = JsUtils.createAssignment(clinitFunction.getName().makeRef(sourceInfo), emptyFunctionFnName.makeRef(sourceInfo));
            statements.add(0, assignment.makeStmt());
        }

        private boolean isMethodPotentiallyCalledAcrossClasses(JMethod method) {
            assert (GenerateJavaScriptAST.this.incremental || GenerateJavaScriptAST.this.crossClassTargets != null);
            return GenerateJavaScriptAST.this.crossClassTargets == null || GenerateJavaScriptAST.this.crossClassTargets.contains(method) || method.isJsInteropEntryPoint();
        }

        private Iterable<JMethod> getPotentiallyAliveConstructors(JDeclaredType x) {
            return Iterables.filter(x.getMethods(), new Predicate<JMethod>(){

                @Override
                public boolean apply(JMethod m) {
                    return GenerateJavaScriptTransformer.this.isMethodPotentiallyALiveConstructor(m);
                }
            });
        }

        private boolean isMethodPotentiallyALiveConstructor(JMethod method) {
            if (!(method instanceof JConstructor)) {
                return false;
            }
            assert (GenerateJavaScriptAST.this.incremental || GenerateJavaScriptAST.this.liveCtors != null);
            return GenerateJavaScriptAST.this.liveCtors == null || GenerateJavaScriptAST.this.liveCtors.contains(method);
        }

        private JsInvocation maybeCreateClinitCall(JField x) {
            if (!x.isStatic() || x.isCompileTimeConstant()) {
                return null;
            }
            JDeclaredType targetType = x.getEnclosingType().getClinitTarget();
            if (targetType == null || targetType == GenerateJavaScriptAST.this.program.getTypeClassLiteralHolder() || this.currentMethod != null && !this.currentMethod.getEnclosingType().checkClinitTo(targetType)) {
                return null;
            }
            JMethod clinitMethod = targetType.getClinitMethod();
            SourceInfo sourceInfo = x.getSourceInfo();
            return new JsInvocation(sourceInfo, (JsExpression)((JsName)GenerateJavaScriptAST.this.names.get(clinitMethod)).makeRef(sourceInfo), new JsExpression[0]);
        }

        private JsInvocation maybeCreateClinitCall(JMethod method) {
            if (!this.isMethodPotentiallyCalledAcrossClasses(method)) {
                return null;
            }
            JDeclaredType enclosingType = method.getEnclosingType();
            if (method.canBePolymorphic() || GenerateJavaScriptAST.this.program.isStaticImpl(method) && !method.isJsOverlay()) {
                return null;
            }
            if (enclosingType == null || !enclosingType.hasClinit()) {
                return null;
            }
            if (JProgram.isClinit(method)) {
                return null;
            }
            JMethod clinitMethod = enclosingType.getClinitTarget().getClinitMethod();
            SourceInfo sourceInfo = method.getSourceInfo();
            return new JsInvocation(sourceInfo, (JsExpression)((JsName)GenerateJavaScriptAST.this.names.get(clinitMethod)).makeRef(sourceInfo), new JsExpression[0]);
        }

        private boolean initializeAtTopScope(JField x) {
            if (x.getEnclosingType().isJsFunctionImplementation()) {
                return false;
            }
            if (x.getLiteralInitializer() == null) {
                return false;
            }
            if (x.isFinal() || x.isStatic() || x.isCompileTimeConstant()) {
                return true;
            }
            return !GenerateJavaScriptAST.this.uninitializedValuePotentiallyObservable.apply(x);
        }

        private <T extends JsExpression> T transform(JExpression expression) {
            return (T)((JsExpression)this.transform((JNode)expression));
        }

        @Override
        public JsNode transformYieldStatement(JYieldStatement x) {
            return new JsReturn(x.getSourceInfo(), (JsExpression)this.transform(x.getExpr()));
        }

        private <T extends JsStatement> T transform(JStatement statement) {
            return (T)((JsStatement)this.transform((JNode)statement));
        }

        private JsBlock transform(JBlock statement) {
            return (JsBlock)this.transform((JNode)statement);
        }
    }

    private class CreateNamesAndScopesVisitor
    extends JVisitor {
        private final Map<String, String> fileNameToUriString = Maps.newHashMap();
        private final Stack<JsScope> scopeStack = new Stack();
        private JMethod currentMethod;

        private CreateNamesAndScopesVisitor() {
        }

        @Override
        public boolean visit(JProgram x, Context ctx) {
            x.visitAllTypes(this);
            return false;
        }

        @Override
        public void endVisit(JArrayType x, Context ctx) {
            JsName name = GenerateJavaScriptAST.this.topScope.declareName(x.getName());
            GenerateJavaScriptAST.this.names.put(x, name);
            this.recordSymbol(x, name);
        }

        @Override
        public void endVisit(JClassType x, Context ctx) {
            this.scopeStack.pop();
        }

        @Override
        public void endVisit(JField x, Context ctx) {
            JsName jsName = x.isStatic() ? GenerateJavaScriptAST.this.topScope.declareName(GenerateJavaScriptAST.this.mangleName(x), x.getName()) : (JjsUtils.requiresJsName(x) ? this.scopeStack.peek().declareUnobfuscatableName(x.getJsName()) : this.scopeStack.peek().declareName(GenerateJavaScriptAST.this.mangleName(x), x.getName()));
            GenerateJavaScriptAST.this.names.put(x, jsName);
            this.recordSymbol(x, jsName);
        }

        @Override
        public void endVisit(JInterfaceType x, Context ctx) {
            this.scopeStack.pop();
        }

        @Override
        public void endVisit(JLabel x, Context ctx) {
            if (GenerateJavaScriptAST.this.names.get(x) != null) {
                return;
            }
            GenerateJavaScriptAST.this.names.put(x, this.scopeStack.peek().declareName(x.getName()));
        }

        @Override
        public void endVisit(JLocal x, Context ctx) {
            JsScope scope = this.scopeStack.peek();
            JsName jsName = scope.declareName(x.getName());
            GenerateJavaScriptAST.this.names.put(x, jsName);
        }

        @Override
        public void endVisit(JMethod x, Context ctx) {
            if (GenerateJavaScriptAST.doesNotHaveConcreteImplementation(x)) {
                return;
            }
            this.scopeStack.pop();
        }

        @Override
        public void endVisit(JParameter x, Context ctx) {
            if (x.isVarargs() && this.currentMethod.isJsMethodVarargs()) {
                GenerateJavaScriptAST.this.names.put(x, this.scopeStack.peek().declareUnobfuscatableName("arguments"));
                return;
            }
            GenerateJavaScriptAST.this.names.put(x, this.scopeStack.peek().declareName(x.getName()));
        }

        @Override
        public void endVisit(JProgram x, Context ctx) {
            JMethod nullMethod = x.getNullMethod();
            GenerateJavaScriptAST.this.polymorphicNames.put(nullMethod, GenerateJavaScriptAST.this.objectScope.declareName("$_nullMethod"));
            JField nullField = x.getNullField();
            JsName nullFieldName = GenerateJavaScriptAST.this.objectScope.declareName("$_nullField");
            GenerateJavaScriptAST.this.names.put(nullField, nullFieldName);
            for (JArrayType arrayType : GenerateJavaScriptAST.this.program.getAllArrayTypes()) {
                if (!((GenerateJavaScriptAST)GenerateJavaScriptAST.this).program.typeOracle.isInstantiatedType(arrayType)) continue;
                this.accept(arrayType);
            }
        }

        @Override
        public boolean visit(JClassType x, Context ctx) {
            JsScope myScope = (JsScope)GenerateJavaScriptAST.this.classScopes.get(x);
            if (myScope != null) {
                this.scopeStack.push(myScope);
                return false;
            }
            JsName jsName = GenerateJavaScriptAST.this.topScope.declareName(JjsUtils.mangledNameString(x), x.getShortName());
            GenerateJavaScriptAST.this.names.put(x, jsName);
            this.recordSymbol(x, jsName);
            if (x.getSuperClass() == null) {
                myScope = GenerateJavaScriptAST.this.objectScope;
            } else {
                JsScope parentScope = (JsScope)GenerateJavaScriptAST.this.classScopes.get(x.getSuperClass());
                if (parentScope == null) {
                    this.accept(x.getSuperClass());
                }
                parentScope = (JsScope)GenerateJavaScriptAST.this.classScopes.get(x.getSuperClass());
                assert (parentScope != null);
                if (parentScope == GenerateJavaScriptAST.this.objectScope) {
                    parentScope = GenerateJavaScriptAST.this.interfaceScope;
                }
                myScope = new JsNormalScope(parentScope, "class " + x.getShortName());
            }
            GenerateJavaScriptAST.this.classScopes.put(x, myScope);
            this.scopeStack.push(myScope);
            return true;
        }

        @Override
        public boolean visit(JInterfaceType x, Context ctx) {
            this.scopeStack.push(GenerateJavaScriptAST.this.interfaceScope);
            return true;
        }

        @Override
        public boolean visit(JMethod x, Context ctx) {
            JsFunction function;
            this.currentMethod = x;
            String name = x.getName();
            if (x.needsDynamicDispatch() && GenerateJavaScriptAST.this.polymorphicNames.get(x) == null) {
                JsName polyName = JjsUtils.requiresJsName(x) ? GenerateJavaScriptAST.this.interfaceScope.declareUnobfuscatableName(x.getJsName()) : GenerateJavaScriptAST.this.interfaceScope.declareName(GenerateJavaScriptAST.this.mangleNameForPoly(x), name);
                GenerateJavaScriptAST.this.polymorphicNames.put(x, polyName);
            }
            if (GenerateJavaScriptAST.doesNotHaveConcreteImplementation(x)) {
                return false;
            }
            JsName globalName = null;
            assert (x.getEnclosingType() != null);
            String mangleName = GenerateJavaScriptAST.this.mangleNameForGlobal(x);
            if (JProgram.isClinit(x)) {
                name = name + "_" + x.getEnclosingType().getShortName();
            }
            if (!GenerateJavaScriptAST.this.stripStack || !GenerateJavaScriptAST.this.polymorphicNames.containsKey(x) || x.isJsniMethod() || GenerateJavaScriptAST.this.nameOfTargets.contains(x)) {
                globalName = GenerateJavaScriptAST.this.topScope.declareName(mangleName, name);
                GenerateJavaScriptAST.this.names.put(x, globalName);
                this.recordSymbol(x, globalName);
            }
            if (x.isJsniMethod()) {
                JsniMethodBody body = (JsniMethodBody)x.getBody();
                function = body.getFunc();
                function.setName(globalName);
            } else {
                function = new JsFunction(x.getSourceInfo(), GenerateJavaScriptAST.this.topScope, globalName, !x.isJsNative());
            }
            GenerateJavaScriptAST.this.jsFunctionsByJavaMethodBody.put(x.getBody(), function);
            this.scopeStack.push(function.getScope());
            return !GenerateJavaScriptAST.this.program.isReferenceOnly(x.getEnclosingType());
        }

        @Override
        public boolean visit(JTryStatement x, Context ctx) {
            this.accept(x.getTryBlock());
            for (JTryStatement.CatchClause clause : x.getCatchClauses()) {
                JLocalRef arg = clause.getArg();
                JBlock catchBlock = clause.getBlock();
                JsCatch jsCatch = new JsCatch(x.getSourceInfo(), this.scopeStack.peek(), arg.getTarget().getName());
                JsParameter jsParam = jsCatch.getParameter();
                GenerateJavaScriptAST.this.names.put(arg.getTarget(), jsParam.getName());
                GenerateJavaScriptAST.this.catchMap.put(catchBlock, jsCatch);
                GenerateJavaScriptAST.this.catchParamIdentifiers.add(jsParam.getName());
                this.scopeStack.push(jsCatch.getScope());
                this.accept(catchBlock);
                this.scopeStack.pop();
            }
            if (x.getFinallyBlock() != null) {
                this.accept(x.getFinallyBlock());
            }
            return false;
        }

        private String makeUriString(HasSourceInfo x) {
            String fileName = x.getSourceInfo().getFileName();
            if (fileName == null) {
                return null;
            }
            String uriString = this.fileNameToUriString.get(fileName);
            if (uriString == null) {
                uriString = StandardSymbolData.toUriString(fileName);
                this.fileNameToUriString.put(fileName, uriString);
            }
            return uriString;
        }

        private void recordSymbol(JReferenceType type, JsName jsName) {
            if (GenerateJavaScriptAST.this.getRuntimeTypeReference(type) == null || !((GenerateJavaScriptAST)GenerateJavaScriptAST.this).program.typeOracle.isInstantiatedType(type)) {
                return;
            }
            String typeId = GenerateJavaScriptAST.this.getRuntimeTypeReference(type).toSource();
            StandardSymbolData symbolData = StandardSymbolData.forClass(type.getName(), type.getSourceInfo().getFileName(), type.getSourceInfo().getStartLine(), typeId);
            assert (!GenerateJavaScriptAST.this.symbolTable.containsKey(symbolData));
            GenerateJavaScriptAST.this.symbolTable.put(symbolData, jsName);
        }

        private <T extends HasEnclosingType & HasName> void recordSymbol(T member, JsName jsName) {
            String methodSignature = null;
            if (member instanceof JMethod) {
                JMethod method = (JMethod)member;
                methodSignature = StringInterner.get().intern(method.getSignature().substring(method.getName().length()));
            }
            StandardSymbolData symbolData = StandardSymbolData.forMember(member.getEnclosingType().getName(), ((HasName)member).getName(), methodSignature, this.makeUriString((HasSourceInfo)member), ((HasSourceInfo)member).getSourceInfo().getStartLine());
            assert (!GenerateJavaScriptAST.this.symbolTable.containsKey(symbolData)) : "Duplicate symbol recorded " + jsName.getIdent() + " for " + ((HasName)member).getName() + " and key " + symbolData.getJsniIdent();
            GenerateJavaScriptAST.this.symbolTable.put(symbolData, jsName);
        }
    }

    private class FindNameOfTargets
    extends JVisitor {
        private FindNameOfTargets() {
        }

        @Override
        public void endVisit(JNameOf x, Context ctx) {
            GenerateJavaScriptAST.this.nameOfTargets.add(x.getNode());
        }
    }
}

