/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl;

import com.google.gwt.dev.jjs.ast.JDeclaredType;
import com.google.gwt.dev.jjs.ast.JField;
import com.google.gwt.dev.jjs.ast.JMethod;
import com.google.gwt.dev.jjs.ast.JNode;
import com.google.gwt.dev.jjs.ast.JProgram;
import com.google.gwt.dev.jjs.ast.JVisitor;
import com.google.gwt.dev.jjs.impl.CallGraph;
import com.google.gwt.dev.jjs.impl.FieldReferencesGraph;
import com.google.gwt.dev.jjs.impl.OptimizerContext;
import com.google.gwt.thirdparty.guava.common.collect.HashMultiset;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import com.google.gwt.thirdparty.guava.common.collect.Multiset;
import com.google.gwt.thirdparty.guava.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class FullOptimizerContext
implements OptimizerContext {
    private int optimizationStep = -1;
    private CallGraph callGraph = new CallGraph();
    private FieldReferencesGraph fieldReferencesGraph = new FieldReferencesGraph();
    private List<CallGraph> deletedSubCallGraphs = Lists.newArrayList();
    private List<CallGraph> addedSubCallGraphs = Lists.newArrayList();
    private Multiset<JMethod> modificationStepByMethod = HashMultiset.create();
    private List<Set<JMethod>> methodsByModificationStep = Lists.newArrayList();
    private Multiset<JField> modificationStepByField = HashMultiset.create();
    private List<Set<JField>> fieldsByModificationStep = Lists.newArrayList();
    private Multiset<String> lastStepForOptimizer = HashMultiset.create();

    public FullOptimizerContext(JProgram program) {
        this.incOptimizationStep();
        this.initializeModifications(program);
        this.buildCallGraph(program);
        this.buildFieldReferencesGraph(program);
        this.incOptimizationStep();
    }

    @Override
    public Set<JMethod> getCallees(Collection<JMethod> callerMethods) {
        return this.callGraph.getCallees(callerMethods);
    }

    @Override
    public Set<JMethod> getCallers(Collection<JMethod> calleeMethods) {
        return this.callGraph.getCallers(calleeMethods);
    }

    @Override
    public int getLastStepFor(String optimizerName) {
        return this.lastStepForOptimizer.count(optimizerName);
    }

    @Override
    public Set<JMethod> getMethodsByReferencedFields(Collection<JField> fields) {
        return this.fieldReferencesGraph.getReferencingMethodsForFields(fields);
    }

    @Override
    public Set<JField> getModifiedFieldsSince(int stepSince) {
        LinkedHashSet<JField> result = Sets.newLinkedHashSet();
        for (int i = stepSince; i < this.optimizationStep; ++i) {
            result.addAll((Collection<JField>)this.fieldsByModificationStep.get(i));
        }
        return result;
    }

    @Override
    public Set<JMethod> getModifiedMethodsSince(int stepSince) {
        LinkedHashSet<JMethod> result = Sets.newLinkedHashSet();
        for (int i = stepSince; i < this.optimizationStep; ++i) {
            result.addAll((Collection<JMethod>)this.methodsByModificationStep.get(i));
        }
        return result;
    }

    @Override
    public int getOptimizationStep() {
        return this.optimizationStep;
    }

    @Override
    public Set<JField> getReferencedFieldsByMethods(Collection<JMethod> methods) {
        return this.fieldReferencesGraph.getReferencedFieldsByMethods(methods);
    }

    @Override
    public Set<JMethod> getRemovedCalleeMethodsSince(int stepSince) {
        LinkedHashSet<JMethod> removedCalleeMethods = Sets.newLinkedHashSet();
        for (int i = stepSince; i < this.optimizationStep; ++i) {
            removedCalleeMethods.addAll(this.deletedSubCallGraphs.get(i).getAllCallees());
        }
        return removedCalleeMethods;
    }

    @Override
    public void incOptimizationStep() {
        this.methodsByModificationStep.add(new LinkedHashSet());
        this.fieldsByModificationStep.add(new LinkedHashSet());
        this.deletedSubCallGraphs.add(new CallGraph());
        this.addedSubCallGraphs.add(new CallGraph());
        ++this.optimizationStep;
    }

    @Override
    public void markModified(JField modifiedField) {
        this.fieldsByModificationStep.get(this.modificationStepByField.count(modifiedField)).remove(modifiedField);
        this.fieldsByModificationStep.get(this.optimizationStep).add(modifiedField);
        this.modificationStepByField.setCount(modifiedField, this.optimizationStep);
    }

    @Override
    public void markModified(JMethod modifiedMethod) {
        this.methodsByModificationStep.get(this.modificationStepByMethod.count(modifiedMethod)).remove(modifiedMethod);
        this.methodsByModificationStep.get(this.optimizationStep).add(modifiedMethod);
        this.modificationStepByMethod.setCount(modifiedMethod, this.optimizationStep);
        this.callGraph.updateCallGraphOfMethod(modifiedMethod, this.deletedSubCallGraphs.get(this.optimizationStep), this.addedSubCallGraphs.get(this.optimizationStep));
        this.fieldReferencesGraph.updateFieldReferencesOfMethod(modifiedMethod);
    }

    @Override
    public void remove(JField field) {
        this.fieldsByModificationStep.get(this.modificationStepByField.count(field)).remove(field);
        this.modificationStepByField.remove(field);
        this.fieldReferencesGraph.removeField(field);
    }

    @Override
    public void remove(JMethod method) {
        this.methodsByModificationStep.get(this.modificationStepByMethod.count(method)).remove(method);
        this.modificationStepByMethod.remove(method);
        Set<JMethod> calleeMethods = this.callGraph.removeCallerMethod(method);
        this.deletedSubCallGraphs.get(this.optimizationStep).addCallerMethod(method, Sets.difference(calleeMethods, this.callGraph.getCallees(Collections.singleton(method))));
        this.addedSubCallGraphs.get(this.optimizationStep).addCallerMethod(method, Sets.difference(this.callGraph.getCallees(Collections.singleton(method)), calleeMethods));
        this.fieldReferencesGraph.removeMethod(method);
    }

    @Override
    public void removeFields(Collection<JField> fields) {
        for (JField field : fields) {
            this.remove(field);
        }
    }

    @Override
    public void removeMethods(Collection<JMethod> methods) {
        for (JMethod method : methods) {
            this.remove(method);
        }
    }

    @Override
    public void setLastStepFor(String optimizerName, int step) {
        this.lastStepForOptimizer.setCount(optimizerName, step);
    }

    @Override
    public void syncDeletedSubCallGraphsSince(int step, Collection<JMethod> prunedMethods) {
        for (int i = step; i < this.optimizationStep; ++i) {
            for (JMethod prunedMethod : prunedMethods) {
                this.deletedSubCallGraphs.get(i).removeCallerMethod(prunedMethod);
                this.deletedSubCallGraphs.get(i).removeCalleeMethod(prunedMethod);
            }
        }
    }

    @Override
    public void traverse(JVisitor visitor, Set<? extends JNode> nodes) {
        assert (nodes != null);
        for (JNode jNode : nodes) {
            visitor.accept(jNode);
        }
    }

    private void buildCallGraph(JProgram program) {
        this.callGraph.buildCallGraph(program);
    }

    private void buildFieldReferencesGraph(JProgram program) {
        this.fieldReferencesGraph.buildFieldReferencesGraph(program);
    }

    private void initializeModifications(JProgram program) {
        assert (this.optimizationStep == 0);
        for (JDeclaredType type : program.getModuleDeclaredTypes()) {
            this.fieldsByModificationStep.get(0).addAll(type.getFields());
            this.methodsByModificationStep.get(0).addAll(type.getMethods());
        }
    }
}

