/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl;

import com.google.gwt.dev.jjs.ast.Context;
import com.google.gwt.dev.jjs.ast.JBinaryOperation;
import com.google.gwt.dev.jjs.ast.JCastOperation;
import com.google.gwt.dev.jjs.ast.JClassType;
import com.google.gwt.dev.jjs.ast.JExpression;
import com.google.gwt.dev.jjs.ast.JModVisitor;
import com.google.gwt.dev.jjs.ast.JPostfixOperation;
import com.google.gwt.dev.jjs.ast.JPrefixOperation;
import com.google.gwt.dev.jjs.ast.JPrimitiveType;
import com.google.gwt.dev.jjs.ast.JProgram;
import com.google.gwt.dev.jjs.impl.AutoboxUtils;
import com.google.gwt.dev.jjs.impl.CompoundAssignmentNormalizer;
import com.google.gwt.dev.util.log.speedtracer.CompilerEventType;
import com.google.gwt.dev.util.log.speedtracer.SpeedTracerLogger;

public class FixAssignmentsToUnboxOrCast
extends JModVisitor {
    private final AutoboxUtils autoboxUtils;

    public static void exec(JProgram program) {
        SpeedTracerLogger.Event fixAssignmentToUnboxEvent = SpeedTracerLogger.start(CompilerEventType.FIX_ASSIGNMENT_TO_UNBOX, new String[0]);
        new CompoundAssignmentsToUnboxOrCastNormalizer(program).accept(program);
        new FixAssignmentsToUnboxOrCast(program).accept(program);
        fixAssignmentToUnboxEvent.end(new String[0]);
    }

    private FixAssignmentsToUnboxOrCast(JProgram program) {
        this.autoboxUtils = new AutoboxUtils(program);
    }

    private JBinaryOperation maybeFixLhsCast(JBinaryOperation x) {
        if (!(x.getLhs() instanceof JCastOperation)) {
            return x;
        }
        JCastOperation cast = (JCastOperation)x.getLhs();
        return new JBinaryOperation(x.getSourceInfo(), x.getType(), x.getOp(), cast.getExpr(), x.getRhs());
    }

    private JBinaryOperation maybeUndoBox(JBinaryOperation x) {
        JExpression lhs = x.getLhs();
        JExpression boxed = this.autoboxUtils.undoUnbox(lhs);
        if (boxed == null) {
            return x;
        }
        JClassType boxedType = (JClassType)boxed.getType();
        return new JBinaryOperation(x.getSourceInfo(), boxedType, x.getOp(), boxed, this.autoboxUtils.box(x.getRhs(), (JPrimitiveType)lhs.getType()));
    }

    @Override
    public void endVisit(JBinaryOperation x, Context ctx) {
        if (!x.isAssignment()) {
            return;
        }
        JBinaryOperation result = this.maybeFixLhsCast(this.maybeUndoBox(x));
        if (result != x) {
            ctx.replaceMe(result);
        }
    }

    private static class CompoundAssignmentsToUnboxOrCastNormalizer
    extends CompoundAssignmentNormalizer {
        private final AutoboxUtils autoboxUtils;

        protected CompoundAssignmentsToUnboxOrCastNormalizer(JProgram program) {
            this.autoboxUtils = new AutoboxUtils(program);
        }

        @Override
        protected JExpression expressionToReturn(JExpression lhs) {
            JExpression boxed = this.autoboxUtils.undoUnbox(lhs);
            if (boxed != null) {
                return boxed;
            }
            return lhs;
        }

        @Override
        protected boolean shouldBreakUp(JBinaryOperation x) {
            return this.isUnboxOrCastExpression(x.getLhs());
        }

        @Override
        protected boolean shouldBreakUp(JPostfixOperation x) {
            return this.isUnboxOrCastExpression(x.getArg());
        }

        @Override
        protected boolean shouldBreakUp(JPrefixOperation x) {
            return this.isUnboxOrCastExpression(x.getArg());
        }

        private boolean isUnboxOrCastExpression(JExpression x) {
            return this.autoboxUtils.undoUnbox(x) != null || x instanceof JCastOperation;
        }
    }
}

