/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl;

import com.google.gwt.dev.jjs.ast.CanBeSetFinal;
import com.google.gwt.dev.jjs.ast.Context;
import com.google.gwt.dev.jjs.ast.JBinaryOperation;
import com.google.gwt.dev.jjs.ast.JClassType;
import com.google.gwt.dev.jjs.ast.JConstructor;
import com.google.gwt.dev.jjs.ast.JDeclarationStatement;
import com.google.gwt.dev.jjs.ast.JExpression;
import com.google.gwt.dev.jjs.ast.JField;
import com.google.gwt.dev.jjs.ast.JFieldRef;
import com.google.gwt.dev.jjs.ast.JLocal;
import com.google.gwt.dev.jjs.ast.JMethod;
import com.google.gwt.dev.jjs.ast.JMethodBody;
import com.google.gwt.dev.jjs.ast.JParameter;
import com.google.gwt.dev.jjs.ast.JPostfixOperation;
import com.google.gwt.dev.jjs.ast.JPrefixOperation;
import com.google.gwt.dev.jjs.ast.JProgram;
import com.google.gwt.dev.jjs.ast.JVariable;
import com.google.gwt.dev.jjs.ast.JVariableRef;
import com.google.gwt.dev.jjs.ast.JVisitor;
import com.google.gwt.dev.jjs.ast.js.JsniFieldRef;
import com.google.gwt.dev.jjs.impl.JChangeTrackingVisitor;
import com.google.gwt.dev.jjs.impl.JavaAstVerifier;
import com.google.gwt.dev.jjs.impl.OptimizerContext;
import com.google.gwt.dev.jjs.impl.OptimizerStats;
import com.google.gwt.dev.util.log.speedtracer.CompilerEventType;
import com.google.gwt.dev.util.log.speedtracer.SpeedTracerLogger;
import com.google.gwt.thirdparty.guava.common.annotations.VisibleForTesting;
import com.google.gwt.thirdparty.guava.common.collect.Sets;
import java.util.Set;

public class Finalizer {
    private static final String NAME = Finalizer.class.getSimpleName();
    private final Set<JVariable> isReassigned = Sets.newHashSet();
    private final JProgram program;

    private Finalizer(JProgram program) {
        this.program = program;
    }

    @VisibleForTesting
    static OptimizerStats exec(JProgram program) {
        return Finalizer.exec(program, OptimizerContext.NULL_OPTIMIZATION_CONTEXT);
    }

    public static OptimizerStats exec(JProgram program, OptimizerContext optimizerCtx) {
        SpeedTracerLogger.Event optimizeEvent = SpeedTracerLogger.start(CompilerEventType.OPTIMIZE, "optimizer", NAME);
        OptimizerStats stats = new Finalizer(program).execImpl(optimizerCtx);
        optimizerCtx.incOptimizationStep();
        optimizeEvent.end("didChange", "" + stats.didChange());
        return stats;
    }

    private OptimizerStats execImpl(OptimizerContext optimizerCtx) {
        MarkVisitor marker = new MarkVisitor();
        marker.accept(this.program);
        FinalizeVisitor finalizer = new FinalizeVisitor(optimizerCtx);
        finalizer.accept(this.program);
        JavaAstVerifier.assertProgramIsConsistent(this.program);
        return new OptimizerStats(NAME).recordModified(finalizer.getNumMods());
    }

    private class MarkVisitor
    extends JVisitor {
        private MarkVisitor() {
        }

        @Override
        public void endVisit(JBinaryOperation x, Context ctx) {
            if (x.getOp().isAssignment()) {
                this.recordAssignment(x.getLhs());
            }
        }

        @Override
        public void endVisit(JConstructor x, Context ctx) {
        }

        @Override
        public void endVisit(JDeclarationStatement x, Context ctx) {
            JField field;
            if (x.getVariableRef() instanceof JFieldRef && (field = ((JFieldRef)x.getVariableRef()).getField()).getLiteralInitializer() != null && !field.getLiteralInitializer().equals(field.getType().getDefaultValue())) {
                this.recordAssignment(x.getVariableRef());
            }
        }

        @Override
        public void endVisit(JPostfixOperation x, Context ctx) {
            if (x.getOp().isModifying()) {
                this.recordAssignment(x.getArg());
            }
        }

        @Override
        public void endVisit(JPrefixOperation x, Context ctx) {
            if (x.getOp().isModifying()) {
                this.recordAssignment(x.getArg());
            }
        }

        @Override
        public void endVisit(JsniFieldRef x, Context ctx) {
            if (x.isLvalue()) {
                this.recordAssignment(x);
            }
        }

        @Override
        public boolean visit(JClassType x, Context ctx) {
            return !x.isExternal();
        }

        private void recordAssignment(JExpression lhs) {
            if (lhs instanceof JVariableRef) {
                JVariableRef variableRef = (JVariableRef)lhs;
                Finalizer.this.isReassigned.add(variableRef.getTarget());
            }
        }
    }

    private class FinalizeVisitor
    extends JChangeTrackingVisitor {
        public FinalizeVisitor(OptimizerContext optimizerCtx) {
            super(optimizerCtx);
        }

        @Override
        public void exit(JConstructor x, Context ctx) {
        }

        @Override
        public void exit(JField x, Context ctx) {
            if (x.isVolatile() || x.canBeImplementedExternally() || x.canBeReferencedExternally()) {
                return;
            }
            this.maybeFinalize(x);
        }

        @Override
        public void endVisit(JLocal x, Context ctx) {
            this.maybeFinalize(x);
        }

        @Override
        public void exit(JMethod x, Context ctx) {
            if (!x.isFinal() && x.getOverridingMethods().isEmpty()) {
                this.setFinal(x);
            }
        }

        @Override
        public void endVisit(JParameter x, Context ctx) {
            this.maybeFinalize(x);
        }

        @Override
        public boolean visit(JClassType x, Context ctx) {
            return !x.isExternal();
        }

        @Override
        public boolean visit(JMethodBody x, Context ctx) {
            for (JLocal local : x.getLocals()) {
                this.maybeFinalize(local);
            }
            return false;
        }

        private void maybeFinalize(JVariable x) {
            if (!x.isFinal() && !Finalizer.this.isReassigned.contains(x)) {
                this.setFinal(x);
            }
        }

        private void setFinal(CanBeSetFinal x) {
            x.setFinal();
            assert (x.isFinal());
            this.madeChanges();
        }
    }
}

