/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl;

import com.google.gwt.dev.jjs.ast.Context;
import com.google.gwt.dev.jjs.ast.JField;
import com.google.gwt.dev.jjs.ast.JFieldRef;
import com.google.gwt.dev.jjs.ast.JMethod;
import com.google.gwt.dev.jjs.ast.JProgram;
import com.google.gwt.dev.jjs.ast.JVisitor;
import com.google.gwt.thirdparty.guava.common.collect.LinkedHashMultimap;
import com.google.gwt.thirdparty.guava.common.collect.Multimap;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;

public class FieldReferencesGraph {
    private Multimap<JField, JMethod> methodsByReferencedField = LinkedHashMultimap.create();
    private Multimap<JMethod, JField> referencedFieldsByMethod = LinkedHashMultimap.create();

    public void buildFieldReferencesGraph(JProgram program) {
        this.reset();
        BuildFieldReferencesGraphVisitor buildFieldUsesVisitor = new BuildFieldReferencesGraphVisitor();
        buildFieldUsesVisitor.accept(program);
    }

    public Set<JField> getReferencedFieldsByMethods(Collection<JMethod> methods) {
        assert (methods != null);
        LinkedHashSet<JField> result = new LinkedHashSet<JField>();
        for (JMethod method : methods) {
            result.addAll(this.referencedFieldsByMethod.get(method));
        }
        return result;
    }

    public Set<JMethod> getReferencingMethodsForFields(Collection<JField> fields) {
        assert (fields != null);
        LinkedHashSet<JMethod> referencingMethods = new LinkedHashSet<JMethod>();
        for (JField field : fields) {
            referencingMethods.addAll(this.methodsByReferencedField.get(field));
        }
        return referencingMethods;
    }

    public void removeField(JField field) {
        Collection<JMethod> methods = this.methodsByReferencedField.removeAll(field);
        for (JMethod method : methods) {
            this.referencedFieldsByMethod.remove(method, field);
        }
    }

    public void removeMethod(JMethod method) {
        Collection<JField> referencedFields = this.referencedFieldsByMethod.removeAll(method);
        for (JField referencedField : referencedFields) {
            this.methodsByReferencedField.remove(referencedField, method);
        }
    }

    public void reset() {
        this.methodsByReferencedField.clear();
        this.referencedFieldsByMethod.clear();
    }

    public void updateFieldReferencesOfMethod(JMethod method) {
        this.removeMethod(method);
        BuildFieldReferencesGraphVisitor buildFieldUsesVisitor = new BuildFieldReferencesGraphVisitor();
        buildFieldUsesVisitor.accept(method);
    }

    class BuildFieldReferencesGraphVisitor
    extends JVisitor {
        private JMethod currentMethod;

        BuildFieldReferencesGraphVisitor() {
        }

        @Override
        public void endVisit(JFieldRef x, Context ctx) {
            JField field = x.getField();
            if (this.currentMethod != null) {
                FieldReferencesGraph.this.methodsByReferencedField.put(field, this.currentMethod);
                FieldReferencesGraph.this.referencedFieldsByMethod.put(this.currentMethod, field);
            }
        }

        @Override
        public void endVisit(JMethod x, Context ctx) {
            assert (this.currentMethod == x);
            this.currentMethod = null;
        }

        @Override
        public boolean visit(JMethod x, Context ctx) {
            assert (this.currentMethod == null);
            this.currentMethod = x;
            return true;
        }
    }
}

