/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl;

import com.google.gwt.dev.jjs.ast.Context;
import com.google.gwt.dev.jjs.ast.JArrayLength;
import com.google.gwt.dev.jjs.ast.JArrayRef;
import com.google.gwt.dev.jjs.ast.JBinaryOperation;
import com.google.gwt.dev.jjs.ast.JBinaryOperator;
import com.google.gwt.dev.jjs.ast.JCastOperation;
import com.google.gwt.dev.jjs.ast.JConditional;
import com.google.gwt.dev.jjs.ast.JExpression;
import com.google.gwt.dev.jjs.ast.JFieldRef;
import com.google.gwt.dev.jjs.ast.JIntLiteral;
import com.google.gwt.dev.jjs.ast.JLocalRef;
import com.google.gwt.dev.jjs.ast.JMethodCall;
import com.google.gwt.dev.jjs.ast.JNewArray;
import com.google.gwt.dev.jjs.ast.JNewInstance;
import com.google.gwt.dev.jjs.ast.JParameterRef;
import com.google.gwt.dev.jjs.ast.JPostfixOperation;
import com.google.gwt.dev.jjs.ast.JPrefixOperation;
import com.google.gwt.dev.jjs.ast.JReferenceType;
import com.google.gwt.dev.jjs.ast.JThisRef;
import com.google.gwt.dev.jjs.ast.JVisitor;

public class ExpressionAnalyzer
extends JVisitor {
    private boolean accessesField;
    private boolean accessesFieldNonFinal;
    private boolean accessesLocal;
    private boolean accessesParameter;
    private boolean assignmentToField;
    private boolean assignmentToLocal;
    private boolean assignmentToParameter;
    private boolean canThrowException;
    private boolean createsObject;
    private int inConditional;

    public boolean accessesField() {
        return this.accessesField;
    }

    public boolean accessesFieldNonFinal() {
        return this.accessesFieldNonFinal;
    }

    public boolean accessesLocal() {
        return this.accessesLocal;
    }

    public boolean accessesParameter() {
        return this.accessesParameter;
    }

    public boolean canThrowException() {
        return this.canThrowException;
    }

    public boolean createsObject() {
        return this.createsObject;
    }

    @Override
    public void endVisit(JArrayLength x, Context ctx) {
        this.accessesField = true;
        JReferenceType refType = (JReferenceType)x.getInstance().getType();
        this.canThrowException = refType.canBeNull();
    }

    @Override
    public void endVisit(JArrayRef x, Context ctx) {
        this.canThrowException = true;
    }

    @Override
    public void endVisit(JBinaryOperation x, Context ctx) {
        if (x.isAssignment()) {
            JExpression lhs = x.getLhs();
            if (lhs instanceof JArrayRef) {
                this.canThrowException = true;
            } else {
                this.analyzeStore(lhs);
            }
        }
    }

    @Override
    public void endVisit(JCastOperation x, Context ctx) {
        this.canThrowException = true;
    }

    @Override
    public void endVisit(JFieldRef x, Context ctx) {
        JExpression instance;
        this.accessesField = true;
        if (!x.getTarget().isFinal()) {
            this.accessesFieldNonFinal = true;
        }
        if (x.hasClinit()) {
            this.recordMethodCall();
        }
        if ((instance = x.getInstance()) == null) {
            return;
        }
        if (instance instanceof JThisRef) {
            return;
        }
        if (x.getField().isStatic()) {
            this.canThrowException = x.hasClinit();
        } else {
            JReferenceType refType = (JReferenceType)instance.getType();
            this.canThrowException = refType.canBeNull();
        }
    }

    @Override
    public void endVisit(JLocalRef x, Context ctx) {
        this.accessesLocal = true;
    }

    @Override
    public void endVisit(JMethodCall x, Context ctx) {
        this.recordMethodCall();
    }

    @Override
    public void endVisit(JNewArray x, Context ctx) {
        this.createsObject = true;
        if (x.getDimensionExpressions() == null) {
            return;
        }
        for (JExpression expression : x.getDimensionExpressions()) {
            int value;
            if (expression instanceof JIntLiteral && (value = ((JIntLiteral)expression).getValue()) >= 0) continue;
            this.canThrowException = true;
        }
    }

    @Override
    public void endVisit(JNewInstance x, Context ctx) {
        this.createsObject = true;
        this.endVisit((JMethodCall)x, ctx);
    }

    @Override
    public void endVisit(JParameterRef x, Context ctx) {
        this.accessesParameter = true;
    }

    @Override
    public void endVisit(JPostfixOperation x, Context ctx) {
        if (x.getOp().isModifying()) {
            this.analyzeStore(x.getArg());
        }
    }

    @Override
    public void endVisit(JPrefixOperation x, Context ctx) {
        if (x.getOp().isModifying()) {
            this.analyzeStore(x.getArg());
        }
    }

    public boolean hasAssignment() {
        return this.assignmentToField || this.assignmentToLocal || this.assignmentToParameter;
    }

    public boolean hasAssignmentToField() {
        return this.assignmentToField;
    }

    public boolean hasAssignmentToLocal() {
        return this.assignmentToLocal;
    }

    public boolean hasAssignmentToParameter() {
        return this.assignmentToParameter;
    }

    @Override
    public boolean visit(JBinaryOperation x, Context ctx) {
        if (x.getOp() == JBinaryOperator.AND || x.getOp() == JBinaryOperator.OR) {
            this.accept(x.getLhs());
            ++this.inConditional;
            this.accept(x.getRhs());
            --this.inConditional;
            return false;
        }
        return true;
    }

    @Override
    public boolean visit(JConditional x, Context ctx) {
        this.accept(x.getIfTest());
        ++this.inConditional;
        this.accept(x.getThenExpr());
        this.accept(x.getElseExpr());
        --this.inConditional;
        return false;
    }

    protected boolean isInConditional() {
        return this.inConditional > 0;
    }

    private void analyzeStore(JExpression expr) {
        if (expr instanceof JFieldRef) {
            this.assignmentToField = true;
        } else if (expr instanceof JParameterRef) {
            this.assignmentToParameter = true;
        } else if (expr instanceof JLocalRef) {
            this.assignmentToLocal = true;
        }
    }

    private void recordMethodCall() {
        this.assignmentToField = true;
        this.accessesField = true;
        this.accessesFieldNonFinal = true;
        this.canThrowException = true;
        this.createsObject = true;
    }
}

