/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl;

import com.google.gwt.dev.jjs.ast.Context;
import com.google.gwt.dev.jjs.ast.JBinaryOperation;
import com.google.gwt.dev.jjs.ast.JBinaryOperator;
import com.google.gwt.dev.jjs.ast.JClassType;
import com.google.gwt.dev.jjs.ast.JExpression;
import com.google.gwt.dev.jjs.ast.JMethod;
import com.google.gwt.dev.jjs.ast.JMethodCall;
import com.google.gwt.dev.jjs.ast.JModVisitor;
import com.google.gwt.dev.jjs.ast.JProgram;
import com.google.gwt.dev.jjs.ast.JReferenceType;
import com.google.gwt.dev.jjs.ast.JType;
import java.util.Map;

public class EqualityNormalizer {
    private static final int D = 0;
    private static final int T = 1;
    private static int[][] COMPARISON_TABLE = new int[][]{{1, 1, 1, 1, 1, 0}, {1, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {1, 1, 1, 0, 1, 0}, {1, 1, 1, 1, 0, 0}, {0, 0, 0, 0, 0, 0}};
    private final JProgram program;

    public static void exec(JProgram program) {
        new EqualityNormalizer(program).execImpl();
    }

    private static boolean canBeNull(JExpression x) {
        return x.getType().canBeNull();
    }

    private EqualityNormalizer(JProgram program) {
        this.program = program;
    }

    private void execImpl() {
        BreakupAssignOpsVisitor breaker = new BreakupAssignOpsVisitor();
        breaker.accept(this.program);
    }

    private static enum UnboxedTypeStatus {
        NOT_UNBOXEDTYPE(4),
        NULL(5),
        DOUBLE(3),
        BOOLEAN(2),
        STRING(1),
        UNKNOWN(0);

        private int index;

        private UnboxedTypeStatus(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }
    }

    private class BreakupAssignOpsVisitor
    extends JModVisitor {
        private BreakupAssignOpsVisitor() {
        }

        @Override
        public void endVisit(JBinaryOperation x, Context ctx) {
            JBinaryOperator op = x.getOp();
            if (op != JBinaryOperator.EQ && op != JBinaryOperator.NEQ) {
                return;
            }
            JExpression lhs = x.getLhs();
            JExpression rhs = x.getRhs();
            JType lhsType = lhs.getType();
            JType rhsType = rhs.getType();
            if (!(lhsType instanceof JReferenceType)) {
                assert (!(rhsType instanceof JReferenceType));
                return;
            }
            UnboxedTypeStatus lhsStatus = this.getUnboxedTypeStatus((JReferenceType)lhsType);
            UnboxedTypeStatus rhsStatus = this.getUnboxedTypeStatus((JReferenceType)rhsType);
            int comparisonStrategy = COMPARISON_TABLE[lhsStatus.getIndex()][rhsStatus.getIndex()];
            switch (comparisonStrategy) {
                case 1: {
                    if (EqualityNormalizer.canBeNull(lhs) && EqualityNormalizer.canBeNull(rhs)) {
                        lhs = this.maskUndefined(lhs);
                        rhs = this.maskUndefined(rhs);
                    }
                    JBinaryOperation binOp = new JBinaryOperation(x.getSourceInfo(), x.getType(), x.getOp(), lhs, rhs);
                    ctx.replaceMe(binOp);
                    break;
                }
                case 0: {
                    boolean rhsNullLit;
                    boolean lhsNullLit = lhs == EqualityNormalizer.this.program.getLiteralNull();
                    boolean bl = rhsNullLit = rhs == EqualityNormalizer.this.program.getLiteralNull();
                    if (lhsNullLit && rhsStatus == UnboxedTypeStatus.NOT_UNBOXEDTYPE || rhsNullLit && lhsStatus == UnboxedTypeStatus.NOT_UNBOXEDTYPE) {
                        String methodName = op == JBinaryOperator.EQ ? "Cast.isNull" : "Cast.isNotNull";
                        JMethod isNullMethod = EqualityNormalizer.this.program.getIndexedMethod(methodName);
                        JMethodCall call = new JMethodCall(x.getSourceInfo(), null, isNullMethod, new JExpression[0]);
                        call.addArg(lhsNullLit ? rhs : lhs);
                        ctx.replaceMe(call);
                        break;
                    }
                    String methodName = op == JBinaryOperator.EQ ? "Cast.jsEquals" : "Cast.jsNotEquals";
                    JMethod eqMethod = EqualityNormalizer.this.program.getIndexedMethod(methodName);
                    JMethodCall call = new JMethodCall(x.getSourceInfo(), null, eqMethod, new JExpression[0]);
                    call.addArgs(lhs, rhs);
                    ctx.replaceMe(call);
                    break;
                }
            }
        }

        private UnboxedTypeStatus getUnboxedTypeStatus(JReferenceType type) {
            if (type.isNullType()) {
                return UnboxedTypeStatus.NULL;
            }
            for (Map.Entry<JClassType, JProgram.DispatchType> nativeDispatchType : EqualityNormalizer.this.program.getRepresentedAsNativeTypesDispatchMap().entrySet()) {
                if (type.getUnderlyingType() == nativeDispatchType.getKey()) {
                    switch (nativeDispatchType.getValue()) {
                        case DOUBLE: {
                            return UnboxedTypeStatus.DOUBLE;
                        }
                        case BOOLEAN: {
                            return UnboxedTypeStatus.BOOLEAN;
                        }
                        case STRING: {
                            return UnboxedTypeStatus.STRING;
                        }
                    }
                    throw new AssertionError((Object)"Shouldn't happen");
                }
                if (((EqualityNormalizer)EqualityNormalizer.this).program.typeOracle.castFailsTrivially(type, nativeDispatchType.getKey())) continue;
                return UnboxedTypeStatus.UNKNOWN;
            }
            return UnboxedTypeStatus.NOT_UNBOXEDTYPE;
        }

        private JExpression maskUndefined(JExpression lhs) {
            assert (lhs.getType().canBeNull());
            JMethod maskMethod = EqualityNormalizer.this.program.getIndexedMethod("Cast.maskUndefined");
            JMethodCall lhsCall = new JMethodCall(lhs.getSourceInfo(), null, maskMethod, lhs);
            lhsCall.overrideReturnType(lhs.getType());
            return lhsCall;
        }
    }
}

