/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.dev.jjs.SourceInfo;
import com.google.gwt.dev.jjs.ast.Context;
import com.google.gwt.dev.jjs.ast.JArrayType;
import com.google.gwt.dev.jjs.ast.JCastOperation;
import com.google.gwt.dev.jjs.ast.JClassLiteral;
import com.google.gwt.dev.jjs.ast.JClassType;
import com.google.gwt.dev.jjs.ast.JDeclarationStatement;
import com.google.gwt.dev.jjs.ast.JEnumField;
import com.google.gwt.dev.jjs.ast.JEnumType;
import com.google.gwt.dev.jjs.ast.JExpression;
import com.google.gwt.dev.jjs.ast.JField;
import com.google.gwt.dev.jjs.ast.JFieldRef;
import com.google.gwt.dev.jjs.ast.JInstanceOf;
import com.google.gwt.dev.jjs.ast.JMethod;
import com.google.gwt.dev.jjs.ast.JMethodCall;
import com.google.gwt.dev.jjs.ast.JNewArray;
import com.google.gwt.dev.jjs.ast.JNode;
import com.google.gwt.dev.jjs.ast.JParameter;
import com.google.gwt.dev.jjs.ast.JPrimitiveType;
import com.google.gwt.dev.jjs.ast.JProgram;
import com.google.gwt.dev.jjs.ast.JType;
import com.google.gwt.dev.jjs.ast.js.JsniClassLiteral;
import com.google.gwt.dev.jjs.ast.js.JsniFieldRef;
import com.google.gwt.dev.jjs.ast.js.JsniMethodRef;
import com.google.gwt.dev.jjs.impl.AstDumper;
import com.google.gwt.dev.jjs.impl.ImplicitUpcastAnalyzer;
import com.google.gwt.dev.jjs.impl.JavaAstVerifier;
import com.google.gwt.dev.jjs.impl.OptimizerContext;
import com.google.gwt.dev.jjs.impl.OptimizerStats;
import com.google.gwt.dev.jjs.impl.TypeRemapper;
import com.google.gwt.dev.util.log.speedtracer.CompilerEventType;
import com.google.gwt.dev.util.log.speedtracer.SpeedTracerLogger;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import com.google.gwt.thirdparty.guava.common.collect.Multimap;
import com.google.gwt.thirdparty.guava.common.collect.Ordering;
import com.google.gwt.thirdparty.guava.common.collect.Sets;
import com.google.gwt.thirdparty.guava.common.collect.TreeMultimap;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class EnumOrdinalizer {
    private static final String NAME = EnumOrdinalizer.class.getSimpleName();
    private static Tracker tracker = null;
    private static boolean trackerEnabled = System.getProperty("gwt.enableEnumOrdinalizerTracking") != null;
    private final JType classLiteralHolderType;
    private final JMethod enumCreateValueOfMapMethod;
    private final JField enumOrdinalField;
    private final JMethod enumOrdinalMethod;
    private final JMethod enumSuperConstructor;
    private final Set<JEnumType> enumsVisited = Sets.newHashSet();
    private final JType javaScriptObjectType;
    private final Set<JEnumType> ordinalizationBlackList = Sets.newHashSet();
    private final JProgram program;

    public static void enableTracker() {
        trackerEnabled = true;
    }

    public static OptimizerStats exec(JProgram program, OptimizerContext optimizerCtx) {
        SpeedTracerLogger.Event optimizeEvent = SpeedTracerLogger.start(CompilerEventType.OPTIMIZE, "optimizer", NAME);
        EnumOrdinalizer.startTracker();
        OptimizerStats stats = new EnumOrdinalizer(program).execImpl(optimizerCtx);
        optimizerCtx.incOptimizationStep();
        optimizeEvent.end("didChange", "" + stats.didChange());
        return stats;
    }

    public static Tracker getTracker() {
        return tracker;
    }

    public static void resetTracker() {
        if (tracker != null) {
            tracker = null;
            EnumOrdinalizer.startTracker();
        }
    }

    private static void startTracker() {
        if (trackerEnabled && tracker == null) {
            tracker = new Tracker();
        }
    }

    public EnumOrdinalizer(JProgram program) {
        this.program = program;
        this.classLiteralHolderType = program.getTypeClassLiteralHolder();
        this.javaScriptObjectType = program.getJavaScriptObject();
        this.enumOrdinalField = program.getIndexedField("Enum.ordinal");
        this.enumCreateValueOfMapMethod = program.getIndexedMethod("Enum.createValueOfMap");
        this.enumOrdinalMethod = program.getIndexedMethod("Enum.ordinal");
        this.enumSuperConstructor = program.getIndexedMethod("Enum.Enum");
    }

    private OptimizerStats execImpl(OptimizerContext optimizerCtx) {
        OptimizerStats stats = new OptimizerStats(NAME);
        if (tracker != null) {
            tracker.incrementRunCount();
            tracker.maybeDumpAST(this.program, 0);
        }
        CannotBeOrdinalAnalyzer ordinalAnalyzer = new CannotBeOrdinalAnalyzer(this.program);
        ordinalAnalyzer.accept(this.program);
        if (this.enumsVisited.size() == this.ordinalizationBlackList.size()) {
            if (tracker != null) {
                for (JEnumType type : this.enumsVisited) {
                    tracker.addVisited(type.getName());
                }
            }
            return stats;
        }
        ReplaceOrdinalizedEnumTypes replaceEnums = new ReplaceOrdinalizedEnumTypes(optimizerCtx);
        replaceEnums.accept(this.program);
        stats.recordModified(replaceEnums.getNumMods());
        if (tracker != null) {
            tracker.maybeDumpAST(this.program, 1);
        }
        for (JEnumType type : this.enumsVisited) {
            if (tracker != null) {
                tracker.addVisited(type.getName());
            }
            if (this.ordinalizationBlackList.contains(type)) continue;
            if (tracker != null) {
                tracker.addOrdinalized(type.getName());
            }
            type.setOrdinalized();
        }
        JavaAstVerifier.assertProgramIsConsistent(this.program);
        return stats;
    }

    private JEnumType getEnumTypeFromArrayLeafType(JType type) {
        if ((type = type.getUnderlyingType()) instanceof JArrayType) {
            type = ((JArrayType)type).getLeafType();
            return type.isEnumOrSubclass();
        }
        return null;
    }

    private class ReplaceOrdinalizedEnumTypes
    extends TypeRemapper {
        public ReplaceOrdinalizedEnumTypes(OptimizerContext optimizerCtx) {
            super(optimizerCtx);
        }

        @Override
        public boolean visit(JClassType x, Context ctx) {
            if (this.canBeOrdinal(x)) {
                for (JMethod method : x.getMethods()) {
                    EnumOrdinalizer.this.program.removeStaticImplMapping(method);
                }
            }
            return true;
        }

        @Override
        public void endVisit(JFieldRef x, Context ctx) {
            super.endVisit(x, ctx);
            JField field = x.getField();
            if (field instanceof JEnumField && this.canBeOrdinal(field.getEnclosingType()) && !ctx.isLvalue()) {
                int ordinal = ((JEnumField)field).ordinal();
                ctx.replaceMe(EnumOrdinalizer.this.program.getLiteralInt(ordinal));
                return;
            }
            this.maybeReplaceOrdinalAccess(x.getInstance(), field, ctx);
        }

        @Override
        public void endVisit(JMethodCall x, Context ctx) {
            super.endVisit(x, ctx);
            this.maybeReplaceOrdinalAccess(x.getInstance(), x.getTarget(), ctx);
        }

        @Override
        public void endVisit(JDeclarationStatement x, Context ctx) {
            super.endVisit(x, ctx);
            if (!(x.getVariableRef().getTarget() instanceof JEnumField)) {
                return;
            }
            JEnumField enumField = (JEnumField)x.getVariableRef().getTarget();
            if (!this.canBeOrdinal(enumField.getEnclosingType())) {
                return;
            }
            ctx.replaceMe(new JDeclarationStatement(x.getSourceInfo(), x.getVariableRef(), EnumOrdinalizer.this.program.getLiteralInt(enumField.ordinal())));
        }

        @Override
        protected JType remap(JType type) {
            JType remappedType = this.getOrdinalizedType(type);
            if (remappedType == null) {
                return type;
            }
            return remappedType;
        }

        private boolean canBeOrdinal(JType type) {
            JType uType = type.getUnderlyingType();
            return uType instanceof JEnumType && !EnumOrdinalizer.this.ordinalizationBlackList.contains(uType);
        }

        private JType getOrdinalizedType(JType type) {
            if (this.canBeOrdinal(type)) {
                return JPrimitiveType.INT;
            }
            JType uType = type.getUnderlyingType();
            if (!(uType instanceof JArrayType)) {
                return null;
            }
            JArrayType aType = (JArrayType)uType;
            JType leafType = aType.getLeafType();
            if (this.canBeOrdinal(leafType)) {
                JArrayType newAType = EnumOrdinalizer.this.program.getOrCreateArrayType(JPrimitiveType.INT, aType.getDims());
                return !type.canBeNull() ? newAType.strengthenToNonNull() : newAType;
            }
            return null;
        }

        private void maybeReplaceOrdinalAccess(JExpression instance, JNode member, Context ctx) {
            if (member != EnumOrdinalizer.this.enumOrdinalField && member != EnumOrdinalizer.this.enumOrdinalMethod) {
                return;
            }
            JType instanceType = instance.getType();
            if (instanceType == JPrimitiveType.INT || this.canBeOrdinal(instanceType)) {
                ctx.replaceMe(instance);
            }
        }
    }

    private class CannotBeOrdinalAnalyzer
    extends ImplicitUpcastAnalyzer {
        public CannotBeOrdinalAnalyzer(JProgram program) {
            super(program);
        }

        @Override
        public void endVisit(JCastOperation x, Context ctx) {
            this.blackListIfEnumCast(x.getExpr().getType(), x.getCastType(), x.getSourceInfo());
            this.blackListIfEnumCast(x.getCastType(), x.getExpr().getType(), x.getSourceInfo());
        }

        @Override
        public void endVisit(JClassLiteral x, Context ctx) {
            this.blackListIfEnum(x.getRefType(), x.getSourceInfo());
        }

        @Override
        public void endVisit(JClassType x, Context ctx) {
            JEnumType enumClass = x.isEnumOrSubclass();
            if (enumClass == null) {
                return;
            }
            EnumOrdinalizer.this.enumsVisited.add(enumClass);
            if (enumClass.isOrdinalized() || enumClass.canBeReferencedExternally()) {
                this.addToBlackList(enumClass, x.getSourceInfo());
            }
        }

        @Override
        public void endVisit(JFieldRef x, Context ctx) {
            if (x.getField() == EnumOrdinalizer.this.enumOrdinalField) {
                return;
            }
            if (x.getInstance() != null) {
                this.blackListIfEnumExpression(x.getInstance());
            }
        }

        @Override
        public void endVisit(JInstanceOf x, Context ctx) {
            this.blackListIfEnum(x.getExpr().getType(), x.getSourceInfo());
            this.blackListIfEnum(x.getTestType(), x.getSourceInfo());
        }

        @Override
        public void endVisit(JMethodCall x, Context ctx) {
            if (x.getTarget() == EnumOrdinalizer.this.enumCreateValueOfMapMethod || x.getTarget() == EnumOrdinalizer.this.enumSuperConstructor || x.getTarget() == EnumOrdinalizer.this.enumOrdinalMethod) {
                return;
            }
            if (x.getInstance() != null) {
                this.blackListIfEnumExpression(x.getInstance());
            } else if (x.getTarget().isStatic()) {
                JMethod target = x.getTarget();
                this.maybeBlackListDueToStaticCall(x.getSourceInfo(), target);
            }
            if (x.getTarget().isJsniMethod()) {
                for (JParameter parameter : x.getTarget().getParams()) {
                    this.blackListIfEnum(parameter.getType(), x.getSourceInfo());
                }
            }
            super.endVisit(x, ctx);
        }

        @Override
        public void endVisit(JsniClassLiteral x, Context ctx) {
            this.blackListIfEnum(x.getRefType(), x.getSourceInfo());
        }

        @Override
        public void endVisit(JsniFieldRef x, Context ctx) {
            this.blackListIfEnum(x.getField().getType(), x.getSourceInfo());
            if (x.getInstance() != null) {
                this.blackListIfEnumExpression(x.getInstance());
            } else {
                this.blackListIfEnum(x.getField().getEnclosingType(), x.getSourceInfo());
            }
        }

        @Override
        public void endVisit(JsniMethodRef x, Context ctx) {
            if (x.getInstance() != null) {
                this.blackListIfEnumExpression(x.getInstance());
            } else if (x.getTarget().isStatic()) {
                this.maybeBlackListDueToStaticCall(x.getSourceInfo(), x.getTarget());
            }
            this.blackListIfEnum(x.getTarget().getType(), x.getSourceInfo());
            super.endVisit(x, ctx);
        }

        @Override
        public boolean visit(JNewArray x, Context ctx) {
            if (x.getDimensionExpressions() != null) {
                this.accept(x.getDimensionExpressions());
            }
            if (x.getInitializers() != null) {
                this.accept(x.getInitializers());
            }
            return false;
        }

        @Override
        public boolean visit(JClassType x, Context ctx) {
            return x != EnumOrdinalizer.this.classLiteralHolderType;
        }

        @Override
        public boolean visit(JMethod x, Context ctx) {
            if (x.getEnclosingType().isEnumOrSubclass() != null && x.getName().equals("getClass") && (x.getOriginalParamTypes() == null || x.getOriginalParamTypes().size() == 0)) {
                return false;
            }
            return super.visit(x, ctx);
        }

        @Override
        public boolean visit(JMethodCall x, Context ctx) {
            return x.getTarget() != EnumOrdinalizer.this.enumCreateValueOfMapMethod;
        }

        @Override
        protected void processImplicitUpcast(JType fromType, JType destType, SourceInfo info) {
            if (fromType.isNullType()) {
                this.blackListIfEnum(destType, info);
            } else if (fromType == EnumOrdinalizer.this.javaScriptObjectType) {
                this.blackListIfEnum(destType, info);
            } else {
                this.blackListIfEnumCast(fromType, destType, info);
            }
        }

        private void addToBlackList(JEnumType enumType, SourceInfo info) {
            EnumOrdinalizer.this.ordinalizationBlackList.add(enumType);
            if (tracker != null) {
                tracker.addEnumNotOrdinalizedInfo(enumType.getName(), info);
            }
        }

        private void blackListIfEnum(JType maybeEnum, SourceInfo info) {
            JEnumType actualEnum = maybeEnum.isEnumOrSubclass();
            if (actualEnum != null) {
                this.addToBlackList(actualEnum, info);
            }
        }

        private void blackListIfEnumCast(JType maybeEnum, JType destType, SourceInfo info) {
            JEnumType actualEnum = maybeEnum.isEnumOrSubclass();
            JEnumType actualDestType = destType.isEnumOrSubclass();
            if (actualEnum != null) {
                if (actualDestType != actualEnum) {
                    this.addToBlackList(actualEnum, info);
                }
                return;
            }
            actualEnum = EnumOrdinalizer.this.getEnumTypeFromArrayLeafType(maybeEnum);
            actualDestType = EnumOrdinalizer.this.getEnumTypeFromArrayLeafType(destType);
            if (actualEnum != null && actualDestType != actualEnum) {
                this.addToBlackList(actualEnum, info);
            }
        }

        private void blackListIfEnumExpression(JExpression instance) {
            if (instance != null) {
                this.blackListIfEnum(instance.getType(), instance.getSourceInfo());
            }
        }

        private void maybeBlackListDueToStaticCall(SourceInfo info, JMethod target) {
            if (target.getEnclosingType().isEnumOrSubclass() != null && target.getName().equals("valueOf")) {
                this.blackListIfEnum(target.getEnclosingType(), info);
            }
        }
    }

    public static class Tracker {
        private static final Comparator<SourceInfo> SOURCE_INFO_COMPARATOR = new Comparator<SourceInfo>(){

            @Override
            public int compare(SourceInfo s1, SourceInfo s2) {
                int fileNameComp = s1.getFileName().compareTo(s2.getFileName());
                return fileNameComp != 0 ? fileNameComp : s1.getStartLine() - s2.getStartLine();
            }
        };
        private final Set<String> allEnumsOrdinalized = Sets.newTreeSet();
        private final Set<String> allEnumsVisited = Sets.newTreeSet();
        private final Multimap<String, SourceInfo> enumInfoMap = TreeMultimap.create(Ordering.natural(), SOURCE_INFO_COMPARATOR);
        private final List<Set<String>> enumsOrdinalizedPerPass = Lists.newArrayList();
        private final List<Set<String>> enumsVisitedPerPass = Lists.newArrayList();
        private int runCount = -1;

        public Tracker() {
            this.enumsVisitedPerPass.add(new TreeSet());
            this.enumsOrdinalizedPerPass.add(new TreeSet());
        }

        public void addEnumNotOrdinalizedInfo(String enumName, SourceInfo info) {
            this.enumInfoMap.put(enumName, info);
        }

        public void addOrdinalized(String ordinalized) {
            this.enumsOrdinalizedPerPass.get(this.runCount).add(ordinalized);
            this.allEnumsOrdinalized.add(ordinalized);
        }

        public void addVisited(String visited) {
            this.enumsVisitedPerPass.get(this.runCount).add(visited);
            this.allEnumsVisited.add(visited);
        }

        public String getInfoString(SourceInfo info) {
            if (info == null) {
                return null;
            }
            return info.getFileName() + ": Line " + info.getStartLine();
        }

        public Set<String> getOrdinalizedNames() {
            return this.allEnumsOrdinalized;
        }

        public int getNumOrdinalized() {
            return this.allEnumsOrdinalized.size();
        }

        public int getNumVisited() {
            return this.allEnumsVisited.size();
        }

        public void incrementRunCount() {
            ++this.runCount;
            this.enumsVisitedPerPass.add(new TreeSet());
            this.enumsOrdinalizedPerPass.add(new TreeSet());
        }

        public boolean isOrdinalized(String className) {
            return this.allEnumsOrdinalized.contains(className);
        }

        public boolean isVisited(String className) {
            return this.allEnumsVisited.contains(className);
        }

        public void logEnumsNotOrdinalized(TreeLogger logger, TreeLogger.Type logType) {
            if (logger == null) {
                return;
            }
            boolean initialMessageLogged = false;
            for (String enumVisited : this.allEnumsVisited) {
                if (this.isOrdinalized(enumVisited)) continue;
                if (!initialMessageLogged) {
                    logger = logger.branch(logType, "Enums Not Ordinalized:");
                    initialMessageLogged = true;
                }
                TreeLogger subLogger = logger.branch(logType, enumVisited);
                for (SourceInfo info : this.enumInfoMap.get(enumVisited)) {
                    subLogger.branch(logType, this.getInfoString(info));
                }
            }
        }

        public void logEnumsOrdinalizedPerPass(TreeLogger logger, TreeLogger.Type logType) {
            if (logger == null) {
                return;
            }
            if (this.allEnumsOrdinalized.size() == 0) {
                return;
            }
            int pass = 0;
            for (Set<String> enumsOrdinalized : this.enumsOrdinalizedPerPass) {
                ++pass;
                if (enumsOrdinalized.size() <= 0) continue;
                TreeLogger subLogger = logger.branch(logType, "Pass " + pass + ": " + enumsOrdinalized.size() + " ordinalized");
                for (String enumOrdinalized : enumsOrdinalized) {
                    subLogger.branch(logType, enumOrdinalized);
                }
            }
        }

        public void logResultsDetailed(TreeLogger logger, TreeLogger.Type logType) {
            logger = this.logResultsSummary(logger, logType);
            this.logEnumsOrdinalizedPerPass(logger, logType);
            this.logEnumsNotOrdinalized(logger, logType);
        }

        public TreeLogger logResultsSummary(TreeLogger logger, TreeLogger.Type logType) {
            if (logger == null) {
                return null;
            }
            logger = logger.branch(logType, "EnumOrdinalizer Results:");
            logger.branch(logType, this.runCount + 1 + " ordinalization passes completed");
            logger.branch(logType, this.allEnumsOrdinalized.size() + " of " + this.allEnumsVisited.size() + " ordinalized");
            return logger;
        }

        public void maybeDumpAST(JProgram program, int stage) {
            AstDumper.maybeDumpAST(program, NAME + "_" + (this.runCount + 1) + "_" + stage);
        }
    }
}

