/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.dev.PrecompileTaskOptions;
import com.google.gwt.dev.cfg.ConfigurationProperties;
import com.google.gwt.dev.jjs.ast.Context;
import com.google.gwt.dev.jjs.ast.JClassType;
import com.google.gwt.dev.jjs.ast.JConstructor;
import com.google.gwt.dev.jjs.ast.JDeclaredType;
import com.google.gwt.dev.jjs.ast.JExpression;
import com.google.gwt.dev.jjs.ast.JMethod;
import com.google.gwt.dev.jjs.ast.JMethodCall;
import com.google.gwt.dev.jjs.ast.JModVisitor;
import com.google.gwt.dev.jjs.ast.JNewInstance;
import com.google.gwt.dev.jjs.ast.JNullLiteral;
import com.google.gwt.dev.jjs.ast.JParameter;
import com.google.gwt.dev.jjs.ast.JProgram;
import com.google.gwt.dev.jjs.ast.JVisitor;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class EnumNameObfuscator {
    private static final String ENUM_NAME_OBFUSCATION_PROPERTY = "compiler.enum.obfuscate.names";
    private static final String ENUM_NAME_OBFUSCATION_BLACKLIST_PROPERTY = "compiler.enum.obfuscate.names.blacklist";

    private static boolean typeInBlacklist(Collection<String> blacklistedEnums, JClassType cType) {
        return blacklistedEnums.contains(cType.getName().replace('$', '.'));
    }

    public static void exec(JProgram jprogram, TreeLogger logger, ConfigurationProperties configurationProperties, PrecompileTaskOptions options) {
        if (!configurationProperties.getBoolean(ENUM_NAME_OBFUSCATION_PROPERTY, false)) {
            return;
        }
        boolean closureMode = options.isClosureCompilerFormatEnabled();
        List<String> blacklistedEnums = configurationProperties.getCommaSeparatedStrings(ENUM_NAME_OBFUSCATION_BLACKLIST_PROPERTY);
        new EnumNameCallChecker(jprogram, logger, blacklistedEnums).accept(jprogram);
        new EnumNameReplacer(jprogram, logger, blacklistedEnums, closureMode).exec();
    }

    private static class EnumNameReplacer
    extends JModVisitor {
        private final JProgram jprogram;
        private final JMethod makeEnumName;
        private List<String> blacklistedEnums;
        private boolean closureMode;
        private final TreeLogger logger;

        private EnumNameReplacer(JProgram jprogram, TreeLogger logger, List<String> blacklistedEnums, boolean closureMode) {
            this.logger = logger;
            this.jprogram = jprogram;
            this.blacklistedEnums = blacklistedEnums;
            this.closureMode = closureMode;
            this.makeEnumName = jprogram.getIndexedMethod("Util.makeEnumName");
        }

        private void exec() {
            this.accept(this.jprogram);
        }

        @Override
        public boolean visit(JClassType x, Context ctx) {
            if (x.isEnumOrSubclass() == null || EnumNameObfuscator.typeInBlacklist(this.blacklistedEnums, x)) {
                return false;
            }
            this.trace(x);
            return true;
        }

        @Override
        public void endVisit(JNewInstance x, Context ctx) {
            JConstructor target = x.getTarget();
            JClassType enclosingType = target.getEnclosingType();
            if (enclosingType.isEnumOrSubclass() == null) {
                return;
            }
            if (EnumNameObfuscator.typeInBlacklist(this.blacklistedEnums, enclosingType)) {
                return;
            }
            JNewInstance newEnum = new JNewInstance(x);
            ArrayList<JExpression> args = Lists.newArrayList(x.getArgs());
            args.set(0, this.closureMode ? new JMethodCall(x.getSourceInfo(), null, this.makeEnumName, (JExpression)args.get(0)) : JNullLiteral.INSTANCE);
            newEnum.addArgs(args);
            ctx.replaceMe(newEnum);
        }

        private void trace(JClassType x) {
            if (this.logger.isLoggable(TreeLogger.TRACE)) {
                this.logger.log(TreeLogger.TRACE, "Obfuscating enum " + x + x.getSourceInfo().getFileName() + ":" + x.getSourceInfo().getStartLine());
            }
        }
    }

    private static class EnumNameCallChecker
    extends JVisitor {
        private final JDeclaredType classType;
        private final JMethod enumNameMethod;
        private final JMethod enumToStringMethod;
        private final JDeclaredType enumType;
        private final JMethod enumValueOfMethod;
        private final TreeLogger logger;
        private final List<String> blacklistedEnums;
        private final JDeclaredType stringType;

        private EnumNameCallChecker(JProgram jprogram, TreeLogger logger, List<String> blacklistedEnums) {
            this.logger = logger;
            this.blacklistedEnums = blacklistedEnums;
            this.enumNameMethod = jprogram.getIndexedMethod("Enum.name");
            this.enumToStringMethod = jprogram.getIndexedMethod("Enum.toString");
            this.classType = jprogram.getFromTypeMap("java.lang.Class");
            this.enumType = jprogram.getFromTypeMap("java.lang.Enum");
            this.stringType = jprogram.getFromTypeMap("java.lang.String");
            JMethod foundMethod = null;
            List<JMethod> enumMethods = this.enumType.getMethods();
            for (JMethod enumMethod : enumMethods) {
                List<JParameter> params = enumMethod.getParams();
                if (!enumMethod.getName().equals("valueOf") || params.size() != 2 || params.get(0).getType() != this.classType || params.get(1).getType() != this.stringType) continue;
                foundMethod = enumMethod;
                break;
            }
            this.enumValueOfMethod = foundMethod;
        }

        @Override
        public void endVisit(JMethodCall x, Context ctx) {
            JMethod target = x.getTarget();
            JDeclaredType type = target.getEnclosingType();
            if (!(type instanceof JClassType)) {
                return;
            }
            JClassType cType = (JClassType)type;
            if (EnumNameObfuscator.typeInBlacklist(this.blacklistedEnums, cType)) {
                return;
            }
            if (target == this.enumNameMethod || target == this.enumToStringMethod || target == this.enumValueOfMethod) {
                this.warn(x);
                return;
            }
            if (cType.isEnumOrSubclass() != null) {
                return;
            }
            List<JParameter> params = target.getParams();
            if (target.getName().equals("valueOf") && params.size() == 1 && params.get(0).getType() == this.stringType) {
                this.warn(x);
            }
        }

        @Override
        public boolean visit(JClassType x, Context ctx) {
            return x != this.enumType;
        }

        private void warn(JMethodCall x) {
            this.logger.log(TreeLogger.WARN, "Call to Enum method " + x.getTarget().getName() + " when enum obfuscation is enabled:  " + x.getSourceInfo().getFileName() + ":" + x.getSourceInfo().getStartLine());
        }
    }
}

