/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl;

import com.google.gwt.dev.jjs.SourceInfo;
import com.google.gwt.dev.jjs.ast.AccessModifier;
import com.google.gwt.dev.jjs.ast.Context;
import com.google.gwt.dev.jjs.ast.JClassType;
import com.google.gwt.dev.jjs.ast.JConditional;
import com.google.gwt.dev.jjs.ast.JDeclaredType;
import com.google.gwt.dev.jjs.ast.JExpression;
import com.google.gwt.dev.jjs.ast.JInterfaceType;
import com.google.gwt.dev.jjs.ast.JMethod;
import com.google.gwt.dev.jjs.ast.JMethodBody;
import com.google.gwt.dev.jjs.ast.JMethodCall;
import com.google.gwt.dev.jjs.ast.JModVisitor;
import com.google.gwt.dev.jjs.ast.JParameter;
import com.google.gwt.dev.jjs.ast.JParameterRef;
import com.google.gwt.dev.jjs.ast.JProgram;
import com.google.gwt.dev.jjs.ast.JReferenceType;
import com.google.gwt.dev.jjs.ast.JReturnStatement;
import com.google.gwt.dev.jjs.ast.JTypeOracle;
import com.google.gwt.dev.jjs.ast.JVariableRef;
import com.google.gwt.dev.jjs.ast.js.JsniMethodBody;
import com.google.gwt.dev.jjs.ast.js.JsniMethodRef;
import com.google.gwt.dev.jjs.impl.MakeCallsStatic;
import com.google.gwt.dev.js.ast.JsContext;
import com.google.gwt.dev.js.ast.JsExpression;
import com.google.gwt.dev.js.ast.JsInvocation;
import com.google.gwt.dev.js.ast.JsModVisitor;
import com.google.gwt.dev.js.ast.JsNameRef;
import com.google.gwt.thirdparty.guava.common.collect.Iterables;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import com.google.gwt.thirdparty.guava.common.collect.Maps;
import com.google.gwt.thirdparty.guava.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;

public class Devirtualizer {
    private Map<JMethod, JMethod> devirtualMethodByMethod = Maps.newHashMap();
    private final JMethod hasJavaObjectVirtualDispatch;
    private final JMethod isJavaArray;
    private final Map<JMethod, JMethod> methodByDevirtualMethod = Maps.newHashMap();
    private final JProgram program;
    private final MakeCallsStatic.CreateStaticImplsVisitor staticImplCreator;
    private final MakeCallsStatic.StaticCallConverter converter;

    private boolean isOverlayMethod(JMethod method) {
        return method.isJsOverlay() || method.getEnclosingType() instanceof JInterfaceType && method.isPrivate() || method.getEnclosingType().isJsFunctionImplementation() && !method.isOrOverridesJsFunctionMethod();
    }

    public static void exec(JProgram program) {
        new Devirtualizer(program).execImpl();
    }

    private JMethod createDevirtualMethodFor(JMethod method, JDeclaredType inClass) {
        SourceInfo sourceInfo = method.getSourceInfo().makeChild();
        String prefix = Devirtualizer.computeEscapedSignature(method.getSignature());
        JMethod devirtualMethod = new JMethod(sourceInfo, prefix + "__devirtual$", inClass, method.getType(), false, true, true, AccessModifier.PUBLIC);
        devirtualMethod.setInliningMode(method.getInliningMode());
        devirtualMethod.setBody(new JMethodBody(sourceInfo));
        devirtualMethod.setSynthetic();
        inClass.addMethod(devirtualMethod);
        devirtualMethod.createThisParameter(sourceInfo, method.getEnclosingType());
        for (JParameter oldParam : method.getParams()) {
            devirtualMethod.createFinalParameter(sourceInfo, oldParam.getName(), oldParam.getType());
        }
        devirtualMethod.freezeParamTypes();
        devirtualMethod.addThrownExceptions(method.getThrownExceptions());
        sourceInfo.addCorrelation(sourceInfo.getCorrelator().by(devirtualMethod));
        return devirtualMethod;
    }

    private static String computeEscapedSignature(String methodSignature) {
        return methodSignature.replaceAll("[\\<\\>\\(\\)\\;\\/\\[]", "_");
    }

    private Devirtualizer(JProgram program) {
        this.program = program;
        this.hasJavaObjectVirtualDispatch = program.getIndexedMethod("Cast.hasJavaObjectVirtualDispatch");
        this.isJavaArray = program.getIndexedMethod("Array.isJavaArray");
        this.converter = new MakeCallsStatic.StaticCallConverter(program, false);
        this.staticImplCreator = new MakeCallsStatic.CreateStaticImplsVisitor(program);
    }

    private void execImpl() {
        JClassType jsoType = this.program.getJavaScriptObject();
        if (jsoType == null) {
            return;
        }
        new RewriteVirtualDispatches().accept(this.program);
    }

    private JMethod findOverridingMethod(JMethod method, JClassType target) {
        if (target == null) {
            return null;
        }
        for (JMethod overridingMethod : target.getMethods()) {
            if (!JTypeOracle.methodsDoMatch(method, overridingMethod)) continue;
            return overridingMethod;
        }
        return this.findOverridingMethod(method, target.getSuperClass());
    }

    private static JExpression constructMinimalCondition(JMethod checkMethod, JVariableRef target, JMethodCall trueDispatch, JExpression falseDispatch) {
        if (falseDispatch == null && trueDispatch == null) {
            return null;
        }
        if (falseDispatch == null) {
            return trueDispatch;
        }
        if (trueDispatch == null || falseDispatch instanceof JMethodCall && ((JMethodCall)falseDispatch).getTarget() == trueDispatch.getTarget()) {
            return falseDispatch;
        }
        JMethodCall condition = new JMethodCall(trueDispatch.getSourceInfo(), null, checkMethod, target);
        return new JConditional(condition.getSourceInfo(), trueDispatch.getType(), condition, trueDispatch, falseDispatch);
    }

    private static JMethodCall maybeCreateDispatch(JMethod dispatchTo, JMethod devirtualMethod) {
        if (dispatchTo == null) {
            return null;
        }
        ArrayList<JParameter> parameters = Lists.newArrayList(devirtualMethod.getParams());
        SourceInfo sourceInfo = devirtualMethod.getSourceInfo();
        JParameterRef thisParamRef = null;
        if (!dispatchTo.isStatic()) {
            thisParamRef = ((JParameter)parameters.remove(0)).makeRef(sourceInfo);
        }
        JMethodCall dispatchCall = new JMethodCall(sourceInfo, (JExpression)thisParamRef, dispatchTo, new JExpression[0]);
        for (JParameter param : parameters) {
            dispatchCall.addArg(param.makeRef(sourceInfo));
        }
        return dispatchCall;
    }

    private JMethod getOrCreateDevirtualMethod(JMethod method) {
        if (this.methodByDevirtualMethod.containsKey(method)) {
            return this.methodByDevirtualMethod.get(method);
        }
        JDeclaredType enclosingType = method.getEnclosingType();
        EnumSet<JProgram.DispatchType> possibleTargetTypes = this.program.getDispatchType(enclosingType.getUnderlyingType());
        EnumMap<JProgram.DispatchType, JMethod> dispatchToMethodByTargetType = new EnumMap<JProgram.DispatchType, JMethod>(JProgram.DispatchType.class);
        for (Map.Entry<JClassType, JProgram.DispatchType> nativeRepresentedType : this.program.getRepresentedAsNativeTypesDispatchMap().entrySet()) {
            if (!this.program.typeOracle.isInstantiatedType(nativeRepresentedType.getKey())) continue;
            this.maybeCreateDispatchFor(method, nativeRepresentedType.getValue(), possibleTargetTypes, dispatchToMethodByTargetType, nativeRepresentedType.getKey());
        }
        if (possibleTargetTypes.contains((Object)JProgram.DispatchType.JAVA_ARRAY)) {
            this.maybeCreateDispatchFor(method, JProgram.DispatchType.JAVA_ARRAY, possibleTargetTypes, dispatchToMethodByTargetType, this.program.getTypeJavaLangObject());
        }
        if (possibleTargetTypes.contains((Object)JProgram.DispatchType.JSO)) {
            JMethod overridingMethod = this.findOverridingMethod(method, this.program.typeOracle.getSingleJsoImpl(enclosingType));
            if (overridingMethod == null && enclosingType == this.program.getTypeJavaLangObject()) {
                overridingMethod = this.findOverridingMethod(method, this.program.getJavaScriptObject());
            }
            assert (overridingMethod != null) : method.getEnclosingType().getName() + "::" + method.getName() + " not overridden by JavaScriptObject";
            dispatchToMethodByTargetType.put(JProgram.DispatchType.JSO, this.staticImplCreator.getOrCreateStaticImpl(this.program, overridingMethod));
        }
        if (possibleTargetTypes.contains((Object)JProgram.DispatchType.HAS_JAVA_VIRTUAL_DISPATCH)) {
            dispatchToMethodByTargetType.put(JProgram.DispatchType.HAS_JAVA_VIRTUAL_DISPATCH, method);
        }
        JClassType devirtualMethodEnclosingClass = null;
        if (method.getEnclosingType() instanceof JClassType) {
            devirtualMethodEnclosingClass = (JClassType)method.getEnclosingType();
        } else {
            for (Map.Entry entry : this.program.getRepresentedAsNativeTypesDispatchMap().entrySet()) {
                if (!dispatchToMethodByTargetType.containsKey(entry.getValue())) continue;
                devirtualMethodEnclosingClass = (JClassType)entry.getKey();
                break;
            }
        }
        if (devirtualMethodEnclosingClass == null) {
            devirtualMethodEnclosingClass = dispatchToMethodByTargetType.get((Object)JProgram.DispatchType.JSO) != null ? (JClassType)dispatchToMethodByTargetType.get((Object)JProgram.DispatchType.JSO).getEnclosingType() : this.program.getTypeJavaLangObject();
        }
        assert (this.program.isReferenceOnly(devirtualMethodEnclosingClass) == this.program.isReferenceOnly(method.getEnclosingType()));
        JMethod devirtualMethod = this.createDevirtualMethodFor(method, devirtualMethodEnclosingClass);
        SourceInfo sourceInfo = method.getSourceInfo().makeChild();
        JParameter thisParam = devirtualMethod.getParams().get(0);
        JExpression dispatchExpression = Devirtualizer.maybeCreateDispatch(dispatchToMethodByTargetType.get((Object)JProgram.DispatchType.JSO), devirtualMethod);
        dispatchExpression = Devirtualizer.constructMinimalCondition(this.isJavaArray, thisParam.makeRef(thisParam.getSourceInfo()), Devirtualizer.maybeCreateDispatch(dispatchToMethodByTargetType.get((Object)JProgram.DispatchType.JAVA_ARRAY), devirtualMethod), dispatchExpression);
        dispatchExpression = Devirtualizer.constructMinimalCondition(this.hasJavaObjectVirtualDispatch, thisParam.makeRef(thisParam.getSourceInfo()), Devirtualizer.maybeCreateDispatch(dispatchToMethodByTargetType.get((Object)JProgram.DispatchType.HAS_JAVA_VIRTUAL_DISPATCH), devirtualMethod), dispatchExpression);
        for (Map.Entry<JClassType, JProgram.DispatchType> nativeRepresentedType : this.program.getRepresentedAsNativeTypesDispatchMap().entrySet()) {
            JProgram.DispatchType dispatchType = nativeRepresentedType.getValue();
            String castInstanceOfQualifier = dispatchType.getTypeCategory().castInstanceOfQualifier();
            dispatchExpression = Devirtualizer.constructMinimalCondition(this.program.getIndexedMethod("Cast.instanceOf" + castInstanceOfQualifier), thisParam.makeRef(thisParam.getSourceInfo()), Devirtualizer.maybeCreateDispatch(dispatchToMethodByTargetType.get((Object)dispatchType), devirtualMethod), dispatchExpression);
        }
        JReturnStatement returnStatement = new JReturnStatement(sourceInfo, dispatchExpression);
        ((JMethodBody)devirtualMethod.getBody()).getBlock().addStmt(returnStatement);
        this.methodByDevirtualMethod.put(method, devirtualMethod);
        return devirtualMethod;
    }

    private void maybeCreateDispatchFor(JMethod method, JProgram.DispatchType target, EnumSet<JProgram.DispatchType> possibleTargetTypes, EnumMap<JProgram.DispatchType, JMethod> dispatchToMethodByTargetType, JClassType targetDevirtualType) {
        if (possibleTargetTypes.contains((Object)target)) {
            JMethod overridingMethod = this.findOverridingMethod(method, targetDevirtualType);
            if (overridingMethod == null) {
                throw new AssertionError((Object)(method.getEnclosingType().getName() + "::" + method.getName() + " not overridden by " + targetDevirtualType.getSimpleName()));
            }
            dispatchToMethodByTargetType.put(target, this.staticImplCreator.getOrCreateStaticImpl(this.program, overridingMethod));
        }
    }

    private static String getJsniReferenceIdentifier(JMethod method) {
        return "@" + method.getJsniSignature(true, false);
    }

    private class RewriteVirtualDispatches
    extends JModVisitor {
        private RewriteVirtualDispatches() {
        }

        @Override
        public void endVisit(JMethod x, Context ctx) {
            if (!this.mightNeedDevirtualization(x)) {
                return;
            }
            this.ensureDevirtualVersionExists(x);
        }

        @Override
        public void endVisit(JsniMethodRef x, Context ctx) {
            JMethod method = x.getTarget();
            if (method == null || !this.mightNeedDevirtualization(method)) {
                return;
            }
            this.ensureDevirtualVersionExists(method);
            JMethod devirtualMethod = (JMethod)Devirtualizer.this.devirtualMethodByMethod.get(method);
            ctx.replaceMe(new JsniMethodRef(x.getSourceInfo(), x.getIdent(), devirtualMethod, Devirtualizer.this.program.getJavaScriptObject()));
        }

        @Override
        public void endVisit(JMethodCall x, Context ctx) {
            JMethod method = x.getTarget();
            if (!method.needsDynamicDispatch()) {
                return;
            }
            JReferenceType instanceType = (JReferenceType)x.getInstance().getType().getUnderlyingType();
            if (!this.mightNeedDevirtualization(method, instanceType)) {
                return;
            }
            if (x.isStaticDispatchOnly() && !method.isJsOverlay()) {
                return;
            }
            this.ensureDevirtualVersionExists(method);
            JMethod devirtualMethod = (JMethod)Devirtualizer.this.devirtualMethodByMethod.get(method);
            ctx.replaceMe(Devirtualizer.this.converter.convertCall(x, devirtualMethod));
        }

        @Override
        public boolean visit(JMethod x, Context ctx) {
            return !Devirtualizer.this.methodByDevirtualMethod.containsValue(x);
        }

        @Override
        public boolean visit(JsniMethodBody x, Context ctx) {
            final HashSet<String> devirtualMethodJsniIdentifiers = Sets.newHashSet();
            for (JsniMethodRef jsniMethodRef : x.getJsniMethodRefs()) {
                JMethod target = jsniMethodRef.getTarget();
                if (target == null || !this.mightNeedDevirtualization(target)) continue;
                devirtualMethodJsniIdentifiers.add(jsniMethodRef.getIdent());
            }
            new JsModVisitor(){

                @Override
                public void endVisit(JsInvocation x, JsContext ctx) {
                    if (!(x.getQualifier() instanceof JsNameRef)) {
                        return;
                    }
                    JsNameRef nameRef = (JsNameRef)x.getQualifier();
                    if (!nameRef.isJsniReference()) {
                        return;
                    }
                    if (!devirtualMethodJsniIdentifiers.contains(nameRef.getIdent())) {
                        return;
                    }
                    ctx.replaceMe(new JsInvocation(x.getSourceInfo(), (JsExpression)new JsNameRef(nameRef.getSourceInfo(), nameRef.getIdent()), Iterables.concat(Collections.singleton(nameRef.getQualifier()), x.getArguments())));
                }
            }.accept(x.getFunc());
            return true;
        }

        private void ensureDevirtualVersionExists(JMethod method) {
            if (Devirtualizer.this.devirtualMethodByMethod.containsKey(method)) {
                return;
            }
            JDeclaredType targetType = method.getEnclosingType();
            if (method.getSignature().equals("toString()Ljava/lang/String;")) {
                Devirtualizer.this.devirtualMethodByMethod.put(method, Devirtualizer.this.program.getIndexedMethod("Runtime.toString"));
            } else if (!((Devirtualizer)Devirtualizer.this).program.typeOracle.isDualJsoInterface(targetType) && ((Devirtualizer)Devirtualizer.this).program.typeOracle.isSingleJsoImpl(targetType)) {
                assert (targetType instanceof JInterfaceType);
                assert (!Devirtualizer.this.program.getTypeJavaLangString().getImplements().contains(targetType));
                JMethod overridingMethod = Devirtualizer.this.findOverridingMethod(method, ((Devirtualizer)Devirtualizer.this).program.typeOracle.getSingleJsoImpl(targetType));
                assert (overridingMethod != null);
                JMethod jsoStaticImpl = Devirtualizer.this.staticImplCreator.getOrCreateStaticImpl(Devirtualizer.this.program, overridingMethod);
                Devirtualizer.this.devirtualMethodByMethod.put(method, jsoStaticImpl);
            } else if (Devirtualizer.this.isOverlayMethod(method)) {
                JMethod devirtualMethod = Devirtualizer.this.staticImplCreator.getOrCreateStaticImpl(Devirtualizer.this.program, method);
                Devirtualizer.this.devirtualMethodByMethod.put(method, devirtualMethod);
            } else {
                JMethod devirtualMethod = Devirtualizer.this.getOrCreateDevirtualMethod(method);
                Devirtualizer.this.devirtualMethodByMethod.put(method, devirtualMethod);
            }
        }

        private boolean mightNeedDevirtualization(JMethod method) {
            return this.mightNeedDevirtualization(method, method.getEnclosingType());
        }

        private boolean mightNeedDevirtualization(JMethod method, JReferenceType instanceType) {
            if (instanceType == null || !method.needsDynamicDispatch()) {
                return false;
            }
            if (Devirtualizer.this.devirtualMethodByMethod.containsKey(method)) {
                return true;
            }
            if (Devirtualizer.this.isOverlayMethod(method)) {
                return true;
            }
            if (method.getEnclosingType().isJsNative()) {
                return false;
            }
            if (instanceType.isNullType()) {
                instanceType = method.getEnclosingType();
            }
            EnumSet<JProgram.DispatchType> dispatchType = Devirtualizer.this.program.getDispatchType(instanceType);
            dispatchType.remove((Object)JProgram.DispatchType.HAS_JAVA_VIRTUAL_DISPATCH);
            return !dispatchType.isEmpty();
        }
    }
}

