/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl;

import com.google.gwt.dev.jjs.ast.Context;
import com.google.gwt.dev.jjs.ast.JDeclaredType;
import com.google.gwt.dev.jjs.ast.JExpression;
import com.google.gwt.dev.jjs.ast.JMethod;
import com.google.gwt.dev.jjs.ast.JMethodCall;
import com.google.gwt.dev.jjs.ast.JModVisitor;
import com.google.gwt.dev.jjs.ast.JProgram;
import com.google.gwt.dev.jjs.impl.MakeCallsStatic;
import com.google.gwt.thirdparty.guava.common.collect.ImmutableList;

public class DevirtualizeDefaultMethodForwarding {
    public static void exec(final JProgram program) {
        MakeCallsStatic.CreateStaticImplsVisitor staticImplCreator = new MakeCallsStatic.CreateStaticImplsVisitor(program);
        for (JDeclaredType type : program.getDeclaredTypes()) {
            for (JMethod method : ImmutableList.copyOf(type.getMethods())) {
                if (!method.isDefaultMethod()) continue;
                staticImplCreator.getOrCreateStaticImpl(program, method);
            }
        }
        new JModVisitor(){

            @Override
            public void endVisit(JMethodCall x, Context ctx) {
                JMethod targetMethod = x.getTarget();
                if (targetMethod.isDefaultMethod() && x.isStaticDispatchOnly()) {
                    assert (x.getInstance() != null);
                    JMethod staticMethod = program.getStaticImpl(targetMethod);
                    assert (staticMethod != null);
                    JMethodCall callStaticMethod = new JMethodCall(x.getSourceInfo(), null, staticMethod, new JExpression[0]);
                    callStaticMethod.addArg(x.getInstance());
                    callStaticMethod.addArgs(x.getArgs());
                    ctx.replaceMe(callStaticMethod);
                }
            }
        }.accept(program);
    }
}

