/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl;

import com.google.gwt.dev.javac.JsInteropUtil;
import com.google.gwt.dev.jjs.SourceInfo;
import com.google.gwt.dev.jjs.ast.JConstructor;
import com.google.gwt.dev.jjs.ast.JDeclaredType;
import com.google.gwt.dev.jjs.ast.JMember;
import com.google.gwt.dev.jjs.impl.JsInteropExportsGenerator;
import com.google.gwt.dev.js.JsUtils;
import com.google.gwt.dev.js.ast.JsExpression;
import com.google.gwt.dev.js.ast.JsInvocation;
import com.google.gwt.dev.js.ast.JsName;
import com.google.gwt.dev.js.ast.JsNameRef;
import com.google.gwt.dev.js.ast.JsStatement;
import com.google.gwt.dev.js.ast.JsStringLiteral;
import java.util.List;

class DefaultJsInteropExportsGenerator
implements JsInteropExportsGenerator {
    private final List<JsStatement> exportStmts;
    private final JsName globalTemp;
    private final JsName provideFuncionName;
    private String lastExportedNamespace;

    public DefaultJsInteropExportsGenerator(List<JsStatement> exportStmts, JsName globalTemp, JsName provideFunctionName) {
        this.exportStmts = exportStmts;
        this.globalTemp = globalTemp;
        this.provideFuncionName = provideFunctionName;
    }

    @Override
    public void exportType(JDeclaredType x) {
    }

    @Override
    public void exportMember(JMember x, JsExpression bridgeMethodOrAlias) {
        if (x.getJsName().isEmpty()) {
            assert (x instanceof JConstructor);
            this.ensureProvideNamespace(x, bridgeMethodOrAlias);
            return;
        }
        this.ensureProvideNamespace(x, null);
        JsNameRef lhs = new JsNameRef(x.getSourceInfo(), x.getJsName(), this.globalTemp.makeRef(x.getSourceInfo()));
        this.exportStmts.add(JsUtils.createAssignment(lhs, bridgeMethodOrAlias).makeStmt());
    }

    private void ensureProvideNamespace(JMember member, JsExpression ctor) {
        String namespace = member.getJsNamespace();
        assert (!JsInteropUtil.isWindow(namespace));
        String string = namespace = JsInteropUtil.isGlobal(namespace) ? "" : namespace;
        if (namespace.equals(this.lastExportedNamespace)) {
            return;
        }
        this.lastExportedNamespace = namespace;
        SourceInfo sourceInfo = member.getSourceInfo();
        JsInvocation provideCall = new JsInvocation(sourceInfo);
        provideCall.setQualifier(this.provideFuncionName.makeRef(sourceInfo));
        provideCall.getArguments().add(new JsStringLiteral(sourceInfo, namespace));
        if (ctor != null) {
            provideCall.getArguments().add(ctor);
        }
        this.exportStmts.add(JsUtils.createAssignment(this.globalTemp.makeRef(sourceInfo), provideCall).makeStmt());
    }
}

