/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl;

import com.google.gwt.dev.jjs.SourceInfo;
import com.google.gwt.dev.jjs.ast.Context;
import com.google.gwt.dev.jjs.ast.JBinaryOperation;
import com.google.gwt.dev.jjs.ast.JBinaryOperator;
import com.google.gwt.dev.jjs.ast.JBlock;
import com.google.gwt.dev.jjs.ast.JBooleanLiteral;
import com.google.gwt.dev.jjs.ast.JBreakStatement;
import com.google.gwt.dev.jjs.ast.JCaseStatement;
import com.google.gwt.dev.jjs.ast.JCastOperation;
import com.google.gwt.dev.jjs.ast.JCharLiteral;
import com.google.gwt.dev.jjs.ast.JClassType;
import com.google.gwt.dev.jjs.ast.JConditional;
import com.google.gwt.dev.jjs.ast.JContinueStatement;
import com.google.gwt.dev.jjs.ast.JDeclarationStatement;
import com.google.gwt.dev.jjs.ast.JDeclaredType;
import com.google.gwt.dev.jjs.ast.JDoStatement;
import com.google.gwt.dev.jjs.ast.JDoubleLiteral;
import com.google.gwt.dev.jjs.ast.JEnumField;
import com.google.gwt.dev.jjs.ast.JExpression;
import com.google.gwt.dev.jjs.ast.JExpressionStatement;
import com.google.gwt.dev.jjs.ast.JField;
import com.google.gwt.dev.jjs.ast.JFieldRef;
import com.google.gwt.dev.jjs.ast.JFloatLiteral;
import com.google.gwt.dev.jjs.ast.JForStatement;
import com.google.gwt.dev.jjs.ast.JIfStatement;
import com.google.gwt.dev.jjs.ast.JInstanceOf;
import com.google.gwt.dev.jjs.ast.JIntLiteral;
import com.google.gwt.dev.jjs.ast.JLiteral;
import com.google.gwt.dev.jjs.ast.JLocalRef;
import com.google.gwt.dev.jjs.ast.JLongLiteral;
import com.google.gwt.dev.jjs.ast.JMethod;
import com.google.gwt.dev.jjs.ast.JMethodCall;
import com.google.gwt.dev.jjs.ast.JNewInstance;
import com.google.gwt.dev.jjs.ast.JNode;
import com.google.gwt.dev.jjs.ast.JParameterRef;
import com.google.gwt.dev.jjs.ast.JPostfixOperation;
import com.google.gwt.dev.jjs.ast.JPrefixOperation;
import com.google.gwt.dev.jjs.ast.JPrimitiveType;
import com.google.gwt.dev.jjs.ast.JProgram;
import com.google.gwt.dev.jjs.ast.JReferenceType;
import com.google.gwt.dev.jjs.ast.JStatement;
import com.google.gwt.dev.jjs.ast.JStringLiteral;
import com.google.gwt.dev.jjs.ast.JSwitchExpression;
import com.google.gwt.dev.jjs.ast.JSwitchStatement;
import com.google.gwt.dev.jjs.ast.JTryStatement;
import com.google.gwt.dev.jjs.ast.JType;
import com.google.gwt.dev.jjs.ast.JUnaryOperator;
import com.google.gwt.dev.jjs.ast.JValueLiteral;
import com.google.gwt.dev.jjs.ast.JVariableRef;
import com.google.gwt.dev.jjs.ast.JVisitor;
import com.google.gwt.dev.jjs.ast.JWhileStatement;
import com.google.gwt.dev.jjs.ast.js.JMultiExpression;
import com.google.gwt.dev.jjs.impl.JChangeTrackingVisitor;
import com.google.gwt.dev.jjs.impl.JavaAstVerifier;
import com.google.gwt.dev.jjs.impl.JjsUtils;
import com.google.gwt.dev.jjs.impl.OptimizerContext;
import com.google.gwt.dev.jjs.impl.OptimizerStats;
import com.google.gwt.dev.jjs.impl.Simplifier;
import com.google.gwt.dev.util.Ieee754_64_Arithmetic;
import com.google.gwt.dev.util.log.speedtracer.CompilerEventType;
import com.google.gwt.dev.util.log.speedtracer.SpeedTracerLogger;
import com.google.gwt.thirdparty.guava.common.annotations.VisibleForTesting;
import com.google.gwt.thirdparty.guava.common.collect.ImmutableMap;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import com.google.gwt.thirdparty.guava.common.collect.Sets;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public class DeadCodeElimination {
    public static final String NAME = DeadCodeElimination.class.getSimpleName();
    private final JProgram program;
    private final Map<JType, Class<?>> classObjectsByType;

    @VisibleForTesting
    public static OptimizerStats exec(JProgram program) {
        return new DeadCodeElimination(program).execImpl(Collections.singleton(program), OptimizerContext.NULL_OPTIMIZATION_CONTEXT);
    }

    public static OptimizerStats exec(JProgram program, JMethod method) {
        return new DeadCodeElimination(program).execImpl(Collections.singleton(method), OptimizerContext.NULL_OPTIMIZATION_CONTEXT);
    }

    public static OptimizerStats exec(JProgram program, OptimizerContext optimizerCtx) {
        Set<JMethod> affectedMethods = DeadCodeElimination.affectedMethods(optimizerCtx);
        OptimizerStats stats = new DeadCodeElimination(program).execImpl(affectedMethods, optimizerCtx);
        optimizerCtx.setLastStepFor(NAME, optimizerCtx.getOptimizationStep());
        optimizerCtx.incOptimizationStep();
        JavaAstVerifier.assertProgramIsConsistent(program);
        return stats;
    }

    private static Set<JMethod> affectedMethods(OptimizerContext optimizerCtx) {
        Set<JMethod> modifiedMethods = optimizerCtx.getModifiedMethodsSince(optimizerCtx.getLastStepFor(NAME));
        LinkedHashSet<JMethod> affectedMethods = Sets.newLinkedHashSet();
        affectedMethods.addAll(modifiedMethods);
        affectedMethods.addAll(optimizerCtx.getCallers(modifiedMethods));
        affectedMethods.addAll(optimizerCtx.getMethodsByReferencedFields(optimizerCtx.getModifiedFieldsSince(optimizerCtx.getLastStepFor(NAME))));
        return affectedMethods;
    }

    public DeadCodeElimination(JProgram program) {
        this.program = program;
        this.classObjectsByType = new ImmutableMap.Builder<JClassType, Class<Object>>().put(program.getTypeJavaLangObject(), Object.class).put(program.getTypeJavaLangString(), String.class).put((JClassType)((Object)program.getTypePrimitiveBoolean()), Boolean.TYPE).put((JClassType)((Object)program.getTypePrimitiveByte()), Byte.TYPE).put((JClassType)((Object)program.getTypePrimitiveChar()), Character.TYPE).put((JClassType)((Object)program.getTypePrimitiveDouble()), Double.TYPE).put((JClassType)((Object)program.getTypePrimitiveFloat()), Float.TYPE).put((JClassType)((Object)program.getTypePrimitiveInt()), Integer.TYPE).put((JClassType)((Object)program.getTypePrimitiveLong()), Long.TYPE).put((JClassType)((Object)program.getTypePrimitiveShort()), Short.TYPE).build();
    }

    private OptimizerStats execImpl(Iterable<? extends JNode> nodes, OptimizerContext optimizerCtx) {
        OptimizerStats stats = new OptimizerStats(NAME);
        SpeedTracerLogger.Event optimizeEvent = SpeedTracerLogger.start(CompilerEventType.OPTIMIZE, "optimizer", NAME);
        DeadCodeVisitor deadCodeVisitor = new DeadCodeVisitor(optimizerCtx);
        for (JNode jNode : nodes) {
            deadCodeVisitor.accept(jNode);
        }
        stats.recordModified(deadCodeVisitor.getNumMods());
        optimizeEvent.end("didChange", "" + stats.didChange());
        return stats;
    }

    private static enum AnalysisResult {
        TRUE,
        FALSE,
        UNKNOWN;

    }

    public static class FindBreakContinueStatementsVisitor
    extends JVisitor {
        private boolean hasBreakContinueStatements = false;

        @Override
        public void endVisit(JBreakStatement x, Context ctx) {
            this.hasBreakContinueStatements = true;
        }

        @Override
        public void endVisit(JContinueStatement x, Context ctx) {
            this.hasBreakContinueStatements = true;
        }

        protected boolean hasBreakContinueStatements() {
            return this.hasBreakContinueStatements;
        }
    }

    public class DeadCodeVisitor
    extends JChangeTrackingVisitor {
        private final Set<JExpression> ignoringExpressionOutput;
        private final Set<JExpression> lvalues;
        private final Set<JBlock> switchBlocks;
        private final JMethod isScriptMethod;
        private final JMethod enumOrdinalMethod;
        private final JField enumOrdinalField;

        public DeadCodeVisitor(OptimizerContext optimizerCtx) {
            super(optimizerCtx);
            this.ignoringExpressionOutput = Sets.newHashSet();
            this.lvalues = Sets.newHashSet();
            this.switchBlocks = Sets.newHashSet();
            this.isScriptMethod = DeadCodeElimination.this.program.getIndexedMethod("GWT.isScript");
            this.enumOrdinalMethod = DeadCodeElimination.this.program.getIndexedMethod("Enum.ordinal");
            this.enumOrdinalField = DeadCodeElimination.this.program.getIndexedField("Enum.ordinal");
        }

        @Override
        public void endVisit(JBinaryOperation x, Context ctx) {
            JBinaryOperator op = x.getOp();
            JExpression lhs = x.getLhs();
            JExpression rhs = x.getRhs();
            if (this.isNonEmptyMultiExpression(lhs)) {
                List<JExpression> expressions = ((JMultiExpression)lhs).getExpressions();
                JMultiExpression result = new JMultiExpression(lhs.getSourceInfo(), expressions.subList(0, expressions.size() - 1));
                result.addExpressions(new JBinaryOperation(x.getSourceInfo(), x.getType(), x.getOp(), expressions.get(expressions.size() - 1), rhs));
                ctx.replaceMe(result);
                return;
            }
            if (this.isNonEmptyMultiExpression(rhs) && lhs instanceof JValueLiteral && op != JBinaryOperator.AND && op != JBinaryOperator.OR) {
                List<JExpression> expressions = ((JMultiExpression)rhs).getExpressions();
                JMultiExpression result = new JMultiExpression(rhs.getSourceInfo(), expressions.subList(0, expressions.size() - 1));
                result.addExpressions(new JBinaryOperation(x.getSourceInfo(), x.getType(), x.getOp(), lhs, expressions.get(expressions.size() - 1)));
                ctx.replaceMe(result);
                return;
            }
            if (lhs instanceof JValueLiteral && rhs instanceof JValueLiteral && this.evalOpOnLiterals(op, (JValueLiteral)lhs, (JValueLiteral)rhs, ctx)) {
                return;
            }
            switch (op) {
                case AND: {
                    this.maybeReplaceMe(x, Simplifier.simplifyAnd(x), ctx);
                    break;
                }
                case OR: {
                    this.maybeReplaceMe(x, Simplifier.simplifyOr(x), ctx);
                    break;
                }
                case BIT_XOR: {
                    this.simplifyXor(lhs, rhs, ctx);
                    break;
                }
                case EQ: {
                    this.simplifyEq(lhs, rhs, ctx, false);
                    break;
                }
                case NEQ: {
                    this.simplifyEq(lhs, rhs, ctx, true);
                    break;
                }
                case ADD: {
                    this.simplifyAdd(lhs, rhs, ctx, x.getType());
                    break;
                }
                case CONCAT: {
                    this.evalConcat(x.getSourceInfo(), lhs, rhs, ctx);
                    break;
                }
                case SUB: {
                    this.simplifySub(lhs, rhs, ctx, x.getType());
                    break;
                }
                case MUL: {
                    this.simplifyMul(lhs, rhs, ctx, x.getType());
                    break;
                }
                case DIV: {
                    this.simplifyDiv(lhs, rhs, ctx, x.getType());
                    break;
                }
                case SHL: 
                case SHR: 
                case SHRU: {
                    if (!this.isLiteralZero(rhs)) break;
                    ctx.replaceMe(lhs);
                    break;
                }
                default: {
                    if (!op.isAssignment()) break;
                    this.lvalues.remove(lhs);
                }
            }
        }

        private boolean isNonEmptyMultiExpression(JExpression expression) {
            return expression instanceof JMultiExpression && !((JMultiExpression)expression).getExpressions().isEmpty();
        }

        @Override
        public void endVisit(JBlock x, Context ctx) {
            if (this.switchBlocks.contains(x)) {
                return;
            }
            for (int i = 0; i < x.getStatements().size(); ++i) {
                JExpressionStatement stmtExpr;
                JBlock block;
                JStatement stmt = x.getStatements().get(i);
                if (stmt instanceof JBlock && this.canPromoteBlock(block = (JBlock)stmt)) {
                    x.removeStmt(i);
                    x.addStmts(i, block.getStatements());
                    --i;
                    this.madeChanges();
                    continue;
                }
                if (stmt instanceof JExpressionStatement && (stmtExpr = (JExpressionStatement)stmt).getExpr() instanceof JMultiExpression) {
                    x.removeStmt(i);
                    int start = i;
                    JMultiExpression multi = (JMultiExpression)stmtExpr.getExpr();
                    for (JExpression expr : multi.getExpressions()) {
                        x.addStmt(i++, expr.makeStatement());
                    }
                    i = start - 1;
                    continue;
                }
                if (!stmt.unconditionalControlBreak()) continue;
                int j = i + 1;
                while (j < x.getStatements().size()) {
                    x.removeStmt(j);
                    this.madeChanges();
                }
            }
            if (ctx.canRemove() && x.getStatements().size() == 0) {
                ctx.removeMe();
            }
        }

        @Override
        public void endVisit(JCastOperation x, Context ctx) {
            this.maybeReplaceMe(x, Simplifier.simplifyCast(x), ctx);
        }

        @Override
        public void endVisit(JConditional x, Context ctx) {
            this.maybeReplaceMe(x, Simplifier.simplifyConditional(x), ctx);
        }

        @Override
        public void endVisit(JDeclarationStatement x, Context ctx) {
            JVariableRef variableRef = x.getVariableRef();
            this.lvalues.remove(variableRef);
        }

        @Override
        public void endVisit(JDoStatement x, Context ctx) {
            JBooleanLiteral booleanLiteral;
            JExpression expression = x.getTestExpr();
            if (expression instanceof JBooleanLiteral && !(booleanLiteral = (JBooleanLiteral)expression).getValue()) {
                if (JjsUtils.isEmptyBlock(x.getBody())) {
                    ctx.removeMe();
                } else {
                    FindBreakContinueStatementsVisitor visitor = new FindBreakContinueStatementsVisitor();
                    visitor.accept(x.getBody());
                    if (!visitor.hasBreakContinueStatements()) {
                        ctx.replaceMe(x.getBody());
                    }
                }
            }
        }

        @Override
        public void endVisit(JExpressionStatement x, Context ctx) {
            this.ignoringExpressionOutput.remove(x.getExpr());
            if (!x.getExpr().hasSideEffects()) {
                this.removeMe(x, ctx);
            }
        }

        @Override
        public void endVisit(JFieldRef x, Context ctx) {
            if (x.getField() == this.enumOrdinalField) {
                this.maybeReplaceWithOrdinalValue(x.getInstance(), ctx);
                return;
            }
            JLiteral literal = this.tryGetConstant(x);
            if (literal == null && !this.ignoringExpressionOutput.contains(x)) {
                return;
            }
            ArrayList<JExpression> exprs = Lists.newArrayList();
            JExpression instance = x.getInstance();
            if (instance != null) {
                exprs.add(instance);
            }
            if (x.hasClinit() && !x.getField().isCompileTimeConstant()) {
                exprs.add(this.createClinitCall(x.getSourceInfo(), x.getField().getEnclosingType()));
            }
            if (literal != null) {
                exprs.add(literal);
            }
            JExpression replacement = exprs.size() == 1 ? (JExpression)exprs.get(0) : new JMultiExpression(x.getSourceInfo(), exprs);
            ctx.replaceMe(this.accept(replacement));
        }

        @Override
        public void endVisit(JForStatement x, Context ctx) {
            JBooleanLiteral booleanLiteral;
            JExpression expression = x.getCondition();
            if (expression instanceof JBooleanLiteral && !(booleanLiteral = (JBooleanLiteral)expression).getValue()) {
                JBlock block = new JBlock(x.getSourceInfo(), new JStatement[0]);
                block.addStmts(x.getInitializers());
                this.replaceMe(block, ctx);
            }
        }

        @Override
        public void endVisit(JIfStatement x, Context ctx) {
            JType methodReturnType = this.getCurrentMethod() != null ? this.getCurrentMethod().getType() : null;
            this.maybeReplaceMe(x, Simplifier.simplifyIfStatement(x, methodReturnType), ctx);
        }

        @Override
        public void endVisit(JInstanceOf x, Context ctx) {
            if (this.ignoringExpressionOutput.contains(x)) {
                ctx.replaceMe(x.getExpr());
                this.ignoringExpressionOutput.remove(x);
                return;
            }
            if (!(x.getExpr().getType() instanceof JReferenceType)) {
                return;
            }
            AnalysisResult analysisResult = this.staticallyEvaluateInstanceOf((JReferenceType)x.getExpr().getType(), x.getTestType());
            switch (analysisResult) {
                case TRUE: {
                    ctx.replaceMe(JjsUtils.createOptimizedNotNullComparison(DeadCodeElimination.this.program, x.getSourceInfo(), x.getExpr()));
                    break;
                }
                case FALSE: {
                    ctx.replaceMe(JjsUtils.createOptimizedMultiExpression(x.getExpr(), DeadCodeElimination.this.program.getLiteralBoolean(false)));
                    break;
                }
            }
        }

        @Override
        public void endVisit(JLocalRef x, Context ctx) {
            JLiteral literal = this.tryGetConstant(x);
            if (literal != null) {
                assert (!x.hasSideEffects());
                ctx.replaceMe(literal);
            }
        }

        @Override
        public void endVisit(JMethodCall x, Context ctx) {
            JDeclaredType targetType;
            JMethod target = x.getTarget();
            JExpression instance = x.getInstance();
            if (target.isStatic() && instance != null) {
                this.ignoringExpressionOutput.remove(instance);
            }
            if ((targetType = target.getEnclosingType()) == DeadCodeElimination.this.program.getTypeJavaLangString() || instance != null && instance.getType().getUnderlyingType() == DeadCodeElimination.this.program.getTypeJavaLangString()) {
                this.tryOptimizeStringCall(x, ctx, target);
            } else if (JProgram.isClinit(target)) {
                if (!targetType.hasClinit()) {
                    ctx.replaceMe(DeadCodeElimination.this.program.getLiteralNull());
                } else if (targetType != targetType.getClinitTarget()) {
                    ctx.replaceMe(this.createClinitCall(x.getSourceInfo(), targetType.getClinitTarget()));
                }
            } else if (target == this.isScriptMethod) {
                ctx.replaceMe(JBooleanLiteral.TRUE);
            } else if (target == this.enumOrdinalMethod) {
                this.maybeReplaceWithOrdinalValue(instance, ctx);
            }
        }

        @Override
        public void endVisit(JMultiExpression x, Context ctx) {
            List<JExpression> exprs = x.getExpressions();
            if (exprs.size() > 0) {
                if (this.ignoringExpressionOutput.contains(x)) {
                    this.ignoringExpressionOutput.removeAll(exprs);
                } else {
                    List<JExpression> nonFinalChildren = exprs.subList(0, exprs.size() - 1);
                    this.ignoringExpressionOutput.removeAll(nonFinalChildren);
                }
            }
            HashSet<JDeclaredType> clinitsCalled = new HashSet<JDeclaredType>();
            for (int i = 0; i < this.numRemovableExpressions(x); ++i) {
                JExpression expr = x.getExpression(i);
                if (!expr.hasSideEffects()) {
                    x.removeExpression(i);
                    --i;
                    this.madeChanges();
                    continue;
                }
                if (expr instanceof JMultiExpression) {
                    x.removeExpression(i);
                    x.addExpressions(i, ((JMultiExpression)expr).getExpressions());
                    --i;
                    this.madeChanges();
                    continue;
                }
                if (!(expr instanceof JMethodCall) || !JProgram.isClinit(((JMethodCall)expr).getTarget())) continue;
                JDeclaredType enclosingType = ((JMethodCall)expr).getTarget().getEnclosingType();
                if (enclosingType.findSubtype(clinitsCalled) != null) {
                    x.removeExpression(i);
                    --i;
                    this.madeChanges();
                    continue;
                }
                clinitsCalled.add(enclosingType);
            }
            if (x.getNumberOfExpressions() == 1) {
                this.maybeReplaceMe(x, x.getExpressions().get(0), ctx);
            }
        }

        @Override
        public void endVisit(JNewInstance x, Context ctx) {
            super.endVisit(x, ctx);
            if (this.ignoringExpressionOutput.contains(x)) {
                if (!x.getTarget().isEmpty()) {
                    return;
                }
                JMultiExpression multi = new JMultiExpression(x.getSourceInfo(), new JExpression[0]);
                multi.addExpressions(x.getArgs());
                if (this.getCurrentMethod().getEnclosingType().checkClinitTo(x.getTarget().getEnclosingType())) {
                    multi.addExpressions(this.createClinitCall(x.getSourceInfo(), x.getTarget().getEnclosingType()));
                }
                this.ignoringExpressionOutput.add(multi);
                ctx.replaceMe(this.accept(multi));
                this.ignoringExpressionOutput.remove(multi);
            }
        }

        @Override
        public void endVisit(JParameterRef x, Context ctx) {
            JLiteral literal = this.tryGetConstant(x);
            if (literal != null) {
                assert (!x.hasSideEffects());
                ctx.replaceMe(literal);
            }
        }

        @Override
        public void endVisit(JPostfixOperation x, Context ctx) {
            if (x.getOp().isModifying()) {
                this.lvalues.remove(x.getArg());
            }
            if (this.isNonEmptyMultiExpression(x.getArg())) {
                List<JExpression> expressions = ((JMultiExpression)x.getArg()).getExpressions();
                JMultiExpression result = new JMultiExpression(x.getArg().getSourceInfo(), expressions.subList(0, expressions.size() - 1));
                result.addExpressions(new JPostfixOperation(x.getSourceInfo(), x.getOp(), expressions.get(expressions.size() - 1)));
                ctx.replaceMe(result);
                return;
            }
            if (this.ignoringExpressionOutput.contains(x)) {
                JPrefixOperation newOp = new JPrefixOperation(x.getSourceInfo(), x.getOp(), x.getArg());
                ctx.replaceMe(newOp);
            }
        }

        @Override
        public void endVisit(JPrefixOperation x, Context ctx) {
            if (x.getOp().isModifying()) {
                this.lvalues.remove(x.getArg());
            }
            if (this.isNonEmptyMultiExpression(x.getArg())) {
                List<JExpression> expressions = ((JMultiExpression)x.getArg()).getExpressions();
                JMultiExpression result = new JMultiExpression(x.getArg().getSourceInfo(), expressions.subList(0, expressions.size() - 1));
                result.addExpressions(new JPrefixOperation(x.getSourceInfo(), x.getOp(), expressions.get(expressions.size() - 1)));
                ctx.replaceMe(result);
                return;
            }
            if (x.getArg() instanceof JValueLiteral && this.evalOpOnLiteral(x.getOp(), (JValueLiteral)x.getArg(), ctx)) {
                return;
            }
            if (x.getOp() == JUnaryOperator.NOT) {
                this.maybeReplaceMe(x, Simplifier.simplifyNot(x), ctx);
                return;
            }
            if (x.getOp() == JUnaryOperator.NEG) {
                this.maybeReplaceMe(x, this.simplifyNegate(x, x.getArg()), ctx);
            }
        }

        @Override
        public void endVisit(JSwitchStatement x, Context ctx) {
            this.switchBlocks.remove(x.getBody());
            if (this.tryReduceSwitchWithConstantInput(x, ctx)) {
                return;
            }
            if (this.hasNoDefaultCase(x)) {
                this.removeEmptyCases(x);
            }
            this.removeDoubleBreaks(x);
            this.tryRemoveSwitch(x, ctx);
        }

        @Override
        public void endVisit(JSwitchExpression x, Context ctx) {
            this.switchBlocks.remove(x.getBody());
        }

        @Override
        public void endVisit(JTryStatement x, Context ctx) {
            List<JTryStatement.CatchClause> catchClauses = x.getCatchClauses();
            Iterator<JTryStatement.CatchClause> itClauses = catchClauses.iterator();
            while (itClauses.hasNext()) {
                JTryStatement.CatchClause clause = itClauses.next();
                Iterator<JType> itTypes = clause.getTypes().iterator();
                while (itTypes.hasNext()) {
                    JReferenceType type = (JReferenceType)itTypes.next();
                    if (((DeadCodeElimination)DeadCodeElimination.this).program.typeOracle.isInstantiatedType(type) && !type.isNullType()) continue;
                    itTypes.remove();
                    this.madeChanges();
                }
                if (!clause.getTypes().isEmpty()) continue;
                itClauses.remove();
                this.madeChanges();
            }
            boolean noTry = JjsUtils.isEmptyBlock(x.getTryBlock());
            boolean noCatch = catchClauses.size() == 0;
            boolean noFinally = JjsUtils.isEmptyBlock(x.getFinallyBlock());
            if (noTry) {
                if (noFinally) {
                    this.removeMe(x, ctx);
                } else {
                    this.replaceMe(x.getFinallyBlock(), ctx);
                }
            } else if (noCatch && noFinally) {
                this.replaceMe(x.getTryBlock(), ctx);
            }
        }

        @Override
        public void endVisit(JWhileStatement x, Context ctx) {
            JBooleanLiteral booleanLiteral;
            JExpression expression = x.getTestExpr();
            if (expression instanceof JBooleanLiteral && !(booleanLiteral = (JBooleanLiteral)expression).getValue()) {
                this.removeMe(x, ctx);
            }
        }

        @Override
        public boolean visit(JBinaryOperation x, Context ctx) {
            if (x.getOp().isAssignment()) {
                this.lvalues.add(x.getLhs());
            }
            return true;
        }

        @Override
        public boolean visit(JClassType x, Context ctx) {
            return !x.isExternal();
        }

        @Override
        public boolean visit(JDeclarationStatement x, Context ctx) {
            this.lvalues.add(x.getVariableRef());
            return true;
        }

        @Override
        public boolean visit(JExpressionStatement x, Context ctx) {
            this.ignoringExpressionOutput.add(x.getExpr());
            return true;
        }

        @Override
        public boolean visit(JMethodCall x, Context ctx) {
            JMethod target = x.getTarget();
            if (target.isStatic() && x.getInstance() != null) {
                this.ignoringExpressionOutput.add(x.getInstance());
            }
            return true;
        }

        @Override
        public boolean visit(JMultiExpression x, Context ctx) {
            List<JExpression> exprs = x.getExpressions();
            if (exprs.size() > 0) {
                if (this.ignoringExpressionOutput.contains(x)) {
                    this.ignoringExpressionOutput.addAll(exprs);
                } else {
                    List<JExpression> nonFinalChildren = exprs.subList(0, exprs.size() - 1);
                    this.ignoringExpressionOutput.addAll(nonFinalChildren);
                }
            }
            return true;
        }

        @Override
        public boolean visit(JPostfixOperation x, Context ctx) {
            if (x.getOp().isModifying()) {
                this.lvalues.add(x.getArg());
            }
            return true;
        }

        @Override
        public boolean visit(JPrefixOperation x, Context ctx) {
            if (x.getOp().isModifying()) {
                this.lvalues.add(x.getArg());
            }
            return true;
        }

        @Override
        public boolean visit(JSwitchStatement x, Context ctx) {
            this.switchBlocks.add(x.getBody());
            return true;
        }

        @Override
        public boolean visit(JSwitchExpression x, Context ctx) {
            this.switchBlocks.add(x.getBody());
            return true;
        }

        private boolean canPromoteBlock(JBlock block) {
            for (JStatement nestedStmt : block.getStatements()) {
                JDeclarationStatement decl;
                if (!(nestedStmt instanceof JDeclarationStatement) || !((decl = (JDeclarationStatement)nestedStmt).getVariableRef() instanceof JLocalRef)) continue;
                return false;
            }
            return true;
        }

        private JMethodCall createClinitCall(SourceInfo sourceInfo, JDeclaredType targetType) {
            JMethod clinit = targetType.getClinitTarget().getClinitMethod();
            assert (JProgram.isClinit(clinit));
            return new JMethodCall(sourceInfo, null, clinit, new JExpression[0]);
        }

        private void evalConcat(SourceInfo info, JExpression lhs, JExpression rhs, Context ctx) {
            if (lhs instanceof JValueLiteral && rhs instanceof JValueLiteral) {
                Object lhsObj = ((JValueLiteral)lhs).getValueObj();
                Object rhsObj = ((JValueLiteral)rhs).getValueObj();
                ctx.replaceMe(DeadCodeElimination.this.program.getStringLiteral(info, String.valueOf(lhsObj) + String.valueOf(rhsObj)));
            }
        }

        private boolean evalEq(JValueLiteral lhs, JValueLiteral rhs) {
            if (this.isTypeNull(lhs)) {
                return this.isTypeNull(rhs);
            }
            if (this.isTypeString(lhs)) {
                return this.isTypeString(rhs) && ((JStringLiteral)lhs).getValue().equals(((JStringLiteral)rhs).getValue());
            }
            if (this.isTypeBoolean(lhs)) {
                return this.toBoolean(lhs) == this.toBoolean(rhs);
            }
            if (this.isTypeFloatingPoint(lhs) || this.isTypeFloatingPoint(rhs)) {
                return Ieee754_64_Arithmetic.eq(this.toDouble(lhs), this.toDouble(rhs));
            }
            if (this.isTypeLong(lhs) || this.isTypeLong(rhs)) {
                return this.toLong(lhs) == this.toLong(rhs);
            }
            return this.toInt(lhs) == this.toInt(rhs);
        }

        private boolean evalOpOnLiteral(JUnaryOperator op, JValueLiteral exp, Context ctx) {
            switch (op) {
                case BIT_NOT: {
                    long value = this.toLong(exp);
                    long res = value ^ 0xFFFFFFFFFFFFFFFFL;
                    if (this.isTypeLong(exp)) {
                        ctx.replaceMe(DeadCodeElimination.this.program.getLiteralLong(res));
                    } else {
                        ctx.replaceMe(DeadCodeElimination.this.program.getLiteralInt((int)res));
                    }
                    return true;
                }
                case NEG: {
                    if (this.isTypeLong(exp)) {
                        ctx.replaceMe(DeadCodeElimination.this.program.getLiteralLong(-this.toLong(exp)));
                        return true;
                    }
                    if (this.isTypeIntegral(exp)) {
                        ctx.replaceMe(DeadCodeElimination.this.program.getLiteralInt(-this.toInt(exp)));
                        return true;
                    }
                    if (this.isTypeDouble(exp)) {
                        ctx.replaceMe(DeadCodeElimination.this.program.getLiteralDouble(Ieee754_64_Arithmetic.neg(this.toDouble(exp))));
                        return true;
                    }
                    if (this.isTypeFloat(exp)) {
                        ctx.replaceMe(DeadCodeElimination.this.program.getLiteralFloat(Ieee754_64_Arithmetic.neg(this.toDouble(exp))));
                        return true;
                    }
                    return false;
                }
                case NOT: {
                    JBooleanLiteral booleanLit = (JBooleanLiteral)exp;
                    ctx.replaceMe(DeadCodeElimination.this.program.getLiteralBoolean(!booleanLit.getValue()));
                    return true;
                }
            }
            return false;
        }

        private boolean evalOpOnLiterals(JBinaryOperator op, JValueLiteral lhs, JValueLiteral rhs, Context ctx) {
            switch (op) {
                case EQ: {
                    ctx.replaceMe(DeadCodeElimination.this.program.getLiteralBoolean(this.evalEq(lhs, rhs)));
                    return true;
                }
                case NEQ: {
                    ctx.replaceMe(DeadCodeElimination.this.program.getLiteralBoolean(!this.evalEq(lhs, rhs)));
                    return true;
                }
                case ADD: 
                case SUB: 
                case MUL: 
                case DIV: 
                case MOD: {
                    if (this.isTypeFloatingPoint(lhs) || this.isTypeFloatingPoint(rhs)) {
                        double res;
                        double left = this.toDouble(lhs);
                        double right = this.toDouble(rhs);
                        switch (op) {
                            case ADD: {
                                res = Ieee754_64_Arithmetic.add(left, right);
                                break;
                            }
                            case SUB: {
                                res = Ieee754_64_Arithmetic.subtract(left, right);
                                break;
                            }
                            case MUL: {
                                res = Ieee754_64_Arithmetic.multiply(left, right);
                                break;
                            }
                            case DIV: {
                                res = Ieee754_64_Arithmetic.divide(left, right);
                                break;
                            }
                            case MOD: {
                                res = Ieee754_64_Arithmetic.mod(left, right);
                                break;
                            }
                            default: {
                                assert (false);
                                return false;
                            }
                        }
                        if (this.isTypeDouble(lhs) || this.isTypeDouble(rhs)) {
                            ctx.replaceMe(DeadCodeElimination.this.program.getLiteralDouble(res));
                        } else {
                            ctx.replaceMe(DeadCodeElimination.this.program.getLiteralFloat(res));
                        }
                        return true;
                    }
                    if (this.isTypeIntegral(lhs) && this.isTypeIntegral(rhs)) {
                        long res;
                        long left = this.toLong(lhs);
                        long right = this.toLong(rhs);
                        switch (op) {
                            case ADD: {
                                res = left + right;
                                break;
                            }
                            case SUB: {
                                res = left - right;
                                break;
                            }
                            case MUL: {
                                res = left * right;
                                break;
                            }
                            case DIV: {
                                if (right == 0L) {
                                    return false;
                                }
                                res = left / right;
                                break;
                            }
                            case MOD: {
                                if (right == 0L) {
                                    return false;
                                }
                                res = left % right;
                                break;
                            }
                            default: {
                                assert (false);
                                return false;
                            }
                        }
                        if (this.isTypeLong(lhs) || this.isTypeLong(rhs)) {
                            ctx.replaceMe(DeadCodeElimination.this.program.getLiteralLong(res));
                        } else {
                            ctx.replaceMe(DeadCodeElimination.this.program.getLiteralInt((int)res));
                        }
                        return true;
                    }
                    return false;
                }
                case LT: 
                case LTE: 
                case GT: 
                case GTE: {
                    if (this.isTypeFloatingPoint(lhs) || this.isTypeFloatingPoint(rhs)) {
                        boolean res;
                        double left = this.toDouble(lhs);
                        double right = this.toDouble(rhs);
                        switch (op) {
                            case LT: {
                                res = Ieee754_64_Arithmetic.lt(left, right);
                                break;
                            }
                            case LTE: {
                                res = Ieee754_64_Arithmetic.le(left, right);
                                break;
                            }
                            case GT: {
                                res = Ieee754_64_Arithmetic.gt(left, right);
                                break;
                            }
                            case GTE: {
                                res = Ieee754_64_Arithmetic.ge(left, right);
                                break;
                            }
                            default: {
                                assert (false);
                                return false;
                            }
                        }
                        ctx.replaceMe(DeadCodeElimination.this.program.getLiteralBoolean(res));
                        return true;
                    }
                    if (this.isTypeIntegral(lhs) && this.isTypeIntegral(rhs)) {
                        boolean res;
                        long left = this.toLong(lhs);
                        long right = this.toLong(rhs);
                        switch (op) {
                            case LT: {
                                res = left < right;
                                break;
                            }
                            case LTE: {
                                res = left <= right;
                                break;
                            }
                            case GT: {
                                res = left > right;
                                break;
                            }
                            case GTE: {
                                res = left >= right;
                                break;
                            }
                            default: {
                                assert (false);
                                return false;
                            }
                        }
                        ctx.replaceMe(DeadCodeElimination.this.program.getLiteralBoolean(res));
                        return true;
                    }
                    return false;
                }
                case BIT_XOR: 
                case BIT_AND: 
                case BIT_OR: {
                    if (this.isTypeBoolean(lhs)) {
                        return false;
                    }
                    if (this.isTypeIntegral(lhs) && this.isTypeIntegral(rhs)) {
                        long res;
                        long left = this.toLong(lhs);
                        long right = this.toLong(rhs);
                        switch (op) {
                            case BIT_AND: {
                                res = left & right;
                                break;
                            }
                            case BIT_OR: {
                                res = left | right;
                                break;
                            }
                            case BIT_XOR: {
                                res = left ^ right;
                                break;
                            }
                            default: {
                                assert (false);
                                return false;
                            }
                        }
                        if (this.isTypeLong(lhs) || this.isTypeLong(rhs)) {
                            ctx.replaceMe(DeadCodeElimination.this.program.getLiteralLong(res));
                        } else {
                            ctx.replaceMe(DeadCodeElimination.this.program.getLiteralInt((int)res));
                        }
                        return true;
                    }
                    return false;
                }
                case SHL: 
                case SHR: 
                case SHRU: {
                    if (this.isTypeLong(lhs)) {
                        long res;
                        long left = this.toLong(lhs);
                        int right = this.toInt(rhs);
                        switch (op) {
                            case SHL: {
                                res = left << right;
                                break;
                            }
                            case SHR: {
                                res = left >> right;
                                break;
                            }
                            case SHRU: {
                                res = left >>> right;
                                break;
                            }
                            default: {
                                assert (false);
                                return false;
                            }
                        }
                        ctx.replaceMe(DeadCodeElimination.this.program.getLiteralLong(res));
                        return true;
                    }
                    if (this.isTypeIntegral(lhs) && this.isTypeIntegral(rhs)) {
                        int res;
                        int left = this.toInt(lhs);
                        int right = this.toInt(rhs);
                        switch (op) {
                            case SHL: {
                                res = left << right;
                                break;
                            }
                            case SHR: {
                                res = left >> right;
                                break;
                            }
                            case SHRU: {
                                res = left >>> right;
                                break;
                            }
                            default: {
                                assert (false);
                                return false;
                            }
                        }
                        ctx.replaceMe(DeadCodeElimination.this.program.getLiteralInt(res));
                        return true;
                    }
                    return false;
                }
            }
            return false;
        }

        private JBreakStatement findUnconditionalBreak(JStatement statement) {
            JBlock block;
            List<JStatement> blockStmts;
            if (statement instanceof JBreakStatement) {
                return (JBreakStatement)statement;
            }
            if (statement instanceof JBlock && (blockStmts = (block = (JBlock)statement).getStatements()).size() > 0 && this.isUnconditionalBreak(blockStmts.get(0))) {
                return (JBreakStatement)blockStmts.get(0);
            }
            return null;
        }

        private boolean tryReduceSwitchWithConstantInput(JSwitchStatement s, Context ctx) {
            JStatement statement;
            if (!(s.getExpr() instanceof JValueLiteral)) {
                return false;
            }
            JValueLiteral targetValue = (JValueLiteral)s.getExpr();
            JCaseStatement matchingCase = null;
            for (JStatement subStatement : s.getBody().getStatements()) {
                if (!(subStatement instanceof JCaseStatement)) continue;
                JCaseStatement caseStatement = (JCaseStatement)subStatement;
                if (caseStatement.isDefault()) {
                    matchingCase = caseStatement;
                    continue;
                }
                JCaseStatement found = null;
                for (JExpression expr : caseStatement.getExprs()) {
                    JValueLiteral caseValue;
                    if (!(expr instanceof JValueLiteral) || !(caseValue = (JValueLiteral)expr).getValueObj().equals(targetValue.getValueObj())) continue;
                    found = caseStatement;
                    break;
                }
                if (found == null) continue;
                matchingCase = found;
                break;
            }
            if (matchingCase == null) {
                this.removeMe(s, ctx);
                return true;
            }
            ListIterator<JStatement> it = s.getBody().getStatements().listIterator();
            while (it.hasNext() && it.next() != matchingCase) {
                it.remove();
                this.madeChanges();
            }
            if (matchingCase.getExprs().size() > 1) {
                it.remove();
                it.add(new JCaseStatement(matchingCase.getSourceInfo(), targetValue));
                this.madeChanges();
            }
            while (it.hasNext() && !(statement = it.next()).unconditionalControlBreak()) {
                if (!(statement instanceof JCaseStatement)) continue;
                it.remove();
                this.madeChanges();
            }
            while (it.hasNext()) {
                it.next();
                it.remove();
                this.madeChanges();
            }
            return false;
        }

        private boolean hasNoDefaultCase(JSwitchStatement x) {
            JBlock body = x.getBody();
            boolean inDefault = false;
            for (JStatement statement : body.getStatements()) {
                if (statement instanceof JCaseStatement) {
                    JCaseStatement caseStmt = (JCaseStatement)statement;
                    if (!caseStmt.isDefault()) continue;
                    inDefault = true;
                    continue;
                }
                if (this.isUnconditionalUnlabeledBreak(statement)) {
                    inDefault = false;
                    continue;
                }
                if (!inDefault) continue;
                return false;
            }
            return true;
        }

        private boolean isLiteralNegativeOne(JExpression exp) {
            if (!(exp instanceof JValueLiteral)) {
                return false;
            }
            JValueLiteral lit = (JValueLiteral)exp;
            if (this.isTypeIntegral(lit) && this.toLong(lit) == -1L) {
                return true;
            }
            return this.isTypeFloatingPoint(lit) && this.toDouble(lit) == -1.0;
        }

        private boolean isLiteralOne(JExpression exp) {
            if (!(exp instanceof JValueLiteral)) {
                return false;
            }
            JValueLiteral lit = (JValueLiteral)exp;
            if (this.isTypeIntegral(lit) && this.toLong(lit) == 1L) {
                return true;
            }
            return this.isTypeFloatingPoint(lit) && this.toDouble(lit) == 1.0;
        }

        private boolean isLiteralZero(JExpression exp) {
            JValueLiteral lit;
            return exp instanceof JValueLiteral && this.toDouble(lit = (JValueLiteral)exp) == 0.0;
        }

        private boolean isTypeBoolean(JExpression lhs) {
            return lhs.getType() == DeadCodeElimination.this.program.getTypePrimitiveBoolean();
        }

        private boolean isTypeDouble(JExpression exp) {
            return this.isTypeDouble(exp.getType());
        }

        private boolean isTypeDouble(JType type) {
            return type == DeadCodeElimination.this.program.getTypePrimitiveDouble();
        }

        private boolean isTypeFloat(JExpression exp) {
            return this.isTypeFloat(exp.getType());
        }

        private boolean isTypeFloat(JType type) {
            return type == DeadCodeElimination.this.program.getTypePrimitiveFloat();
        }

        private boolean isTypeFloatingPoint(JExpression exp) {
            return this.isTypeFloatingPoint(exp.getType());
        }

        private boolean isTypeFloatingPoint(JType type) {
            return type == DeadCodeElimination.this.program.getTypePrimitiveDouble() || type == DeadCodeElimination.this.program.getTypePrimitiveFloat();
        }

        private boolean isTypeIntegral(JExpression exp) {
            return this.isTypeIntegral(exp.getType());
        }

        private boolean isTypeIntegral(JType type) {
            return type == DeadCodeElimination.this.program.getTypePrimitiveInt() || type == DeadCodeElimination.this.program.getTypePrimitiveLong() || type == DeadCodeElimination.this.program.getTypePrimitiveChar() || type == DeadCodeElimination.this.program.getTypePrimitiveByte() || type == DeadCodeElimination.this.program.getTypePrimitiveShort();
        }

        private boolean isTypeLong(JExpression exp) {
            return this.isTypeLong(exp.getType());
        }

        private boolean isTypeLong(JType type) {
            return type == DeadCodeElimination.this.program.getTypePrimitiveLong();
        }

        private boolean isTypeNull(JExpression exp) {
            return this.isTypeNull(exp.getType());
        }

        private boolean isTypeNull(JType type) {
            return type.isNullType();
        }

        private boolean isTypeString(JExpression exp) {
            return DeadCodeElimination.this.program.isJavaLangString(exp.getType());
        }

        private boolean isUnconditionalBreak(JStatement statement) {
            return this.findUnconditionalBreak(statement) != null;
        }

        private boolean isUnconditionalUnlabeledBreak(JStatement statement) {
            JBreakStatement breakStat = this.findUnconditionalBreak(statement);
            return breakStat != null && breakStat.getLabel() == null;
        }

        private <T> T last(List<T> statements) {
            return statements.get(statements.size() - 1);
        }

        private Class<?> classObjectForType(JType type) {
            return (Class)DeadCodeElimination.this.classObjectsByType.get(type);
        }

        private void maybeReplaceMe(JExpression x, JExpression updated, Context ctx) {
            if (updated != x) {
                ctx.replaceMe(updated);
            }
        }

        private void maybeReplaceMe(JStatement x, JStatement updated, Context ctx) {
            if (updated != x) {
                this.replaceMe(updated, ctx);
            }
        }

        private void maybeReplaceWithOrdinalValue(JExpression instanceExpr, Context ctx) {
            if (!(instanceExpr instanceof JFieldRef)) {
                return;
            }
            JFieldRef fieldRef = (JFieldRef)instanceExpr;
            if (!(fieldRef.getField() instanceof JEnumField)) {
                return;
            }
            assert (fieldRef.getInstance() == null);
            JEnumField enumField = (JEnumField)fieldRef.getField();
            ctx.replaceMe(DeadCodeElimination.this.program.getLiteralInt(enumField.ordinal()));
        }

        private int numRemovableExpressions(JMultiExpression x) {
            if (this.ignoringExpressionOutput.contains(x)) {
                return x.getNumberOfExpressions();
            }
            return x.getNumberOfExpressions() - 1;
        }

        private void removeDoubleBreaks(JSwitchStatement x) {
            JBlock body = x.getBody();
            boolean lastWasBreak = true;
            for (int i = 0; i < body.getStatements().size(); ++i) {
                JStatement statement = body.getStatements().get(i);
                boolean isBreak = this.isUnconditionalBreak(statement);
                if (isBreak && lastWasBreak) {
                    body.removeStmt(i--);
                    this.madeChanges();
                }
                lastWasBreak = isBreak;
            }
            if (body.getStatements().size() > 0 && this.isUnconditionalUnlabeledBreak(this.last(body.getStatements()))) {
                body.removeStmt(body.getStatements().size() - 1);
                this.madeChanges();
            }
        }

        private void removeEmptyCases(JSwitchStatement x) {
            JBlock body = x.getBody();
            ArrayList noOpCaseStatements = new ArrayList();
            ArrayList<JStatement> potentialNoOpCaseStatements = new ArrayList<JStatement>();
            for (JStatement statement : body.getStatements()) {
                if (statement instanceof JCaseStatement) {
                    potentialNoOpCaseStatements.add(statement);
                    continue;
                }
                if (this.isUnconditionalUnlabeledBreak(statement)) {
                    noOpCaseStatements.addAll(potentialNoOpCaseStatements);
                    potentialNoOpCaseStatements.clear();
                    continue;
                }
                potentialNoOpCaseStatements.clear();
            }
            noOpCaseStatements.addAll(potentialNoOpCaseStatements);
            if (noOpCaseStatements.size() > 0) {
                for (JStatement statement : noOpCaseStatements) {
                    body.removeStmt(body.getStatements().indexOf(statement));
                    this.madeChanges();
                }
            }
        }

        private void removeMe(JStatement stmt, Context ctx) {
            if (ctx.canRemove()) {
                ctx.removeMe();
            } else {
                ctx.replaceMe(new JBlock(stmt.getSourceInfo(), new JStatement[0]));
            }
        }

        private void replaceMe(JStatement stmt, Context ctx) {
            if ((stmt = this.accept(stmt, ctx.canRemove())) == null) {
                ctx.removeMe();
            } else {
                ctx.replaceMe(stmt);
            }
        }

        private boolean simplifyAdd(JExpression lhs, JExpression rhs, Context ctx, JType type) {
            if (this.isLiteralZero(rhs)) {
                ctx.replaceMe(Simplifier.cast(type, lhs));
                return true;
            }
            if (this.isLiteralZero(lhs)) {
                ctx.replaceMe(Simplifier.cast(type, rhs));
                return true;
            }
            return false;
        }

        private void simplifyBooleanEq(JExpression exp, boolean bool, Context ctx) {
            if (bool) {
                ctx.replaceMe(exp);
            } else {
                ctx.replaceMe(new JPrefixOperation(exp.getSourceInfo(), JUnaryOperator.NOT, exp));
            }
        }

        private void simplifyBooleanEq(JExpression lhs, JExpression rhs, Context ctx, boolean negate) {
            if (lhs instanceof JBooleanLiteral) {
                boolean left = ((JBooleanLiteral)lhs).getValue();
                this.simplifyBooleanEq(rhs, left ^ negate, ctx);
                return;
            }
            if (rhs instanceof JBooleanLiteral) {
                boolean right = ((JBooleanLiteral)rhs).getValue();
                this.simplifyBooleanEq(lhs, right ^ negate, ctx);
                return;
            }
        }

        private boolean simplifyDiv(JExpression lhs, JExpression rhs, Context ctx, JType type) {
            if (this.isLiteralOne(rhs)) {
                ctx.replaceMe(Simplifier.cast(type, lhs));
                return true;
            }
            if (this.isLiteralNegativeOne(rhs)) {
                ctx.replaceMe(this.simplifyNegate(Simplifier.cast(type, lhs)));
                return true;
            }
            return false;
        }

        private AnalysisResult staticallyEvaluateEq(JExpression lhs, JExpression rhs) {
            JType lhsType = lhs.getType();
            JType rhsType = rhs.getType();
            if (lhsType.isNullType() && rhsType.isNullType()) {
                return AnalysisResult.TRUE;
            }
            if (lhsType.isNullType() && !rhsType.canBeNull() || rhsType.isNullType() && !lhsType.canBeNull()) {
                return AnalysisResult.FALSE;
            }
            if (!(lhsType.canBeSubclass() || rhsType.canBeSubclass() || lhsType.canBeNull() || rhsType.canBeNull() || !(lhsType instanceof JReferenceType) || lhsType.getUnderlyingType() == rhsType.getUnderlyingType())) {
                return AnalysisResult.FALSE;
            }
            return AnalysisResult.UNKNOWN;
        }

        private AnalysisResult staticallyEvaluateInstanceOf(JReferenceType fromType, JReferenceType toType) {
            if (fromType.isNullType()) {
                return AnalysisResult.FALSE;
            }
            if (((DeadCodeElimination)DeadCodeElimination.this).program.typeOracle.castSucceedsTrivially(fromType, toType)) {
                return AnalysisResult.TRUE;
            }
            if (!((DeadCodeElimination)DeadCodeElimination.this).program.typeOracle.isInstantiatedType(toType)) {
                return AnalysisResult.FALSE;
            }
            if (((DeadCodeElimination)DeadCodeElimination.this).program.typeOracle.castFailsTrivially(fromType, toType)) {
                return AnalysisResult.FALSE;
            }
            return AnalysisResult.UNKNOWN;
        }

        private void simplifyEq(JExpression lhs, JExpression rhs, Context ctx, boolean negate) {
            AnalysisResult analysisResult = this.staticallyEvaluateEq(lhs, rhs);
            if (analysisResult != AnalysisResult.UNKNOWN) {
                ctx.replaceMe(JjsUtils.createOptimizedMultiExpression(lhs, rhs, DeadCodeElimination.this.program.getLiteralBoolean(negate ^ analysisResult == AnalysisResult.TRUE)));
                return;
            }
            if (this.isTypeBoolean(lhs) && this.isTypeBoolean(rhs)) {
                this.simplifyBooleanEq(lhs, rhs, ctx, negate);
                return;
            }
        }

        private boolean simplifyMul(JExpression lhs, JExpression rhs, Context ctx, JType type) {
            if (this.isLiteralOne(rhs)) {
                ctx.replaceMe(Simplifier.cast(type, lhs));
                return true;
            }
            if (this.isLiteralOne(lhs)) {
                ctx.replaceMe(Simplifier.cast(type, rhs));
                return true;
            }
            if (this.isLiteralNegativeOne(rhs)) {
                ctx.replaceMe(this.simplifyNegate(Simplifier.cast(type, lhs)));
                return true;
            }
            if (this.isLiteralNegativeOne(lhs)) {
                ctx.replaceMe(this.simplifyNegate(Simplifier.cast(type, rhs)));
                return true;
            }
            if (this.isLiteralZero(rhs) && !lhs.hasSideEffects()) {
                ctx.replaceMe(Simplifier.cast(type, rhs));
                return true;
            }
            if (this.isLiteralZero(lhs) && !rhs.hasSideEffects()) {
                ctx.replaceMe(Simplifier.cast(type, lhs));
                return true;
            }
            return false;
        }

        private JExpression simplifyNegate(JExpression exp) {
            return this.simplifyNegate(null, exp);
        }

        private JExpression simplifyNegate(JExpression original, JExpression exp) {
            JPrefixOperation prefarg;
            if (exp instanceof JPrefixOperation && (prefarg = (JPrefixOperation)exp).getOp() == JUnaryOperator.NEG) {
                return prefarg.getArg();
            }
            if (original != null) {
                return original;
            }
            return new JPrefixOperation(exp.getSourceInfo(), JUnaryOperator.NEG, exp);
        }

        private boolean simplifySub(JExpression lhs, JExpression rhs, Context ctx, JType type) {
            if (this.isLiteralZero(rhs)) {
                ctx.replaceMe(Simplifier.cast(type, lhs));
                return true;
            }
            if (this.isLiteralZero(lhs) && !this.isTypeFloatingPoint(type)) {
                ctx.replaceMe(this.simplifyNegate(Simplifier.cast(type, rhs)));
                return true;
            }
            return false;
        }

        private void simplifyXor(JExpression lhs, JBooleanLiteral rhs, Context ctx) {
            if (rhs.getValue()) {
                ctx.replaceMe(new JPrefixOperation(lhs.getSourceInfo(), JUnaryOperator.NOT, lhs));
            } else {
                ctx.replaceMe(lhs);
            }
        }

        private void simplifyXor(JExpression lhs, JExpression rhs, Context ctx) {
            if (lhs instanceof JBooleanLiteral) {
                JBooleanLiteral booleanLiteral = (JBooleanLiteral)lhs;
                this.simplifyXor(rhs, booleanLiteral, ctx);
            } else if (rhs instanceof JBooleanLiteral) {
                JBooleanLiteral booleanLiteral = (JBooleanLiteral)rhs;
                this.simplifyXor(lhs, booleanLiteral, ctx);
            }
        }

        private boolean toBoolean(JValueLiteral x) {
            return ((JBooleanLiteral)x).getValue();
        }

        private double toDouble(JValueLiteral literal) {
            Object valueObj = literal.getValueObj();
            if (valueObj instanceof Number) {
                return ((Number)valueObj).doubleValue();
            }
            return ((Character)valueObj).charValue();
        }

        private int toInt(JValueLiteral literal) {
            Object valueObj = literal.getValueObj();
            if (valueObj instanceof Number) {
                return ((Number)valueObj).intValue();
            }
            return ((Character)valueObj).charValue();
        }

        private long toLong(JValueLiteral literal) {
            Object valueObj = literal.getValueObj();
            if (valueObj instanceof Number) {
                return ((Number)valueObj).longValue();
            }
            return ((Character)valueObj).charValue();
        }

        private JLiteral tryGetConstant(JVariableRef x) {
            JLiteral lit;
            if (!this.lvalues.contains(x) && (lit = x.getTarget().getConstInitializer()) != null) {
                if (x.getType().isPrimitiveType() && lit instanceof JValueLiteral) {
                    JPrimitiveType xTypePrim = (JPrimitiveType)x.getType();
                    lit = xTypePrim.coerce((JValueLiteral)lit);
                }
                return lit;
            }
            return null;
        }

        private void tryOptimizeStringCall(JMethodCall x, Context ctx, JMethod method) {
            List<JExpression> arguments;
            if (method.getType() == DeadCodeElimination.this.program.getTypeVoid()) {
                return;
            }
            if (method.getOriginalParamTypes().size() != method.getParams().size()) {
                return;
            }
            if (method.getName().endsWith("hashCode")) {
                return;
            }
            boolean isStaticImplMethod = DeadCodeElimination.this.program.isStaticImpl(method);
            JExpression instance = isStaticImplMethod ? x.getArgs().get(0) : x.getInstance();
            List<JExpression> list = arguments = isStaticImplMethod ? x.getArgs().subList(1, x.getArgs().size()) : x.getArgs();
            if (method.getName().endsWith("toString")) {
                if (!instance.getType().canBeNull()) {
                    ctx.replaceMe(instance);
                }
                return;
            }
            Object instanceLiteral = this.tryTranslateLiteral(instance, String.class);
            JMethod jMethod = method = isStaticImplMethod ? DeadCodeElimination.this.program.instanceMethodForStaticImpl(method) : method;
            if (instanceLiteral == null && !method.isStatic()) {
                return;
            }
            int numberOfParameters = method.getOriginalParamTypes().size();
            Object[] argumentConstantValues = new Object[numberOfParameters];
            Class[] parametersClasses = new Class[numberOfParameters];
            for (int i = 0; i < numberOfParameters; ++i) {
                parametersClasses[i] = this.classObjectForType(method.getOriginalParamTypes().get(i));
                argumentConstantValues[i] = this.tryTranslateLiteral(arguments.get(i), parametersClasses[i]);
                if (parametersClasses[i] != null && argumentConstantValues[i] != null) continue;
                return;
            }
            JLiteral resultValue = this.staticallyInvokeStringMethod(method.getName(), instanceLiteral, parametersClasses, argumentConstantValues);
            if (resultValue != null) {
                ctx.replaceMe(resultValue);
            }
        }

        private JLiteral staticallyInvokeStringMethod(String methodName, Object instance, Class<?>[] parameterClasses, Object[] argumentValues) {
            Method actualMethod = this.getMethod(methodName, String.class, parameterClasses);
            if (actualMethod == null) {
                Arrays.fill(parameterClasses, Object.class);
                actualMethod = this.getMethod(methodName, String.class, parameterClasses);
            }
            if (actualMethod == null) {
                return null;
            }
            try {
                return DeadCodeElimination.this.program.getLiteral(actualMethod.invoke(instance, argumentValues));
            }
            catch (Exception e) {
                return null;
            }
        }

        private Method getMethod(String name, Class<?> enclosingClass, Class<?>[] parameterTypes) {
            try {
                return enclosingClass.getMethod(name, parameterTypes);
            }
            catch (NoSuchMethodException e) {
                return null;
            }
        }

        private void tryRemoveSwitch(JSwitchStatement x, Context ctx) {
            JBlock body = x.getBody();
            if (body.getStatements().isEmpty()) {
                this.replaceMe(x.getExpr().makeStatement(), ctx);
            } else if (body.getStatements().size() == 2) {
                JCaseStatement caseStatement = (JCaseStatement)body.getStatements().get(0);
                JStatement statement = body.getStatements().get(1);
                FindBreakContinueStatementsVisitor visitor = new FindBreakContinueStatementsVisitor();
                visitor.accept(statement);
                if (visitor.hasBreakContinueStatements()) {
                    return;
                }
                if (caseStatement.isDefault()) {
                    JBlock block = new JBlock(x.getSourceInfo(), new JStatement[0]);
                    block.addStmt(x.getExpr().makeStatement());
                    block.addStmt(statement);
                    this.replaceMe(block, ctx);
                } else {
                    JBinaryOperation compareOperation = caseStatement.convertToCompareExpression(x.getExpr());
                    JBlock block = new JBlock(x.getSourceInfo(), new JStatement[0]);
                    block.addStmt(statement);
                    JIfStatement ifStatement = new JIfStatement(x.getSourceInfo(), compareOperation, block, null);
                    this.replaceMe(ifStatement, ctx);
                }
            }
        }

        private Object tryTranslateLiteral(JExpression maybeLiteral, Class<?> type) {
            if (!(maybeLiteral instanceof JValueLiteral)) {
                return null;
            }
            if (type == Boolean.TYPE && maybeLiteral instanceof JBooleanLiteral) {
                return ((JBooleanLiteral)maybeLiteral).getValue();
            }
            if (type == Character.TYPE && maybeLiteral instanceof JCharLiteral) {
                return Character.valueOf(((JCharLiteral)maybeLiteral).getValue());
            }
            if (type == Double.TYPE && maybeLiteral instanceof JFloatLiteral) {
                return new Double(((JFloatLiteral)maybeLiteral).getValue());
            }
            if (type == Double.TYPE && maybeLiteral instanceof JDoubleLiteral) {
                return new Double(((JDoubleLiteral)maybeLiteral).getValue());
            }
            if (type == Integer.TYPE && maybeLiteral instanceof JIntLiteral) {
                return ((JIntLiteral)maybeLiteral).getValue();
            }
            if (type == Long.TYPE && maybeLiteral instanceof JLongLiteral) {
                return ((JLongLiteral)maybeLiteral).getValue();
            }
            if (type == String.class && maybeLiteral instanceof JStringLiteral) {
                return ((JStringLiteral)maybeLiteral).getValue();
            }
            if (type == Object.class) {
                return ((JValueLiteral)maybeLiteral).getValueObj();
            }
            return null;
        }
    }
}

