/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl;

import com.google.gwt.dev.StringAnalyzableTypeEnvironment;
import com.google.gwt.dev.jjs.ast.Context;
import com.google.gwt.dev.jjs.ast.JClassLiteral;
import com.google.gwt.dev.jjs.ast.JClassType;
import com.google.gwt.dev.jjs.ast.JDeclaredType;
import com.google.gwt.dev.jjs.ast.JField;
import com.google.gwt.dev.jjs.ast.JFieldRef;
import com.google.gwt.dev.jjs.ast.JInterfaceType;
import com.google.gwt.dev.jjs.ast.JMethod;
import com.google.gwt.dev.jjs.ast.JMethodCall;
import com.google.gwt.dev.jjs.ast.JProgram;
import com.google.gwt.dev.jjs.ast.JType;
import com.google.gwt.dev.jjs.ast.JVisitor;
import com.google.gwt.dev.jjs.ast.js.JsniFieldRef;
import com.google.gwt.dev.jjs.ast.js.JsniMethodRef;
import com.google.gwt.thirdparty.guava.common.collect.Sets;
import java.util.Set;

public class ControlFlowRecorder
extends JVisitor {
    private final Set<String> bannedMethodNames = Sets.newHashSet();
    private String currentMethodName;
    private final boolean onlyUpdate;
    private final JProgram program;
    private final StringAnalyzableTypeEnvironment stringAnalyzableTypeEnvironment;

    public static void exec(JProgram program, StringAnalyzableTypeEnvironment stringAnalyzableTypeEnvironment, boolean onlyUpdate) {
        new ControlFlowRecorder(stringAnalyzableTypeEnvironment, onlyUpdate, program).execImpl();
    }

    private static String computeName(JMethod method) {
        return method.getJsniSignature(true, true);
    }

    public ControlFlowRecorder(StringAnalyzableTypeEnvironment stringAnalyzableTypeEnvironment, boolean onlyUpdate, JProgram program) {
        this.stringAnalyzableTypeEnvironment = stringAnalyzableTypeEnvironment;
        this.onlyUpdate = onlyUpdate;
        this.program = program;
        this.bannedMethodNames.add(ControlFlowRecorder.computeName(program.getTypeClassLiteralHolder().getClinitMethod()));
    }

    @Override
    public void endVisit(JClassLiteral x, Context ctx) {
        JMethod valueOfMethod;
        JType type = x.getRefType();
        if (type instanceof JDeclaredType) {
            String typeName = type.getName();
            this.stringAnalyzableTypeEnvironment.recordStaticReferenceInMethod(typeName, this.currentMethodName);
            this.maybeRecordClinitCall(typeName);
        }
        if (type.isEnumOrSubclass() != null && !type.getName().equals("java.lang.Enum") && (valueOfMethod = this.getValueOfMethod((JDeclaredType)type)) != null) {
            this.stringAnalyzableTypeEnvironment.recordMethodCallsMethod(this.currentMethodName, ControlFlowRecorder.computeName(valueOfMethod));
        }
    }

    @Override
    public void endVisit(JFieldRef x, Context ctx) {
        this.processJFieldRef(x);
    }

    @Override
    public void endVisit(JsniFieldRef x, Context ctx) {
        this.processJFieldRef(x);
    }

    @Override
    public void endVisit(JsniMethodRef x, Context ctx) {
        this.processMethodCall(x);
    }

    @Override
    public boolean visit(JDeclaredType x, Context ctx) {
        if (!this.onlyUpdate) {
            this.stringAnalyzableTypeEnvironment.removeControlFlowIndexesFor(x.getName());
        }
        return true;
    }

    @Override
    public boolean visit(JField x, Context ctx) {
        String typeName = x.getEnclosingType().getName();
        if (x.isJsInteropEntryPoint()) {
            this.stringAnalyzableTypeEnvironment.recordExportedStaticReferenceInType(typeName);
        }
        return true;
    }

    @Override
    public boolean visit(JMethod x, Context ctx) {
        String typeName = x.getEnclosingType().getName();
        this.currentMethodName = ControlFlowRecorder.computeName(x);
        if (this.bannedMethodNames.contains(this.currentMethodName)) {
            return false;
        }
        this.stringAnalyzableTypeEnvironment.recordTypeEnclosesMethod(typeName, this.currentMethodName);
        for (JMethod overriddenMethod : x.getOverriddenMethods()) {
            String overriddenMethodName = ControlFlowRecorder.computeName(overriddenMethod);
            this.stringAnalyzableTypeEnvironment.recordMethodOverridesMethod(this.currentMethodName, overriddenMethodName);
        }
        if (x.canBeReferencedExternally()) {
            this.stringAnalyzableTypeEnvironment.recordExportedMethodInType(this.currentMethodName, typeName);
        }
        if (x.isJsInteropEntryPoint()) {
            this.stringAnalyzableTypeEnvironment.recordExportedStaticReferenceInType(typeName);
        }
        if (x.isConstructor()) {
            this.recordCurrentMethodInstantiatesType(x.getEnclosingType());
        }
        return true;
    }

    @Override
    public boolean visit(JMethodCall x, Context ctx) {
        this.processMethodCall(x);
        return true;
    }

    private void execImpl() {
        this.accept(this.program);
    }

    private JMethod getValueOfMethod(JDeclaredType type) {
        for (JMethod method : type.getMethods()) {
            if (!method.getName().equals("valueOf")) continue;
            return method;
        }
        return null;
    }

    private void maybeRecordClinitCall(String typeName) {
        String typeClinitMethod = typeName + "::$clinit()V";
        if (!typeClinitMethod.equals(this.currentMethodName)) {
            this.stringAnalyzableTypeEnvironment.recordMethodCallsMethod(this.currentMethodName, typeClinitMethod);
        }
    }

    private void processJFieldRef(JFieldRef x) {
        JField field;
        if (x.getTarget() instanceof JField && (field = (JField)x.getTarget()).isStatic()) {
            String typeName = field.getEnclosingType().getName();
            this.stringAnalyzableTypeEnvironment.recordStaticReferenceInMethod(typeName, this.currentMethodName);
            this.maybeRecordClinitCall(typeName);
        }
    }

    private void processMethodCall(JMethodCall x) {
        String typeName;
        JMethod targetMethod = x.getTarget();
        String calleeMethodName = ControlFlowRecorder.computeName(targetMethod);
        this.stringAnalyzableTypeEnvironment.recordMethodCallsMethod(this.currentMethodName, calleeMethodName);
        if (targetMethod.isStatic()) {
            typeName = targetMethod.getEnclosingType().getName();
            this.stringAnalyzableTypeEnvironment.recordStaticReferenceInMethod(typeName, this.currentMethodName);
            this.maybeRecordClinitCall(typeName);
        }
        if (targetMethod.isConstructor()) {
            typeName = targetMethod.getEnclosingType().getName();
            this.stringAnalyzableTypeEnvironment.recordMethodInstantiatesType(this.currentMethodName, typeName);
            this.maybeRecordClinitCall(typeName);
        }
    }

    private void recordCurrentMethodInstantiatesType(JDeclaredType type) {
        String typeName = type.getName();
        this.stringAnalyzableTypeEnvironment.recordMethodInstantiatesType(this.currentMethodName, typeName);
        this.maybeRecordClinitCall(typeName);
        JClassType superClass = type.getSuperClass();
        if (superClass != null) {
            this.recordCurrentMethodInstantiatesType(superClass);
        }
        for (JInterfaceType interfaceType : type.getImplements()) {
            this.recordCurrentMethodInstantiatesType(interfaceType);
        }
    }
}

